/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.WorldCoord;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.me.tiles.IColoredMETile;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IFulllyOptionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IOptionalMETile;
import appeng.common.AppEngTextureRegistry;
import appeng.common.network.IAppEngNetworkTile;
import appeng.interfaces.ICustomCollision;
import appeng.me.basetiles.TileCableBase;
import appeng.me.basetiles.TileME;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileDarkCable
extends TileCableBase
implements IAppEngNetworkTile,
IGridMachine,
IColoredMETile,
ICustomCollision,
IOptionalMETile {
    boolean isLit = false;
    int color = -1;

    @Override
    public boolean isColored() {
        return this.color >= 0;
    }

    @Override
    public boolean requiresRedstoneUpdates() {
        return true;
    }

    @Override
    public int getLightValue() {
        return 0;
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public void setOrientationBySide(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        super.setOrientationBySide(player, side, hitX, hitY, hitZ);
        ForgeDirection orientation = ForgeDirection.getOrientation((int)side);
        WorldCoord pos = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        pos.add(orientation, -1);
        TileEntity te = this.field_70331_k.func_72796_p(pos.x, pos.y, pos.z);
        if (te instanceof IColoredMETile && ((IColoredMETile)te).isColored()) {
            this.color = ((IColoredMETile)te).getColor();
        }
    }

    @Override
    public boolean connectsTo(IBlockAccess w, int x, int y, int z) {
        IDirectionalMETile dmet;
        TileEntity te = w.func_72796_p(x, y, z);
        ForgeDirection directionTo = this.getLocation().DirectionTo(new WorldCoord(x, y, z));
        if (te instanceof IFulllyOptionalMETile && ((IFulllyOptionalMETile)te).isSeperated()) {
            return false;
        }
        if (te instanceof IDirectionalMETile && !(dmet = (IDirectionalMETile)te).canConnect(directionTo.getOpposite())) {
            return false;
        }
        if (te instanceof IColoredMETile && this.isColored() && ((IColoredMETile)te).isColored()) {
            return ((IColoredMETile)te).getColor() == this.getColor();
        }
        return te instanceof TileME;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.field_78661_f = true;
        Icon cableColor = this.isLit ? (this.color == -1 ? AppEngTextureRegistry.Blocks.MECableClear.get() : AppEngTextureRegistry.Blocks.MECableColors[this.color].get()) : (this.color == -1 ? AppEngTextureRegistry.Blocks.MECableClearDark.get() : AppEngTextureRegistry.Blocks.MEDarkCableColors[this.color].get());
        this.renderCableAt(0.11, world, x, y, z, block, modelId, renderer, cableColor, true, 0.0);
        this.renderCableAt(0.18, world, x, y, z, block, modelId, renderer, AppEngTextureRegistry.Blocks.MECable.get(), false, 0.1875);
        renderer.field_78661_f = false;
        super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        return true;
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.color = par1nbtTagCompound.func_74771_c("co");
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74774_a("co", (byte)this.color);
    }

    @Override
    public boolean isBlockNormalCube() {
        return false;
    }

    @Override
    public void setColor(int offset) {
        this.color = offset;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void handleTilePacket(DataInputStream stream) {
        try {
            int oldColor = this.color;
            boolean oldisLit = this.isLit;
            super.handleTilePacket(stream);
            this.color = stream.readByte();
            this.isLit = stream.readBoolean();
            if (oldisLit != this.isLit || oldColor != this.color) {
                this.markForUpdate();
            }
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public void configureTilePacket(DataOutputStream data) {
        try {
            super.configureTilePacket(data);
            data.writeByte((byte)this.color);
            data.writeBoolean(this.getRedstoneState());
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    public void onUpdateRedstone() {
        super.onUpdateRedstone();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.field_70331_k, this.getLocation()));
        if (!this.getRedstoneState()) {
            this.setGrid(null);
        }
        this.markForUpdate();
    }

    @Override
    public float getPowerDrainPerTick() {
        return 0.0f;
    }

    @Override
    public boolean isEnabled() {
        return this.getRedstoneState();
    }
}

