/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.WorldCoord;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IConfigEnum;
import appeng.api.config.RedstoneModeInput;
import appeng.api.config.StackModeOutput;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.me.tiles.IColoredMETile;
import appeng.api.me.tiles.IConfigureableTile;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IOrientableTile;
import appeng.api.me.tiles.IPushable;
import appeng.api.me.tiles.IStorageAware;
import appeng.api.me.tiles.ITileIOCable;
import appeng.api.me.util.IConfigManager;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventory;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngTextureRegistry;
import appeng.common.network.IAppEngNetworkTile;
import appeng.interfaces.IConfigEnabledTile;
import appeng.me.METhrottle;
import appeng.me.basetiles.TileCableBase;
import appeng.me.crafting.CraftRequest;
import appeng.me.crafting.CraftingManager;
import appeng.me.crafting.ICraftingManagerOwner;
import appeng.me.tile.AEAppEngInternalInventory;
import appeng.me.tile.TileController;
import appeng.render.AppEngBlockRenderer;
import appeng.util.ConfigManager;
import appeng.util.InventoryAdaptor;
import appeng.util.ItemList;
import appeng.util.Platform;
import appeng.util.inv.AdaptorBCPipe;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileOutputCable
extends TileCableBase
implements IOrientableTile,
IPipeConnection,
IConfigEnabledTile,
ICraftingManagerOwner,
IPushable,
ITileIOCable,
IConfigureableTile,
IAppEngNetworkTile,
IGridMachine,
IDirectionalMETile,
IColoredMETile,
IStorageAware {
    ConfigManager config = new ConfigManager(this);
    ForgeDirection orientation;
    CraftingManager craftingManager;
    int color = -1;
    public AEAppEngInternalInventory item;
    public ITileIOCable.Version ver;
    RedstoneModeInput rsMode = RedstoneModeInput.Ignore;
    StackModeOutput sMode = StackModeOutput.Single;
    METhrottle throttle;
    int sleepMode = 0;
    FuzzyMode fuzzyMode;

    @Override
    public boolean isColored() {
        return this.color >= 0;
    }

    @Override
    public AxisAlignedBB extendBusCollision(AxisAlignedBB b) {
        if (this.ver == ITileIOCable.Version.Basic) {
            return this.IOBusCollision(0.3f, this.orientation, b);
        }
        return this.IOBusCollision(0.25f, this.orientation, b);
    }

    @Override
    public ITileIOCable.Version getVersion() {
        return this.ver;
    }

    public TileOutputCable() {
        this.orientation = ForgeDirection.UP;
        this.sMode = StackModeOutput.Single;
        this.config.RegisterSetting(this.sMode);
        this.fuzzyMode = FuzzyMode.Percent_99;
        this.config.RegisterSetting(this.fuzzyMode);
        this.rsMode = RedstoneModeInput.Ignore;
        this.config.RegisterSetting(this.rsMode);
        this.ver = ITileIOCable.Version.Precision;
        this.item = new AEAppEngInternalInventory(this, 8);
        this.item.setMaxStackSize(1);
        this.craftingManager = new CraftingManager(this.getGrid() == null ? "NULL-" + this.getName() : this.getGrid().getName() + "-" + this.getName(), this);
        this.orientation = ForgeDirection.NORTH;
        this.throttle = new METhrottle(5, AppEngConfiguration.automationMinTickRate, AppEngConfiguration.automationMinTickRate + 40);
    }

    @Override
    public void setGrid(IGridInterface gi) {
        super.setGrid(gi);
        this.craftingManager = new CraftingManager(this.getGrid() == null ? "NULL-" + this.getName() : this.getGrid().getName() + "-" + this.getName(), this);
    }

    @Override
    public boolean requiresRedstoneUpdates() {
        return this.ver != ITileIOCable.Version.Basic;
    }

    @Override
    public int getLightValue() {
        return 0;
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public void setOrientationBySide(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        super.setOrientationBySide(player, side, hitX, hitY, hitZ);
        this.orientation = ForgeDirection.getOrientation((int)side);
        if (player.func_70093_af()) {
            this.orientation = this.orientation.getOpposite();
        }
        WorldCoord pos = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        pos.add(this.orientation, -1);
        TileEntity te = this.field_70331_k.func_72796_p(pos.x, pos.y, pos.z);
        if (te instanceof IColoredMETile && ((IColoredMETile)te).isColored()) {
            this.color = ((IColoredMETile)te).getColor();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTipPart(Block block, RenderBlocks renderer, float offset, float Thickness, int x, int y, int z) {
        AppEngBlockRenderer.instance.setOverrideBlockTexture(block, this.ver == ITileIOCable.Version.Fuzzy ? AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get() : AppEngTextureRegistry.Blocks.BlockInterface.get());
        float offX = (float)this.orientation.offsetX / 2.0f;
        float offY = (float)this.orientation.offsetY / 2.0f;
        float offZ = (float)this.orientation.offsetZ / 2.0f;
        float centerX = 0.5f;
        float centerY = 0.5f;
        float centerZ = 0.5f;
        float thickX = (double)Math.abs(this.orientation.offsetX) > 0.1 ? 0.076f : Thickness;
        float thickY = (double)Math.abs(this.orientation.offsetY) > 0.1 ? 0.076f : Thickness;
        float thickZ = (double)Math.abs(this.orientation.offsetZ) > 0.1 ? 0.076f : Thickness;
        this.setTipRenderBounds(renderer, this.orientation, centerX + offX - thickX, (centerY += (float)this.orientation.offsetY * -offset) + offY - thickY, (centerZ += (float)this.orientation.offsetZ * -offset) + offZ - thickZ, (centerX += (float)this.orientation.offsetX * -offset) + offX + thickX, centerY + offY + thickY, centerZ + offZ + thickZ);
        renderer.func_78570_q(block, x, y, z);
        AppEngBlockRenderer.instance.setOverrideBlockTexture(block, null);
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return this.ver != ITileIOCable.Version.Basic;
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.field_78661_f = true;
        Icon cableColor = this.color == -1 ? AppEngTextureRegistry.Blocks.MECableClear.get() : AppEngTextureRegistry.Blocks.MECableColors[this.color].get();
        this.renderCableAt(0.11, world, x, y, z, block, modelId, renderer, cableColor, true, 0.0);
        this.renderCableAt(0.18, world, x, y, z, block, modelId, renderer, AppEngTextureRegistry.Blocks.MECable.get(), false, 0.1875);
        if (this.ver == ITileIOCable.Version.Basic) {
            this.renderTipPart(block, renderer, 0.076f, 0.1f, x, y, z);
            this.renderTipPart(block, renderer, 0.22799999f, 0.2f, x, y, z);
            this.renderTipPart(block, renderer, 0.304f, 0.1f, x, y, z);
        } else {
            this.renderTipPart(block, renderer, 0.076f, 0.1f, x, y, z);
            this.renderTipPart(block, renderer, 0.152f, 0.15f, x, y, z);
            this.renderTipPart(block, renderer, 0.22799999f, 0.2f, x, y, z);
            this.renderTipPart(block, renderer, 0.304f, 0.25f, x, y, z);
        }
        renderer.field_78661_f = false;
        super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        return true;
    }

    @Override
    public NBTTagCompound getSettings() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("rsMode", this.rsMode.toString());
        tag.func_74778_a("sMode", this.sMode.toString());
        tag.func_74778_a("fzMode", this.fuzzyMode.toString());
        NBTTagCompound it = new NBTTagCompound();
        if (this.item != null) {
            this.item.writeToNBT(it);
        }
        tag.func_74766_a("it", it);
        return tag;
    }

    @Override
    public void restoreSettings(NBTTagCompound tag) {
        try {
            this.item.readFromNBT(tag.func_74775_l("it"));
            this.rsMode = (RedstoneModeInput)this.config.loadSetting(this.rsMode, tag, "rsMode");
            this.sMode = (StackModeOutput)this.config.loadSetting(this.sMode, tag, "sMode");
            this.fuzzyMode = this.config.loadSetting(this.fuzzyMode, tag, "fzMode");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.color = par1nbtTagCompound.func_74771_c("co");
        this.orientation = ForgeDirection.getOrientation((int)par1nbtTagCompound.func_74771_c("ori"));
        this.item.readFromNBT(par1nbtTagCompound.func_74775_l("it"));
        this.rsMode = (RedstoneModeInput)this.config.loadSetting(this.rsMode, par1nbtTagCompound, "rsMode");
        this.sMode = (StackModeOutput)this.config.loadSetting(this.sMode, par1nbtTagCompound, "sMode");
        this.fuzzyMode = this.config.loadSetting(this.fuzzyMode, par1nbtTagCompound, "fzMode");
        try {
            this.ver = ITileIOCable.Version.valueOf(par1nbtTagCompound.func_74779_i("ver"));
        }
        catch (IllegalArgumentException err) {
            this.ver = ITileIOCable.Version.Precision;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74774_a("co", (byte)this.color);
        par1nbtTagCompound.func_74774_a("ori", (byte)this.orientation.ordinal());
        par1nbtTagCompound.func_74778_a("rsMode", this.rsMode.toString());
        par1nbtTagCompound.func_74778_a("sMode", this.sMode.toString());
        par1nbtTagCompound.func_74778_a("fzMode", this.fuzzyMode.toString());
        par1nbtTagCompound.func_74778_a("ver", this.ver.toString());
        NBTTagCompound it = new NBTTagCompound();
        if (this.item != null) {
            this.item.writeToNBT(it);
        }
        par1nbtTagCompound.func_74766_a("it", it);
    }

    @Override
    public boolean isBlockNormalCube() {
        return false;
    }

    @Override
    public void setColor(int offset) {
        this.color = offset;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void handleTilePacket(DataInputStream stream) {
        try {
            ForgeDirection oldOrientation = this.orientation;
            int oldColor = this.color;
            super.handleTilePacket(stream);
            this.orientation = ForgeDirection.getOrientation((int)stream.readByte());
            this.color = stream.readByte();
            this.ver = ITileIOCable.Version.values()[stream.readByte()];
            if (oldColor != this.color || oldOrientation != this.orientation) {
                this.markForUpdate();
            }
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    public void configureTilePacket(DataOutputStream data) {
        try {
            super.configureTilePacket(data);
            data.writeByte((byte)this.orientation.ordinal());
            data.writeByte((byte)this.color);
            data.writeByte((byte)this.ver.ordinal());
        }
        catch (IOException e) {
            return;
        }
    }

    public String getTileName() {
        return "ExportBus-" + this.field_70329_l + "," + this.field_70330_m + "," + this.field_70327_n;
    }

    public void OutputItems() {
        int remainingItems;
        if (!this.isPowered()) {
            return;
        }
        int n = remainingItems = this.sMode == StackModeOutput.Stack ? 64 : 1;
        if (this.rsMode != RedstoneModeInput.OnPulse) {
            remainingItems = (int)((float)remainingItems * this.throttle.getMultipler());
        }
        int diff = 0;
        do {
            diff = 0;
            for (int x = 0; x < this.item.func_70302_i_() && remainingItems > 0; ++x) {
                IMEInventoryHandler mei;
                IAEItemStack itstck = this.item.getAEStackInSlot(x);
                if (itstck == null) continue;
                WorldCoord wc = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                wc.add(this.orientation, 1);
                TileEntity te = this.field_70331_k.func_72796_p(wc.x, wc.y, wc.z);
                InventoryAdaptor ia = AppEng.getInstance().BCProxy != null && AppEng.getInstance().BCProxy.isPipe(te, this.orientation) ? new AdaptorBCPipe(te, this.orientation.getOpposite()) : InventoryAdaptor.getAdaptor(te, this.orientation.getOpposite());
                IGridInterface gi = this.getGrid();
                if (gi == null) {
                    return;
                }
                TileController tc = (TileController)gi.getController();
                if (!(ia != null & (mei = gi.getCellArray()) != null)) continue;
                ItemStack willAdd_def = Platform.getSharedItemStack(itstck);
                willAdd_def.field_77994_a = Math.min(remainingItems, willAdd_def.func_77976_d());
                itstck = itstck.copy();
                itstck.setStackSize(willAdd_def.field_77994_a);
                for (IAEItemStack ae_willAdd : this.findSimilar(mei, itstck)) {
                    ItemStack willAdd = Platform.getSharedItemStack(ae_willAdd);
                    ItemStack canGet = ia.simulateAdd(willAdd);
                    if (this.craftingManager.isCrafting(willAdd)) {
                        if (this.sMode == StackModeOutput.Craft || this.sMode == StackModeOutput.CraftOnly) continue;
                        this.craftingManager.cancel(willAdd, tc);
                    }
                    if (canGet != null) {
                        willAdd.field_77994_a -= canGet.field_77994_a;
                    }
                    if (willAdd.field_77994_a <= 0) continue;
                    if (this.sMode == StackModeOutput.CraftOnly) {
                        if ((willAdd = tc.getCraftAmount(willAdd)) == null) continue;
                        CraftRequest cr = (CraftRequest)tc.pushRequest(this.getTileName(), willAdd, this, true);
                        cr.requestedPreReqs(tc.craftingRequest(willAdd, true, true));
                        this.craftingManager.requestedPreReqs(cr);
                        continue;
                    }
                    if (mei == null) {
                        return;
                    }
                    int count = willAdd.field_77994_a;
                    if (willAdd != null) {
                        willAdd.field_77994_a = count;
                    }
                    ItemStack is = null;
                    IAEItemStack ae_ais = mei.extractItems(ae_willAdd);
                    if (ae_ais != null) {
                        is = ae_ais.getItemStack();
                    }
                    if (this.sMode == StackModeOutput.Craft && (is == null || is.field_77994_a == 0)) {
                        if (willAdd == null) continue;
                        this.craftingManager.requestedPreReqs(tc.pushRequest(this.getTileName(), willAdd, this, true, true));
                        continue;
                    }
                    if (is != null) {
                        int allowItems = gi.usePowerForAddition(is.field_77994_a, this.sMode == StackModeOutput.Stack ? 3 : 1);
                        if (allowItems < willAdd.field_77994_a) {
                            ItemStack addBack = is.func_77946_l();
                            addBack.field_77994_a = is.field_77994_a - allowItems;
                            is.field_77994_a = allowItems;
                            Platform.addItems(mei, addBack);
                            if (is.field_77994_a == 0) {
                                is = null;
                            }
                        }
                        if (is != null) {
                            int td = is.field_77994_a;
                            ItemStack leftOver = ia.addItems(is);
                            if (leftOver != null) {
                                if ((td -= leftOver.field_77994_a) > 0) {
                                    this.throttle.hasAccomplishedWork();
                                }
                                Platform.addItems(mei, leftOver);
                            } else {
                                this.throttle.hasAccomplishedWork();
                            }
                            remainingItems -= td;
                            diff += td;
                        }
                        return;
                    }
                    this.sleepMode = 40;
                }
            }
        } while (remainingItems > 0 && diff > 0);
    }

    @Override
    public void onNetworkInventoryChange(IItemList is) {
        if (this.sleepMode > 0) {
            for (int x = 0; x < this.item.func_70302_i_(); ++x) {
                IAEItemStack itstck = this.item.getAEStackInSlot(x);
                if (itstck == null) continue;
                if (this.ver == ITileIOCable.Version.Fuzzy) {
                    if (Platform.findSimilarItem(is.getItems(), Platform.getSharedItemStack(itstck), this.fuzzyMode) == null) continue;
                    this.sleepMode = 0;
                    return;
                }
                if (is.findItem(itstck) == null) continue;
                this.sleepMode = 0;
                return;
            }
        }
    }

    private IAEItemStack[] findSimilar(IMEInventory mei, IAEItemStack willAdd) {
        if (this.ver == ITileIOCable.Version.Fuzzy) {
            ItemList available = (ItemList)mei.getAvailableItems();
            IAEItemStack[] g = Platform.findSimilarItem(available, willAdd, this.fuzzyMode);
            if (g.length == 0 && this.getGrid() != null) {
                available = (ItemList)this.getGrid().getCraftableArray().getAvailableItems();
                g = Platform.findSimilarItem(available, willAdd, this.fuzzyMode);
            }
            return g;
        }
        if (Platform.hasSpecialComparison(willAdd)) {
            ItemList available = (ItemList)mei.getAvailableItems();
            return Platform.findMatchingItem(available, willAdd);
        }
        return new IAEItemStack[]{willAdd};
    }

    @Override
    public void updateTileEntity() {
        if (!this.isPowered()) {
            return;
        }
        --this.sleepMode;
        if (this.throttle.process() && this.sleepMode <= 0) {
            this.sleepMode = 0;
            if (this.rsMode == RedstoneModeInput.Ignore) {
                this.OutputItems();
            } else if (this.rsMode == RedstoneModeInput.WhenOff && !this.getRedstoneState()) {
                this.OutputItems();
            } else if (this.rsMode == RedstoneModeInput.WhenOn && this.getRedstoneState()) {
                this.OutputItems();
            }
        }
    }

    @Override
    public void onUpdateRedstone() {
        super.onUpdateRedstone();
        this.throttle.hasAccomplishedWork();
    }

    @Override
    public void pulseRedStone() {
        if (!this.isPowered()) {
            return;
        }
        if (this.rsMode == RedstoneModeInput.OnPulse) {
            this.OutputItems();
        }
    }

    @Override
    public void cycleOrientation() {
        this.orientation = Platform.cycleOrientations(this.orientation, false);
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.getWorld(), this.getLocation()));
    }

    @Override
    public float getHoleThickness(ForgeDirection direction) {
        if (this.orientation == direction) {
            return 0.4f;
        }
        return super.getHoleThickness(direction);
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir.ordinal() != this.orientation.ordinal();
    }

    @Override
    public float getPowerDrainPerTick() {
        return this.sMode == StackModeOutput.Stack ? 2.0f : 1.0f;
    }

    @Override
    public List<String> getConfigurations() {
        return this.config.getConfigurations();
    }

    @Override
    public String nextConfiguration(String name) {
        return this.config.nextConfiguration(name);
    }

    @Override
    public String prevConfiguration(String name) {
        return this.config.prevConfiguration(name);
    }

    @Override
    public String setConfiguration(String name, String value) {
        return this.config.setConfiguration(name, value);
    }

    @Override
    public String getConfiguration(String name) {
        return this.config.getConfiguration(name);
    }

    @Override
    public List<String> getConfiguationOptions(String name) {
        return this.config.getConfiguationOptions(name);
    }

    @Override
    public IInventory getConfiguration() {
        return this.item;
    }

    @Override
    public boolean canPushItem(ItemStack out) {
        if (out == null) {
            return false;
        }
        WorldCoord wc = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        wc.add(this.orientation, 1);
        InventoryAdaptor ia = InventoryAdaptor.getAdaptor(this.field_70331_k.func_72796_p(wc.x, wc.y, wc.z), this.orientation.getOpposite());
        if (ia != null) {
            return ia.simulateAdd(out) == null;
        }
        return false;
    }

    @Override
    public ItemStack pushItem(ItemStack out) {
        if (out == null) {
            return null;
        }
        IGridInterface gi = this.getGrid();
        if (gi == null) {
            return out;
        }
        WorldCoord wc = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        wc.add(this.orientation, 1);
        InventoryAdaptor ia = InventoryAdaptor.getAdaptor(this.field_70331_k.func_72796_p(wc.x, wc.y, wc.z), this.orientation.getOpposite());
        if (ia != null) {
            ItemStack returnValue = out.func_77946_l();
            int allowItems = gi.usePowerForAddition(out.field_77994_a, 1);
            if (allowItems < out.field_77994_a) {
                out.field_77994_a = allowItems;
                returnValue.field_77994_a -= allowItems;
            } else {
                returnValue.field_77994_a = 0;
            }
            if (out.field_77994_a > 0) {
                out = ia.addItems(out);
            }
            if (out != null) {
                returnValue.field_77994_a += out.field_77994_a;
            }
            if (returnValue.field_77994_a == 0) {
                return null;
            }
            return returnValue;
        }
        return out;
    }

    @Override
    public String getName() {
        switch (this.ver) {
            case Basic: {
                return "AppEng.Blocks.ExportBus.name";
            }
            case Precision: {
                return "AppEng.Blocks.ExportBusPrecision.name";
            }
            case Fuzzy: {
                return "AppEng.Blocks.ExportBusFuzzy.name";
            }
        }
        return "Undefined";
    }

    @Override
    public void OnCraftingChange(CraftingManager cm) {
    }

    @Override
    public void jobDone(CraftingManager cm) {
        this.throttle.wakeUp();
        this.sleepMode = 0;
    }

    @Override
    public void updateSetting(IConfigEnum newValue) {
        if (newValue instanceof RedstoneModeInput) {
            this.rsMode = (RedstoneModeInput)newValue;
        }
        if (newValue instanceof StackModeOutput) {
            this.sMode = (StackModeOutput)newValue;
        }
        if (newValue instanceof FuzzyMode) {
            this.fuzzyMode = (FuzzyMode)newValue;
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (type == IPipeTile.PipeType.ITEM) {
            return this.orientation == with ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public ForgeDirection getPrimaryOrientation() {
        return this.orientation;
    }

    @Override
    public int getSpin() {
        return 0;
    }

    @Override
    public void setPrimaryOrientation(ForgeDirection s) {
        this.orientation = s;
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.getWorld(), this.getLocation()));
    }

    @Override
    public void setSpin(int spin) {
    }
}

