/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.me.items.IAEChargeableItem;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.INonSignalBlock;
import appeng.api.me.util.IGridInterface;
import appeng.common.AppEngInternalInventory;
import appeng.common.AppEngTextureRegistry;
import appeng.interfaces.IPowerSharing;
import appeng.me.METhrottle;
import appeng.me.basetiles.TilePoweredBase;
import appeng.me.tile.TileController;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TilePowerRelay
extends TilePoweredBase
implements IGridTileEntity,
IPowerSharing,
INonSignalBlock,
ISidedInventory {
    List<IGridInterface> cachedSources = new ArrayList<IGridInterface>();
    AppEngInternalInventory inv;
    METhrottle throttle;
    private boolean refreshList;
    int[] input = new int[]{0};
    int[] output = new int[]{1};

    public TilePowerRelay() {
        this.maxStoredPower = 8000.0f;
        this.refreshList = true;
        this.inv = new AppEngInternalInventory(this, 2);
        this.throttle = new METhrottle(1, 1, 60);
    }

    @Override
    public void updateTileEntity() {
        ItemStack is;
        super.updateTileEntity();
        if (this.inv.func_70301_a(0) != null && this.cachedSources.size() > 0 && this.storedPower < 5.0f) {
            for (IGridInterface grid : this.cachedSources) {
                TileEntity te = grid.getController();
                if (!(te instanceof TileController)) continue;
                ArrayList<Object> me = new ArrayList<Object>();
                me.add(this);
                float half = ((TileController)te).storedPower / 2.0f;
                if (!((TileController)te).useMEEnergyRecursive(half, me)) continue;
                this.storedPower += half;
            }
        }
        if (this.throttle.process() && this.storedPower > 0.0f && (is = this.inv.func_70301_a(0)) != null && Platform.isChargeable(is)) {
            Item it = is.func_77973_b();
            float oldPower = this.storedPower;
            this.storedPower = ((IAEChargeableItem)it).addEnergy(is, this.storedPower);
            if ((double)Math.abs(this.storedPower - oldPower) < 0.001) {
                if (this.inv.func_70301_a(1) == null) {
                    this.inv.func_70299_a(1, is);
                    this.inv.func_70299_a(0, null);
                    this.throttle.wakeUp();
                    this.throttle.hasAccomplishedWork();
                }
            } else {
                this.inv.func_70299_a(0, is);
                this.throttle.wakeUp();
                this.throttle.hasAccomplishedWork();
            }
        }
        if ((double)this.storedPower > 0.01) {
            this.onUpdatePower();
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.initList();
        }
    }

    @Override
    public void onUpdatePower() {
        if (this.cachedSources.size() > 0 && (double)this.storedPower > 0.01) {
            double split = (double)this.storedPower / (double)this.cachedSources.size();
            this.storedPower = 0.0f;
            for (IGridInterface grid : this.cachedSources) {
                TileEntity te = grid.getController();
                if (!(te instanceof TileController)) continue;
                this.storedPower = (float)((double)this.storedPower + ((TileController)te).addMEPower(split));
            }
        }
    }

    @Override
    public IGridInterface getGrid() {
        return null;
    }

    @Override
    public void setGrid(IGridInterface gi) {
        this.cachedSources = new ArrayList<IGridInterface>();
        this.refreshList = true;
    }

    @Override
    public void onChunkLoad() {
        super.onChunkLoad();
        this.cachedSources = new ArrayList<IGridInterface>();
        this.refreshList = true;
    }

    private void initList() {
        this.cachedSources = new ArrayList<IGridInterface>();
        this.check(ForgeDirection.UP);
        this.check(ForgeDirection.DOWN);
        this.check(ForgeDirection.SOUTH);
        this.check(ForgeDirection.NORTH);
        this.check(ForgeDirection.EAST);
        this.check(ForgeDirection.WEST);
    }

    @Override
    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        NBTTagCompound invnbt = new NBTTagCompound();
        this.inv.writeToNBT(invnbt);
        tagCompound.func_74766_a("inv", invnbt);
    }

    @Override
    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        this.inv.readFromNBT(tagCompound.func_74775_l("inv"));
    }

    private void check(ForgeDirection north) {
        TileController tc;
        IGridInterface gi;
        TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + north.offsetX, this.field_70330_m + north.offsetY, this.field_70327_n + north.offsetZ);
        if (te instanceof IGridTileEntity && (gi = ((IGridTileEntity)te).getGrid()) != null && (tc = (TileController)gi.getController()) != null && !this.cachedSources.contains(tc)) {
            this.cachedSources.add(tc);
        }
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.cachedSources = new ArrayList<IGridInterface>();
        this.refreshList = true;
    }

    @Override
    public boolean useEnergy(int amount) {
        return this.useEnergy(amount, new ArrayList<Object>());
    }

    @Override
    public boolean canUseEnergy(int amount) {
        return this.canUseEnergy(amount, new ArrayList<Object>());
    }

    @Override
    public boolean useEnergy(int amount, List<Object> providersToIgnore) {
        if (providersToIgnore.contains(this)) {
            return false;
        }
        providersToIgnore.add(this);
        for (IGridInterface grid : this.cachedSources) {
            TileEntity te = grid.getController();
            if (providersToIgnore == null) {
                providersToIgnore = new ArrayList<Object>();
            }
            if (!((TileController)te).useMEEnergyRecursive(amount, providersToIgnore)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canUseEnergy(int amount, List<Object> providersToIgnore) {
        if (providersToIgnore.contains(this)) {
            return false;
        }
        providersToIgnore.add(this);
        for (IGridInterface grid : this.cachedSources) {
            TileEntity te = grid.getController();
            if (providersToIgnore == null) {
                providersToIgnore = new ArrayList<Object>();
            }
            if (!((TileController)te).canUseEnergyRecursive(amount, providersToIgnore)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean useMEEnergy(float use, String for_what) {
        return false;
    }

    @Override
    public int getPowerLevel() {
        return 0;
    }

    @Override
    protected int getMaxStoredPower() {
        return 0;
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection dir) {
        return AppEngTextureRegistry.Blocks.BlockPowerRelay.get();
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inv.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return this.inv.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
    }

    public String func_70303_b() {
        return "PowerRelay";
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0 ? Platform.isChargeable(itemstack) : false;
    }

    public int[] func_94128_d(int s) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)s);
        if (fd == ForgeDirection.UP || fd == ForgeDirection.DOWN) {
            return this.input;
        }
        return this.output;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.isCommonUseableByPlayer(entityplayer);
    }
}

