/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.DimentionalCoord;
import appeng.api.Materials;
import appeng.api.TileRef;
import appeng.api.WorldCoord;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IFulllyOptionalMETile;
import appeng.api.me.tiles.IGridTeleport;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngInternalInventory;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.network.IAppEngNetworkTile;
import appeng.interfaces.ICustomCollision;
import appeng.interfaces.InvOperation;
import appeng.me.basetiles.TilePoweredBase;
import appeng.me.cluster.QuantumCluster;
import appeng.me.tile.IInternalInventory;
import appeng.render.AppEngBlockRenderer;
import appeng.util.Platform;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileQuantumBridge
extends TilePoweredBase
implements ICustomCollision,
IGridTeleport,
IFulllyOptionalMETile,
IGridTileEntity,
IAppEngNetworkTile,
IDirectionalMETile,
IInventory {
    public AppEngInternalInventory inv;
    final byte start = (byte)15;
    final byte corner = (byte)16;
    final byte hasSingularity = (byte)32;
    final byte powered = (byte)64;
    public boolean bridgePowered;
    int oldxdex = -1;
    byte xdex;
    QuantumCluster clust;

    public TileQuantumBridge() {
        this.updateStatus(null, (byte)-1);
        this.inv = new AppEngInternalInventory(this, 1);
        this.inv.setMaxStackSize(1);
    }

    public void updateStatus(QuantumCluster obj, byte dex) {
        boolean hasCust = this.clust != null;
        this.xdex = dex;
        this.clust = obj;
        this.updatePowerCosts();
    }

    private void updatePowerCosts() {
        this.maxStoredPower = this.clust != null ? (!this.isCorner() || this.isCenter() ? 10.0f * AppEngConfiguration.perTickNetworkBridge : 0.0f) : 0.0f;
    }

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        if (Platform.isClient()) {
            boolean hasSingularityS;
            if (!this.isCenter() || this.xdex == -1) {
                return;
            }
            boolean hasPower = (this.xdex & 0x40) == 64;
            boolean bl = hasSingularityS = (this.xdex & 0x20) == 32;
            if (hasSingularityS && (this.xdex & 0xF) > 0) {
                AppEng.getInstance().SideProxy.SingularityEffect(this);
            }
            return;
        }
        this.updatePowerCosts();
        if (this.clust != null) {
            if (this.isCenter()) {
                boolean oldPower = this.bridgePowered;
                this.bridgePowered = this.useMEEnergy(AppEngConfiguration.perTickNetworkBridge, "NetworkBridge");
                if (oldPower != this.bridgePowered && this.clust != null) {
                    this.clust.updateStatus(true);
                    this.clust.updateRender();
                }
            } else if (this.storedPower > 0.0f) {
                try {
                    this.storedPower = (float)this.clust.getCenter().getTile().addMEPower(this.storedPower);
                }
                catch (AppEngTileMissingException e) {
                    AppEng.log("Unable to submit power to QNB");
                }
            }
        }
        if (this.oldxdex != this.xdex) {
            this.oldxdex = this.xdex;
            this.tickUpdateCount = 0;
            this.markForUpdate();
            this.updatePowerConnectivity();
            MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.field_70331_k, this.getLocation()));
        }
    }

    @Override
    public boolean requiresTickingUpdates() {
        return true;
    }

    boolean isCorner() {
        return (this.xdex & 0x10) == 16;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return !this.isCorner() && !this.isCenter();
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return !this.isCorner() && !this.isCenter();
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (this.isCorner()) {
            return null;
        }
        return super.getPowerReceiver(side);
    }

    @Override
    public boolean isPowered() {
        if (this.clust == null) {
            return false;
        }
        if (!AppEngConfiguration.requirePower) {
            return true;
        }
        return this.clust.hasPower();
    }

    @Override
    public boolean isEnabled() {
        return !this.isSeperated() && this.isPowered();
    }

    @Override
    public boolean isSeperated() {
        return this.isCorner();
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        if (this.isCenter()) {
            TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + direction.offsetX, this.field_70330_m + direction.offsetY, this.field_70327_n + direction.offsetZ);
            return this.clust != null && te instanceof TileQuantumBridge;
        }
        return !this.isCorner();
    }

    @Override
    public int getLightValue() {
        return 0;
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection dir) {
        if (this.isCenter()) {
            return AppEngTextureRegistry.Blocks.BlockQLink.get();
        }
        if (this.xdex == -1) {
            return AppEngTextureRegistry.Blocks.BlockQRingEdge.get();
        }
        if (this.isCorner()) {
            return AppEngTextureRegistry.Blocks.BlockQRingCorner.get();
        }
        return AppEngTextureRegistry.Blocks.BlockQRingEdge.get();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderCableAt(double Thickness, IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer, Icon texture, boolean center, double pull) {
        AppEngBlockRenderer AppEngRenderer = AppEngBlockRenderer.instance;
        AppEngRenderer.setOverrideBlockTexture(block, texture);
        if (this.connectsTo(world, x - 1, y, z)) {
            renderer.func_83020_a(0.0, 0.5 - Thickness, 0.5 - Thickness, 0.5 - Thickness - pull, 0.5 + Thickness, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x + 1, y, z)) {
            renderer.func_83020_a(0.5 + Thickness + pull, 0.5 - Thickness, 0.5 - Thickness, 1.0, 0.5 + Thickness, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y, z - 1)) {
            renderer.func_83020_a(0.5 - Thickness, 0.5 - Thickness, 0.0, 0.5 + Thickness, 0.5 + Thickness, 0.5 - Thickness - pull);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y, z + 1)) {
            renderer.func_83020_a(0.5 - Thickness, 0.5 - Thickness, 0.5 + Thickness + pull, 0.5 + Thickness, 0.5 + Thickness, 1.0);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y - 1, z)) {
            renderer.func_83020_a(0.5 - Thickness, 0.0, 0.5 - Thickness, 0.5 + Thickness, 0.5 - Thickness - pull, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        if (this.connectsTo(world, x, y + 1, z)) {
            renderer.func_83020_a(0.5 - Thickness, 0.5 + Thickness + pull, 0.5 - Thickness, 0.5 + Thickness, 1.0, 0.5 + Thickness);
            renderer.func_78570_q(block, x, y, z);
        }
        AppEngRenderer.setOverrideBlockTexture(block, null);
    }

    private boolean connectsTo(IBlockAccess world, int x, int i, int z) {
        TileEntity te = world.func_72796_p(x, i, z);
        if (Platform.isClient() ? te instanceof TileQuantumBridge && this.xdex != -1 : te instanceof TileQuantumBridge) {
            return !((TileQuantumBridge)te).isCorner();
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.field_78661_f = true;
        if (this.isCenter()) {
            this.renderCableAt(0.11, world, x, y, z, block, modelId, renderer, AppEngTextureRegistry.Blocks.BlockMEQlink.get(), true, 0.141);
            this.renderCableAt(0.188, world, x, y, z, block, modelId, renderer, AppEngTextureRegistry.Blocks.MECable.get(), false, 0.1875);
            float px = 0.125f;
            float maxpx = 0.875f;
            renderer.func_83020_a((double)px, (double)px, (double)px, (double)maxpx, (double)maxpx, (double)maxpx);
            renderer.func_78570_q(block, x, y, z);
        } else if (this.xdex == -1) {
            float px = 0.125f;
            float maxpx = 0.875f;
            renderer.func_83020_a((double)px, (double)px, (double)px, (double)maxpx, (double)maxpx, (double)maxpx);
            renderer.func_78570_q(block, x, y, z);
        } else if (this.isCorner()) {
            this.renderCableAt(0.188, world, x, y, z, block, modelId, renderer, AppEngTextureRegistry.Blocks.MECable.get(), false, 0.05);
            float px = 0.25f;
            float maxpx = 0.75f;
            renderer.func_83020_a((double)px, (double)px, (double)px, (double)maxpx, (double)maxpx, (double)maxpx);
            renderer.func_78570_q(block, x, y, z);
            if ((this.xdex & 0x40) == 64) {
                AppEngBlockRenderer AppEngRenderer = AppEngBlockRenderer.instance;
                AppEngRenderer.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.BlockQRingCornerLight.get());
                px = 0.24375f;
                maxpx = 0.75625f;
                renderer.func_83020_a((double)px, (double)px, (double)px, (double)maxpx, (double)maxpx, (double)maxpx);
                int bn = 15;
                Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
                Tessellator.field_78398_a.func_78380_c(bn << 20 | bn << 4);
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    this.renderFace(block, renderer, side);
                }
                AppEngRenderer.setOverrideBlockTexture(block, null);
            }
        } else {
            float px = 0.125f;
            float maxpx = 0.875f;
            renderer.func_83020_a(0.0, (double)px, (double)px, 1.0, (double)maxpx, (double)maxpx);
            renderer.func_78570_q(block, x, y, z);
            renderer.func_83020_a((double)px, 0.0, (double)px, (double)maxpx, 1.0, (double)maxpx);
            renderer.func_78570_q(block, x, y, z);
            renderer.func_83020_a((double)px, (double)px, 0.0, (double)maxpx, (double)maxpx, 1.0);
            renderer.func_78570_q(block, x, y, z);
            if ((this.xdex & 0x40) == 64) {
                AppEngBlockRenderer AppEngRenderer = AppEngBlockRenderer.instance;
                AppEngRenderer.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.BlockQRingEdgeLight.get());
                px = -6.25E-4f;
                maxpx = 1.000625f;
                renderer.func_83020_a((double)px, (double)px, (double)px, (double)maxpx, (double)maxpx, (double)maxpx);
                int bn = 15;
                Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
                Tessellator.field_78398_a.func_78380_c(bn << 20 | bn << 4);
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    this.renderFace(block, renderer, side);
                }
                AppEngRenderer.setOverrideBlockTexture(block, null);
            }
        }
        renderer.field_78661_f = false;
        return true;
    }

    public boolean isNetBridge(IBlockAccess w, int x, int y, int z) {
        return w.func_72796_p(x, y, z) instanceof TileQuantumBridge;
    }

    @Override
    protected void terminate() {
        this.disconnect();
        super.terminate();
    }

    void disconnect() {
        if (this.clust != null) {
            this.clust.destroy();
            this.clust = null;
        }
    }

    public void calculateMultiblock() {
        block23: {
            if (Platform.isClient()) {
                return;
            }
            try {
                WorldCoord min = this.getLocation();
                WorldCoord max = this.getLocation();
                World w = this.field_70331_k;
                while (this.isNetBridge((IBlockAccess)w, min.x - 1, min.y, min.z)) {
                    --min.x;
                }
                while (this.isNetBridge((IBlockAccess)w, min.x, min.y - 1, min.z)) {
                    --min.y;
                }
                while (this.isNetBridge((IBlockAccess)w, min.x, min.y, min.z - 1)) {
                    --min.z;
                }
                while (this.isNetBridge((IBlockAccess)w, max.x + 1, max.y, max.z)) {
                    ++max.x;
                }
                while (this.isNetBridge((IBlockAccess)w, max.x, max.y + 1, max.z)) {
                    ++max.y;
                }
                while (this.isNetBridge((IBlockAccess)w, max.x, max.y, max.z + 1)) {
                    ++max.z;
                }
                if ((max.x - min.x + 1) * (max.y - min.y + 1) * (max.z - min.z + 1) != 9) break block23;
                int ones = (max.x - min.x == 0 ? 1 : 0) + (max.y - min.y == 0 ? 1 : 0) + (max.z - min.z == 0 ? 1 : 0);
                int threes = (max.x - min.x == 2 ? 1 : 0) + (max.y - min.y == 2 ? 1 : 0) + (max.z - min.z == 2 ? 1 : 0);
                if (ones != 1 || threes != 2 || !TileQuantumBridge.verifyUnownedRegion((IBlockAccess)w, min, max)) break block23;
                QuantumCluster c = new QuantumCluster(min, max);
                byte num = 0;
                int ringNum = 0;
                try {
                    for (int x = min.x; x <= max.x; ++x) {
                        for (int y = min.y; y <= max.y; ++y) {
                            for (int z = min.z; z <= max.z; ++z) {
                                TileQuantumBridge te = (TileQuantumBridge)w.func_72796_p(x, y, z);
                                if (!te.isValid()) {
                                    this.disconnect();
                                    return;
                                }
                                if ((num = (byte)((byte)(num + 1))) == 5) {
                                    if (w.func_72805_g(x, y, z) == AppEng.getInstance().registration.blkQuantumLink.getMetaData()) continue;
                                    this.disconnect();
                                    return;
                                }
                                if (w.func_72805_g(x, y, z) == AppEng.getInstance().registration.blkQuantumRing.getMetaData()) continue;
                                this.disconnect();
                                return;
                            }
                        }
                    }
                }
                catch (Exception err) {
                    this.disconnect();
                    return;
                }
                boolean updateGrid = false;
                if (this.clust == null) {
                    num = 0;
                    for (int x = min.x; x <= max.x; ++x) {
                        for (int y = min.y; y <= max.y; ++y) {
                            for (int z = min.z; z <= max.z; ++z) {
                                TileQuantumBridge te = (TileQuantumBridge)w.func_72796_p(x, y, z);
                                byte Fish = 0;
                                if ((num = (byte)((byte)(num + 1))) == 5) {
                                    Fish = num;
                                    c.setCenter(te);
                                } else {
                                    Fish = num == 1 || num == 3 || num == 7 || num == 9 ? (byte)((byte)(0x10 | num)) : num;
                                    int n = ringNum;
                                    ringNum = (byte)(ringNum + 1);
                                    c.Ring[n] = new TileRef(te);
                                }
                                te.updateStatus(c, Fish);
                            }
                        }
                    }
                    updateGrid = true;
                } else {
                    c = this.clust;
                }
                c.updateStatus(updateGrid);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.disconnect();
    }

    public static boolean verifyUnownedRegionInner(IBlockAccess w, int minx, int miny, int minz, int maxx, int maxy, int maxz, ForgeDirection side) {
        switch (side) {
            case WEST: {
                maxx = --minx;
                break;
            }
            case EAST: {
                minx = ++maxx;
                break;
            }
            case DOWN: {
                maxy = --miny;
                break;
            }
            case NORTH: {
                minz = ++maxz;
                break;
            }
            case SOUTH: {
                maxz = --minz;
                break;
            }
            case UP: {
                miny = ++maxy;
                break;
            }
            case UNKNOWN: {
                return false;
            }
        }
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                for (int z = minz; z <= maxz; ++z) {
                    TileEntity te = w.func_72796_p(x, y, z);
                    if (!(te instanceof TileQuantumBridge)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean verifyUnownedRegion(IBlockAccess w, WorldCoord min, WorldCoord max) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!TileQuantumBridge.verifyUnownedRegionInner(w, min.x, min.y, min.z, max.x, max.y, max.z, side)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onNeighborBlockChange() {
        this.calculateMultiblock();
        this.updatePowerCosts();
    }

    private boolean isCenter() {
        return this.field_70331_k != null && this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n) == AppEng.getInstance().registration.blkQuantumLink.getMetaData();
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.inv.readFromNBT(par1nbtTagCompound);
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        this.inv.writeToNBT(par1nbtTagCompound);
    }

    @Override
    public boolean isBlockNormalCube() {
        return false;
    }

    @Override
    public void configureTilePacket(DataOutputStream data) {
        try {
            boolean hasPowerVal = false;
            boolean hasQES = false;
            if (this.clust != null) {
                hasPowerVal = this.clust.hasPower();
                hasQES = this.clust.hasQES();
            }
            data.writeByte(this.xdex | (hasQES ? 32 : 0) | (hasPowerVal ? 64 : 0));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void handleTilePacket(DataInputStream stream) {
        this.oldxdex = this.xdex;
        try {
            this.xdex = stream.readByte();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.xdex != this.oldxdex) {
            this.markForUpdate();
        }
    }

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return st == IAppEngNetworkTile.SyncTime.WORLD;
    }

    @Override
    protected int getMaxStoredPower() {
        return 0;
    }

    @Override
    public void InvChanged(IInternalInventory invv, int slot, InvOperation Operation) {
        if (invv == this.inv && this.clust != null) {
            this.clust.updateStatus(true);
            this.markForUpdate();
        }
    }

    @Override
    public DimentionalCoord[] findRemoteSide() {
        if (this.isEnabled() && this.clust != null && this.isPowered()) {
            return this.clust.getOtherSide();
        }
        return new DimentionalCoord[0];
    }

    public long getQEDest() {
        if (this.isCenter() && this.inv.func_70301_a(0) != null) {
            NBTTagCompound cmp = Platform.openNbtData(this.inv.func_70301_a(0));
            return cmp.func_74763_f("freq");
        }
        return 0L;
    }

    @Override
    public boolean useMEEnergy(float use, String for_what) {
        if (!AppEngConfiguration.requirePower) {
            return true;
        }
        if (this.storedPower >= (use *= AppEngConfiguration.powerUsageMultiplier)) {
            this.storedPower -= use;
            return true;
        }
        this.storedPower = 0.0f;
        this.func_70296_d();
        return false;
    }

    public void updateGrid() {
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.field_70331_k, this.getLocation()));
    }

    @Override
    public void addCollidingBlockToList(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        AppEngMultiBlock blk = (AppEngMultiBlock)this.func_70311_o();
        float thickness = 0.38f;
        if (this.xdex == -1 || this.isCenter()) {
            float xminPos = 0.5f - thickness;
            float xmaxPos = 0.5f + thickness;
            float yminPos = 0.5f - thickness;
            float ymaxPos = 0.5f + thickness;
            float zminPos = 0.5f - thickness;
            float zmaxPos = 0.5f + thickness;
            AxisAlignedBB b = AxisAlignedBB.func_72332_a().func_72299_a((double)xminPos, (double)yminPos, (double)zminPos, (double)xmaxPos, (double)ymaxPos, (double)zmaxPos);
            blk.func_71905_a((float)b.field_72340_a, (float)b.field_72338_b, (float)b.field_72339_c, (float)b.field_72336_d, (float)b.field_72337_e, (float)b.field_72334_f);
            blk.configureCollidingBlockToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
            blk.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else if (this.isCorner()) {
            blk.func_71905_a(0.2f, 0.2f, 0.2f, 0.8f, 0.8f, 0.8f);
            blk.configureCollidingBlockToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
            blk.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            blk.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            blk.configureCollidingBlockToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
        }
    }

    @Override
    public AxisAlignedBB[] getSelectedBoundingBoxsFromPool(World world, int i, int j, int k) {
        float thickness = 0.38f;
        float xminPos = 0.5f - thickness;
        float xmaxPos = 0.5f + thickness;
        float yminPos = 0.5f - thickness;
        float ymaxPos = 0.5f + thickness;
        float zminPos = 0.5f - thickness;
        float zmaxPos = 0.5f + thickness;
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        if (this.xdex == -1 || this.isCenter()) {
            boxes.add(AxisAlignedBB.func_72332_a().func_72299_a((double)xminPos, (double)yminPos, (double)zminPos, (double)xmaxPos, (double)ymaxPos, (double)zmaxPos));
        } else if (this.isCorner()) {
            boxes.add(AxisAlignedBB.func_72332_a().func_72299_a(0.25, 0.25, 0.25, 0.75, 0.75, 0.75));
        } else {
            boxes.add(AxisAlignedBB.func_72332_a().func_72299_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        }
        return boxes.toArray(new AxisAlignedBB[boxes.size()]);
    }

    public int func_70302_i_() {
        if (this.isCenter()) {
            return this.inv.func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        if (this.isCenter()) {
            return this.inv.func_70301_a(i);
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.isCenter()) {
            return this.inv.func_70298_a(i, j);
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.isCenter()) {
            return this.inv.func_70304_b(i);
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (this.isCenter()) {
            this.inv.func_70299_a(i, itemstack);
        }
    }

    public String func_70303_b() {
        return "Quantum Network Bridge";
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return Platform.isSameItemType(itemstack, Materials.matQuantumEntangledSingularity);
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.isCommonUseableByPlayer(entityplayer);
    }
}

