/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.Materials;
import appeng.api.WorldCoord;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.me.tiles.IColoredMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IOrientableTile;
import appeng.api.me.tiles.IStorageAware;
import appeng.api.me.tiles.IStorageMonitor;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngInternalInventory;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.network.IAppEngNetworkTile;
import appeng.common.network.packets.PacketStorageMonitor;
import appeng.me.basetiles.TileME;
import appeng.util.AEItemStack;
import appeng.util.Platform;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class TileStorageMonitor
extends TileME
implements IOrientableTile,
IAppEngNetworkTile,
IStorageMonitor,
IGridMachine,
IColoredMETile,
IStorageAware {
    public ForgeDirection orientation;
    public int spin;
    protected int color = Colors.length;
    protected boolean isLocked;
    protected boolean upgraded;
    protected IAEItemStack myItem;

    @Override
    public void onNetworkInventoryChange(IItemList iItemList) {
        long oldQty = this.myItem == null ? 0L : this.myItem.getStackSize();
        IAEItemStack inv = iItemList.findItem(this.myItem);
        if (inv == null && this.myItem != null) {
            inv = this.myItem.copy();
            inv.setStackSize(0L);
        }
        if (inv != null) {
            this.myItem = inv.copy();
            if (oldQty != inv.getStackSize()) {
                this.markForUpdate();
            }
        }
    }

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return true;
    }

    public TileStorageMonitor() {
        this.hasPower = false;
        this.isLocked = false;
        this.orientation = ForgeDirection.NORTH;
    }

    public boolean upgrade() {
        if (AppEngConfiguration.enableStorageMonitorConvMatrix) {
            if (this.upgraded) {
                return false;
            }
            this.upgraded = true;
            this.markForUpdate();
            return true;
        }
        return false;
    }

    @Override
    public int getLightValue() {
        return this.hasPower ? 7 : 0;
    }

    @Override
    public NBTTagCompound getSettings() {
        NBTTagCompound c = new NBTTagCompound();
        c.func_74757_a("locked", this.isLocked);
        if (this.myItem != null) {
            this.myItem.writeToNBT(c);
        }
        return c;
    }

    @Override
    public void restoreSettings(NBTTagCompound tag) {
        this.isLocked = tag.func_74767_n("locked");
        this.myItem = AEItemStack.loadItemStackFromNBT(tag);
        if (this.getGrid() != null) {
            this.onNetworkInventoryChange(this.getGrid().getCellArray().getAvailableItems());
        }
        this.markForUpdate();
    }

    @Override
    public void setOrientationBySide(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        super.setOrientationBySide(player, side, hitX, hitY, hitZ);
        ForgeDirection orientation = ForgeDirection.getOrientation((int)side);
        WorldCoord pos = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        pos.add(orientation, -1);
        TileEntity te = this.field_70331_k.func_72796_p(pos.x, pos.y, pos.z);
        if (te instanceof IColoredMETile && ((IColoredMETile)te).isColored()) {
            this.color = ((IColoredMETile)te).getColor();
            MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.field_70331_k, this.getLocation()));
        }
    }

    @Override
    public void placedBy(EntityLivingBase entityliving) {
        int rotation = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        if (entityliving.field_70125_A > 65.0f) {
            this.spin = rotation;
            rotation = 4;
        } else if (entityliving.field_70125_A < -65.0f) {
            this.spin = rotation;
            rotation = 5;
        }
        this.orientation = this.getDirectionFromAERotation((byte)rotation);
    }

    protected Icon getTerminalFace() {
        if (this.color < 0) {
            this.color = 0;
        }
        return this.upgraded ? AppEngTextureRegistry.Blocks.MEStorageMonitorMatrix[this.color].get() : AppEngTextureRegistry.Blocks.MEStorageMonitor[this.color].get();
    }

    private Icon defTextures(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return AppEngTextureRegistry.Blocks.GenericTop.get();
        }
        if (side == ForgeDirection.DOWN) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        return AppEngTextureRegistry.Blocks.GenericSide.get();
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        Icon frontFace = this.getTerminalFace();
        if (this.orientation == side) {
            return frontFace;
        }
        return this.defTextures(side);
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("r", (int)this.getAERotationFromDirection(this.orientation));
        par1nbtTagCompound.func_74768_a("s", this.spin);
        par1nbtTagCompound.func_74768_a("c", this.color);
        par1nbtTagCompound.func_74757_a("l", this.isLocked);
        par1nbtTagCompound.func_74757_a("u", this.upgraded);
        AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
        if (this.myItem != null) {
            inv.func_70299_a(0, Platform.getSharedItemStack(this.myItem));
        }
        inv.writeToNBT(par1nbtTagCompound);
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.orientation = this.getDirectionFromAERotation((byte)par1nbtTagCompound.func_74762_e("r"));
        this.spin = par1nbtTagCompound.func_74762_e("s");
        this.color = par1nbtTagCompound.func_74762_e("c");
        this.isLocked = par1nbtTagCompound.func_74767_n("l");
        this.upgraded = par1nbtTagCompound.func_74767_n("u");
        AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
        inv.readFromNBT(par1nbtTagCompound);
        this.myItem = inv.func_70301_a(0) == null ? null : AEItemStack.create(inv.func_70301_a(0));
    }

    public boolean[] noScreen() {
        byte rotation = this.getAERotationFromDirection(this.orientation);
        return new boolean[]{rotation == 5, rotation == 4, rotation == 2, rotation == 0, rotation == 1, rotation == 3};
    }

    public boolean[] screenOnly() {
        byte rotation = this.getAERotationFromDirection(this.orientation);
        return new boolean[]{rotation != 5, rotation != 4, rotation != 2, rotation != 0, rotation != 1, rotation != 3};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (this.hasPower) {
            AppEngMultiBlock b = (AppEngMultiBlock)block;
            b.dontrender = this.noScreen();
            renderer.func_78570_q(block, x, y, z);
            b.dontrender = this.screenOnly();
            int bn = 15;
            Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
            Tessellator.field_78398_a.func_78380_c(bn << 20 | bn << 4);
            this.renderFace(block, renderer, this.orientation);
            b.dontrender = null;
        } else {
            renderer.func_78570_q(block, x, y, z);
        }
        return true;
    }

    @Override
    public boolean isBlockNormalCube() {
        return true;
    }

    @Override
    public IAEItemStack getItem() {
        return this.myItem;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    public void toggleLock() {
        this.isLocked = !this.isLocked;
        this.markForUpdate();
    }

    public void setItem(ItemStack p) {
        if (this.isLocked) {
            IMEInventoryHandler ginv;
            IGridInterface gi = this.getGrid();
            if (gi != null && AppEngConfiguration.enableStorageMonitorConvMatrix && this.upgraded && this.hasPower && this.myItem != null && (ginv = gi.getCellArray()) != null) {
                this.myItem.setStackSize(64L);
                IAEItemStack out = ginv.extractItems(this.myItem);
                if (out != null) {
                    ArrayList<ItemStack> set = new ArrayList<ItemStack>();
                    set.add(out.getItemStack());
                    WorldCoord wc = this.getLocation();
                    wc.add(this.orientation, 1);
                    Platform.spawnDrops(this.field_70331_k, wc.x, wc.y, wc.z, set);
                }
            }
            return;
        }
        if (p != null && (p = Platform.cloneItemStack(p)).func_77942_o()) {
            p.func_77982_d(Platform.getSharedTagCompound(p));
        }
        this.myItem = AEItemStack.create(p);
        if (this.getGrid() != null) {
            this.onNetworkInventoryChange(this.getGrid().getCellArray().getAvailableItems());
        }
        this.markForUpdate();
    }

    @Override
    public void handleTilePacket(DataInputStream stream) {
        try {
            int oldSpin = this.spin;
            ForgeDirection oldOrientation = this.orientation;
            int oldColor = this.color;
            boolean oldupgraded = this.upgraded;
            boolean oldhasPower = this.hasPower;
            byte rotation = stream.readByte();
            this.spin = rotation >> 4;
            this.orientation = this.getDirectionFromAERotation((byte)(rotation & 0xF));
            this.color = stream.readByte();
            byte flags = stream.readByte();
            this.upgraded = (flags & 1) == 1;
            this.hasPower = (flags & 2) == 2;
            boolean hasItem = (flags & 4) == 4;
            this.myItem = hasItem ? AEItemStack.loadItemStackFromPacket(stream) : null;
            if (oldSpin != this.spin || oldOrientation != this.orientation || oldColor != this.color || oldupgraded != this.upgraded || oldhasPower != this.hasPower) {
                this.markForUpdate();
            }
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    public void configureTilePacket(DataOutputStream data) {
        try {
            data.writeByte((byte)(this.getAERotationFromDirection(this.orientation) | this.spin << 4));
            data.writeByte(this.color);
            byte flags = 0;
            flags = (byte)(flags | (this.upgraded ? 1 : 0));
            flags = (byte)(flags | (this.hasPower ? 2 : 0));
            flags = (byte)(flags | (this.myItem != null ? 4 : 0));
            data.writeByte(flags);
            if (this.myItem != null) {
                this.myItem.writeToPacket(data);
            }
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    public boolean isColored() {
        return this.color != Colors.length;
    }

    @Override
    public void setPowerStatus(boolean _hasPower) {
        super.setPowerStatus(_hasPower);
        this.hasPower = _hasPower;
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.markForUpdate();
    }

    @Override
    public boolean getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        if (this.upgraded) {
            drops.add(Materials.matConversionMatrix.func_77946_l());
        }
        return false;
    }

    @Override
    public float getPowerDrainPerTick() {
        return 1.0f;
    }

    @Override
    public void setColor(int offset) {
        this.color = offset;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public void onPlayerInteract(PlayerInteractEvent e) {
        EntityPlayer p = e.entityPlayer;
        World w = p.field_70170_p;
        if (Platform.isClient()) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)e.face);
            if (dir == this.orientation) {
                try {
                    PacketDispatcher.sendPacketToServer((Packet)new PacketStorageMonitor(e.x, e.y, e.z, e.face).getPacket());
                    e.setCanceled(true);
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            return;
        }
        if (p.func_71045_bC() != null) {
            Item eq = p.func_71045_bC().func_77973_b();
            if (Platform.isSameItemType(Materials.matConversionMatrix, p.func_71045_bC()) && p.func_70093_af()) {
                if (this.upgrade()) {
                    p.field_71071_by.func_70298_a(p.field_71071_by.field_70461_c, 1);
                }
                return;
            }
        }
        if (this.getGrid() != null) {
            if (this.isPowered()) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)e.face);
                if (dir == this.orientation) {
                    ItemStack eqq = p.func_71045_bC();
                    if (Platform.isWrench(p, eqq, e.x, e.y, e.z) && p.func_70093_af()) {
                        this.toggleLock();
                        Platform.LocalizedChatMsg(this.isLocked() ? "ChatMsg.Locked" : "ChatMsg.Unlocked", p);
                        return;
                    }
                    boolean canExtract = this.upgraded;
                    if (!AppEngConfiguration.enableStorageMonitorConvMatrix) {
                        canExtract = false;
                    }
                    ItemStack hand = p.func_71045_bC();
                    if (canExtract && this.isLocked() && p.func_70093_af() && hand != null) {
                        int usePower = this.getGrid().usePowerForAddition(hand.field_77994_a, 1);
                        if (usePower > 0) {
                            ItemStack whatCanI = hand.func_77946_l();
                            whatCanI.field_77994_a = usePower;
                            ItemStack leftOvers = Platform.addItems(this.getGrid().getCellArray(), whatCanI);
                            p.field_71071_by.func_70298_a(p.field_71071_by.field_70461_c, whatCanI.field_77994_a - (leftOvers == null ? 0 : leftOvers.field_77994_a));
                        }
                    } else if (canExtract && this.isLocked() && p.func_70093_af() && this.getItem() != null && hand == null) {
                        ItemStack filter = this.getItem().getItemStack();
                        for (int x = 0; x < p.field_71071_by.func_70302_i_(); ++x) {
                            hand = p.field_71071_by.func_70301_a(x);
                            if (!Platform.isSameItem(hand, filter)) continue;
                            int usePower = this.getGrid().usePowerForAddition(hand.field_77994_a, 1);
                            if (usePower > 0) {
                                ItemStack whatCanI = hand.func_77946_l();
                                whatCanI.field_77994_a = usePower;
                                ItemStack leftOvers = Platform.refundEnergy(this.getGrid(), Platform.addItems(this.getGrid().getCellArray(), whatCanI), "Storage Monitor");
                                p.field_71071_by.func_70298_a(x, whatCanI.field_77994_a - (leftOvers == null ? 0 : leftOvers.field_77994_a));
                                continue;
                            }
                            break;
                        }
                    } else {
                        this.setItem(p.func_71045_bC());
                    }
                    e.setCanceled(true);
                }
            } else {
                Platform.LocalizedChatMsg("ChatMsg.NoPowerSM", p);
            }
        } else {
            Platform.LocalizedChatMsg("ChatMsg.NoController", p);
        }
    }

    @Override
    public ForgeDirection getPrimaryOrientation() {
        return this.orientation;
    }

    @Override
    public int getSpin() {
        return this.spin;
    }

    @Override
    public void setPrimaryOrientation(ForgeDirection s) {
        this.orientation = s;
    }

    @Override
    public void setSpin(int _spin) {
        this.spin = _spin;
    }
}

