/*
 * Decompiled with CFR 0.152.
 */
package appeng.proxy;

import appeng.api.exceptions.AppEngException;
import appeng.proxy.IProxyBC;
import appeng.proxy.helpers.FacadeProxyBC;
import appeng.proxy.helpers.IFacadeProxy;
import appeng.util.Platform;
import buildcraft.api.core.Position;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.FacadeManager;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.TileGenericPipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class ProxyBC
implements IProxyBC {
    public ProxyBC() throws AppEngException {
        if (!Platform.isModLoaded("BuildCraft|Core")) {
            throw new AppEngException("Buildcraft is not available.");
        }
    }

    @Override
    public void addFacade(ItemStack item) {
        FacadeManager.addFacade((ItemStack)item);
    }

    @Override
    public IFacadeProxy createFacadeProxy() {
        return new FacadeProxyBC();
    }

    @Override
    public boolean isWrench(Item eq) {
        return eq instanceof IToolWrench;
    }

    @Override
    public boolean isPipe(TileEntity te, ForgeDirection dir) {
        if (te instanceof IPipeTile) {
            try {
                if (te instanceof TileGenericPipe && ((TileGenericPipe)te).hasPlug(dir.getOpposite())) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canWrench(Item i, EntityPlayer p, int x, int y, int z) {
        return ((IToolWrench)i).canWrench(p, x, y, z);
    }

    @Override
    public void wrenchUsed(Item i, EntityPlayer p, int x, int y, int z) {
        ((IToolWrench)i).wrenchUsed(p, x, y, z);
    }

    @Override
    public boolean addItemsToPipe(TileEntity te, ItemStack is, ForgeDirection dir) {
        IPipeTile pt;
        if (is != null && te != null && te instanceof IPipeTile && (pt = (IPipeTile)te).getPipeType() == IPipeTile.PipeType.ITEM) {
            try {
                if (te instanceof TileGenericPipe && ((TileGenericPipe)te).hasPlug(dir.getOpposite())) {
                    return false;
                }
            }
            catch (Exception err) {
                // empty catch block
            }
            Position itemPos = new Position((double)te.field_70329_l, (double)te.field_70330_m, (double)te.field_70327_n, dir);
            itemPos.x += 0.5;
            itemPos.y += 0.25;
            itemPos.z += 0.5;
            int amt = pt.injectItem(is, false, dir);
            if (amt == is.field_77994_a) {
                pt.injectItem(is, true, dir);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFacade(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b() instanceof ItemFacade;
    }
}

