/*
 * Decompiled with CFR 0.152.
 */
package appeng.proxy;

import appeng.api.exceptions.AppEngException;
import appeng.api.me.util.IMEInventory;
import appeng.proxy.IProxyFactorization;
import appeng.proxy.helpers.FactorizationBarrel;
import appeng.util.Platform;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ProxyFactorization
implements IProxyFactorization {
    private static Class day_BarrelClass;
    private static Method day_getItemCount;
    private static Method day_setItemCount;
    private static Method day_getMaxSize;
    private static Field day_item;
    private static Class barrelClass;
    private static Method getItemCount;
    private static Method setItemCount;
    private static Method getMaxSize;
    private static Field item;

    public ProxyFactorization() throws AppEngException {
        try {
            barrelClass = Class.forName("factorization.common.TileEntityBarrel");
            day_BarrelClass = Class.forName("factorization.common.TileEntityDayBarrel");
            getItemCount = barrelClass.getDeclaredMethod("getItemCount", new Class[0]);
            setItemCount = barrelClass.getDeclaredMethod("setItemCount", Integer.TYPE);
            getMaxSize = barrelClass.getDeclaredMethod("getMaxSize", new Class[0]);
            item = barrelClass.getDeclaredField("item");
            day_getItemCount = day_BarrelClass.getDeclaredMethod("getItemCount", new Class[0]);
            day_setItemCount = day_BarrelClass.getDeclaredMethod("setItemCount", Integer.TYPE);
            day_getMaxSize = day_BarrelClass.getDeclaredMethod("getMaxSize", new Class[0]);
            day_item = day_BarrelClass.getDeclaredField("item");
        }
        catch (Exception e) {
            throw new AppEngException("Factorization is not available.");
        }
    }

    @Override
    public ItemStack barrelGetItem(TileEntity te) {
        try {
            ItemStack i = day_BarrelClass.isInstance(te) ? (ItemStack)day_item.get(te) : (ItemStack)item.get(te);
            if (i != null) {
                i = Platform.cloneItemStack(i);
            }
            return i;
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int barrelGetMaxItemCount(TileEntity te) {
        try {
            if (day_BarrelClass.isInstance(te)) {
                return (Integer)day_getMaxSize.invoke((Object)te, new Object[0]);
            }
            return (Integer)getMaxSize.invoke((Object)te, new Object[0]);
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public int barrelGetItemCount(TileEntity te) {
        try {
            if (day_BarrelClass.isInstance(te)) {
                return (Integer)day_getItemCount.invoke((Object)te, new Object[0]);
            }
            return (Integer)getItemCount.invoke((Object)te, new Object[0]);
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public void setItemType(TileEntity te, ItemStack input) {
        try {
            if (day_BarrelClass.isInstance(te)) {
                day_item.set(te, input == null ? null : input.func_77946_l());
            } else {
                item.set(te, input == null ? null : input.func_77946_l());
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public void barrelSetCount(TileEntity te, int max) {
        try {
            if (day_BarrelClass.isInstance(te)) {
                day_setItemCount.invoke((Object)te, max);
            } else {
                setItemCount.invoke((Object)te, max);
            }
            te.field_70331_k.func_72845_h(te.field_70329_l, te.field_70330_m, te.field_70327_n);
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    @Override
    public IMEInventory getFactorizationBarrel(TileEntity te) {
        return new FactorizationBarrel(this, te);
    }

    @Override
    public boolean isBarrel(TileEntity te) {
        if (day_BarrelClass.isAssignableFrom(te.getClass())) {
            return true;
        }
        return barrelClass.isAssignableFrom(te.getClass());
    }
}

