/*
 * Decompiled with CFR 0.152.
 */
package appeng.proxy.helpers;

import appeng.proxy.helpers.IFacadeProxy;
import appeng.proxy.helpers.IFacadeTile;
import appeng.render.AppEngBlockRenderer;
import buildcraft.transport.ItemFacade;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class FacadeProxyBC
implements IFacadeProxy {
    float facadeThickness = 0.0625f;
    int[] facadeBlocks = new int[6];
    int[] facadeMeta = new int[6];

    private void mirrorY(float[][] targetArray) {
        float temp = targetArray[1][0];
        targetArray[1][0] = (targetArray[1][1] - 0.5f) * -1.0f + 0.5f;
        targetArray[1][1] = (temp - 0.5f) * -1.0f + 0.5f;
    }

    private void rotate(float[][] targetArray) {
        for (int i = 0; i < 2; ++i) {
            float temp = targetArray[2][i];
            targetArray[2][i] = targetArray[1][i];
            targetArray[1][i] = targetArray[0][i];
            targetArray[0][i] = temp;
        }
    }

    private void transform(float[][] targetArray, ForgeDirection direction) {
        if ((direction.ordinal() & 1) == 1) {
            this.mirrorY(targetArray);
        }
        for (int i = 0; i < direction.ordinal() >> 1; ++i) {
            this.rotate(targetArray);
        }
    }

    private float[][] deepClone(float[][] source) {
        float[][] target = (float[][])source.clone();
        for (int i = 0; i < target.length; ++i) {
            target[i] = (float[])source[i].clone();
        }
        return target;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void facadeRender(RenderBlocks renderblocks, Block block, IFacadeTile ft, int x, int y, int z, float tubeThickness) {
        float zFightOffset = 2.4414062E-4f;
        float[][] zeroState = new float[3][2];
        zeroState[0][0] = 0.0f - zFightOffset / 2.0f;
        zeroState[0][1] = 1.0f + zFightOffset / 2.0f;
        zeroState[1][0] = 0.0f - zFightOffset;
        zeroState[1][1] = this.facadeThickness;
        zeroState[2][0] = 0.0f;
        zeroState[2][1] = 1.0f;
        renderblocks.field_78661_f = true;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (this.hasFacade(ft, direction)) {
                float[][] rotated;
                Block blk = Block.field_71973_m[this.facadeBlocks[direction.ordinal()]];
                renderblocks.field_78664_d = blk.func_71858_a(direction.ordinal(), this.facadeMeta[direction.ordinal()]);
                try {
                    AppEngBlockRenderer.overrideRenderColor = Item.field_77698_e[this.facadeBlocks[direction.ordinal()]].func_82790_a(new ItemStack(this.facadeBlocks[direction.ordinal()], 1, this.facadeMeta[direction.ordinal()]), 0);
                }
                catch (Throwable error) {
                    // empty catch block
                }
                if (blk.func_71857_b() == 31) {
                    if ((this.facadeMeta[direction.ordinal()] & 0xC) == 4) {
                        renderblocks.field_78662_g = 1;
                        renderblocks.field_78683_h = 1;
                        renderblocks.field_78681_k = 1;
                        renderblocks.field_78675_l = 1;
                    } else if ((this.facadeMeta[direction.ordinal()] & 0xC) == 8) {
                        renderblocks.field_78685_i = 1;
                        renderblocks.field_78679_j = 1;
                    }
                }
                float holeThickness = ft.getHoleThickness(direction);
                if (ft.isConnected(direction)) {
                    rotated = this.deepClone(zeroState);
                    rotated[2][0] = 0.0f;
                    rotated[2][1] = 0.0f + holeThickness;
                    float[] fArray = rotated[1];
                    fArray[0] = fArray[0] - zFightOffset / 2.0f;
                    this.transform(rotated, direction);
                    block.func_71905_a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
                    renderblocks.func_83018_a(block);
                    renderblocks.func_78570_q(block, x, y, z);
                    rotated = this.deepClone(zeroState);
                    rotated[2][0] = 1.0f - holeThickness;
                    float[] fArray2 = rotated[1];
                    fArray2[0] = fArray2[0] - zFightOffset / 2.0f;
                    this.transform(rotated, direction);
                    block.func_71905_a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
                    renderblocks.func_83018_a(block);
                    renderblocks.func_78570_q(block, x, y, z);
                    rotated = this.deepClone(zeroState);
                    rotated[0][0] = 0.0f;
                    rotated[0][1] = 0.0f + holeThickness;
                    float[] fArray3 = rotated[1];
                    fArray3[1] = fArray3[1] - zFightOffset;
                    this.transform(rotated, direction);
                    block.func_71905_a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
                    renderblocks.func_83018_a(block);
                    renderblocks.func_78570_q(block, x, y, z);
                    rotated = this.deepClone(zeroState);
                    rotated[0][0] = 1.0f - holeThickness;
                    rotated[0][1] = 1.0f;
                    float[] fArray4 = rotated[1];
                    fArray4[1] = fArray4[1] - zFightOffset;
                    this.transform(rotated, direction);
                    block.func_71905_a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
                    renderblocks.func_83018_a(block);
                    renderblocks.func_78570_q(block, x, y, z);
                } else {
                    rotated = this.deepClone(zeroState);
                    this.transform(rotated, direction);
                    block.func_71905_a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
                    renderblocks.func_83018_a(block);
                    renderblocks.func_78570_q(block, x, y, z);
                }
                AppEngBlockRenderer.overrideRenderColor = -1;
            }
            renderblocks.field_78662_g = 0;
            renderblocks.field_78683_h = 0;
            renderblocks.field_78681_k = 0;
            renderblocks.field_78675_l = 0;
            renderblocks.field_78685_i = 0;
            renderblocks.field_78679_j = 0;
        }
        zeroState[0][0] = 0.0f + tubeThickness;
        zeroState[0][1] = 1.0f - tubeThickness;
        zeroState[1][0] = this.facadeThickness;
        zeroState[1][1] = 0.0f + tubeThickness;
        zeroState[2][0] = 0.0f + tubeThickness;
        zeroState[2][1] = 1.0f - tubeThickness;
        if ((double)tubeThickness > 0.001) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                if (!this.hasFacade(ft, direction) || ft.isConnected(direction)) continue;
                float[][] rotated = this.deepClone(zeroState);
                this.transform(rotated, direction);
                block.func_71905_a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
                renderblocks.func_83018_a(block);
                renderblocks.func_78570_q(block, x, y, z);
            }
        }
        renderblocks.field_78661_f = false;
        renderblocks.field_78664_d = null;
    }

    ItemStack createFacade(int itemid, int meta) {
        return null;
    }

    @Override
    public List<ItemStack> getDrops(IFacadeTile ft) {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (this.facadeBlocks[direction.ordinal()] == 0) continue;
            ItemStack facade = this.createFacade(this.facadeBlocks[direction.ordinal()], this.facadeMeta[direction.ordinal()]);
            this.facadeMeta[direction.ordinal()] = 0;
            out.add(facade);
        }
        return out;
    }

    @Override
    public boolean addFacade(IFacadeTile ft, ForgeDirection direction, int blockid, int meta) {
        if (this.hasFacade(ft, direction)) {
            this.dropFacade(ft, direction);
        }
        this.facadeBlocks[direction.ordinal()] = blockid;
        this.facadeMeta[direction.ordinal()] = meta;
        ft.markForUpdate();
        return true;
    }

    @Override
    public boolean hasFacade(IFacadeTile ft, ForgeDirection direction) {
        return this.facadeBlocks[direction.ordinal()] != 0;
    }

    @Override
    public void dropFacade(IFacadeTile ft, ForgeDirection direction) {
        if (this.facadeBlocks[direction.ordinal()] != 0) {
            ItemStack facade = this.createFacade(this.facadeBlocks[direction.ordinal()], this.facadeMeta[direction.ordinal()]);
            this.facadeBlocks[direction.ordinal()] = 0;
            this.facadeMeta[direction.ordinal()] = 0;
            ft.dropFacadeItem(facade);
            ft.markForUpdate();
        }
    }

    @Override
    public boolean readFromStream(DataInputStream out) throws IOException {
        boolean diffrent = false;
        for (int x = 0; x < 6; ++x) {
            int fb = this.facadeBlocks[x];
            int fm = this.facadeMeta[x];
            this.facadeBlocks[x] = out.readInt();
            this.facadeMeta[x] = out.readInt();
            diffrent = diffrent || fb != this.facadeBlocks[x] || fm != this.facadeMeta[x];
        }
        return diffrent;
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        for (int x = 0; x < 6; ++x) {
            out.writeInt(this.facadeBlocks[x]);
            out.writeInt(this.facadeMeta[x]);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tc) {
        tc.func_74783_a("facadeBlocks", this.facadeBlocks);
        tc.func_74783_a("facadeMeta", this.facadeMeta);
    }

    @Override
    public void readFromNBT(NBTTagCompound tc) {
        this.facadeBlocks = tc.func_74759_k("facadeBlocks");
        this.facadeMeta = tc.func_74759_k("facadeMeta");
        if (this.facadeBlocks == null) {
            this.facadeBlocks = new int[6];
        }
        if (this.facadeMeta == null) {
            this.facadeMeta = new int[6];
        }
        if (this.facadeBlocks.length != 6) {
            this.facadeBlocks = new int[6];
        }
        if (this.facadeMeta.length != 6) {
            this.facadeMeta = new int[6];
        }
    }

    @Override
    public boolean addFacade(TileEntity tileEntity, int side, ItemStack hand) {
        if (tileEntity instanceof IFacadeTile) {
            try {
                return this.addFacade((IFacadeTile)tileEntity, ForgeDirection.getOrientation((int)side), ItemFacade.getBlockId((ItemStack)hand), ItemFacade.getMetaData((ItemStack)hand));
            }
            catch (Throwable e) {
                FMLLog.severe((String)"Unable to place facade item, please make sure your using the newest Version of BC and AE, and if you are inform AlgorithmX2 of this message.", (Object[])new Object[0]);
            }
        }
        return false;
    }
}

