/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes;

import appeng.api.Blocks;
import appeng.api.Items;
import appeng.api.Materials;
import appeng.api.Util;
import appeng.api.me.tiles.IColoredMETile;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngMultiItemBlock;
import appeng.common.registries.AppEngGrinderRecipeManager;
import appeng.recipes.AEShapedOreRecipe;
import appeng.recipes.AEShapedQuartzRecipe;
import appeng.recipes.AEShapelessOreRecipe;
import buildcraft.api.recipes.AssemblyRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;

public class AERecipes {
    public ItemStack GoldChip;
    public ItemStack DiamondChip;
    public ItemStack woodGear;
    List<IRecipe> recipeList;
    AppEng AppEng;

    boolean isDisabled(ItemStack output) {
        try {
            Item item = output.func_77973_b();
            if (item instanceof AppEngMultiItemBlock) {
                AppEngMultiBlock aemb = (AppEngMultiBlock)Block.field_71973_m[((AppEngMultiItemBlock)item).func_77883_f()];
                return !aemb.getSubBlock(output.func_77960_j()).isEnabled();
            }
        }
        catch (Throwable tx) {
            tx.printStackTrace();
            return true;
        }
        return false;
    }

    void addRecipe(ItemStack output, Object ... t) {
        if (this.isDisabled(output)) {
            return;
        }
        if (output != null) {
            this.recipeList.add((IRecipe)new AEShapedOreRecipe(output, t));
        }
    }

    void addShapelessRecipe(ItemStack output, Object ... t) {
        if (this.isDisabled(output)) {
            return;
        }
        if (output != null) {
            this.recipeList.add((IRecipe)new AEShapelessOreRecipe(output, t));
        }
    }

    void addQuartzRecipe(ItemStack output, boolean dust, Object ... t) {
        if (this.isDisabled(output)) {
            return;
        }
        if (output != null) {
            this.recipeList.add(new AEShapedQuartzRecipe(output, dust, t));
        }
    }

    void addFurnaceRecipe(ItemStack input, ItemStack Output, float XP) {
        if (this.isDisabled(Output)) {
            return;
        }
        FurnaceRecipes.func_77602_a().addSmelting(input.field_77993_c, input.func_77960_j(), Output, XP);
    }

    public AERecipes() {
        AERecipes aERecipes = this;
        this.AppEng = aERecipes.AppEng.getInstance();
        this.recipeList = CraftingManager.func_77594_a().func_77592_b();
        this.DiamondChip = Materials.matProcessorAdvanced;
        this.GoldChip = Materials.matProcessorBasic;
        this.BCCompatibility();
        if (!AppEngConfiguration.useBuildcraftChips) {
            this.addProcessors();
        }
        this.AddNuggets();
        this.AddQuartzTools();
        if (AppEngConfiguration.enableGrinder) {
            this.addGrindStnone();
        }
        if (this.AppEng.registration.blkTinyTNT != null) {
            this.addQuartzRecipe(new ItemStack((Block)this.AppEng.registration.blkTinyTNT), true, "GD", "DG", Character.valueOf('D'), "dustQuartz", Character.valueOf('G'), new ItemStack(Item.field_77677_M));
        }
        this.AddCraftingMats();
        this.addStorageCells();
        this.AddTools();
        this.AddMECables();
        this.AddMEItems();
        this.AddMEBlocks();
        this.AddFurnaceProcessingRecipes();
        this.AddGrinderProcessingRecipes();
    }

    private void AddFurnaceProcessingRecipes() {
        this.addFurnaceRecipe(Materials.matIronDust, new ItemStack(Item.field_77703_o), 0.7f);
        this.addFurnaceRecipe(Materials.matGoldDust, new ItemStack(Item.field_77717_p), 1.0f);
        this.addFurnaceRecipe(Materials.matFlour, new ItemStack(Item.field_77684_U), 0.1f);
        this.addFurnaceRecipe(Materials.matQuartzDust, Materials.matSilicon, 0.2f);
        this.addFurnaceRecipe(Materials.matQuartzDustNether, Materials.matSilicon, 0.2f);
        this.addFurnaceRecipe(Materials.matProcessorAdvancedUncooked, Materials.matProcessorAdvanced, 0.2f);
        this.addFurnaceRecipe(Materials.matProcessorBasicUncooked, Materials.matProcessorBasic, 0.2f);
    }

    private void AddGrinderProcessingRecipes() {
        AERecipes aERecipes = this;
        AppEngGrinderRecipeManager GrinderRecipes = (AppEngGrinderRecipeManager)aERecipes.AppEng.getApiInstance().getGrinderRecipeManage();
        GrinderRecipes.addOreDiciontaryEntires();
        ItemStack dustRecipe = Materials.matQuartzDustNether.func_77946_l();
        dustRecipe.field_77994_a = 1;
        GrinderRecipes.addRecipe(new ItemStack(Block.field_71981_t), new ItemStack(Block.field_71978_w), 1);
        GrinderRecipes.addRecipe(new ItemStack(Block.field_71978_w), new ItemStack(Block.field_71939_E), 8);
        GrinderRecipes.addRecipe(new ItemStack(Block.field_71957_Q), new ItemStack(Block.field_71939_E), 4);
        GrinderRecipes.addRecipe(new ItemStack(Block.field_71946_M), new ItemStack(Block.field_71939_E), 4);
        GrinderRecipes.addRecipe(new ItemStack(Item.field_77731_bo), new ItemStack(Item.field_77722_bw, 4), 8);
        GrinderRecipes.addRecipe(new ItemStack(Block.field_72014_bd), new ItemStack(Item.field_77751_aT, 4), 8);
        GrinderRecipes.addRecipe(new ItemStack(Block.field_71940_F), new ItemStack(Item.field_77804_ap), 2);
        GrinderRecipes.addRecipe(new ItemStack(Item.field_77755_aX), new ItemStack(Item.field_77756_aW, 6, 15), 4);
        GrinderRecipes.addRecipe(new ItemStack(Item.field_77758_aJ, 1), new ItemStack(Item.field_77747_aY, 2), 8);
        GrinderRecipes.addRecipe(new ItemStack(Item.field_77685_T, 1), Materials.matFlour, 3);
        GrinderRecipes.addRecipe(Blocks.blkQuartzOre, Materials.matQuartz, 2);
        GrinderRecipes.addRecipe(Materials.matQuartz, Materials.matQuartzDust, 2);
        GrinderRecipes.addRecipe(new ItemStack(Item.field_94583_ca), dustRecipe, 2);
    }

    private void addGrindStnone() {
        this.addRecipe(Materials.matCrank, "SSS", "  S", "  S", Character.valueOf('S'), "stickWood");
        this.addQuartzRecipe(Blocks.blkGrinder, true, "SGS", "QSQ", "CQC", Character.valueOf('S'), new ItemStack(Block.field_71981_t), Character.valueOf('C'), new ItemStack(Block.field_71978_w), Character.valueOf('G'), this.woodGear, Character.valueOf('Q'), "dustQuartz");
    }

    private void addStorageCells() {
        this.addRecipe(Items.itemCell1k, "GRG", "RXR", "III", Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('R'), new ItemStack(Item.field_77767_aC, 1), Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('X'), Materials.matStorageCell);
        this.addRecipe(Items.itemCell4k, "GRG", "RXR", "III", Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('R'), new ItemStack(Item.field_77767_aC, 1), Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('X'), Materials.matStorageSegment);
        this.addRecipe(Items.itemCell16k, "GRG", "RXR", "III", Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('R'), new ItemStack(Item.field_77767_aC, 1), Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('X'), Materials.matStorageBlock);
        this.addRecipe(Items.itemCell64k, "GRG", "RXR", "III", Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('R'), new ItemStack(Item.field_77767_aC, 1), Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('X'), Materials.matStorageCluster);
        this.addShapelessRecipe(Items.itemCell1k, Materials.matStorageCellHouseing, Materials.matStorageCell);
        this.addShapelessRecipe(Items.itemCell4k, Materials.matStorageCellHouseing, Materials.matStorageSegment);
        this.addShapelessRecipe(Items.itemCell16k, Materials.matStorageCellHouseing, Materials.matStorageBlock);
        this.addShapelessRecipe(Items.itemCell64k, Materials.matStorageCellHouseing, Materials.matStorageCluster);
    }

    private void AddNuggets() {
        ArrayList ironNuggets = OreDictionary.getOres((String)"nuggetIron");
        if (ironNuggets.isEmpty()) {
            this.addShapelessRecipe(new ItemStack(Item.field_77703_o), Materials.matIronNugget, Materials.matIronNugget, Materials.matIronNugget, Materials.matIronNugget, Materials.matIronNugget, Materials.matIronNugget, Materials.matIronNugget, Materials.matIronNugget, Materials.matIronNugget);
            ItemStack nn = Materials.matIronNugget.func_77946_l();
            nn.field_77994_a = 9;
            this.addShapelessRecipe(nn, new ItemStack(Item.field_77703_o));
            OreDictionary.registerOre((String)"nuggetIron", (ItemStack)Materials.matIronNugget);
        } else {
            Materials.matIronNugget = (ItemStack)ironNuggets.get(0);
        }
    }

    private void AddQuartzTools() {
        this.addQuartzRecipe(Items.toolQuartzKnife, false, "  S", "IS ", "QQ ", Character.valueOf('S'), "stickWood", Character.valueOf('I'), new ItemStack(Item.field_77703_o), Character.valueOf('Q'), "crystalQuartz");
        this.addQuartzRecipe(Items.toolQuartzWrench, false, "Q Q", " Q ", "Q Q", Character.valueOf('Q'), "crystalQuartz");
        ItemStack qglass = Blocks.blkQuartzGlass.func_77946_l();
        qglass.field_77994_a = 4;
        this.addQuartzRecipe(qglass, true, "CGC", "GCG", "CGC", Character.valueOf('G'), new ItemStack(Block.field_71946_M), Character.valueOf('C'), "dustQuartz");
        this.addShapelessRecipe(Blocks.blkQuartzLamp, Blocks.blkQuartzGlass, new ItemStack(Item.field_77751_aT), new ItemStack(Item.field_77751_aT));
        this.addRecipe(Blocks.blkQuantumLink, "CPC", "P P", "CPC", Character.valueOf('C'), Blocks.blkQuartzGlass, Character.valueOf('P'), Materials.matFluxPearl);
        this.addRecipe(Blocks.blkQuantumRing, "IGI", "AEC", "IGI", Character.valueOf('C'), Blocks.blkColorlessCable, Character.valueOf('E'), Blocks.blkEnergyCell, Character.valueOf('I'), new ItemStack(Item.field_77703_o), Character.valueOf('G'), this.GoldChip, Character.valueOf('A'), this.DiamondChip);
        if (AppEngConfiguration.enableQuartzTools) {
            this.addQuartzRecipe(Items.toolQuartzShovel, false, " Q ", " S ", " S ", Character.valueOf('S'), "stickWood", Character.valueOf('Q'), "crystalQuartz");
            this.recipeList.add(new AEShapedQuartzRecipe(Items.toolQuartzHoe, false, "QQ ", " S ", " S ", Character.valueOf('S'), "stickWood", Character.valueOf('Q'), "crystalQuartz"));
            this.addQuartzRecipe(Items.toolQuartzPick, false, "QQQ", " S ", " S ", Character.valueOf('S'), "stickWood", Character.valueOf('Q'), "crystalQuartz");
            this.addQuartzRecipe(Items.toolQuartzAxe, false, "QQ ", "QS ", " S ", Character.valueOf('S'), "stickWood", Character.valueOf('Q'), "crystalQuartz");
            this.addQuartzRecipe(Items.toolQuartzSword, false, " Q ", " Q ", " S ", Character.valueOf('S'), "stickWood", Character.valueOf('Q'), "crystalQuartz");
        }
    }

    private void AddMEBlocks() {
        if (!AppEngConfiguration.disableNetherQuartzDeblocking) {
            ItemStack nBlockOut = new ItemStack(Item.field_94583_ca, 1);
            nBlockOut.field_77994_a = 4;
            this.addShapelessRecipe(nBlockOut, new ItemStack(Block.field_94339_ct, Short.MAX_VALUE));
        }
        ItemStack BlockOut = Materials.matQuartz.func_77946_l();
        BlockOut.field_77994_a = 4;
        this.addShapelessRecipe(BlockOut, Blocks.blkQuartz);
        this.addRecipe(Blocks.blkQuartz, "AA", "AA", Character.valueOf('A'), Materials.matQuartz);
        this.addRecipe(Blocks.blkPowerRelay, "ICI", "CXC", "ICI", Character.valueOf('C'), Blocks.blkColorlessCable, Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('X'), Blocks.blkEnergyCell);
        this.addRecipe(Blocks.blkEnergyCell, "IFI", "FGF", "IFI", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('F'), Materials.matFluxCrystal);
        this.addRecipe(Blocks.blkCondenser, "IGI", "GFG", "IGI", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('F'), Materials.matFluxDust);
        this.addRecipe(Blocks.blkTransitionPlane, "FFF", "IXI", "IAI", Character.valueOf('A'), Blocks.blkColorlessCable, Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('F'), Materials.matFluxDust, Character.valueOf('X'), Materials.matConversionMatrix);
        this.addRecipe(Blocks.blkChest, "GMG", "ICI", "III", Character.valueOf('C'), new ItemStack((Block)Block.field_72077_au, 1), Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('M'), Materials.matConversionMatrix);
        this.addRecipe(Blocks.blkController, "IQI", "QXQ", "IQI", Character.valueOf('Q'), Materials.matFluxCrystal, Character.valueOf('X'), this.DiamondChip, Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1));
        this.addRecipe(Blocks.blkDrive, "IRI", "GCG", "IRI", Character.valueOf('C'), new ItemStack((Block)Block.field_72077_au, 1), Character.valueOf('R'), this.GoldChip, Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1));
        this.addRecipe(Blocks.blkInterface, "IGI", "CXG", "IGI", Character.valueOf('C'), Blocks.blkColorlessCable, Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('X'), Materials.matConversionMatrix);
        this.addRecipe(Blocks.blkWireless, "IGI", "AWG", "IGI", Character.valueOf('A'), Blocks.blkColorlessCable, Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('W'), Materials.matWireless);
        this.addRecipe(Blocks.blkTerminal, "IIG", "AXG", "IIG", Character.valueOf('A'), Blocks.blkColorlessCable, Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('X'), Materials.matConversionMatrix);
        this.addRecipe(Blocks.blkCraftingTerminal, "IIG", "CSX", "IIG", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('S'), Materials.matStorageCell, Character.valueOf('C'), new ItemStack(Block.field_72060_ay), Character.valueOf('X'), Blocks.blkTerminal);
        this.addRecipe(Blocks.blkAssembler, "ITI", "XDX", "ISI", Character.valueOf('D'), this.DiamondChip, Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('T'), new ItemStack(Block.field_72060_ay), Character.valueOf('S'), Materials.matStorageCell, Character.valueOf('X'), Materials.matConversionMatrix);
        this.addRecipe(Blocks.blkPatternEncoder, "IXI", "ITI", "III", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('T'), new ItemStack(Block.field_72060_ay), Character.valueOf('X'), Materials.matConversionMatrix);
        this.addRecipe(Blocks.blkPartitioner, "GXG", "ITI", "III", Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('T'), new ItemStack(Block.field_72060_ay), Character.valueOf('X'), Materials.matConversionMatrix);
        this.addRecipe(Blocks.blkInputCableBasic, " C ", "IXI", " P ", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('P'), new ItemStack((Block)Block.field_71956_V), Character.valueOf('C'), Blocks.blkColorlessCable, Character.valueOf('X'), Blocks.blkInterface);
        this.addRecipe(Blocks.blkOutputCableBasic, " C ", "IXI", " P ", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('P'), new ItemStack((Block)Block.field_71963_Z), Character.valueOf('C'), Blocks.blkColorlessCable, Character.valueOf('X'), Blocks.blkInterface);
        this.addShapelessRecipe(Blocks.blkInputCableFuzzy, Blocks.blkInputCableBasic, this.DiamondChip);
        this.addShapelessRecipe(Blocks.blkOutputCableFuzzy, Blocks.blkOutputCableBasic, this.DiamondChip);
        this.addShapelessRecipe(Blocks.blkInputCablePrecision, Blocks.blkInputCableBasic, this.GoldChip);
        this.addShapelessRecipe(Blocks.blkOutputCablePrecision, Blocks.blkOutputCableBasic, this.GoldChip);
        this.addRecipe(Blocks.blkLevelEmitter, " I ", "CXR", " I ", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('C'), Blocks.blkColorlessCable, Character.valueOf('R'), new ItemStack(Block.field_72035_aQ), Character.valueOf('X'), this.GoldChip);
        this.addRecipe(Blocks.blkStorageMonitor, "IIG", "AXG", "IIG", Character.valueOf('A'), Blocks.blkColorlessCable, Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('X'), Blocks.blkLevelEmitter);
        this.addRecipe(Blocks.blkAssemblerFieldWall, "IGI", "GQG", "IGI", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('G'), new ItemStack(Item.field_77717_p, 1), Character.valueOf('Q'), Materials.matQuartz);
        this.addRecipe(Blocks.blkHeatVent, "IGI", "GCG", "IGI", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('G'), new ItemStack(Block.field_72002_bp, 1), Character.valueOf('C'), Blocks.blkColorlessCable);
        this.addRecipe(Blocks.blkCraftingAccelerator, "IQI", "GXG", "IQI", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('G'), new ItemStack(Item.field_77751_aT, 1), Character.valueOf('Q'), Materials.matQuartz, Character.valueOf('X'), this.DiamondChip);
        this.addRecipe(Blocks.blkDarkCable, " R ", "CLC", " R ", Character.valueOf('C'), Blocks.blkColorlessCable, Character.valueOf('L'), new ItemStack(Block.field_72043_aJ, 1), Character.valueOf('R'), new ItemStack(Item.field_77767_aC, 1));
        this.addRecipe(Blocks.blkIOPort, "GGG", "DCD", "IXI", Character.valueOf('C'), Blocks.blkColorlessCable, Character.valueOf('D'), Blocks.blkDrive, Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('X'), this.GoldChip);
        GameRegistry.addRecipe((ItemStack)Blocks.blkStorageBus, (Object[])new Object[]{" C ", " X ", "III", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('C'), Blocks.blkColorlessCable, Character.valueOf('X'), Blocks.blkInterface});
        this.addRecipe(Blocks.blkStorageBusFuzzy, " C ", "CXC", " C ", Character.valueOf('X'), Blocks.blkStorageBus, Character.valueOf('C'), new ItemStack(Block.field_72101_ab, 1, Short.MAX_VALUE));
        this.addRecipe(Blocks.blkCraftingMonitor, "IIG", "AXG", "IIG", Character.valueOf('A'), Blocks.blkColorlessCable, Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('X'), this.GoldChip);
    }

    private void AddCraftingMats() {
        this.addRecipe(Materials.matConversionMatrix, "INI", "RXR", "IQI", Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('R'), Materials.matFluxDust, Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('X'), this.GoldChip, Character.valueOf('Q'), Materials.matQuartz, Character.valueOf('N'), new ItemStack(Item.field_94583_ca, 1));
        this.addRecipe(Materials.matConversionMatrix, "IQI", "RXR", "INI", Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('R'), Materials.matFluxDust, Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('X'), this.GoldChip, Character.valueOf('Q'), Materials.matQuartz, Character.valueOf('N'), new ItemStack(Item.field_94583_ca, 1));
        this.addRecipe(Materials.matStorageCell, "RQR", "QXQ", "RQR", Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('R'), new ItemStack(Item.field_77767_aC, 1), Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('X'), this.GoldChip, Character.valueOf('Q'), Materials.matQuartz);
        this.addRecipe(Materials.matStorageSegment, "RCR", "XGX", "RXR", Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('C'), this.GoldChip, Character.valueOf('R'), new ItemStack(Item.field_77767_aC, 1), Character.valueOf('X'), Materials.matStorageCell);
        this.addRecipe(Materials.matStorageBlock, "RCR", "XGX", "RXR", Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('C'), this.DiamondChip, Character.valueOf('R'), new ItemStack(Item.field_77751_aT, 1), Character.valueOf('X'), Materials.matStorageSegment);
        this.addRecipe(Materials.matStorageCluster, "RCR", "XGX", "RXR", Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('C'), this.DiamondChip, Character.valueOf('R'), new ItemStack(Item.field_77751_aT, 1), Character.valueOf('X'), Materials.matStorageBlock);
        this.addRecipe(Materials.matFluxPearl, "DCD", "CEC", "DCD", Character.valueOf('D'), Materials.matFluxDust, Character.valueOf('C'), Materials.matFluxCrystal, Character.valueOf('E'), new ItemStack(Item.field_77730_bn, 1));
        this.addRecipe(Materials.matWireless, " P ", "ISI", " I ", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('S'), "stickWood", Character.valueOf('P'), Materials.matFluxPearl);
        this.addRecipe(Materials.matWirelessBooster, "QR ", "II ", "   ", Character.valueOf('Q'), Materials.matQuartz, Character.valueOf('R'), new ItemStack(Item.field_77767_aC, 1), Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1));
        ItemStack matFluxDustRecipe = Materials.matFluxDust.func_77946_l();
        matFluxDustRecipe.field_77994_a = 3;
        GameRegistry.addShapelessRecipe((ItemStack)matFluxDustRecipe, (Object[])new Object[]{Materials.matQuartzDust, Materials.matQuartzDustNether, new ItemStack(Item.field_77767_aC, 1)});
        ItemStack matFluxCrystalRecipe = Materials.matFluxCrystal.func_77946_l();
        matFluxDustRecipe.field_77994_a = 2;
        GameRegistry.addShapelessRecipe((ItemStack)matFluxCrystalRecipe, (Object[])new Object[]{Materials.matQuartz, new ItemStack(Item.field_94583_ca, 1), new ItemStack(Item.field_77767_aC, 1)});
    }

    private void AddMEItems() {
        this.addRecipe(Materials.matBlankPattern, "GRG", "RXR", "III", Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1), Character.valueOf('R'), new ItemStack(Item.field_77751_aT, 1), Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('X'), Materials.matQuartz);
        this.addRecipe(Items.itemMemoryCard, "AII", "GRG", Character.valueOf('G'), new ItemStack(Item.field_77717_p, 1), Character.valueOf('R'), new ItemStack(Item.field_77767_aC, 1), Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('A'), this.DiamondChip);
    }

    private void AddTools() {
        this.addRecipe(Items.toolWirelessTerminal, " W ", " X ", " E ", Character.valueOf('W'), Materials.matWireless, Character.valueOf('X'), Blocks.blkTerminal, Character.valueOf('E'), Blocks.blkEnergyCell);
        if (Items.toolEntropyAccelerator != null) {
            this.addRecipe(Items.toolEntropyAccelerator, "XT ", " E ", "  I", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('T'), new ItemStack(Block.field_72036_aT, 1), Character.valueOf('E'), Blocks.blkEnergyCell, Character.valueOf('X'), Materials.matConversionMatrix);
        }
        if (Items.toolVibrationCatalyst != null) {
            this.addRecipe(Items.toolVibrationCatalyst, "XT ", " E ", "  I", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('T'), new ItemStack(Item.field_77775_ay, 1), Character.valueOf('E'), Blocks.blkEnergyCell, Character.valueOf('X'), Materials.matConversionMatrix);
        }
        if (Items.toolMassCannon != null) {
            this.addRecipe(Items.toolMassCannon, "IIC", "SD ", "I  ", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1), Character.valueOf('C'), Materials.matConversionMatrix, Character.valueOf('S'), Materials.matStorageSegment, Character.valueOf('D'), Blocks.blkEnergyCell);
        }
    }

    private void AddMECables() {
        int x;
        ItemStack newCable = Blocks.blkColorlessCable.func_77946_l();
        newCable.field_77994_a = 3;
        this.addRecipe(newCable, "GGG", "DDD", "GGG", Character.valueOf('D'), Materials.matFluxDust, Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1));
        this.addShapelessRecipe(Blocks.blkColorlessCableCovered, Blocks.blkColorlessCable, new ItemStack(Block.field_72101_ab, 1, Short.MAX_VALUE));
        this.addShapelessRecipe(Blocks.blkColorlessCable, Blocks.blkColorlessCableCovered);
        for (x = 0; x < this.AppEng.registration.blkCable_Colored.length; ++x) {
            this.addShapelessRecipe(Blocks.blkColorlessCable, Blocks.blkCable_Colored[x]);
        }
        for (x = 0; x < this.AppEng.registration.blkCable_Colored.length; ++x) {
            this.addRecipe(this.AppEng.registration.blkCable_Colored[x].getItemStack(8), "CCC", "CDC", "CCC", Character.valueOf('C'), Blocks.blkColorlessCable, Character.valueOf('D'), "dye" + IColoredMETile.Colors[x]);
        }
    }

    private void BCCompatibility() {
        try {
            Class BuildCraftCore = ReflectionHelper.getClass((ClassLoader)Util.class.getClassLoader(), (String[])new String[]{"buildcraft.BuildCraftCore"});
            Class BuildCraftSilicon = ReflectionHelper.getClass((ClassLoader)Util.class.getClassLoader(), (String[])new String[]{"buildcraft.BuildCraftSilicon"});
            Item chipsetItem = (Item)BuildCraftSilicon.getField("redstoneChipset").get(BuildCraftSilicon);
            Item woodenGearItem = (Item)BuildCraftCore.getField("woodenGearItem").get(BuildCraftCore);
            if (AppEngConfiguration.useBuildcraftChips) {
                this.GoldChip = new ItemStack(chipsetItem, 1, 2);
                this.DiamondChip = new ItemStack(chipsetItem, 1, 3);
                appeng.common.AppEng.log("Using BC Chipsets instead of AE Chips!");
            }
            this.woodGear = new ItemStack(woodenGearItem);
            this.AppEng.buildCraftMode = true;
            ItemStack[] BasicMats = new ItemStack[3];
            ItemStack[] AdvMats = new ItemStack[3];
            ItemStack[] BasicMatsB = new ItemStack[2];
            ItemStack[] AdvMatsB = new ItemStack[2];
            BasicMatsB[0] = Materials.matSilicon;
            AdvMatsB[0] = Materials.matSilicon;
            BasicMatsB[1] = new ItemStack(chipsetItem, 1, 2);
            AdvMatsB[1] = new ItemStack(chipsetItem, 1, 3);
            BasicMats[0] = Materials.matSilicon;
            AdvMats[0] = Materials.matSilicon;
            BasicMats[1] = new ItemStack(Item.field_77767_aC, 1);
            AdvMats[1] = new ItemStack(Item.field_77767_aC, 1);
            BasicMats[2] = new ItemStack(Item.field_77717_p);
            AdvMats[2] = new ItemStack(Item.field_77702_n);
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(BasicMats, 30000, Materials.matProcessorBasic));
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(AdvMats, 50000, Materials.matProcessorAdvanced));
            if (AppEngConfiguration.enableBCtoMEChipRecipe) {
                GameRegistry.addShapelessRecipe((ItemStack)Materials.matProcessorAdvanced, (Object[])new Object[]{AdvMatsB[0], AdvMatsB[1], Materials.matFluxDust});
                GameRegistry.addShapelessRecipe((ItemStack)Materials.matProcessorBasic, (Object[])new Object[]{BasicMatsB[0], BasicMatsB[1], Materials.matFluxDust});
            }
        }
        catch (Exception e) {
            this.woodGear = Materials.matWoodenGear;
            if (AppEngConfiguration.enableGrinder) {
                this.addRecipe(Materials.matWoodenGear, " S ", "S S", " S ", Character.valueOf('S'), "stickWood");
            }
            this.AppEng.buildCraftMode = false;
            FMLLog.info((String)"Could not find Buildcraft Gear adding a substitue.", (Object[])new Object[0]);
        }
    }

    private void addProcessors() {
        this.addRecipe(Materials.matProcessorBasicUncooked, " K ", "RXR", " S ", Character.valueOf('K'), new ItemStack((Item)this.AppEng.registration.itemCrystalKnife, 1, Short.MAX_VALUE), Character.valueOf('S'), Materials.matSilicon, Character.valueOf('R'), new ItemStack(Item.field_77767_aC, 1), Character.valueOf('X'), new ItemStack(Item.field_77717_p));
        this.addRecipe(Materials.matProcessorAdvancedUncooked, " K ", "RXR", " S ", Character.valueOf('K'), new ItemStack((Item)this.AppEng.registration.itemCrystalKnife, 1, Short.MAX_VALUE), Character.valueOf('S'), Materials.matSilicon, Character.valueOf('R'), new ItemStack(Item.field_77767_aC, 1), Character.valueOf('X'), new ItemStack(Item.field_77702_n));
    }
}

