/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes;

import appeng.interfaces.IOreListener;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryHandler {
    private List<IOreListener> ol = new ArrayList<IOreListener>();

    private boolean shouldCare(String name) {
        return true;
    }

    @Subscribe
    public void onOreDictionaryRegister(OreDictionary.OreRegisterEvent event) {
        if (this.shouldCare(event.Name)) {
            for (IOreListener v : this.ol) {
                v.oreRegistered(event.Name, event.Ore);
            }
        }
    }

    public void observe(IOreListener n) {
        this.ol.add(n);
        for (String name : OreDictionary.getOreNames()) {
            if (!this.shouldCare(name)) continue;
            for (ItemStack item : OreDictionary.getOres((String)name)) {
                n.oreRegistered(name, item);
            }
        }
    }
}

