/*
 * Decompiled with CFR 0.152.
 */
package appeng.slot;

import appeng.api.Materials;
import appeng.api.Util;
import appeng.api.me.items.IStorageComponent;
import appeng.api.me.util.IAssemblerPattern;
import appeng.common.AppEng;
import appeng.common.registries.AppEngCellRegistry;
import appeng.slot.AppEngSlot;
import appeng.util.Platform;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class SlotRestrictedInput
extends AppEngSlot {
    public PlaceableItemType which;
    public int stackLimit = -1;

    public int func_75219_a() {
        if (this.stackLimit != -1) {
            return this.stackLimit;
        }
        return super.func_75219_a();
    }

    public boolean isValid(ItemStack is, World theWorld) {
        if (this.which == PlaceableItemType.VALID_ENCODED_PATTERN_W_OUPUT) {
            IAssemblerPattern ap = Util.getAssemblerPattern(is);
            return ap != null && ap.isEncoded() && ap.isCraftable(theWorld);
        }
        return true;
    }

    public SlotRestrictedInput(PlaceableItemType valid, IInventory i, int slotnum, int x, int y) {
        super(i, slotnum, x, y);
        this.which = valid;
        this.icon = valid.icon;
    }

    @Override
    public ItemStack getDisplayStack() {
        IAssemblerPattern ap;
        ItemStack is;
        if (Platform.isClient() && (this.which == PlaceableItemType.VALID_ENCODED_PATTERN_W_OUPUT || this.which == PlaceableItemType.ENCODED_PATTERN_W_OUTPUT) && (is = super.func_75211_c()) != null && (ap = Util.getAssemblerPattern(is)) != null) {
            return ap.getOutput().func_77946_l();
        }
        return super.func_75211_c();
    }

    public boolean func_75214_a(ItemStack i) {
        if (i == null) {
            return false;
        }
        if (i.func_77973_b() == null) {
            return false;
        }
        switch (this.which) {
            case VALID_ENCODED_PATTERN_W_OUPUT: 
            case ENCODED_PATTERN_W_OUTPUT: 
            case ENCODED_PATTERN: {
                if (Util.isAssemblerPattern(i).booleanValue()) {
                    return Util.getAssemblerPattern(i).isEncoded();
                }
                return false;
            }
            case BLANK_PATTERN: {
                if (Platform.isSameItem(i, Materials.matBlankPattern)) {
                    return true;
                }
                if (Util.isAssemblerPattern(i).booleanValue()) {
                    return !Util.getAssemblerPattern(i).isEncoded();
                }
                return false;
            }
            case ORE: {
                return Util.getGrinderRecipeManage().getRecipeForInput(i) != null;
            }
            case POWERED_TOOL: {
                return Platform.isChargeable(i);
            }
            case QE_SINGULARTIY: {
                return Platform.isSameItemType(i, Materials.matQuantumEntangledSingularity);
            }
            case RANGE_BOOSTER: {
                return Platform.isSameItemType(i, Materials.matWirelessBooster);
            }
            case STORAGE_CELLS: {
                return AppEngCellRegistry.isCell(i);
            }
            case STORAGE_COMPONENT: {
                return i.func_77973_b() instanceof IStorageComponent && ((IStorageComponent)i.func_77973_b()).isStorageComponent(i);
            }
            case TRASH: {
                if (AppEngCellRegistry.isCell(i)) {
                    return false;
                }
                return !(i.func_77973_b() instanceof IStorageComponent) || !((IStorageComponent)i.func_77973_b()).isStorageComponent(i);
            }
            case WIRELESS_TERMINAL: {
                return AppEng.getApiInstance().getWirelessRegistry().isWirelessTerminal(i);
            }
        }
        return false;
    }

    public static enum PlaceableItemType {
        STORAGE_CELLS(15),
        ORE(31),
        STORAGE_COMPONENT(63),
        WIRELESS_TERMINAL(79),
        TRASH(95),
        VALID_ENCODED_PATTERN_W_OUPUT(127),
        ENCODED_PATTERN_W_OUTPUT(127),
        ENCODED_PATTERN(127),
        BLANK_PATTERN(143),
        POWERED_TOOL(159),
        RANGE_BOOSTER(111),
        QE_SINGULARTIY(175);

        int icon;

        private PlaceableItemType(int o) {
            this.icon = o;
        }
    }
}

