/*
 * Decompiled with CFR 0.152.
 */
package appeng.tech1.block;

import appeng.api.Materials;
import appeng.common.AppEng;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngSubBlock;
import appeng.gui.AppEngGuiHandler;
import appeng.tech1.tile.TileGrinder;
import appeng.tech1.tile.TilePhantom;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockGrinder
extends AppEngSubBlock {
    public BlockGrinder(AppEngMultiBlock mb, boolean enableGrinder) {
        super(mb, enableGrinder);
        this.unlocalizedName = "GrindStone";
    }

    @Override
    public boolean onBlockActivated(World w, int x, int y, int z, EntityPlayer p, int side) {
        ItemStack crank;
        TileEntity tileEntity = w.func_72796_p(x, y, z);
        if (p.func_71045_bC() != null && Platform.isSameItemType(crank = p.func_71045_bC(), Materials.matCrank)) {
            if (Platform.isBlockAir(w, x, y + 1, z)) {
                p.field_71071_by.func_70298_a(p.field_71071_by.field_70461_c, 1);
                w.func_72832_d(x, y + 1, z, AppEng.getInstance().registration.blkPhantom.getBlockID(), AppEng.getInstance().registration.blkPhantom.getMetaData(), 3);
                TileEntity te = w.func_72796_p(x, y + 1, z);
                if (te instanceof TilePhantom) {
                    ((TilePhantom)te).item = Materials.matCrank;
                }
            }
            return true;
        }
        if (tileEntity == null || p.func_70093_af()) {
            return false;
        }
        Platform.openGui(p, AppEngGuiHandler.GUI_GRINDER, w, x, y, z);
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World w) {
        return new TileGrinder();
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public Icon getBlockTextureFromSide(int side) {
        if (side == 0) {
            return AppEngTextureRegistry.Blocks.BlockGrinderBottom.get();
        }
        if (side == 1) {
            return AppEngTextureRegistry.Blocks.BlockGrinderTop.get();
        }
        return (side - 2) % 4 == 1 ? AppEngTextureRegistry.Blocks.BlockGrinderFace.get() : AppEngTextureRegistry.Blocks.BlockGrinderSide.get();
    }

    @Override
    public boolean isOpaqueCube() {
        return true;
    }
}

