/*
 * Decompiled with CFR 0.152.
 */
package appeng.tech1.tile;

import appeng.api.Materials;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngTile;
import appeng.common.network.IAppEngNetworkTile;
import appeng.interfaces.ICustomCollision;
import appeng.render.BlockRenderer;
import appeng.tech1.tile.TileGrinder;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.common.ForgeDirection;

public class TilePhantom
extends AppEngTile
implements IAppEngNetworkTile,
ICustomCollision {
    public ItemStack item = null;
    private byte playerCount;
    private int extraActive = 0;
    int cycle;
    public int Active;
    byte failedTurns = 0;
    long start = 0L;
    List<EntityPlayer> Players = new ArrayList<EntityPlayer>();
    @SideOnly(value=Side.CLIENT)
    BlockRenderer br;

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return true;
    }

    @Override
    public boolean isBlockNormalCube() {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public int getLightValue() {
        return 0;
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        if (Platform.isSameItemType(this.item, Materials.matCrank)) {
            return AppEngTextureRegistry.Blocks.BlockCrank.get();
        }
        return null;
    }

    @Override
    public boolean requiresTickingUpdates() {
        return Platform.isClient();
    }

    @Override
    public void updateTileEntity() {
        if (Platform.isSameItemType(this.item, Materials.matCrank)) {
            if (this.Active > 0 && this.playerCount > 0) {
                this.scheduleBlockUpdate(1);
                this.cycle += this.playerCount;
                this.Active -= this.playerCount;
                if (Platform.isClient() && this.Active <= 0 && this.extraActive > 0) {
                    this.Active += 20;
                    this.extraActive -= 20;
                }
                if (this.cycle >= 20) {
                    this.cycle -= 20;
                    TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
                    if (te != null && te instanceof TileGrinder) {
                        ((TileGrinder)te).applyForce(1);
                    }
                }
            } else {
                if (this.extraActive > 0) {
                    this.Active += 20;
                    this.extraActive -= 20;
                }
                if (this.extraActive < 0) {
                    this.extraActive = 0;
                }
                if (this.Active < 0) {
                    this.Active = 0;
                }
                this.playerCount = 0;
                this.Players.clear();
            }
        }
    }

    @Override
    public boolean getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        if (this.item != null) {
            drops.add(this.item);
            this.item = null;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        return true;
    }

    public void BreakPhantomTile() {
        this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 3);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(this.item);
        this.item = null;
        Platform.spawnDrops(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, stacks);
    }

    public void checkValid() {
        if (Platform.isSameItemType(this.item, Materials.matCrank)) {
            TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
            if (te instanceof TileGrinder) {
                return;
            }
            this.BreakPhantomTile();
        }
    }

    public void activateEntity(EntityPlayer p) {
        TileEntity te;
        if (Platform.isClient()) {
            return;
        }
        if (p instanceof EntityPlayerMP && p.func_70089_S() && p.func_82114_b() != null && !(p instanceof FakePlayer) && Platform.isSameItemType(this.item, Materials.matCrank) && this.Active <= 0 && (te = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n)) != null && te instanceof TileGrinder) {
            if (((TileGrinder)te).beginForceApplication()) {
                this.failedTurns = 0;
                this.Active = 20;
                this.Players.clear();
                this.Players.add(p);
                this.playerCount = 1;
                this.extraActive = 20;
                this.markForUpdate();
                this.scheduleBlockUpdate(1);
            } else {
                if (this.failedTurns > 5) {
                    this.item = new ItemStack(Item.field_77669_D, 2);
                    this.BreakPhantomTile();
                }
                this.failedTurns = (byte)(this.failedTurns + 1);
            }
        }
    }

    @Override
    public void addCollidingBlockToList(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        if (Platform.isSameItemType(this.item, Materials.matCrank)) {
            AppEngMultiBlock blk = (AppEngMultiBlock)this.func_70311_o();
            blk.func_71905_a(0.18f, 0.0f, 0.18f, 0.82f, 0.6f, 0.82f);
            blk.configureCollidingBlockToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
            blk.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public AxisAlignedBB[] getSelectedBoundingBoxsFromPool(World world, int x, int y, int z) {
        if (Platform.isSameItemType(this.item, Materials.matCrank)) {
            return new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.18f, (double)0.0, (double)0.18f, (double)0.82f, (double)0.6f, (double)0.82f)};
        }
        return new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0)};
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.item = ItemStack.func_77949_a((NBTTagCompound)par1nbtTagCompound.func_74775_l("item"));
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        NBTTagCompound c = new NBTTagCompound();
        if (this.item != null) {
            this.item.func_77955_b(c);
        }
        par1nbtTagCompound.func_74766_a("item", c);
    }

    @Override
    public void handleTilePacket(DataInputStream data) {
        try {
            int items = data.readInt();
            if (items == 1) {
                int len = data.readInt();
                byte[] bytedata = new byte[len];
                data.read(bytedata, 0, len);
                NBTTagCompound c = CompressedStreamTools.func_74792_a((byte[])bytedata);
                ItemStack s = null;
                for (int x = 0; x < items; ++x) {
                    NBTTagCompound i = c.func_74775_l("#" + x);
                    s = ItemStack.func_77949_a((NBTTagCompound)i);
                    if (s == null) continue;
                    s.field_77994_a = i.func_74762_e("C" + x);
                }
                this.item = s;
                this.extraActive += c.func_74762_e("a");
                if (this.Active <= 0) {
                    this.Active += 20;
                    this.extraActive -= 20;
                }
                this.playerCount = c.func_74771_c("p");
                this.start = System.currentTimeMillis();
            }
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    public void configureTilePacket(DataOutputStream data) {
        try {
            data.writeInt(1);
            NBTTagCompound c = new NBTTagCompound();
            NBTTagCompound i = new NBTTagCompound();
            ItemStack is = this.item;
            int isSize = 0;
            if (is != null) {
                isSize = is.field_77994_a;
                is.func_77955_b(i);
            }
            c.func_74766_a("#0", i);
            i.func_74768_a("C0", isSize);
            c.func_74768_a("a", this.extraActive);
            this.extraActive = 0;
            c.func_74774_a("p", this.playerCount);
            byte[] byteData = CompressedStreamTools.func_74798_a((NBTTagCompound)c);
            data.writeInt(byteData.length);
            data.write(byteData);
        }
        catch (IOException e) {
            return;
        }
    }
}

