/*
 * Decompiled with CFR 0.152.
 */
package appeng.tools;

import appeng.common.AppEngConfiguration;
import appeng.common.AppEngItem;
import appeng.common.AppEngTextureRegistry;
import appeng.common.AutoID;
import appeng.interfaces.IElectricChargeable;
import appeng.tools.ElectricBaseImplementation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItemManager;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public abstract class ElectricTool
extends AppEngItem
implements IElectricChargeable {
    final ElectricBaseImplementation ebi = new ElectricBaseImplementation(this);

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister ir) {
        AppEngTextureRegistry.loadTextures(ir, AppEngTextureRegistry.Items);
    }

    @Override
    public boolean use(ItemStack i, double powerusage, EntityLivingBase user, boolean simulate) {
        return this.ebi.use(i, powerusage, user, simulate);
    }

    public boolean canShowChargeToolTip(ItemStack itemStack) {
        return false;
    }

    public int getDamage(ItemStack stack) {
        return 1;
    }

    public ItemStack func_77659_a(ItemStack item, World w, EntityPlayer p) {
        int z;
        int y;
        int x;
        float var4 = 1.0f;
        MovingObjectPosition target = this.func_77621_a(w, p, true);
        if (target == null) {
            return item;
        }
        if (target.field_72313_a == EnumMovingObjectType.TILE && (w.func_72803_f(x = target.field_72311_b, y = target.field_72312_c, z = target.field_72309_d) == Material.field_76256_h || w.func_72803_f(x, y, z) == Material.field_76244_g) && w.func_72962_a(p, x, y, z)) {
            this.func_77648_a(item, p, w, x, y, z, 0, 0.0f, 0.0f, 0.0f);
        }
        return item;
    }

    public ElectricTool(AutoID id) {
        super(id);
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public abstract boolean func_77644_a(ItemStack var1, EntityLivingBase var2, EntityLivingBase var3);

    public abstract boolean func_77648_a(ItemStack var1, EntityPlayer var2, World var3, int var4, int var5, int var6, int var7, float var8, float var9, float var10);

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.rare;
    }

    @Override
    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack is = new ItemStack(par1, 1, AppEngConfiguration.requirePower ? 1 : 0);
        par3List.add(is);
        if (AppEngConfiguration.requirePower) {
            is = is.func_77946_l();
            this.setMaxPower(is);
            par3List.add(is);
        }
    }

    public int func_77612_l() {
        return 2;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    @Override
    public double getStoredAEPower(ItemStack i) {
        return this.ebi.getStoredAEPower(i);
    }

    @Override
    public void setMaxPower(ItemStack is) {
        this.ebi.setMaxPower(is);
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return this.ebi.canProvideEnergy(itemStack);
    }

    public int getChargedItemId(ItemStack itemStack) {
        return this.ebi.getChargedItemId(itemStack);
    }

    public int getEmptyItemId(ItemStack itemStack) {
        return this.ebi.getEmptyItemId(itemStack);
    }

    public int getMaxCharge(ItemStack itemStack) {
        return this.ebi.getMaxCharge(itemStack);
    }

    public int getTier(ItemStack itemStack) {
        return this.ebi.getTier(itemStack);
    }

    public int getTransferLimit(ItemStack itemStack) {
        return this.ebi.getTransferLimit(itemStack);
    }

    public float receiveEnergy(ItemStack theItem, float energy, boolean doReceive) {
        return this.ebi.receiveEnergy(theItem, energy, doReceive);
    }

    public float transferEnergy(ItemStack theItem, float energy, boolean doTransfer) {
        return this.ebi.transferEnergy(theItem, energy, doTransfer);
    }

    public float getEnergyStored(ItemStack theItem) {
        return this.ebi.getEnergyStored(theItem);
    }

    public float getMaxEnergyStored(ItemStack theItem) {
        return this.ebi.getMaxEnergyStored(theItem);
    }

    public int charge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        return this.ebi.charge(itemStack, amount, tier, ignoreTransferLimit, simulate);
    }

    public int discharge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        return this.ebi.discharge(itemStack, amount, tier, ignoreTransferLimit, simulate);
    }

    public boolean canUse(ItemStack itemStack, int amount) {
        return this.ebi.canUse(itemStack, amount);
    }

    @Override
    public float addEnergy(ItemStack target, float energy) {
        return this.ebi.addEnergy(target, energy);
    }

    @Override
    public boolean isChargeable(ItemStack it) {
        return this.ebi.isChargeable(it);
    }

    public boolean isRepairable() {
        return this.ebi.isRepairable();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.ebi.getItemMaxDamageFromStack(stack);
    }

    public int getDisplayDamage(ItemStack stack) {
        return this.ebi.getItemDamageFromStackForDisplay(stack);
    }

    public boolean func_77645_m() {
        return this.ebi.isDamageable();
    }

    public boolean func_82789_a(ItemStack var1, ItemStack var2) {
        return this.ebi.getIsRepairable(var1, var2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.ebi.addInformation(par1ItemStack, par2EntityPlayer, par3List, par4);
    }

    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        this.ebi.chargeFromArmor(itemStack, entity);
    }

    public int getCharge(ItemStack itemStack) {
        return this.ebi.getCharge(itemStack);
    }

    public IElectricItemManager getManager(ItemStack itemStack) {
        return this;
    }

    public String getToolTip(ItemStack itemStack) {
        return null;
    }

    public boolean use(ItemStack itemStack, int amount, EntityLivingBase entity) {
        return this.ebi.use(itemStack, amount, entity);
    }

    public float recharge(ItemStack itemStack, float energy, boolean doRecharge) {
        return this.ebi.recharge(itemStack, energy, doRecharge);
    }

    public float discharge(ItemStack itemStack, float energy, boolean doDischarge) {
        return this.ebi.discharge(itemStack, energy, doDischarge);
    }

    public float getElectricityStored(ItemStack theItem) {
        return this.ebi.getElectricityStored(theItem);
    }

    public float getMaxElectricityStored(ItemStack theItem) {
        return this.ebi.getMaxElectricityStored(theItem);
    }

    public void setElectricity(ItemStack itemStack, float joules) {
        this.ebi.setElectricity(itemStack, joules);
    }

    public float getTransfer(ItemStack itemStack) {
        return this.ebi.getTransfer(itemStack);
    }

    public float getVoltage(ItemStack itemStack) {
        return this.ebi.getVoltage(itemStack);
    }
}

