/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.IAETagCompound;
import appeng.api.IItemComparison;
import appeng.common.AppEng;
import appeng.util.Platform;
import appeng.util.SharedSearchObject;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AppEngSharedNBTTagCompound
extends NBTTagCompound
implements IAETagCompound {
    private int itemid;
    private int meta;
    private int hash;
    public SharedSearchObject sso;
    private IItemComparison comp;

    @Override
    public IItemComparison getSpecialComparison() {
        return this.comp;
    }

    private AppEngSharedNBTTagCompound(int itemID, int damageValue, String name) {
        super(name);
        this.itemid = itemID;
        this.meta = damageValue;
    }

    @Override
    public NBTTagCompound clone() {
        return (NBTTagCompound)super.func_74737_b();
    }

    public static AppEngSharedNBTTagCompound createFromCompound(int itemID, int damageValue, NBTTagCompound c) {
        AppEngSharedNBTTagCompound x = new AppEngSharedNBTTagCompound(itemID, damageValue, c.func_74740_e());
        for (NBTBase tag : c.func_74758_c()) {
            x.func_74782_a(tag.func_74740_e(), tag.func_74737_b());
        }
        x.hash = Platform.NBTOrderlessHash((NBTBase)c);
        ItemStack isc = new ItemStack(itemID, 1, damageValue);
        isc.func_77982_d(c);
        x.comp = AppEng.getApiInstance().getSpecialComparsonRegistry().getSpecialComparion(isc);
        return x;
    }

    @Override
    public boolean equals(Object par1Obj) {
        if (par1Obj instanceof AppEngSharedNBTTagCompound) {
            return this == par1Obj;
        }
        return super.equals(par1Obj);
    }

    public boolean matches(int itemid2, int meta2, int orderlessHash) {
        return itemid2 == this.itemid && this.meta == meta2 && this.hash == orderlessHash;
    }

    public boolean comparePreciseWithRegistry(AppEngSharedNBTTagCompound tagCompound) {
        if (this == tagCompound) {
            return true;
        }
        if (this.comp != null && tagCompound.comp != null) {
            return this.comp.sameAsPrecise(tagCompound.comp);
        }
        return false;
    }

    public boolean compareFuzzyWithRegistry(AppEngSharedNBTTagCompound tagCompound) {
        if (this == tagCompound) {
            return true;
        }
        if (tagCompound == null) {
            return false;
        }
        if (this.comp == tagCompound.comp) {
            return true;
        }
        if (this.comp != null) {
            return this.comp.sameAsFuzzy(tagCompound.comp);
        }
        return false;
    }
}

