/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.FuzzyMode;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.util.Platform;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.AdaptorISpecialInventory;
import appeng.util.inv.AdaptorList;
import appeng.util.inv.AdaptorPlayerInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.WrapperMCISidedInventory;
import buildcraft.api.inventory.ISpecialInventory;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.common.ForgeDirection;

public abstract class InventoryAdaptor {
    private static boolean canBeSpecial = true;

    public abstract ItemStack removeItems(int var1, ItemStack var2, IInventoryDestination var3);

    public abstract ItemStack simulateRemove(int var1, ItemStack var2, IInventoryDestination var3);

    public abstract ItemStack removeSimilarItems(int var1, ItemStack var2, FuzzyMode var3, IInventoryDestination var4);

    public abstract ItemStack simulateSimilarRemove(int var1, ItemStack var2, FuzzyMode var3, IInventoryDestination var4);

    public abstract ItemStack addItems(ItemStack var1);

    public abstract ItemStack simulateAdd(ItemStack var1);

    public abstract boolean containsItems();

    public static InventoryAdaptor getAdaptor(Object te, ForgeDirection d) {
        if (te == null) {
            return null;
        }
        if (te instanceof Player) {
            if (AppEngConfiguration.logInventoryAdaptor) {
                AppEng.log("Using Player Adaptor for " + te.getClass().getName());
            }
            return new AdaptorIInventory(new AdaptorPlayerInventory(((EntityPlayer)te).field_71071_by));
        }
        if (te instanceof ArrayList) {
            if (AppEngConfiguration.logInventoryAdaptor) {
                AppEng.log("Using ArrayList Adaptor for " + te.getClass().getName());
            }
            return new AdaptorList((ArrayList)te);
        }
        if (AppEng.getInstance().BSProxy != null && AppEng.getInstance().BSProxy.isStorageCrate(te)) {
            if (AppEngConfiguration.logInventoryAdaptor) {
                AppEng.log("Using BetterStorage.IStorageCrate Adaptor for " + te.getClass().getName());
            }
            return AppEng.getInstance().BSProxy.getAdaptor(te, d);
        }
        if (te instanceof TileEntityChest) {
            if (AppEngConfiguration.logInventoryAdaptor) {
                AppEng.log("Using Vanilla.TileEntityChest Adaptor for " + te.getClass().getName());
            }
            return new AdaptorIInventory(Platform.GetChestInv(te));
        }
        if (InventoryAdaptor.isSpecialInventory(te)) {
            if (AppEngConfiguration.logInventoryAdaptor) {
                AppEng.log("Using BC.ISpecialInventory Adaptor for " + te.getClass().getName());
            }
            return new AdaptorISpecialInventory((ISpecialInventory)te, d);
        }
        if (te instanceof ISidedInventory) {
            if (AppEngConfiguration.logInventoryAdaptor) {
                AppEng.log("Using Vanilla.ISidedInventory Adaptor for " + te.getClass().getName());
            }
            return new AdaptorIInventory(new WrapperMCISidedInventory((ISidedInventory)te, d));
        }
        if (te instanceof IInventory) {
            if (AppEngConfiguration.logInventoryAdaptor) {
                AppEng.log("Using IInventory Adaptor for " + te.getClass().getName());
            }
            return new AdaptorIInventory((IInventory)te);
        }
        if (AppEngConfiguration.logInventoryAdaptor) {
            AppEng.log("No Matching Adaptor for " + te.getClass().getName());
        }
        return null;
    }

    private static boolean isSpecialInventory(Object a) {
        if (canBeSpecial) {
            try {
                return a instanceof ISpecialInventory;
            }
            catch (Throwable e) {
                canBeSpecial = false;
            }
        }
        return false;
    }
}

