/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.DimentionalCoord;
import appeng.api.IAEItemStack;
import appeng.api.IAETagCompound;
import appeng.api.IItemList;
import appeng.api.WorldCoord;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IConfigEnum;
import appeng.api.me.items.IAEChargeableItem;
import appeng.api.me.items.IAEWrench;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventory;
import appeng.common.AppEng;
import appeng.common.base.AppEngTile;
import appeng.common.network.packets.PacketLocalizedChatMsg;
import appeng.gui.AppEngContainer;
import appeng.gui.AppEngGuiHandler;
import appeng.util.AEItemStack;
import appeng.util.AppEngSharedNBTTagCompound;
import appeng.util.SharedSearchObject;
import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.src.ModLoader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class Platform {
    private static Random rdnSrc = new Random();
    private static TreeMap<Integer, Integer> oreDic = new TreeMap();
    public static final long MaxIntegerStackSize = Integer.MAX_VALUE;
    private static WeakHashMap<SharedSearchObject, WeakReference<SharedSearchObject>> sharedTagCompounts = new WeakHashMap();
    public static final int DEF_OFFSET = 16;
    private static WeakHashMap<World, EntityPlayer> fakePlayers = new WeakHashMap();

    public static int getRandomInt() {
        return Math.abs(rdnSrc.nextInt());
    }

    public static <T extends IConfigEnum> T nextEnum(T ce) {
        IConfigEnum[] valList = ce.getValues();
        int pLoc = ce.ordinal() + 1;
        if (pLoc >= valList.length) {
            pLoc = 0;
        }
        if (pLoc >= 0 && pLoc < valList.length) {
            return (T)valList[pLoc];
        }
        return (T)valList[0];
    }

    public static <T extends IConfigEnum> T prevEnum(T ce) {
        IConfigEnum[] valList = ce.getValues();
        int pLoc = ce.ordinal() - 1;
        if (pLoc < 0) {
            pLoc = valList.length - 1;
        }
        if (pLoc >= 0 && pLoc < valList.length) {
            return (T)valList[pLoc];
        }
        return (T)valList[0];
    }

    public static void closeContainers(AppEngTile te) {
        List PlayerList;
        if (Platform.isClient()) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (PlayerList = server.func_71203_ab().field_72404_b) != null) {
            for (int o = 0; o < PlayerList.size(); ++o) {
                AppEngTile tc;
                EntityPlayerMP p = (EntityPlayerMP)PlayerList.get(o);
                if (p.field_71093_bK != te.field_70331_k.field_73011_w.field_76574_g || p.field_71070_bA == null || !(p.field_71070_bA instanceof AppEngContainer) || (tc = ((AppEngContainer)p.field_71070_bA).getTile()) != te) continue;
                p.func_71053_j();
            }
        }
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static boolean isServer() {
        return !Platform.isClient();
    }

    public static boolean isBlockAir(World w, int x, int y, int z) {
        try {
            int bid = w.func_72798_a(x, y, z);
            if (bid <= 0) {
                return true;
            }
            if (Block.field_71973_m[bid] == null) {
                return true;
            }
            return Block.field_71973_m[bid].isAirBlock(w, x, y, z);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static List<ItemStack> CondenseItemList(List<ItemStack> List2) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack l : List2) {
            Platform.sumItemToList(list, l);
        }
        return list;
    }

    public static synchronized int getOreID(ItemStack a) {
        if (a == null) {
            return -1;
        }
        int meta = a.func_77960_j();
        int value = meta << 16 | a.field_77993_c;
        Integer res = oreDic.get(value);
        if (res != null) {
            return res;
        }
        int result = OreDictionary.getOreID((ItemStack)a);
        oreDic.put(value, result);
        return result;
    }

    public static boolean isOreType(ItemStack output, int oreID) {
        int OreID = Platform.getOreID(output);
        if (OreID != -1) {
            return OreID == oreID;
        }
        return false;
    }

    public static boolean sameStackStags(ItemStack a, ItemStack b) {
        NBTTagCompound tb;
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        NBTTagCompound ta = a.func_77978_p();
        if (ta == (tb = b.func_77978_p())) {
            return true;
        }
        if (ta == null && tb == null || ta != null && ta.func_82582_d() && tb == null || tb != null && tb.func_82582_d() && ta == null || ta != null && ta.func_82582_d() && tb != null && tb.func_82582_d()) {
            return true;
        }
        if (ta == null && tb != null || ta != null && tb == null) {
            return false;
        }
        if (Platform.isShared(ta) && Platform.isShared(tb)) {
            return ta == tb;
        }
        return Platform.NBTEqualityTest((NBTBase)ta, (NBTBase)tb);
    }

    public static boolean NBTEqualityTest(NBTBase A, NBTBase B) {
        byte id = A.func_74732_a();
        if (id == B.func_74732_a()) {
            switch (id) {
                case 10: {
                    NBTTagCompound ctA = (NBTTagCompound)A;
                    NBTTagCompound ctB = (NBTTagCompound)B;
                    Collection cA = ctA.func_74758_c();
                    Collection cB = ctB.func_74758_c();
                    if (cA.size() != cB.size()) {
                        return false;
                    }
                    for (NBTBase tag : cA) {
                        NBTBase aTag = ctB.func_74781_a(tag.func_74740_e());
                        if (aTag == null) {
                            return false;
                        }
                        if (Platform.NBTEqualityTest(tag, aTag)) continue;
                        return false;
                    }
                    return true;
                }
                case 9: {
                    NBTTagList lA = (NBTTagList)A;
                    NBTTagList lB = (NBTTagList)B;
                    if (lA.func_74745_c() != lB.func_74745_c()) {
                        return false;
                    }
                    for (int x = 0; x < lA.func_74745_c(); ++x) {
                        NBTBase tag = lA.func_74743_b(x);
                        NBTBase aTag = lB.func_74743_b(x);
                        if (aTag == null) {
                            return false;
                        }
                        if (Platform.NBTEqualityTest(tag, aTag)) continue;
                        return false;
                    }
                    return true;
                }
                case 1: {
                    return ((NBTTagByte)A).field_74756_a == ((NBTTagByte)B).field_74756_a;
                }
                case 4: {
                    return ((NBTTagLong)A).field_74753_a == ((NBTTagLong)B).field_74753_a;
                }
                case 8: {
                    return ((NBTTagString)A).field_74751_a == ((NBTTagString)B).field_74751_a || ((NBTTagString)A).field_74751_a.equals(((NBTTagString)B).field_74751_a);
                }
                case 6: {
                    return ((NBTTagDouble)A).field_74755_a == ((NBTTagDouble)B).field_74755_a;
                }
                case 5: {
                    return ((NBTTagFloat)A).field_74750_a == ((NBTTagFloat)B).field_74750_a;
                }
                case 3: {
                    return ((NBTTagInt)A).field_74748_a == ((NBTTagInt)B).field_74748_a;
                }
            }
            return A.equals((Object)B);
        }
        return false;
    }

    public static int NBTOrderlessHash(NBTBase A) {
        int hash = 0;
        byte id = A.func_74732_a();
        hash += id;
        switch (id) {
            case 10: {
                NBTTagCompound ctA = (NBTTagCompound)A;
                Collection cA = ctA.func_74758_c();
                for (NBTBase tag : cA) {
                    hash += Platform.NBTOrderlessHash(ctA.func_74781_a(tag.func_74740_e()));
                }
                return hash;
            }
            case 9: {
                NBTTagList lA = (NBTTagList)A;
                hash += 9 * lA.func_74745_c();
                for (int x = 0; x < lA.func_74745_c(); ++x) {
                    hash += Platform.NBTOrderlessHash(lA.func_74743_b(x));
                }
                return hash;
            }
            case 1: {
                return hash + ((NBTTagByte)A).field_74756_a;
            }
            case 4: {
                return hash + (int)((NBTTagLong)A).field_74753_a;
            }
            case 8: {
                return hash + ((NBTTagString)A).field_74751_a.hashCode();
            }
            case 6: {
                return hash + (int)((NBTTagDouble)A).field_74755_a;
            }
            case 5: {
                return hash + (int)((NBTTagFloat)A).field_74750_a;
            }
            case 3: {
                return hash + ((NBTTagInt)A).field_74748_a;
            }
        }
        return hash;
    }

    public static IRecipe findMatchingRecipe(InventoryCrafting par1InventoryCrafting, World par2World) {
        CraftingManager cm = CraftingManager.func_77594_a();
        List rl = cm.func_77592_b();
        for (int x = 0; x < rl.size(); ++x) {
            IRecipe r = (IRecipe)rl.get(x);
            if (!r.func_77569_a(par1InventoryCrafting, par2World)) continue;
            return r;
        }
        return null;
    }

    public static boolean isSameItemPrecise(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (!a.func_77969_a(b)) {
            return false;
        }
        if (Platform.isShared(a.func_77978_p()) && Platform.isShared(b.func_77978_p())) {
            return ((AppEngSharedNBTTagCompound)a.func_77978_p()).comparePreciseWithRegistry((AppEngSharedNBTTagCompound)b.func_77978_p());
        }
        return Platform.sameStackStags(a, b);
    }

    public static boolean isSameItemPrecise(IAEItemStack s, IAEItemStack itstck) {
        return s.equals(itstck);
    }

    public static boolean isSameItemFuzzy(ItemStack a, ItemStack b, FuzzyMode Mode) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (a.field_77993_c != 0 && b.field_77993_c != 0 && a.func_77973_b().func_77645_m() && a.field_77993_c == b.field_77993_c) {
            try {
                if (Mode == FuzzyMode.IgnoreAll) {
                    return true;
                }
                if (Mode == FuzzyMode.Percent_99) {
                    return a.func_77952_i() > 1 == b.func_77952_i() > 1;
                }
                float APercentDamaged = 1.0f - (float)a.func_77952_i() / (float)a.func_77958_k();
                float BPercentDamaged = 1.0f - (float)b.func_77952_i() / (float)b.func_77958_k();
                return APercentDamaged > Mode.breakPoint == BPercentDamaged > Mode.breakPoint;
            }
            catch (Throwable e) {
                if (Mode == FuzzyMode.IgnoreAll) {
                    return true;
                }
                if (Mode == FuzzyMode.Percent_99) {
                    return a.func_77960_j() > 1 == b.func_77960_j() > 1;
                }
                float APercentDamaged = (float)a.func_77960_j() / (float)a.func_77958_k();
                float BPercentDamaged = (float)b.func_77960_j() / (float)b.func_77958_k();
                return APercentDamaged > Mode.breakPoint == BPercentDamaged > Mode.breakPoint;
            }
        }
        int OreID = Platform.getOreID(a);
        if (OreID != -1) {
            return OreID == Platform.getOreID(b);
        }
        if (Mode != FuzzyMode.IgnoreAll) {
            if (a.func_77942_o() && !Platform.isShared(a.func_77978_p())) {
                a = Platform.getSharedItemStack(AEItemStack.create(a));
            }
            if (b.func_77942_o() && !Platform.isShared(b.func_77978_p())) {
                b = Platform.getSharedItemStack(AEItemStack.create(b));
            }
            if (Platform.isShared(a.func_77978_p()) && Platform.isShared(b.func_77978_p()) && a.field_77993_c == b.field_77993_c) {
                return ((AppEngSharedNBTTagCompound)a.func_77978_p()).compareFuzzyWithRegistry((AppEngSharedNBTTagCompound)b.func_77978_p());
            }
        }
        return a.func_77969_a(b);
    }

    public static boolean isSameItemFuzzy(IAEItemStack a, IAEItemStack b, FuzzyMode Mode) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (a.getItem() == null) {
            return false;
        }
        if (b.getItem() == null) {
            return false;
        }
        if (a.getItemID() != 0 && b.getItemID() != 0 && a.getItem().func_77645_m() && a.getItemID() == b.getItemID()) {
            ItemStack isA = Platform.getSharedItemStack(a);
            ItemStack isB = Platform.getSharedItemStack(b);
            try {
                if (Mode == FuzzyMode.IgnoreAll) {
                    return true;
                }
                if (Mode == FuzzyMode.Percent_99) {
                    return isA.func_77952_i() > 1 == isB.func_77952_i() > 1;
                }
                float APercentDamaged = 1.0f - (float)isA.func_77952_i() / (float)isA.func_77958_k();
                float BPercentDamaged = 1.0f - (float)isB.func_77952_i() / (float)isB.func_77958_k();
                return APercentDamaged > Mode.breakPoint == BPercentDamaged > Mode.breakPoint;
            }
            catch (Throwable e) {
                if (Mode == FuzzyMode.IgnoreAll) {
                    return true;
                }
                if (Mode == FuzzyMode.Percent_99) {
                    return isA.func_77960_j() > 1 == isB.func_77960_j() > 1;
                }
                float APercentDamaged = (float)isA.func_77960_j() / (float)isA.func_77958_k();
                float BPercentDamaged = (float)isB.func_77960_j() / (float)isB.func_77958_k();
                return APercentDamaged > Mode.breakPoint == BPercentDamaged > Mode.breakPoint;
            }
        }
        if (a.sameOre(b)) {
            return true;
        }
        if (Mode != FuzzyMode.IgnoreAll && a.getItemID() == b.getItemID() && a.hasTagCompound() && b.hasTagCompound()) {
            return ((AppEngSharedNBTTagCompound)a.getTagCompound()).compareFuzzyWithRegistry((AppEngSharedNBTTagCompound)b.getTagCompound());
        }
        return a.getDef() == b.getDef();
    }

    public static boolean isSameItemType(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        int OreID = Platform.getOreID(a);
        if (OreID != -1) {
            return OreID == Platform.getOreID(b);
        }
        if (a.field_77993_c != 0 && b.field_77993_c != 0 && a.func_77984_f() && !a.func_77981_g()) {
            return a.field_77993_c == b.field_77993_c;
        }
        return a.func_77969_a(b);
    }

    public static boolean isSameItem(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.func_77969_a(b) && Platform.sameStackStags(a, b);
    }

    public static ItemStack getItemStackVersion(World w, int x, int y, int z) {
        int BlockID = w.func_72798_a(x, y, z);
        if (BlockID > 0) {
            Block blk = Block.field_71973_m[BlockID];
            int metadata = w.func_72805_g(x, y, z);
            blk.func_71885_a(metadata, w.field_73012_v, 0);
            return new ItemStack(BlockID, 1, blk.func_71899_b(metadata));
        }
        return null;
    }

    public static ItemStack[] getBlockDrops(World w, int x, int y, int z) {
        ArrayList out = new ArrayList();
        int bid = w.func_72798_a(x, y, z);
        if (Block.field_71973_m.length > bid) {
            Block which = Block.field_71973_m[bid];
            if (which == null) {
                return new ItemStack[0];
            }
            out = which.getBlockDropped(w, x, y, z, w.func_72805_g(x, y, z), 0);
        }
        if (out == null) {
            return new ItemStack[0];
        }
        return out.toArray(new ItemStack[out.size()]);
    }

    public static ForgeDirection cycleOrientations(ForgeDirection dir, boolean upAndDown) {
        if (upAndDown) {
            switch (dir) {
                case NORTH: {
                    return ForgeDirection.SOUTH;
                }
                case SOUTH: {
                    return ForgeDirection.EAST;
                }
                case EAST: {
                    return ForgeDirection.WEST;
                }
                case WEST: {
                    return ForgeDirection.NORTH;
                }
                case UP: {
                    return ForgeDirection.UP;
                }
                case DOWN: {
                    return ForgeDirection.DOWN;
                }
                case UNKNOWN: {
                    return ForgeDirection.UNKNOWN;
                }
            }
        } else {
            switch (dir) {
                case UP: {
                    return ForgeDirection.DOWN;
                }
                case DOWN: {
                    return ForgeDirection.NORTH;
                }
                case NORTH: {
                    return ForgeDirection.SOUTH;
                }
                case SOUTH: {
                    return ForgeDirection.EAST;
                }
                case EAST: {
                    return ForgeDirection.WEST;
                }
                case WEST: {
                    return ForgeDirection.UP;
                }
                case UNKNOWN: {
                    return ForgeDirection.UNKNOWN;
                }
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public static NBTTagCompound openNbtData(ItemStack i) {
        NBTTagCompound compound = i.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            i.func_77982_d(compound);
        }
        return compound;
    }

    public static void spawnDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        if (Platform.isServer()) {
            for (ItemStack i : drops) {
                if (i == null || i.field_77994_a <= 0) continue;
                double offset_x = (Platform.getRandomInt() % 32 - 16) / 82;
                double offset_y = (Platform.getRandomInt() % 32 - 16) / 82;
                double offset_z = (Platform.getRandomInt() % 32 - 16) / 82;
                EntityItem ei = new EntityItem(w, 0.5 + offset_x + (double)x, 0.5 + offset_y + (double)y, 0.2 + offset_z + (double)z, i.func_77946_l());
                w.func_72838_d((Entity)ei);
            }
        }
    }

    public static IInventory GetChestInv(Object te) {
        TileEntityChest x;
        TileEntityChest teA = (TileEntityChest)te;
        TileEntity teB = null;
        int myBlockID = teA.field_70331_k.func_72798_a(teA.field_70329_l, teA.field_70330_m, teA.field_70327_n);
        if (teA.field_70331_k.func_72798_a(teA.field_70329_l + 1, teA.field_70330_m, teA.field_70327_n) == myBlockID && !((teB = teA.field_70331_k.func_72796_p(teA.field_70329_l + 1, teA.field_70330_m, teA.field_70327_n)) instanceof TileEntityChest)) {
            teB = null;
        }
        if (teB == null && teA.field_70331_k.func_72798_a(teA.field_70329_l - 1, teA.field_70330_m, teA.field_70327_n) == myBlockID) {
            teB = teA.field_70331_k.func_72796_p(teA.field_70329_l - 1, teA.field_70330_m, teA.field_70327_n);
            if (!(teB instanceof TileEntityChest)) {
                teB = null;
            } else {
                x = teA;
                teA = (TileEntityChest)teB;
                teB = x;
            }
        }
        if (teB == null && teA.field_70331_k.func_72798_a(teA.field_70329_l, teA.field_70330_m, teA.field_70327_n + 1) == myBlockID && !((teB = teA.field_70331_k.func_72796_p(teA.field_70329_l, teA.field_70330_m, teA.field_70327_n + 1)) instanceof TileEntityChest)) {
            teB = null;
        }
        if (teB == null && teA.field_70331_k.func_72798_a(teA.field_70329_l, teA.field_70330_m, teA.field_70327_n - 1) == myBlockID) {
            teB = teA.field_70331_k.func_72796_p(teA.field_70329_l, teA.field_70330_m, teA.field_70327_n - 1);
            if (!(teB instanceof TileEntityChest)) {
                teB = null;
            } else {
                x = teA;
                teA = (TileEntityChest)teB;
                teB = x;
            }
        }
        if (teB == null) {
            return teA;
        }
        return new InventoryLargeChest("", (IInventory)teA, (IInventory)((TileEntityChest)teB));
    }

    public static int sharedTagLoad() {
        return sharedTagCompounts.size();
    }

    public static boolean isShared(NBTTagCompound ta) {
        return ta instanceof AppEngSharedNBTTagCompound;
    }

    public static synchronized NBTTagCompound getSharedTagCompound(ItemStack s) {
        SharedSearchObject cg;
        NBTTagCompound tagCompound = s.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        if (tagCompound.func_82582_d()) {
            return null;
        }
        int itemid = s.field_77993_c;
        int meta = -1;
        if (s.field_77993_c != 0 && s.func_77984_f() && s.func_77981_g()) {
            meta = s.func_77960_j();
        }
        if (Platform.isShared(tagCompound)) {
            return tagCompound;
        }
        SharedSearchObject sso = new SharedSearchObject(itemid, meta, tagCompound);
        WeakReference<SharedSearchObject> c = sharedTagCompounts.get(sso);
        if (c != null && (cg = (SharedSearchObject)c.get()) != null) {
            return cg.shared;
        }
        AppEngSharedNBTTagCompound clone = AppEngSharedNBTTagCompound.createFromCompound(itemid, meta, tagCompound);
        sso.compound = (NBTTagCompound)sso.compound.func_74737_b();
        sso.shared = clone;
        clone.sso = sso;
        sharedTagCompounts.put(sso, new WeakReference<SharedSearchObject>(sso));
        return clone;
    }

    public static void sumItemToList(List<ItemStack> out, ItemStack sub) {
        if (sub == null) {
            return;
        }
        for (ItemStack g : out) {
            if (!Platform.isSameItem(g, sub)) continue;
            long newSize = g.field_77994_a + sub.field_77994_a;
            if (newSize >= Integer.MAX_VALUE) {
                g.field_77994_a = Integer.MAX_VALUE;
                continue;
            }
            g.field_77994_a = (int)newSize;
            return;
        }
        out.add(Platform.cloneItemStack(sub));
    }

    public static ItemStack cloneItemStack(ItemStack sub) {
        if (sub.func_77942_o()) {
            NBTTagCompound tmp = sub.func_77978_p();
            sub.func_77982_d(null);
            ItemStack copy = sub.func_77946_l();
            sub.func_77982_d(tmp);
            copy.func_77982_d(tmp);
            return copy;
        }
        return sub.func_77946_l();
    }

    public static IAEItemStack[] findMatchingItem(IItemList available, IAEItemStack itstck) {
        ArrayList<IAEItemStack> t = new ArrayList<IAEItemStack>();
        for (IAEItemStack s : available) {
            if (!Platform.isSameItemPrecise(s, itstck)) continue;
            IAEItemStack b = s.copy();
            b.setStackSize(itstck.getStackSize());
            t.add(b);
        }
        return t.toArray(new IAEItemStack[t.size()]);
    }

    public static ItemStack[] findMatchingItem(List<ItemStack> is, ItemStack itstck) {
        ArrayList<ItemStack> t = new ArrayList<ItemStack>();
        for (ItemStack s : is) {
            if (!Platform.isSameItemPrecise(s, itstck)) continue;
            ItemStack b = Platform.cloneItemStack(s);
            b.field_77994_a = itstck.field_77994_a;
            t.add(b);
        }
        return t.toArray(new ItemStack[t.size()]);
    }

    public static IAEItemStack[] findSimilarItem(IItemList is, IAEItemStack itstck, FuzzyMode fuzzyMode) {
        ArrayList<IAEItemStack> t = new ArrayList<IAEItemStack>();
        for (IAEItemStack s : is) {
            if (!Platform.isSameItemFuzzy(s, itstck, fuzzyMode)) continue;
            IAEItemStack b = s.copy();
            b.setStackSize(itstck.getStackSize());
            t.add(b);
        }
        return t.toArray(new IAEItemStack[t.size()]);
    }

    public static ItemStack[] findSimilarItem(List<ItemStack> is, ItemStack itstck, FuzzyMode fuzzyMode) {
        ArrayList<ItemStack> t = new ArrayList<ItemStack>();
        for (ItemStack s : is) {
            if (!Platform.isSameItemFuzzy(s, itstck, fuzzyMode)) continue;
            ItemStack b = Platform.cloneItemStack(s);
            b.field_77994_a = itstck.field_77994_a;
            t.add(b);
        }
        return t.toArray(new ItemStack[t.size()]);
    }

    public static boolean isModLoaded(String modid) {
        try {
            return ModLoader.isModLoaded((String)modid);
        }
        catch (Throwable e) {
            for (ModContainer f : Loader.instance().getActiveModList()) {
                if (!f.getModId().equals(modid)) continue;
                return true;
            }
            return false;
        }
    }

    public static ItemStack findItem(List<ItemStack> is, ItemStack itstck) {
        for (ItemStack s : is) {
            if (!Platform.isSameItem(s, itstck)) continue;
            return s;
        }
        return null;
    }

    public static ItemStack findMatchingRecipeOutput(InventoryCrafting ic, World worldObj) {
        return CraftingManager.func_77594_a().func_82787_a(ic, worldObj);
    }

    public static ItemStack addItems(IMEInventory ime, ItemStack in) {
        if (in == null) {
            return null;
        }
        AEItemStack is = AEItemStack.create(in);
        IAEItemStack vs = ime.addItems(is);
        if (vs != null) {
            return vs.getItemStack();
        }
        return null;
    }

    public static ItemStack extractItems(IMEInventory ime, ItemStack out) {
        if (out == null) {
            return null;
        }
        AEItemStack is = AEItemStack.create(out);
        IAEItemStack vs = ime.extractItems(is);
        if (vs != null) {
            return vs.getItemStack();
        }
        return null;
    }

    public static ItemStack calculateItemAddition(IMEInventory mei, ItemStack in) {
        if (in == null) {
            return null;
        }
        AEItemStack is = AEItemStack.create(in);
        IAEItemStack vs = mei.calculateItemAddition(is);
        if (vs != null) {
            return vs.getItemStack();
        }
        return null;
    }

    public static ItemStack getSharedItemStack(IAEItemStack filter) {
        if (filter == null) {
            return null;
        }
        return ((AEItemStack)filter).getSharedItemStack();
    }

    public static void sumItemToList(List<IAEItemStack> out, IAEItemStack sub) {
        if (sub == null) {
            return;
        }
        for (IAEItemStack g : out) {
            if (!g.equals(sub)) continue;
            long newSize = g.getStackSize() + sub.getStackSize();
            if (newSize >= Integer.MAX_VALUE) {
                g.setStackSize(Integer.MAX_VALUE);
                continue;
            }
            g.setStackSize(newSize);
            return;
        }
        out.add(sub.copy());
    }

    @SideOnly(value=Side.CLIENT)
    public static List getTooltip(Object o) {
        if (o == null) {
            return new ArrayList();
        }
        ItemStack itemStack = null;
        if (o instanceof AEItemStack) {
            AEItemStack ais = (AEItemStack)o;
            return ais.getToolTip();
        }
        if (!(o instanceof ItemStack)) {
            return new ArrayList();
        }
        itemStack = (ItemStack)o;
        try {
            return itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
        }
        catch (Exception errB) {
            return new ArrayList();
        }
    }

    public static String getItemDisplayName(Object o) {
        if (o == null) {
            return "** Null";
        }
        ItemStack itemStack = null;
        if (o instanceof AEItemStack) {
            String n = ((AEItemStack)o).getDisplayName();
            return n == null ? "** Null" : n;
        }
        if (!(o instanceof ItemStack)) {
            return "**Invalid Object";
        }
        itemStack = (ItemStack)o;
        try {
            String name = itemStack.func_82833_r();
            if (name == null || name.equals("")) {
                name = itemStack.func_77973_b().func_77667_c(itemStack);
            }
            return name == null ? "** Null" : name;
        }
        catch (Exception errA) {
            try {
                String n = itemStack.func_77977_a();
                return n == null ? "** Null" : n;
            }
            catch (Exception errB) {
                return "** Exception";
            }
        }
    }

    public static DimentionalCoord getDimentionalCoord(Object _te) {
        if (_te instanceof TileEntity) {
            TileEntity te = (TileEntity)_te;
            return new DimentionalCoord(te.field_70331_k, te.field_70329_l, te.field_70330_m, te.field_70327_n);
        }
        throw new RuntimeException("INVALID TILE ENTITY");
    }

    public static bulkPacket parseBulkUpdate(DataInputStream stream) {
        bulkPacket o = new bulkPacket();
        try {
            o.min = new WorldCoord(stream.readInt(), stream.readInt(), stream.readInt());
            o.max = new WorldCoord(stream.readInt(), stream.readInt(), stream.readInt());
            o.tc = CompressedStreamTools.func_74796_a((InputStream)stream);
            return o;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] createBulkUpdate(NBTTagCompound tc, WorldCoord min, WorldCoord max) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(min.x);
            data.writeInt(min.y);
            data.writeInt(min.z);
            data.writeInt(max.x);
            data.writeInt(max.y);
            data.writeInt(max.z);
            CompressedStreamTools.func_74799_a((NBTTagCompound)tc, (OutputStream)data);
            return bytes.toByteArray();
        }
        catch (Exception err) {
            return null;
        }
    }

    public static boolean hasSpecialComparison(IAEItemStack willAdd) {
        if (willAdd == null) {
            return false;
        }
        IAETagCompound tag = willAdd.getTagCompound();
        return tag != null && ((AppEngSharedNBTTagCompound)tag).getSpecialComparison() != null;
    }

    public static boolean hasSpecialComparison(ItemStack willAdd) {
        return Platform.isShared(willAdd.func_77978_p()) && ((AppEngSharedNBTTagCompound)willAdd.func_77978_p()).getSpecialComparison() != null;
    }

    public static boolean isWrench(EntityPlayer player, ItemStack eq, int x, int y, int z) {
        block4: {
            if (eq != null) {
                try {
                    if (eq.func_77973_b() instanceof IToolWrench) {
                        IToolWrench wrench = (IToolWrench)eq.func_77973_b();
                        return wrench.canWrench(player, x, y, z);
                    }
                }
                catch (Throwable _) {
                    if (!(eq.func_77973_b() instanceof IAEWrench)) break block4;
                    IAEWrench wrench = (IAEWrench)eq.func_77973_b();
                    return wrench.canWrench(player, x, y, z);
                }
            }
        }
        return false;
    }

    public static boolean isChargeable(ItemStack i) {
        if (i == null) {
            return false;
        }
        Item it = i.func_77973_b();
        if (it instanceof IAEChargeableItem) {
            return ((IAEChargeableItem)it).isChargeable(i);
        }
        return false;
    }

    public static void LocalizedChatMsg(String msg, Object Player2) {
        try {
            PacketDispatcher.sendPacketToPlayer((Packet)new PacketLocalizedChatMsg(msg).getPacket(), (Player)((Player)Player2));
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
    }

    public static int calculateChange(ItemStack before, ItemStack after) {
        if (before == null) {
            if (after == null) {
                return 0;
            }
            return after.field_77994_a;
        }
        if (after == null || !Platform.isSameItem(before, after)) {
            return -before.field_77994_a;
        }
        return after.field_77994_a - before.field_77994_a;
    }

    public static ItemStack refundEnergy(IGridInterface grid, ItemStack leftOverItems, String for_what) {
        if (grid != null && leftOverItems != null) {
            grid.refundMEEnergy(leftOverItems.field_77994_a, for_what);
        }
        return leftOverItems;
    }

    public static void openGui(EntityPlayer p, AppEngGuiHandler whichGui, World w, int x, int y, int z) {
        p.openGui((Object)AppEng.getInstance(), whichGui.ordinal(), w, x, y, z);
    }

    public static EntityPlayer getPlayer(World w) {
        EntityPlayer wrp = fakePlayers.get(w);
        if (wrp != null) {
            return wrp;
        }
        FakePlayer p = new FakePlayer(w, "[AppEng]");
        fakePlayers.put(w, (EntityPlayer)p);
        return p;
    }

    public static int MC2MEColor(int color) {
        switch (color) {
            case 4: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 15: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 11: {
                return 5;
            }
            case 2: {
                return 6;
            }
        }
        return -1;
    }

    public static class bulkPacket {
        public int PACKET_ID;
        public NBTTagCompound tc;
        public WorldCoord min;
        public WorldCoord max;
    }
}

