/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.building;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.building.Building;
import com.gollum.core.common.building.handler.BuildingBlockHandler;
import com.gollum.core.tools.registered.RegisteredObjects;
import com.gollum.core.tools.registry.BuildingBlockRegistry;
import com.gollum.core.utils.math.Integer3d;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class Builder {
    public static ArrayList<BuilderRunnable> currentBuilds = new ArrayList();

    public void build(World world, Building.SubBuilding subBuilding, boolean isStaff) {
        this.build(world, subBuilding.building, subBuilding.orientation, subBuilding.x, subBuilding.y, subBuilding.z, isStaff);
    }

    public void build(World world, Building building, int rotate, int initX, int initY, int initZ) {
        this.build(world, building, rotate, initX, initY, initZ, false);
    }

    public void build(World world, Building building, int rotate, int initX, int initY, int initZ, boolean isStaff) {
        BuilderRunnable thread = new BuilderRunnable(world, building, rotate, initX, initY, initZ, isStaff);
        thread.start();
        currentBuilds.add(thread);
    }

    public static int getRotatedX(int x, int z, int rotate, int maxX, int maxZ) {
        if (rotate == 1) {
            return z;
        }
        if (rotate == 2) {
            int newX = Builder.getRotatedX(x, z, 1, maxX, maxZ);
            int newZ = Builder.getRotatedZ(x, z, 1, maxX, maxZ);
            return Builder.getRotatedX(newX, newZ, 1, maxX, maxZ);
        }
        if (rotate == 3) {
            int newX = Builder.getRotatedX(x, z, 2, maxX, maxZ);
            int newZ = Builder.getRotatedZ(x, z, 2, maxX, maxZ);
            return Builder.getRotatedX(newX, newZ, 1, maxX, maxZ);
        }
        return x;
    }

    public static int getRotatedZ(int x, int z, int rotate, int maxX, int maxZ) {
        if (rotate == 1) {
            return maxX - x - 1;
        }
        if (rotate == 2) {
            int newX = Builder.getRotatedX(x, z, 1, maxX, maxZ);
            int newZ = Builder.getRotatedZ(x, z, 1, maxX, maxZ);
            return Builder.getRotatedZ(newX, newZ, 1, maxX, maxZ);
        }
        if (rotate == 3) {
            int newX = Builder.getRotatedX(x, z, 2, maxX, maxZ);
            int newZ = Builder.getRotatedZ(x, z, 2, maxX, maxZ);
            return Builder.getRotatedZ(newX, newZ, 1, maxX, maxZ);
        }
        return z;
    }

    public static class BuilderRunnable
    extends Thread {
        WorldServer world;
        Building building;
        int rotate;
        int initX;
        int initY;
        int initZ;
        public ReentrantLock lockWorld = new ReentrantLock();
        public Object waiter = new Object();
        private Boolean waitForWorld = true;
        private long time = 0L;
        private boolean isStaff = false;
        private int placeBlockCount = 0;
        private long timeDisplayProgress = System.currentTimeMillis();

        public WorldServer getWorld() {
            return this.world;
        }

        public int getRotate() {
            return this.rotate;
        }

        public Building getBuilding() {
            return this.building;
        }

        public Integer3d getPosition() {
            return new Integer3d(this.initX, this.initY, this.initZ);
        }

        public BuilderRunnable(World world, Building building, int rotate, int initX, int initY, int initZ, boolean isStaff) {
            this.world = (WorldServer)world;
            this.building = building;
            this.rotate = rotate;
            this.initX = initX;
            this.initY = initY;
            this.initZ = initZ;
            this.isStaff = isStaff;
        }

        @Override
        public void run() {
            this.run(true);
        }

        public void run(boolean reTop) {
            try {
                ModGollumCoreLib.log.info("Create building width matrix : " + this.building.name + " " + this.initX + " " + this.initY + " " + this.initZ);
                this.initY += this.building.height;
                if (reTop) {
                    this.initY = this.initY < 3 ? 3 : this.initY;
                }
                int dx = -1;
                int dz = 1;
                switch (this.rotate) {
                    case 1: {
                        dx = -1;
                        dz = -1;
                        break;
                    }
                    case 2: {
                        dx = 1;
                        dz = -1;
                        break;
                    }
                    case 3: {
                        dx = 1;
                        dz = 1;
                        break;
                    }
                }
                ModGollumCoreLib.log.debug("Building placeBlocks : " + this.building.name + " " + this.initX + " " + this.initY + " " + this.initZ);
                this.placeBlocks(dx, dz);
                ModGollumCoreLib.log.debug("Building placeAfterBlocks : " + this.building.name + " " + this.initX + " " + this.initY + " " + this.initZ);
                this.placeAfterBlock(dx, dz);
                ModGollumCoreLib.log.debug("Building placeBlockRandom : " + this.building.name + " " + this.initX + " " + this.initY + " " + this.initZ);
                this.placeBlockRandom(dx, dz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ModGollumCoreLib.log.info("End create building width matrix : " + this.building.name + " " + this.initX + " " + this.initY + " " + this.initZ);
            this.unlockWorld();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dontWaitWorld() {
            Boolean bl = this.waitForWorld;
            synchronized (bl) {
                this.waitForWorld = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lock() {
            block9: {
                boolean waitForWorld = true;
                Boolean bl = this.waitForWorld;
                synchronized (bl) {
                    waitForWorld = this.waitForWorld;
                }
                try {
                    long lantency;
                    if (!waitForWorld || (lantency = System.currentTimeMillis() - this.time) <= 200L) break block9;
                    if (lantency > 500L && this.time != 0L) {
                        ModGollumCoreLib.log.warning("Latency of builder is gretter that 300 milliseconds. lantency = " + lantency);
                    }
                    this.unlockWorld();
                    Object object = this.waiter;
                    synchronized (object) {
                        this.waiter.wait();
                    }
                    this.lockWorld.lock();
                    this.time = System.currentTimeMillis();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public synchronized void unlockWorld() {
            try {
                if (this.lockWorld.isLocked()) {
                    this.lockWorld.unlock();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private boolean setBlock(int x, int y, int z, Block block, int metadata) {
            if (y < 3) {
                return false;
            }
            try {
                return this.world.func_72832_d(x, y, z, block != null ? block.field_71990_ca : 0, metadata, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        private void placeBlockStone(int dx, int dz) {
            for (Building.Unity3D unity3D : this.building.unities) {
                int finalX = this.initX + unity3D.x(this.rotate) * dx;
                int finalY = this.initY + unity3D.y(this.rotate);
                int finalZ = this.initZ + unity3D.z(this.rotate) * dz;
                this.lock();
                this.setBlock(finalX, finalY, finalZ, Block.field_71981_t, 0);
            }
        }

        private void placeBlocks(int dx, int dz) {
            ArrayList<Building.Unity3D> placed = new ArrayList<Building.Unity3D>();
            Iterator<Building.Unity3D> i = this.building.unities.iterator();
            while (i.hasNext()) {
                this.lock();
                Building.Unity3D unity3D = i.next();
                Building.Unity unity = unity3D.unity;
                int finalX = this.initX + unity3D.x(this.rotate) * dx;
                int finalY = this.initY + unity3D.y(this.rotate);
                int finalZ = this.initZ + unity3D.z(this.rotate) * dz;
                boolean isPlaced = false;
                this.world.func_72932_q(finalX, finalY, finalZ);
                if (unity.after || BuildingBlockRegistry.instance().isAfterBlock(unity.block)) {
                    this.setBlock(finalX, finalY, finalZ, null, 0);
                } else if (unity.block != null) {
                    isPlaced = this.setBlock(finalX, finalY, finalZ, unity.block, unity.metadata);
                } else {
                    this.setBlock(finalX, finalY, finalZ, null, 0);
                }
                if (isPlaced) {
                    this.setOrientation(finalX, finalY, finalZ, this.rotateOrientation(this.rotate, unity.orientation));
                    this.setContents(finalX, finalY, finalZ, unity.contents);
                    this.setExtra(finalX, finalY, finalZ, unity.extra, this.building.maxX(this.rotate), this.building.maxZ(this.rotate));
                    placed.add(unity3D);
                }
                if (System.currentTimeMillis() - this.timeDisplayProgress <= 5000L) continue;
                this.timeDisplayProgress = System.currentTimeMillis();
                ModGollumCoreLib.log.message("Building step 1 progress " + this.building.name + " : " + (float)this.placeBlockCount / (float)this.building.unities.size() * 100.0f + "%");
            }
            for (Building.Unity3D unity3D : placed) {
                this.lock();
                boolean isPlaced = false;
                Building.Unity unity = unity3D.unity;
                int finalX = this.initX + unity3D.x(this.rotate) * dx;
                int finalY = this.initY + unity3D.y(this.rotate);
                int finalZ = this.initZ + unity3D.z(this.rotate) * dz;
                this.lock();
                this.world.func_72898_h(finalX, finalY, finalZ, unity.block != null ? unity.block.field_71990_ca : 0);
                this.world.func_72845_h(finalX, finalY, finalZ);
            }
        }

        private void placeAfterBlock(int dx, int dz) {
            int finalZ;
            int finalY;
            int finalX;
            ArrayList<Building.Unity3D> placed = new ArrayList<Building.Unity3D>();
            for (Building.Unity3D unity3D : this.building.unities) {
                Building.Unity unity = unity3D.unity;
                if (!unity.after && !BuildingBlockRegistry.instance().isAfterBlock(unity.block)) continue;
                boolean isPlaced = false;
                finalX = this.initX + unity3D.x(this.rotate) * dx;
                finalY = this.initY + unity3D.y(this.rotate);
                finalZ = this.initZ + unity3D.z(this.rotate) * dz;
                if (unity.block != null) {
                    ModGollumCoreLib.log.debug("Place after block : " + RegisteredObjects.instance().getRegisterName(unity.block));
                    isPlaced = this.setBlock(finalX, finalY, finalZ, unity.block, unity.metadata);
                } else {
                    this.setBlock(finalX, finalY, finalZ, null, 0);
                }
                if (isPlaced) {
                    this.setOrientation(finalX, finalY, finalZ, this.rotateOrientation(this.rotate, unity.orientation));
                    this.setContents(finalX, finalY, finalZ, unity.contents);
                    this.setExtra(finalX, finalY, finalZ, unity.extra, this.building.maxX(this.rotate), this.building.maxZ(this.rotate));
                    placed.add(unity3D);
                }
                if (System.currentTimeMillis() - this.timeDisplayProgress <= 5000L) continue;
                this.timeDisplayProgress = System.currentTimeMillis();
                ModGollumCoreLib.log.message("Building step 2 progress " + this.building.name + " : " + (float)this.placeBlockCount / (float)this.building.unities.size() * 100.0f + "%");
            }
            for (Building.Unity3D unity3D : placed) {
                this.lock();
                boolean isPlaced = false;
                Building.Unity unity = unity3D.unity;
                finalX = this.initX + unity3D.x(this.rotate) * dx;
                finalY = this.initY + unity3D.y(this.rotate);
                finalZ = this.initZ + unity3D.z(this.rotate) * dz;
                this.lock();
                this.world.func_72898_h(finalX, finalY, finalZ, unity.block != null ? unity.block.field_71990_ca : 0);
                this.world.func_72845_h(finalX, finalY, finalZ);
            }
        }

        private void placeBlockRandom(int dx, int dz) {
            for (Building.GroupSubBuildings group : this.building.getRandomGroupSubBuildings()) {
                Building.ListSubBuildings randomBuilding = (Building.ListSubBuildings)group.get(this.world.field_73012_v.nextInt(group.size()));
                for (Building.SubBuilding subBuilding : randomBuilding) {
                    BuilderRunnable thread = new BuilderRunnable((World)this.world, subBuilding.building, this.rotate, this.initX + subBuilding.x * dx, this.initY + subBuilding.y, this.initZ + subBuilding.z * dz, this.isStaff);
                    thread.waiter = this.waiter;
                    thread.lockWorld = this.lockWorld;
                    thread.run(false);
                }
            }
        }

        private int rotateOrientation(int rotate, int orientation) {
            if (rotate == 1) {
                switch (orientation) {
                    case 1: {
                        return 4;
                    }
                    case 4: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 1;
                    }
                    case 5: {
                        return 7;
                    }
                    case 7: {
                        return 5;
                    }
                    case 6: {
                        return 8;
                    }
                    case 8: {
                        return 6;
                    }
                }
                return 0;
            }
            if (rotate == 2) {
                return this.rotateOrientation(1, this.rotateOrientation(1, orientation));
            }
            if (rotate == 3) {
                return this.rotateOrientation(2, this.rotateOrientation(1, orientation));
            }
            return orientation;
        }

        private void setContents(int x, int y, int z, ArrayList<ArrayList<Building.Unity.Content>> contents) {
            TileEntity te;
            Block block = Block.field_71973_m[this.world.func_72798_a(x, y, z)];
            if (block instanceof BlockContainer && (te = this.world.func_72796_p(x, y, z)) instanceof IInventory) {
                for (int i = 0; i < contents.size(); ++i) {
                    ArrayList<Building.Unity.Content> groupItem = contents.get(i);
                    Building.Unity.Content content = groupItem.get(this.world.field_73012_v.nextInt(groupItem.size()));
                    int diff = content.max - content.min;
                    int nombre = content.min + (diff > 0 ? this.world.field_73012_v.nextInt(diff) : 0);
                    if (content.item == null) continue;
                    ItemStack itemStack = content.metadata == -1 ? new ItemStack(content.item, nombre) : new ItemStack(content.item, nombre, content.metadata);
                    ((IInventory)te).func_70299_a(i, itemStack);
                }
            }
        }

        private void setExtra(int x, int y, int z, HashMap<String, String> extra, int maxX, int maxZ) {
            Block block = Block.field_71973_m[this.world.func_72798_a(x, y, z)];
            int dx = -1;
            int dz = 1;
            switch (this.rotate) {
                case 1: {
                    dx = -1;
                    dz = -1;
                    break;
                }
                case 2: {
                    dx = 1;
                    dz = -1;
                    break;
                }
                case 3: {
                    dx = 1;
                    dz = 1;
                    break;
                }
            }
            for (BuildingBlockHandler handler : BuildingBlockRegistry.instance().getHandlers()) {
                handler.setExtra(block, (World)this.world, this.world.field_73012_v, x, y, z, extra, this.initX, this.initY, this.initZ, this.rotate, dx, dz, maxX, maxZ);
            }
        }

        private void setOrientation(int x, int y, int z, int orientation) {
            Block block = Block.field_71973_m[this.world.func_72798_a(x, y, z)];
            int metadata = this.world.func_72805_g(x, y, z);
            for (BuildingBlockHandler handler : BuildingBlockRegistry.instance().getHandlers()) {
                handler.setOrientation((World)this.world, x, y, z, block, metadata, orientation, this.rotate);
            }
        }
    }
}

