/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.building;

import com.gollum.core.utils.math.Integer3d;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class Building {
    public static final int ROTATED_0 = 0;
    public static final int ROTATED_90 = 1;
    public static final int ROTATED_180 = 2;
    public static final int ROTATED_270 = 3;
    public static final int ROTATED_360 = 4;
    private int maxX;
    private int maxY;
    private int maxZ;
    public int height = 0;
    public String name = "random";
    public String modId = "";
    public HashMap<Integer, DimentionSpawnInfos> dimentionsInfos = new HashMap();
    public TreeSet<Unity3D> unities = new TreeSet();
    private ArrayList<GroupSubBuildings> randomGroupSubBuildings = new ArrayList();

    public Building(String name, String modId) {
        this.name = name;
        this.modId = modId;
    }

    public Building() {
    }

    public int maxX() {
        return this.maxX;
    }

    public int maxY() {
        return this.maxY;
    }

    public int maxZ() {
        return this.maxZ;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int maxX(int rotate) {
        int n;
        if (rotate != 1) {
            if (rotate != 3) {
                n = this.maxX;
                return n;
            }
        }
        n = this.maxZ;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int maxZ(int rotate) {
        int n;
        if (rotate != 1) {
            if (rotate != 3) {
                n = this.maxZ;
                return n;
            }
        }
        n = this.maxX;
        return n;
    }

    public void setNull(int x, int y, int z) {
        this.maxX = Math.max(this.maxX, x + 1);
        this.maxY = Math.max(this.maxY, y + 1);
        this.maxZ = Math.max(this.maxZ, z + 1);
        Unity3D unity3D = new Unity3D(this, null, x, y, z);
        if (this.unities.contains(unity3D)) {
            this.unities.remove(unity3D);
        }
    }

    public void set(int x, int y, int z, Unity unity) {
        this.setNull(x, y, z);
        if (unity != null) {
            this.unities.add(new Unity3D(this, unity, x, y, z));
        }
    }

    public void addRandomBuildings(GroupSubBuildings groupSubBuildings) {
        this.randomGroupSubBuildings.add(groupSubBuildings);
    }

    public void addBuilding(SubBuilding subBuilding) {
        GroupSubBuildings groupSubBuildings = new GroupSubBuildings();
        groupSubBuildings.add(subBuilding);
        this.addRandomBuildings(groupSubBuildings);
    }

    public ArrayList<GroupSubBuildings> getRandomGroupSubBuildings() {
        return this.randomGroupSubBuildings;
    }

    public static class GroupSubBuildings
    extends ArrayList<ListSubBuildings> {
        public void add(SubBuilding subBuilding) {
            ListSubBuildings listSubBuildings = new ListSubBuildings();
            listSubBuildings.add(subBuilding);
            this.add(listSubBuildings);
        }
    }

    public static class ListSubBuildings
    extends ArrayList<SubBuilding> {
    }

    public static class SubBuilding {
        public int x = 0;
        public int y = 0;
        public int z = 0;
        public int orientation;
        public Building building = new Building();

        public void synMax(Building building) {
            this.building.maxX = building.maxX;
            this.building.maxY = building.maxY;
            this.building.maxZ = building.maxZ;
        }
    }

    public static class DimentionSpawnInfos {
        public int spawnRate = 0;
        public int spawnMin = 3;
        public int spawnMax = 256;
        public ArrayList<Block> blocksSpawn = new ArrayList();

        public DimentionSpawnInfos() {
        }

        public DimentionSpawnInfos(int spawnRate, int spawnMin, int spawnMax, ArrayList<Block> blocksSpawn) {
            this.spawnRate = spawnRate;
            this.spawnMin = spawnMin;
            this.spawnMax = spawnMax;
            this.blocksSpawn = blocksSpawn;
        }
    }

    public static class Unity {
        public static final int ORIENTATION_NONE = 0;
        public static final int ORIENTATION_UP = 1;
        public static final int ORIENTATION_DOWN = 2;
        public static final int ORIENTATION_LEFT = 3;
        public static final int ORIENTATION_RIGTH = 4;
        public static final int ORIENTATION_TOP_HORIZONTAL = 5;
        public static final int ORIENTATION_BOTTOM_HORIZONTAL = 6;
        public static final int ORIENTATION_TOP_VERTICAL = 7;
        public static final int ORIENTATION_BOTTOM_VERTICAL = 8;
        public Block block = null;
        public int metadata = 0;
        public int orientation = 0;
        public boolean after = false;
        public ArrayList<ArrayList<Content>> contents = new ArrayList();
        public HashMap<String, String> extra = new HashMap();

        public static class Content {
            public static final int TYPE_ITEM = 0;
            public static final int TYPE_BLOCK = 1;
            public Item item = null;
            public int min = 1;
            public int max = 1;
            public int metadata = -1;
            public int type;
        }
    }

    public static class Unity3D
    implements Comparable {
        private Building building;
        private Integer3d position3d;
        public Unity unity;

        public Unity3D(Building building, Unity unity, int x, int y, int z) {
            this(building, unity, new Integer3d(x, y, z));
        }

        private Unity3D(Building building, Unity unity, Integer3d position3d) {
            this.building = building;
            this.unity = unity;
            this.position3d = position3d;
        }

        public int x(int rotate) {
            return rotate == 1 || rotate == 3 ? this.building.maxX(rotate) - this.position3d.z - 1 : this.position3d.x;
        }

        public int y(int rotate) {
            return this.position3d.y;
        }

        public int z(int rotate) {
            return rotate == 1 || rotate == 3 ? this.position3d.x : this.building.maxZ(rotate) - this.position3d.z - 1;
        }

        public boolean equals(Object o) {
            return this.position3d.equals(((Unity3D)o).position3d);
        }

        public int compareTo(Object o) {
            return this.position3d.compareTo(((Unity3D)o).position3d);
        }
    }
}

