/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.config;

import argo.format.JsonFormatter;
import argo.format.PrettyJsonFormatter;
import argo.jdom.JdomParser;
import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import argo.jdom.JsonNodeFactories;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.config.Config;
import com.gollum.core.common.config.ConfigProp;
import com.gollum.core.common.config.IConfigMerge;
import com.gollum.core.common.config.type.ConfigJsonType;
import com.gollum.core.common.context.ModContext;
import com.gollum.core.common.log.Logger;
import com.gollum.core.common.mod.GollumMod;
import com.gollum.core.tools.simplejson.Json;
import cpw.mods.fml.relauncher.FMLInjectionData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class ConfigLoader {
    private static final String extention = ".cfg";
    private static final String configDir = "config";
    private static final JdomParser parser = new JdomParser();
    private static final JsonFormatter formatter = new PrettyJsonFormatter();
    private static boolean firstLoading = true;
    public static HashMap<GollumMod, ConfigLoad> configLoaded = new HashMap();
    public static HashMap<GollumMod, ArrayList<ConfigLoad>> subConfigLoaded = new HashMap();
    private boolean updateFile = false;
    private File dir;
    private String fileName;
    private Config config;
    private LinkedList<Field> configFields;
    private HashSet<String> groupList;

    public ConfigLoader(Config config) {
        this(config, true);
    }

    public ConfigLoader(Config config, boolean register) {
        Field[] fields;
        if (register) {
            GollumMod mod = ModContext.instance().getCurrent();
            if (config.isMain()) {
                if (!configLoaded.containsKey(mod)) {
                    configLoaded.put(mod, new ConfigLoad(mod, config));
                }
            }
        }
        this.dir = new File(((File)FMLInjectionData.data()[6]).getAbsoluteFile(), configDir);
        this.dir = new File(this.dir, config.getRelativePath());
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        this.config = config;
        this.configFields = new LinkedList();
        this.groupList = new HashSet();
        this.fileName = config.getFileName() + extention;
        for (Field field : fields = this.config.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigProp.class)) continue;
            this.configFields.add(field);
            ConfigProp prop = field.getAnnotation(ConfigProp.class);
            this.groupList.add(prop.group());
            Logger.log("GollumCoreLib", 0, "Field : " + field.getName() + " found goup=" + prop.group());
        }
    }

    public static void addSubConfig(Config config) {
        ConfigLoader.addSubConfig(ModContext.instance().getCurrent(), config);
    }

    public static void addSubConfig(GollumMod mod, Config config) {
        if (!subConfigLoaded.containsKey(mod)) {
            subConfigLoaded.put(mod, new ArrayList());
        }
        subConfigLoaded.get(mod).add(new ConfigLoad(mod, config));
    }

    public static ArrayList<ConfigLoad> getSubConfig(GollumMod Mod2) {
        for (Map.Entry<GollumMod, ArrayList<ConfigLoad>> entry : subConfigLoaded.entrySet()) {
            if (!entry.getKey().equals(Mod2)) continue;
            return entry.getValue();
        }
        return new ArrayList<ConfigLoad>();
    }

    public LinkedList<Field> getFieldByGroup(String groupName) {
        LinkedList<Field> list = new LinkedList<Field>();
        for (Field field : this.configFields) {
            ConfigProp prop = field.getAnnotation(ConfigProp.class);
            if (!prop.group().equals(groupName)) continue;
            list.add(field);
        }
        return list;
    }

    public void loadConfig() {
        Logger.log("GollumCoreLib", 1, "Read config : " + this.config.getRelativePath() + "/" + this.fileName);
        try {
            File configFile = new File(this.dir, this.fileName);
            HashMap<String, Field> types = new HashMap<String, Field>();
            for (Field field : this.configFields) {
                Object prop = field.getAnnotation(ConfigProp.class);
                types.put(field.getName(), field);
            }
            if (configFile.exists()) {
                HashMap properties = this.parseConfig(configFile, types);
                for (Object prop : types.keySet()) {
                    try {
                        if (properties.containsKey(prop)) {
                            Field field = (Field)types.get(prop);
                            Object obj = properties.get(prop);
                            field.setAccessible(true);
                            if (obj.equals(field.get(this.config))) continue;
                            Logger.log("GollumCoreLib", 0, "Set field : " + field.getName() + ", obj=" + obj + ", objType=" + obj.getClass().getName());
                            field.set(this.config, this.mergeValue(field.get(this.config), obj));
                            continue;
                        }
                        Logger.log("GollumCoreLib", 3, this.fileName + "Propery : " + (String)prop + " Not found");
                        this.updateFile = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.updateFile = true;
                    }
                }
            } else {
                this.updateFile = true;
            }
        }
        catch (Exception e) {
            this.updateFile = true;
            e.printStackTrace();
            Logger.log("GollumCoreLib", 4, e.getMessage());
        }
        if (this.updateFile) {
            this.writeConfig();
        }
        this.updateFile = false;
    }

    private Object mergeValue(Object oldValue, Object newValue) {
        if (oldValue instanceof IConfigMerge) {
            if (!((IConfigMerge)oldValue).merge(newValue)) {
                this.updateFile = true;
            }
            return oldValue;
        }
        return newValue;
    }

    private Object parseConvert(Class classType, String prop) {
        String jsonStr = "{\"root\":" + prop + "}";
        try {
            JsonRootNode root = parser.parse(jsonStr);
            return this.parseConvert(classType, root.getNode(new Object[]{"root"}));
        }
        catch (Exception e) {
            Logger.log("GollumCoreLib", 4, "Erreur read config : file=" + this.dir + "/" + this.fileName + ", prop=" + prop + ", json parsed=" + jsonStr);
            e.printStackTrace();
            if (Logger.getLevel() <= 0) {
                // empty if block
            }
            return null;
        }
    }

    private Object parseConvert(Class classType, JsonNode json) throws Exception {
        Object value = null;
        if (classType.isAssignableFrom(String.class)) {
            value = json.getText();
        } else if (classType.isAssignableFrom(Long.TYPE) || classType.isAssignableFrom(Long.class)) {
            value = Long.parseLong(json.getNumberValue(new Object[0]));
        } else if (classType.isAssignableFrom(Integer.TYPE) || classType.isAssignableFrom(Integer.class)) {
            value = Integer.parseInt(json.getNumberValue(new Object[0]));
        } else if (classType.isAssignableFrom(Short.TYPE) || classType.isAssignableFrom(Short.class)) {
            value = Short.parseShort(json.getNumberValue(new Object[0]));
        } else if (classType.isAssignableFrom(Byte.TYPE) || classType.isAssignableFrom(Byte.class)) {
            value = Byte.parseByte(json.getNumberValue(new Object[0]));
        } else if (classType.isAssignableFrom(Character.TYPE) || classType.isAssignableFrom(Character.class)) {
            value = Character.valueOf((char)(Byte.parseByte(json.getNumberValue(new Object[0])) & 0xFF));
        } else if (classType.isAssignableFrom(Double.TYPE) || classType.isAssignableFrom(Double.class)) {
            value = Double.parseDouble(json.getNumberValue(new Object[0]));
        } else if (classType.isAssignableFrom(Float.TYPE) || classType.isAssignableFrom(Float.class)) {
            value = Float.valueOf(Float.parseFloat(json.getNumberValue(new Object[0])));
        } else if (classType.isAssignableFrom(Boolean.TYPE) || classType.isAssignableFrom(Boolean.class)) {
            value = json.getBooleanValue(new Object[0]);
        } else if (ConfigJsonType.class.isAssignableFrom(classType)) {
            value = classType.newInstance();
            ((ConfigJsonType)value).readConfig(Json.create(json));
        } else if (Json.class.isAssignableFrom(classType)) {
            value = Json.create(json);
        } else if (classType.isArray()) {
            ArrayList<Object> tmp = new ArrayList<Object>();
            Class<?> subClass = classType.getComponentType();
            for (JsonNode el : json.getElements()) {
                Object subValue = this.parseConvert(subClass, el);
                if (subValue == null) continue;
                tmp.add(subValue);
            }
            value = Array.newInstance(subClass, tmp.size());
            for (int i = 0; i < tmp.size(); ++i) {
                Array.set(value, i, tmp.get(i));
            }
        }
        return value;
    }

    private HashMap parseConfig(File file, HashMap types) throws Exception {
        String strLine;
        HashMap<String, Object> config = new HashMap<String, Object>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((strLine = reader.readLine()) != null) {
            if (strLine.startsWith("#") || strLine.length() == 0) continue;
            int index = strLine.indexOf("=");
            if (index <= 0 || index == strLine.length()) {
                this.updateFile = true;
                continue;
            }
            String name = strLine.substring(0, index).trim();
            String prop = this.readValue(strLine.substring(index + 1), reader);
            Logger.log("GollumCoreLib", 0, "Read prop  : " + name + ":" + prop);
            if (!types.containsKey(name)) {
                this.updateFile = true;
                continue;
            }
            Class<?> classType = ((Field)types.get(name)).getType();
            Object value = this.parseConvert(classType, prop);
            if (value == null) continue;
            Logger.log("GollumCoreLib", 0, "Read " + this.fileName + " : " + name + ":" + value);
            config.put(name, value);
        }
        reader.close();
        return config;
    }

    private String readValue(String line, BufferedReader reader) throws Exception {
        return this.readValue(line, 0, reader);
    }

    private String readValue(String line, int i, BufferedReader reader) throws Exception {
        if (line.length() <= i) {
            i = 0;
            line = reader.readLine();
            if (line != null) {
                return "";
            }
            return this.readValue(line, i, reader);
        }
        char c = line.charAt(i);
        if (Character.isWhitespace(c)) {
            return this.readValue(line, i + 1, reader);
        }
        if (c == '{') {
            return c + this.readAccoladeValue(line, i + 1, 1, reader);
        }
        if (c == '[') {
            return c + this.readCrochetValue(line, i + 1, 1, reader);
        }
        return c + (i + 1 != line.length() ? line.substring(i + 1) : "");
    }

    private String readAccoladeValue(String line, int i, int niveau, BufferedReader reader) throws Exception {
        if (line.length() <= i) {
            i = 0;
            line = reader.readLine();
            if (line == null) {
                return "";
            }
            return this.readAccoladeValue(line, i, niveau, reader);
        }
        char c = line.charAt(i);
        if (c == '{') {
            return c + this.readAccoladeValue(line, i + 1, niveau + 1, reader);
        }
        if (c == '}') {
            if (niveau == 1) {
                return c + (i + 1 != line.length() ? line.substring(i + 1) : "");
            }
            return c + this.readAccoladeValue(line, i + 1, niveau - 1, reader);
        }
        return c + this.readAccoladeValue(line, i + 1, niveau, reader);
    }

    private String readCrochetValue(String line, int i, int niveau, BufferedReader reader) throws Exception {
        if (line.length() <= i) {
            i = 0;
            line = reader.readLine();
            if (line == null) {
                return "";
            }
            return this.readCrochetValue(line, i, niveau, reader);
        }
        char c = line.charAt(i);
        if (c == '[') {
            return c + this.readCrochetValue(line, i + 1, niveau + 1, reader);
        }
        if (c == ']') {
            if (niveau == 1) {
                return c + (i + 1 != line.length() ? line.substring(i + 1) : "");
            }
            return c + this.readCrochetValue(line, i + 1, niveau - 1, reader);
        }
        return c + this.readCrochetValue(line, i + 1, niveau, reader);
    }

    private String toJsonValue(Field field) throws Exception {
        Object value = field.get(this.config);
        JsonRootNode json = JsonNodeFactories.object((JsonField[])new JsonField[]{JsonNodeFactories.field((String)"root", (JsonNode)this.toJsonValue(value))});
        String out = formatter.format(json);
        out = out.substring(1).trim().substring("\"root\":".length()).trim();
        out = out.substring(0, out.length() - "}".length());
        return out;
    }

    private JsonNode toJsonValue(Object value) {
        JsonStringNode node = null;
        if (value != null) {
            if (value instanceof String) {
                node = JsonNodeFactories.string((String)((String)value));
            } else if (value instanceof Long) {
                node = JsonNodeFactories.number((long)((Long)value));
            } else if (value instanceof Integer) {
                node = JsonNodeFactories.number((long)((Integer)value).intValue());
            } else if (value instanceof Short) {
                node = JsonNodeFactories.number((long)((Short)value).shortValue());
            } else if (value instanceof Byte) {
                node = JsonNodeFactories.number((long)((Byte)value).byteValue());
            } else if (value instanceof Character) {
                node = JsonNodeFactories.number((long)((Character)value).charValue());
            } else if (value instanceof Double) {
                node = JsonNodeFactories.number((String)((Double)value).toString());
            } else if (value instanceof Float) {
                node = JsonNodeFactories.number((String)((Float)value).toString());
            } else if (value instanceof Boolean) {
                node = JsonNodeFactories.booleanNode((boolean)((Boolean)value));
            } else if (value instanceof ConfigJsonType) {
                node = ((ConfigJsonType)value).writeConfig().argoJson().build();
            } else if (value instanceof Json) {
                node = ((Json)value).argoJson().build();
            } else if (value.getClass().isArray()) {
                ArrayList<JsonNode> childs = new ArrayList<JsonNode>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    childs.add(this.toJsonValue(Array.get(value, i)));
                }
                node = JsonNodeFactories.lazyArray(childs);
            }
        }
        return node;
    }

    public ConfigLoader writeConfig() {
        File file = new File(this.dir, this.fileName);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            Iterator<String> i$ = this.groupList.iterator();
            while (i$.hasNext()) {
                int i;
                String groupName;
                String title = groupName = i$.next();
                if (groupName.equals("")) {
                    title = "General";
                }
                for (i = 0; i < title.length() + 4; ++i) {
                    out.write("#");
                }
                out.write(System.getProperty("line.separator") + "# " + title + " #" + System.getProperty("line.separator"));
                for (i = 0; i < title.length() + 4; ++i) {
                    out.write("#");
                }
                out.write(System.getProperty("line.separator") + System.getProperty("line.separator"));
                for (Field field : this.getFieldByGroup(groupName)) {
                    ConfigProp prop = field.getAnnotation(ConfigProp.class);
                    if (prop.info().length() != 0) {
                        out.write("#" + prop.info() + System.getProperty("line.separator"));
                    }
                    String name = field.getName();
                    try {
                        String value = this.toJsonValue(field);
                        out.write(name + "=" + value + System.getProperty("line.separator"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                out.write(System.getProperty("line.separator"));
                out.write(System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public static class ConfigLoad {
        public GollumMod mod;
        public Config configDefault;
        public Config config;

        public ConfigLoad(GollumMod mod, Config config) {
            this.mod = mod;
            this.configDefault = (Config)config.clone();
            this.config = config;
        }

        public ArrayList<String> getCategories() {
            ArrayList<String> categories = new ArrayList<String>();
            try {
                for (Field f : this.config.getClass().getDeclaredFields()) {
                    f.setAccessible(true);
                    ConfigProp anno = f.getAnnotation(ConfigProp.class);
                    if (anno == null || anno.dev() && !ModGollumCoreLib.config.devTools) continue;
                    String group = anno.group().trim();
                    if (group.equals("")) {
                        group = "General";
                    }
                    if (categories.contains(group)) continue;
                    categories.add(group);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return categories;
        }

        public void saveValue(LinkedHashMap<String, Object> values) {
            for (Field f : this.config.getClass().getDeclaredFields()) {
                String name = f.getName();
                if (!values.containsKey(name)) continue;
                Object value = values.get(name);
                try {
                    f.set(this.config, value);
                    ModGollumCoreLib.log.info("Save config \"" + name + "\"" + value.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

