/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.log;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.context.ModContext;
import com.gollum.core.common.log.LogFormatter;
import java.util.Hashtable;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;

public class Logger {
    private static final String FILE_NAME = "GollumCoreLib.log";
    public static final int LEVEL_DEBUG = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_MESSAGE = 2;
    public static final int LEVEL_WARNING = 3;
    public static final int LEVEL_SEVERE = 4;
    public static final int LEVEL_NONE = 99;
    private static final LogFormatter formater = new LogFormatter();
    private static int level = 1;
    private static Handler fileHandler = null;
    private static Hashtable<String, java.util.logging.Logger> loggers = new Hashtable();
    private String modId = ModContext.instance().getCurrent().getModId();

    public static int getLevel() {
        return level;
    }

    public static void setLevelDisplay(int levelDisplay) {
        level = levelDisplay;
    }

    private String implode(Object[] list) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Object s : list) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(s.toString());
            ++i;
        }
        return builder.toString();
    }

    public static void setLevelDisplay(String levelDisplay) {
        level = 1;
        if (levelDisplay.equals("DEBUG")) {
            level = 0;
        }
        if (levelDisplay.equals("MESSAGE")) {
            level = 2;
        }
        if (levelDisplay.equals("WARNING")) {
            level = 3;
        }
        if (levelDisplay.equals("SEVERE")) {
            level = 4;
        }
        if (levelDisplay.equals("NONE")) {
            level = 99;
        }
    }

    public void debug(Object ... msg) {
        Logger.log(this.modId, 0, this.implode(msg));
    }

    public void info(Object ... msg) {
        Logger.log(this.modId, 1, this.implode(msg));
    }

    public void message(Object ... msg) {
        Logger.log(this.modId, 2, this.implode(msg));
    }

    public void warning(Object ... msg) {
        Logger.log(this.modId, 3, this.implode(msg));
    }

    public void severe(Object ... msg) {
        Logger.log(this.modId, 4, this.implode(msg));
    }

    public static java.util.logging.Logger getLogger(String key) {
        if (loggers.containsKey(key)) {
            return loggers.get(key);
        }
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(key);
        if (fileHandler == null) {
            try {
                if (ModGollumCoreLib.config != null) {
                    fileHandler = new FileHandler(FILE_NAME, 2000000, ModGollumCoreLib.config.numberLogFilesUse, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (fileHandler != null) {
                fileHandler.setLevel(Level.INFO);
                fileHandler.setFormatter(formater);
            }
        }
        if (fileHandler != null) {
            logger.addHandler(fileHandler);
            loggers.put(key, logger);
        }
        return logger;
    }

    public static void log(String key, int level, Object msg) {
        java.util.logging.Logger log = Logger.getLogger(key);
        log.setLevel(Level.INFO);
        switch (level) {
            case 4: {
                if (Logger.level > 4) break;
                log.log(Level.SEVERE, msg.toString());
                break;
            }
            case 3: {
                if (Logger.level > 3) break;
                log.log(Level.WARNING, msg.toString());
                break;
            }
            case 2: {
                if (Logger.level > 2) break;
                log.log(Level.INFO, msg.toString());
                break;
            }
            case 1: {
                if (Logger.level > 1) break;
                log.log(Level.INFO, msg.toString());
                break;
            }
            case 0: {
                if (Logger.level > 0) break;
                log.log(Level.INFO, msg.toString());
                break;
            }
        }
    }
}

