/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.resources;

import com.gollum.core.common.resources.AbstractResourcePack;
import com.gollum.core.common.resources.ResourcePackFileNotFoundException;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileResourcePack
extends AbstractResourcePack
implements Closeable {
    public static final Splitter entryNameSplitter = Splitter.on((char)'/').omitEmptyStrings().limit(3);
    private ZipFile resourcePackZipFile;

    public FileResourcePack(File par1File) {
        super(par1File);
    }

    private ZipFile getResourcePackZipFile() throws IOException {
        if (this.resourcePackZipFile == null) {
            this.resourcePackZipFile = new ZipFile(this.resourcePackFile);
        }
        return this.resourcePackZipFile;
    }

    @Override
    protected InputStream getInputStreamByName(String par1Str) throws IOException {
        ZipFile zipfile = this.getResourcePackZipFile();
        ZipEntry zipentry = zipfile.getEntry(par1Str);
        if (zipentry == null) {
            throw new ResourcePackFileNotFoundException(this.resourcePackFile, par1Str);
        }
        return zipfile.getInputStream(zipentry);
    }

    @Override
    public boolean hasResourceName(String par1Str) {
        try {
            return this.getResourcePackZipFile().getEntry(par1Str) != null;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    @Override
    public Set getResourceDomains() {
        ZipFile zipfile;
        try {
            zipfile = this.getResourcePackZipFile();
        }
        catch (IOException ioexception) {
            return Collections.emptySet();
        }
        Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
        HashSet hashset = Sets.newHashSet();
        while (enumeration.hasMoreElements()) {
            ArrayList arraylist;
            ZipEntry zipentry = enumeration.nextElement();
            String s = zipentry.getName();
            if (!s.startsWith("assets/") || (arraylist = Lists.newArrayList((Iterable)entryNameSplitter.split((CharSequence)s))).size() <= 1) continue;
            String s1 = (String)arraylist.get(1);
            if (!s1.equals(s1.toLowerCase())) {
                this.logNameNotLowercase(s1);
                continue;
            }
            hashset.add(s1);
        }
        return hashset;
    }

    protected void finalize() {
        this.close();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        if (this.resourcePackZipFile != null) {
            try {
                this.resourcePackZipFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.resourcePackZipFile = null;
        }
    }
}

