/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.tools.simplejson;

import argo.format.CompactJsonFormatter;
import argo.format.PrettyJsonFormatter;
import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import argo.jdom.JsonNodeBuilder;
import argo.jdom.JsonNodeBuilders;
import argo.jdom.JsonNodeFactories;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import com.gollum.core.tools.simplejson.IJsonComplement;
import com.gollum.core.tools.simplejson.IJsonObjectDisplay;
import com.gollum.core.tools.simplejson.JsonArray;
import com.gollum.core.tools.simplejson.JsonBool;
import com.gollum.core.tools.simplejson.JsonByte;
import com.gollum.core.tools.simplejson.JsonChar;
import com.gollum.core.tools.simplejson.JsonDouble;
import com.gollum.core.tools.simplejson.JsonFloat;
import com.gollum.core.tools.simplejson.JsonInt;
import com.gollum.core.tools.simplejson.JsonLong;
import com.gollum.core.tools.simplejson.JsonNull;
import com.gollum.core.tools.simplejson.JsonObject;
import com.gollum.core.tools.simplejson.JsonShort;
import com.gollum.core.tools.simplejson.JsonString;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Json
implements Cloneable {
    protected Object value;
    protected ArrayList<IJsonComplement> complements = new ArrayList();

    public static Json create(Json json) {
        return Json.create(json.value()).addComplements(json.getComplements());
    }

    public static JsonNull create() {
        return new JsonNull();
    }

    public static JsonString create(String str) {
        return new JsonString(str);
    }

    public static JsonLong create(long l) {
        return new JsonLong(l);
    }

    public static JsonInt create(int i) {
        return new JsonInt(i);
    }

    public static JsonShort create(short s) {
        return new JsonShort(s);
    }

    public static JsonByte create(byte b) {
        return new JsonByte(b);
    }

    public static JsonChar create(char c) {
        return new JsonChar(c);
    }

    public static JsonDouble create(double d) {
        return new JsonDouble(d);
    }

    public static JsonFloat create(float f) {
        return new JsonFloat(f);
    }

    public static JsonBool create(boolean b) {
        return new JsonBool(b);
    }

    public static JsonArray create(Object ... objs) {
        return Json.createArray(objs);
    }

    public static JsonArray createArray(Object ... objs) {
        JsonArray ar = new JsonArray();
        for (Object i : objs) {
            ar.add(i);
        }
        return ar;
    }

    public static JsonObject create(EntryObject ... objs) {
        return Json.createObject(objs);
    }

    public static JsonObject createObject(EntryObject ... objs) {
        JsonObject o = new JsonObject();
        for (EntryObject entry : objs) {
            o.add(entry.key, entry.dom);
        }
        return o;
    }

    public static JsonObject create(Map map) {
        JsonObject json = Json.createObject(new EntryObject[0]);
        json.setValue(map);
        return json;
    }

    public static JsonArray create(List list) {
        JsonArray json = Json.createArray(new Object[0]);
        json.setValue(list);
        return json;
    }

    public static Json create(Object o) {
        if (o == null) {
            return Json.create();
        }
        if (o.getClass().isArray()) {
            JsonArray ar = new JsonArray();
            for (int i = 0; i < Array.getLength(o); ++i) {
                ar.add(Array.get(o, i));
            }
            return ar;
        }
        if (o instanceof String) {
            return Json.create((String)o);
        }
        if (o instanceof EntryObject) {
            return Json.create((Object)((EntryObject)o));
        }
        if (o instanceof JsonNode) {
            return Json.create((JsonNode)o);
        }
        if (o instanceof Json) {
            return Json.create((Json)o);
        }
        if (o instanceof Long || o.getClass().isAssignableFrom(Long.TYPE)) {
            return Json.create((Long)o);
        }
        if (o instanceof Integer || o.getClass().isAssignableFrom(Integer.TYPE)) {
            return Json.create((Integer)o);
        }
        if (o instanceof Short || o.getClass().isAssignableFrom(Short.TYPE)) {
            return Json.create((Short)o);
        }
        if (o instanceof Byte || o.getClass().isAssignableFrom(Byte.TYPE)) {
            return Json.create((Byte)o);
        }
        if (o instanceof Character || o.getClass().isAssignableFrom(Character.TYPE)) {
            return Json.create(((Character)o).charValue());
        }
        if (o instanceof Double || o.getClass().isAssignableFrom(Double.TYPE)) {
            return Json.create((Double)o);
        }
        if (o instanceof Float || o.getClass().isAssignableFrom(Float.TYPE)) {
            return Json.create(((Float)o).floatValue());
        }
        if (o instanceof Boolean || o.getClass().isAssignableFrom(Boolean.TYPE)) {
            return Json.create((Boolean)o);
        }
        if (o instanceof Map || o.getClass().isAssignableFrom(Boolean.TYPE)) {
            return Json.create((Map)o);
        }
        if (o instanceof List || o.getClass().isAssignableFrom(Boolean.TYPE)) {
            return Json.create((List)o);
        }
        return Json.create(o.toString());
    }

    public Object value() {
        return this.value;
    }

    public String strValue() {
        return this.value() != null ? this.value().toString() : "";
    }

    public long longValue() {
        try {
            return Long.parseLong(this.strValue());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public int intValue() {
        return new Long(this.longValue()).intValue();
    }

    public short shortValue() {
        return new Integer(this.intValue()).shortValue();
    }

    public byte byteValue() {
        return new Short(this.shortValue()).byteValue();
    }

    public char charValue() {
        return (char)this.byteValue();
    }

    public float floatValue() {
        try {
            return Float.parseFloat(this.strValue());
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public double doubleValue() {
        try {
            return Double.parseDouble(this.strValue());
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public boolean boolValue() {
        try {
            return Boolean.parseBoolean(this.strValue());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int size() {
        return 0;
    }

    public Json child(int i) {
        return Json.create();
    }

    public Json child(String key) {
        return Json.create();
    }

    public Collection<Json> allChild() {
        return new ArrayList<Json>();
    }

    public Set<Map.Entry<String, Json>> allChildWithKey() {
        return new HashSet<Map.Entry<String, Json>>();
    }

    public boolean contains(Json json) {
        return false;
    }

    public boolean containsKey(int i) {
        return false;
    }

    public boolean containsKey(String key) {
        return false;
    }

    public void add(Json child) {
    }

    public void add(Object child) {
        this.add(Json.create(child));
    }

    public void add(String key, Json child) {
    }

    public void add(String key, Object child) {
        this.add(key, Json.create(child));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Json) {
            if (((Json)obj).value() == null || this.value() == null) {
                return this.value() == ((Json)obj).value();
            }
            return this.value().equals(((Json)obj).value());
        }
        try {
            return Json.create(obj).equals(this.value());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Json addComplement(IJsonComplement jsonComplement) {
        this.complements.add(jsonComplement);
        return this;
    }

    public Json clearComplement() {
        this.complements.clear();
        return this;
    }

    private Json addComplements(ArrayList<IJsonComplement> complements) {
        this.complements.addAll(complements);
        return this;
    }

    public ArrayList<IJsonComplement> getComplements() {
        return this.complements;
    }

    public void clear() {
    }

    public IJsonComplement getComplement(Class search) {
        for (IJsonComplement complement : this.complements) {
            if (!search.isAssignableFrom(complement.getClass())) continue;
            return complement;
        }
        return null;
    }

    public TYPE getType() {
        return TYPE.NULL;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isNull() {
        return this.getType() == TYPE.NULL;
    }

    public boolean isArray() {
        return this.getType() == TYPE.ARRAY;
    }

    public boolean isObject() {
        return this.getType() == TYPE.OBJECT;
    }

    public boolean isString() {
        return this.getType() == TYPE.STRING;
    }

    public boolean isLong() {
        return this.getType() == TYPE.LONG;
    }

    public boolean isInt() {
        return this.getType() == TYPE.INT;
    }

    public boolean isShort() {
        return this.getType() == TYPE.SHORT;
    }

    public boolean isByte() {
        return this.getType() == TYPE.BYTE;
    }

    public boolean isChar() {
        return this.getType() == TYPE.CHAR;
    }

    public boolean isDouble() {
        return this.getType() == TYPE.DOUBLE;
    }

    public boolean isFloat() {
        return this.getType() == TYPE.FLOAT;
    }

    public boolean isBool() {
        return this.getType() == TYPE.BOOLEAN;
    }

    public Object clone() {
        return Json.create(this);
    }

    public String toString() {
        IJsonObjectDisplay display = (IJsonObjectDisplay)this.getComplement(IJsonObjectDisplay.class);
        if (display != null) {
            return display.display(this);
        }
        return this.toString(false);
    }

    public String toString(boolean pretty) {
        JsonRootNode json = JsonNodeFactories.object((JsonField[])new JsonField[]{JsonNodeFactories.field((String)"root", (JsonNode)this.argoJson().build())});
        String out = pretty ? new PrettyJsonFormatter().format(json) : new CompactJsonFormatter().format(json);
        out = out.substring(1).trim().substring("\"root\":".length()).trim();
        out = out.substring(0, out.length() - "}".length());
        return out;
    }

    public static Json create(JsonNode json) {
        if (json.isObjectNode(new Object[0])) {
            JsonObject o = Json.createObject(new EntryObject[0]);
            for (Map.Entry entry : json.getFields().entrySet()) {
                o.add(((JsonStringNode)entry.getKey()).getText(), entry.getValue());
            }
            return o;
        }
        if (json.isArrayNode(new Object[0])) {
            JsonArray ar = Json.createArray(new Object[0]);
            for (JsonNode child : json.getElements()) {
                ar.add(child);
            }
            return ar;
        }
        if (json.isStringValue(new Object[0])) {
            return Json.create(json.getStringValue(new Object[0]));
        }
        if (json.isNumberValue(new Object[0])) {
            return Json.create(json.getNumberValue(new Object[0]));
        }
        if (json.isBooleanValue(new Object[0])) {
            return Json.create((Object)json.getBooleanValue(new Object[0]));
        }
        return Json.create();
    }

    public JsonNodeBuilder argoJson() {
        return JsonNodeBuilders.aNullBuilder();
    }

    public static class EntryObject {
        public String key;
        public Json dom;

        public EntryObject(String key, Object value) {
            this(key, Json.create(value));
        }

        public EntryObject(String key, Json dom) {
            this.key = key;
            this.dom = dom;
        }

        public EntryObject addComplement(IJsonComplement jsonComplement) {
            this.dom.addComplement(jsonComplement);
            return this;
        }
    }

    static enum TYPE {
        NULL,
        OBJECT,
        ARRAY,
        STRING,
        LONG,
        INT,
        SHORT,
        BYTE,
        CHAR,
        DOUBLE,
        FLOAT,
        BOOLEAN;

    }
}

