/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.utils.reflection;

import com.gollum.core.utils.reflection.DeobfuscateName;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Reflection {
    public static void setFinalField(Field field, Object object, Object value) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(object, value);
        modifiersField.setInt(field, field.getModifiers() | 0x10);
    }

    public static void setFinalStatic(Field field, Object value) throws Exception {
        Reflection.setFinalField(field, null, value);
    }

    public static void enableSynchronized(Method m) throws Exception {
        Field modifiersField = Method.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(m, m.getModifiers() | 0x20);
    }

    public static Method getMethodByDesobfuscate(Class clazz, String name) {
        for (Method m : clazz.getDeclaredMethods()) {
            DeobfuscateName anno = m.getAnnotation(DeobfuscateName.class);
            if (anno == null || !anno.value().equals(name)) continue;
            return m;
        }
        return null;
    }

    public static String getObfuscateName(Class clazz, String name) throws Exception {
        return Reflection.getMethodByDesobfuscate(clazz, name).getName();
    }

    public static Class<?>[] getObfuscateParameters(Class<?> clazz, String name) throws Exception {
        return Reflection.getMethodByDesobfuscate(clazz, name).getParameterTypes();
    }

    public static Method getObfuscateMethod(Class<?> target, Class<?> stub, String name) throws Exception {
        return target.getDeclaredMethod(Reflection.getObfuscateName(stub, name), Reflection.getObfuscateParameters(stub, name));
    }
}

