/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.UV;

public class MultiIconTransformation
implements IUVTransformation {
    public ms[] icons;

    public MultiIconTransformation(ms ... icons) {
        this.icons = icons;
    }

    @Override
    public void transform(UV texcoord) {
        int i = (int)texcoord.u >> 1;
        ms icon = this.icons[i % this.icons.length];
        texcoord.u = icon.a(texcoord.u % 2.0 * 16.0);
        texcoord.v = icon.b(texcoord.v % 2.0 * 16.0);
    }

    public static CCModel setIconIndex(CCModel m, int index) {
        return MultiIconTransformation.setIconIndex(m, 0, m.verts.length, index);
    }

    public static CCModel setIconIndex(CCModel m, int start, int end, int index) {
        for (int k = start; k < end; ++k) {
            UV uv = m.verts[k].uv;
            uv.u = uv.u % 2.0 + (double)(index * 2);
            uv.v %= 2.0;
        }
        return m;
    }
}

