/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.jammyfurniture.common.tilesentities.iron;

import com.gollum.core.common.tileentities.GCLInventoryTileEntity;
import com.gollum.core.tools.helper.IBlockMetadataHelper;
import com.gollum.jammyfurniture.ModJammyFurniture;
import com.gollum.jammyfurniture.common.crafting.CookerRecipes;
import com.gollum.jammyfurniture.inits.ModBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileEntityIronBlocksOne
extends GCLInventoryTileEntity {
    public static final int INV_SIZE_FRIDGE = 9;
    public static final int INV_SIZE_COOKER = 5;
    public static final int INV_SIZE_RUBBISHBIN = 27;
    public static final int INDEX_SLOT_BURN = 1;
    public static final int INDEX_SLOT_BEFORE0 = 0;
    public static final int INDEX_SLOT_BEFORE1 = 3;
    public static final int INDEX_SLOT_AFTER0 = 2;
    public static final int INDEX_SLOT_AFTER1 = 4;
    public static final int COOKING_SPEED0 = 200;
    public static final int COOKING_SPEED1 = 150;
    public int currentItemBurnTime = 0;
    public int cookerBurnTime = 0;
    public int cookerCookTime0 = 0;
    public int cookerCookTime1 = 0;
    long lastClearance = System.currentTimeMillis();
    public short rubishBinOrientation = 0;

    public TileEntityIronBlocksOne() {
        super(Math.max(9, Math.max(5, 27)));
    }

    public int func_70302_i_() {
        if (this.field_70331_k != null && this.field_70331_k.func_72899_e(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
            switch (this.getSubBlock()) {
                case 0: 
                case 4: {
                    return 9;
                }
                case 8: {
                    return 5;
                }
                case 12: {
                    return 27;
                }
            }
        }
        return super.func_70302_i_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 1) {
            if (TileEntityIronBlocksOne.isItemFuel(itemStack)) return true;
        }
        if (slot == 0) {
            if (CookerRecipes.smelting().getSmeltingResult(itemStack) == null) return true;
        }
        if (slot != 3) return false;
        if (CookerRecipes.smelting().getSmeltingResult(itemStack) != null) return false;
        return true;
    }

    public String func_70303_b() {
        switch (this.getSubBlock()) {
            case 0: {
                return ModJammyFurniture.i18n.trans("Fridge", new Object[0]);
            }
            case 4: {
                return ModJammyFurniture.i18n.trans("Freezer", new Object[0]);
            }
            case 8: {
                return ModJammyFurniture.i18n.trans("Cooker", new Object[0]);
            }
            case 12: {
                return ModJammyFurniture.i18n.trans("Rubbish Bin", new Object[0]);
            }
        }
        return "ERROR";
    }

    protected void playSoundClosedInventory() {
        String oldSound = this.soundClosedInventory;
        float oldVolume = this.volumeSoundOpenClosedInventory;
        if (this.getSubBlock() == 12) {
            this.soundClosedInventory = "JammyFurniture".toLowerCase() + ":trashclosed";
            this.volumeSoundOpenClosedInventory = 1.5f;
        }
        super.playSoundClosedInventory();
        this.soundClosedInventory = oldSound;
        this.volumeSoundOpenClosedInventory = oldVolume;
    }

    protected void playSoundOpenInventory() {
        String oldSound = this.soundOpenInventory;
        float oldVolume = this.volumeSoundOpenClosedInventory;
        if (this.getSubBlock() == 12) {
            this.soundOpenInventory = "JammyFurniture".toLowerCase() + ":trashopen";
            this.volumeSoundOpenClosedInventory = 1.5f;
        }
        super.playSoundOpenInventory();
        this.soundOpenInventory = oldSound;
        this.volumeSoundOpenClosedInventory = oldVolume;
    }

    public void func_70316_g() {
        super.func_70316_g();
        int metadata = this.func_70322_n();
        int subBlock = this.getSubBlock();
        if (subBlock == 12) {
            if (System.currentTimeMillis() - this.lastClearance >= 60000L) {
                this.removeAllItems();
                this.lastClearance = System.currentTimeMillis();
            }
            return;
        }
        if (subBlock == 8) {
            boolean inventoryChange = false;
            if (this.isBurning()) {
                --this.cookerBurnTime;
            }
            if (!this.field_70331_k.field_72995_K) {
                if (this.cookerBurnTime == 0 && (this.canSmelt(0) || this.canSmelt(1))) {
                    this.currentItemBurnTime = this.cookerBurnTime = TileEntityIronBlocksOne.getItemBurnTime(this.inventory[1]);
                    if (this.cookerBurnTime > 0) {
                        inventoryChange = true;
                        if (this.inventory[1] != null) {
                            --this.inventory[1].field_77994_a;
                            if (this.inventory[1].field_77994_a == 0) {
                                this.inventory[1] = this.inventory[1].func_77973_b().getContainerItemStack(this.inventory[1]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt(0)) {
                    ++this.cookerCookTime0;
                    if (this.cookerCookTime0 == 200) {
                        this.cookerCookTime0 = 0;
                        this.smeltItem(0);
                        inventoryChange = true;
                    }
                } else {
                    this.cookerCookTime0 = 0;
                }
                if (this.isBurning() && this.canSmelt(1)) {
                    ++this.cookerCookTime1;
                    if (this.cookerCookTime1 >= 150) {
                        this.cookerCookTime1 = 0;
                        this.smeltItem(1);
                        inventoryChange = true;
                    }
                } else {
                    this.cookerCookTime1 = 0;
                }
            }
            if (inventoryChange) {
                this.func_70296_d();
            }
        }
    }

    public void func_70307_a(NBTTagCompound nbtTagCompound) {
        super.func_70307_a(nbtTagCompound);
        this.readItems(nbtTagCompound, "FriFreItems", true);
        this.readItems(nbtTagCompound, "CookerItems", true);
        this.readItems(nbtTagCompound, "BinItems", true);
        this.cookerBurnTime = nbtTagCompound.func_74765_d("BurnTime");
        this.cookerCookTime0 = nbtTagCompound.func_74765_d("CookTime");
        this.cookerCookTime1 = nbtTagCompound.func_74765_d("CookTime2");
        this.rubishBinOrientation = nbtTagCompound.func_74765_d("rubishBinOrientation");
        this.currentItemBurnTime = TileEntityIronBlocksOne.getItemBurnTime(this.inventory[1]);
    }

    public void func_70310_b(NBTTagCompound nbtTagCompound) {
        super.func_70310_b(nbtTagCompound);
        nbtTagCompound.func_74777_a("BurnTime", (short)this.cookerBurnTime);
        nbtTagCompound.func_74777_a("CookTime", (short)this.cookerCookTime0);
        nbtTagCompound.func_74777_a("CookTime2", (short)this.cookerCookTime1);
        nbtTagCompound.func_74777_a("rubishBinOrientation", this.rubishBinOrientation);
    }

    public Packet func_70319_e() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_70310_b(nbttagcompound);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, nbttagcompound);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        this.func_70307_a(pkt.field_73331_e);
        this.field_70331_k.func_72909_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void removeAllItems() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, null);
        }
    }

    private int getSubBlock() {
        int metadata = this.func_70322_n();
        return ((IBlockMetadataHelper)ModBlocks.blockIronBlocksOne).getEnabledMetadata(metadata);
    }

    public boolean isBurning() {
        return this.cookerBurnTime > 0;
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return TileEntityIronBlocksOne.getItemBurnTime(par0ItemStack) > 0;
    }

    protected static int getItemBurnTime(ItemStack itemStack) {
        return TileEntityFurnace.func_70398_a((ItemStack)itemStack);
    }

    private boolean canSmelt(int i) {
        int after;
        int before = i == 0 ? 0 : 3;
        int n = after = i == 0 ? 2 : 4;
        if (this.inventory[before] == null) {
            return false;
        }
        ItemStack itemCooked = CookerRecipes.smelting().getSmeltingResult(this.inventory[before]);
        if (itemCooked == null) {
            return false;
        }
        if (this.inventory[after] == null) {
            return true;
        }
        if (!this.inventory[after].func_77969_a(itemCooked)) {
            return false;
        }
        int total = this.inventory[after].field_77994_a + itemCooked.field_77994_a;
        return total <= this.func_70297_j_() && total <= itemCooked.func_77976_d();
    }

    public void smeltItem(int i) {
        int after;
        int before = i == 0 ? 0 : 3;
        int n = after = i == 0 ? 2 : 4;
        if (this.canSmelt(i)) {
            ItemStack itemStack = CookerRecipes.smelting().getSmeltingResult(this.inventory[before]);
            if (this.inventory[after] == null) {
                this.inventory[after] = itemStack.func_77946_l();
            } else if (this.inventory[after].func_77969_a(itemStack)) {
                this.inventory[after].field_77994_a += itemStack.field_77994_a;
            }
            --this.inventory[before].field_77994_a;
            if (this.inventory[before].field_77994_a <= 0) {
                this.inventory[before] = null;
            }
        }
    }

    public int getBurnTimeRemainingScaled(int maxSize) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.cookerBurnTime * maxSize / this.currentItemBurnTime;
    }

    public int getCookProgressScaled0(int par1) {
        return this.cookerCookTime0 * par1 / 200;
    }

    public int getCookProgressScaled1(int par1) {
        return this.cookerCookTime1 * par1 / 150;
    }
}

