/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tileentity;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import dan200.computer.api.IPeripheral;
import java.util.ArrayList;
import mekanism.api.Object3D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasAcceptor;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.ISustainedTank;
import mekanism.common.PacketHandler;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tileentity.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.block.BlockGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityElectrolyticSeparator
extends TileEntityElectricBlock
implements IFluidHandler,
IPeripheral,
ITubeConnection,
ISustainedTank {
    public FluidTank waterTank = new FluidTank(24000);
    public int MAX_GAS = 2400;
    public int oxygenStored;
    public int hydrogenStored;
    public int output = 16;
    public Gas outputType;
    public Gas dumpType;

    public TileEntityElectrolyticSeparator() {
        super("ElectrolyticSeparator", BlockGenerator.GeneratorType.ELECTROLYTIC_SEPARATOR.maxEnergy);
        this.inventory = new ItemStack[4];
        this.outputType = GasRegistry.getGas((String)"oxygen");
        this.dumpType = null;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            FluidStack fluid;
            ChargeUtils.discharge((int)3, (TileEntityElectricBlock)this);
            if (this.inventory[0] != null && (fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[0])) != null && fluid.getFluid() == FluidRegistry.WATER && (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount + fluid.amount <= this.waterTank.getCapacity())) {
                this.waterTank.fill(fluid, true);
                if (this.inventory[0].func_77973_b().func_77634_r()) {
                    this.inventory[0] = this.inventory[0].func_77973_b().getContainerItemStack(this.inventory[0]);
                } else {
                    --this.inventory[0].field_77994_a;
                }
                if (this.inventory[0].field_77994_a == 0) {
                    this.inventory[0] = null;
                }
            }
            if (!this.field_70331_k.field_72995_K) {
                if (this.inventory[1] != null && this.hydrogenStored > 0) {
                    this.hydrogenStored -= GasTransmission.addGas((ItemStack)this.inventory[1], (GasStack)new GasStack(GasRegistry.getGas((String)"hydrogen"), this.hydrogenStored));
                    MekanismUtils.saveChunk((TileEntity)this);
                }
                if (this.inventory[2] != null && this.oxygenStored > 0) {
                    this.hydrogenStored -= GasTransmission.addGas((ItemStack)this.inventory[2], (GasStack)new GasStack(GasRegistry.getGas((String)"oxygen"), this.oxygenStored));
                    MekanismUtils.saveChunk((TileEntity)this);
                }
            }
            if (this.oxygenStored < this.MAX_GAS && this.hydrogenStored < this.MAX_GAS && this.waterTank.getFluid() != null && this.waterTank.getFluid().amount - 2 >= 0 && this.getEnergy() - 100.0 > 0.0) {
                this.waterTank.drain(2, true);
                this.setEnergy(this.getEnergy() - MekanismGenerators.electrolyticSeparatorUsage);
                this.setStored(GasRegistry.getGas((String)"oxygen"), this.oxygenStored + 1);
                this.setStored(GasRegistry.getGas((String)"hydrogen"), this.hydrogenStored + 2);
            }
            if (this.outputType != null && this.getStored(this.outputType) > 0) {
                GasStack toSend = new GasStack(this.outputType, Math.min(this.getStored(this.outputType), this.output));
                this.setStored(this.outputType, this.getStored(this.outputType) - GasTransmission.emitGasToNetwork((GasStack)toSend, (TileEntity)this, (ForgeDirection)ForgeDirection.getOrientation((int)this.facing)));
                TileEntity tileEntity = Object3D.get((TileEntity)this).getFromSide(ForgeDirection.getOrientation((int)this.facing)).getTileEntity((IBlockAccess)this.field_70331_k);
                if (tileEntity instanceof IGasAcceptor && ((IGasAcceptor)tileEntity).canReceiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), this.outputType)) {
                    int added = ((IGasAcceptor)tileEntity).receiveGas(new GasStack(this.outputType, Math.min(this.getStored(this.outputType), this.output)));
                    this.setStored(this.outputType, this.getStored(this.outputType) - added);
                }
            }
            if (this.dumpType != null && this.getStored(this.dumpType) > 0) {
                this.setStored(this.dumpType, this.getStored(this.dumpType) - 8);
                if (this.field_70331_k.field_73012_v.nextInt(3) == 2) {
                    PacketHandler.sendPacket((PacketHandler.Transmission)PacketHandler.Transmission.CLIENTS_RANGE, (IMekanismPacket)new PacketTileEntity().setParams(new Object[]{Object3D.get((TileEntity)this), this.getParticlePacket(new ArrayList())}), (Object[])new Object[]{Object3D.get((TileEntity)this), 40.0});
                }
            }
        }
    }

    public int getStored(Gas gas) {
        if (gas == GasRegistry.getGas((String)"oxygen")) {
            return this.oxygenStored;
        }
        if (gas == GasRegistry.getGas((String)"hydrogen")) {
            return this.hydrogenStored;
        }
        return 0;
    }

    public void setStored(Gas type, int amount) {
        if (type == GasRegistry.getGas((String)"hydrogen")) {
            this.hydrogenStored = Math.max(Math.min(amount, this.MAX_GAS), 0);
        } else if (type == GasRegistry.getGas((String)"oxygen")) {
            this.oxygenStored = Math.max(Math.min(amount, this.MAX_GAS), 0);
        }
        MekanismUtils.saveChunk((TileEntity)this);
    }

    public void spawnParticle() {
        switch (this.facing) {
            case 3: {
                this.field_70331_k.func_72869_a("smoke", (double)this.field_70329_l + 0.1, (double)(this.field_70330_m + 1), (double)this.field_70327_n + 0.25, 0.0, 0.0, 0.0);
                break;
            }
            case 4: {
                this.field_70331_k.func_72869_a("smoke", (double)this.field_70329_l + 0.75, (double)(this.field_70330_m + 1), (double)this.field_70327_n + 0.1, 0.0, 0.0, 0.0);
                break;
            }
            case 2: {
                this.field_70331_k.func_72869_a("smoke", (double)this.field_70329_l + 0.9, (double)(this.field_70330_m + 1), (double)this.field_70327_n + 0.75, 0.0, 0.0, 0.0);
                break;
            }
            case 5: {
                this.field_70331_k.func_72869_a("smoke", (double)this.field_70329_l + 0.25, (double)(this.field_70330_m + 1), (double)this.field_70327_n + 0.9, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted((ItemStack)itemstack, (boolean)false);
        }
        if (slotID == 0) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
        }
        if (slotID == 1 || slotID == 2) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(new Object[]{itemstack}) != null && ((IGasItem)itemstack.func_77973_b()).getGas((Object[])new Object[]{itemstack}).amount == ((IGasItem)itemstack.func_77973_b()).getMaxGas(new Object[]{itemstack});
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack) != null && FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack).getFluid() == FluidRegistry.WATER;
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && (((IGasItem)itemstack.func_77973_b()).getGas(new Object[]{itemstack}) == null || ((IGasItem)itemstack.func_77973_b()).getGas(new Object[]{itemstack}).getGas() == GasRegistry.getGas((String)"hydrogen"));
        }
        if (slotID == 2) {
            return itemstack.func_77973_b() instanceof IGasItem && (((IGasItem)itemstack.func_77973_b()).getGas(new Object[]{itemstack}) == null || ((IGasItem)itemstack.func_77973_b()).getGas(new Object[]{itemstack}).getGas() == GasRegistry.getGas((String)"oxygen"));
        }
        if (slotID == 3) {
            return ChargeUtils.canBeDischarged((ItemStack)itemstack);
        }
        return true;
    }

    public int[] func_94128_d(int side) {
        if (ForgeDirection.getOrientation((int)side) == MekanismUtils.getLeft((int)this.facing)) {
            return new int[]{3};
        }
        if (side == this.facing || ForgeDirection.getOrientation((int)side) == ForgeDirection.getOrientation((int)this.facing).getOpposite()) {
            return new int[]{1, 2};
        }
        return new int[]{0};
    }

    public int getScaledHydrogenLevel(int i) {
        return this.hydrogenStored * i / this.MAX_GAS;
    }

    public int getScaledOxygenLevel(int i) {
        return this.oxygenStored * i / this.MAX_GAS;
    }

    public int getScaledWaterLevel(int i) {
        return this.waterTank.getFluid() != null ? this.waterTank.getFluid().amount * i / this.waterTank.getCapacity() : 0;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / this.MAX_ELECTRICITY);
    }

    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.field_70331_k.field_72995_K) {
            byte type = dataStream.readByte();
            if (type == 0) {
                this.outputType = GasRegistry.getGas((int)dataStream.readInt());
            } else if (type == 1) {
                this.dumpType = GasRegistry.getGas((int)dataStream.readInt());
            }
            return;
        }
        super.handlePacketData(dataStream);
        int type = dataStream.readInt();
        if (type == 0) {
            int amount = dataStream.readInt();
            if (amount != 0) {
                this.waterTank.setFluid(new FluidStack(FluidRegistry.WATER, amount));
            } else {
                this.waterTank.setFluid(null);
            }
            this.oxygenStored = dataStream.readInt();
            this.hydrogenStored = dataStream.readInt();
            this.outputType = GasRegistry.getGas((int)dataStream.readInt());
            this.dumpType = GasRegistry.getGas((int)dataStream.readInt());
        } else if (type == 1) {
            this.spawnParticle();
        }
    }

    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(0);
        if (this.waterTank.getFluid() != null) {
            data.add(this.waterTank.getFluid().amount);
        } else {
            data.add(0);
        }
        data.add(this.oxygenStored);
        data.add(this.hydrogenStored);
        data.add(GasRegistry.getGasID((Gas)this.outputType));
        data.add(GasRegistry.getGasID((Gas)this.dumpType));
        return data;
    }

    public ArrayList getParticlePacket(ArrayList data) {
        super.getNetworkedData(data);
        data.add(1);
        return data;
    }

    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.hydrogenStored = nbtTags.func_74762_e("hydrogenStored");
        this.oxygenStored = nbtTags.func_74762_e("oxygenStored");
        if (nbtTags.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(nbtTags.func_74775_l("waterTank"));
        }
        try {
            this.outputType = Gas.readFromNBT((NBTTagCompound)nbtTags.func_74775_l("outputType"));
            this.dumpType = Gas.readFromNBT((NBTTagCompound)nbtTags.func_74775_l("dumpType"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("hydrogenStored", this.hydrogenStored);
        nbtTags.func_74768_a("oxygenStored", this.oxygenStored);
        if (this.waterTank.getFluid() != null) {
            nbtTags.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.outputType != null) {
            nbtTags.func_74766_a("outputType", this.outputType.write(new NBTTagCompound()));
        }
        if (this.dumpType != null) {
            nbtTags.func_74766_a("dumpType", this.dumpType.write(new NBTTagCompound()));
        }
    }

    public String getType() {
        return this.func_70303_b();
    }

    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getWater", "getWaterNeeded", "getHydrogen", "getHydrogenNeeded", "getOxygen", "getOxygenNeeded"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.waterTank.getFluid() != null ? this.waterTank.getFluid().amount : 0};
            }
            case 5: {
                return new Object[]{this.waterTank.getFluid() != null ? this.waterTank.getCapacity() - this.waterTank.getFluid().amount : 0};
            }
            case 6: {
                return new Object[]{this.hydrogenStored};
            }
            case 7: {
                return new Object[]{this.MAX_GAS - this.hydrogenStored};
            }
            case 8: {
                return new Object[]{this.oxygenStored};
            }
            case 9: {
                return new Object[]{this.MAX_GAS - this.oxygenStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public boolean canTubeConnect(ForgeDirection side) {
        return side == ForgeDirection.getOrientation((int)this.facing);
    }

    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        this.waterTank.setFluid(fluidStack);
    }

    public FluidStack getFluidStack(Object ... data) {
        return this.waterTank.getFluid();
    }

    public boolean hasTank(Object ... data) {
        return true;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.getFluid() == FluidRegistry.WATER) {
            return this.waterTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.waterTank.getInfo()};
    }
}

