/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tileentity;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import java.util.ArrayList;
import mekanism.common.tileentity.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.tileentity.TileEntityGenerator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityHeatGenerator
extends TileEntityGenerator
implements IFluidHandler {
    public FluidTank lavaTank = new FluidTank(24000);

    public TileEntityHeatGenerator() {
        super("HeatGenerator", 160000.0, MekanismGenerators.heatGeneration * 2.0);
        this.inventory = new ItemStack[2];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            ChargeUtils.charge((int)1, (TileEntityElectricBlock)this);
            if (this.inventory[0] != null) {
                FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[0]);
                if (fluid != null && fluid.fluidID == FluidRegistry.LAVA.getID()) {
                    if (this.lavaTank.getFluid() == null || this.lavaTank.getFluid().amount + fluid.amount <= this.lavaTank.getCapacity()) {
                        this.lavaTank.fill(fluid, true);
                        if (this.inventory[0].func_77973_b().getContainerItemStack(this.inventory[0]) != null) {
                            this.inventory[0] = this.inventory[0].func_77973_b().getContainerItemStack(this.inventory[0]);
                        } else {
                            --this.inventory[0].field_77994_a;
                        }
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = null;
                        }
                    }
                } else {
                    int fuelNeeded;
                    int fuel = this.getFuel(this.inventory[0]);
                    if (fuel > 0 && fuel <= (fuelNeeded = this.lavaTank.getCapacity() - (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0))) {
                        this.lavaTank.fill(new FluidStack(FluidRegistry.LAVA, fuel), true);
                        if (this.inventory[0].func_77973_b().getContainerItemStack(this.inventory[0]) != null) {
                            this.inventory[0] = this.inventory[0].func_77973_b().getContainerItemStack(this.inventory[0]);
                        } else {
                            --this.inventory[0].field_77994_a;
                        }
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = null;
                        }
                    }
                }
            }
            this.setEnergy(this.electricityStored + this.getBoost());
            if (this.canOperate()) {
                this.setActive(true);
                this.lavaTank.drain(10, true);
                this.setEnergy(this.electricityStored + MekanismGenerators.heatGeneration);
            } else {
                this.setActive(false);
            }
        }
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return this.getFuel(itemstack) > 0 || FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack) != null && FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack).fluidID == FluidRegistry.LAVA.getID();
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged((ItemStack)itemstack);
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored < this.MAX_ELECTRICITY && this.lavaTank.getFluid() != null && this.lavaTank.getFluid().amount >= 10 && MekanismUtils.canFunction((TileEntity)this);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        if (nbtTags.func_74764_b("lavaTank")) {
            this.lavaTank.readFromNBT(nbtTags.func_74775_l("lavaTank"));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        if (this.lavaTank.getFluid() != null) {
            nbtTags.func_74782_a("lavaTank", (NBTBase)this.lavaTank.writeToNBT(new NBTTagCompound()));
        }
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted((ItemStack)itemstack, (boolean)true);
        }
        if (slotID == 0) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
        }
        return false;
    }

    public double getBoost() {
        int boost = 0;
        if (this.field_70331_k.func_72798_a(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) == 10 || this.field_70331_k.func_72798_a(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) == 11) {
            boost += 5;
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) == 10 || this.field_70331_k.func_72798_a(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) == 11) {
            boost += 5;
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) == 10 || this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) == 11) {
            boost += 5;
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) == 10 || this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) == 11) {
            boost += 5;
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) == 10 || this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) == 11) {
            boost += 5;
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) == 10 || this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) == 11) {
            boost += 5;
        }
        return boost;
    }

    public int getFuel(ItemStack itemstack) {
        if (itemstack.field_77993_c == Item.field_77775_ay.field_77779_bT) {
            return 1000;
        }
        return TileEntityFurnace.func_70398_a((ItemStack)itemstack);
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (ForgeDirection.getOrientation((int)side) == MekanismUtils.getRight((int)this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    public int getScaledFuelLevel(int i) {
        return (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0) * i / this.lavaTank.getCapacity();
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        int amount = dataStream.readInt();
        if (amount != 0) {
            this.lavaTank.setFluid(new FluidStack(FluidRegistry.LAVA, amount));
        } else {
            this.lavaTank.setFluid(null);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.lavaTank.getFluid() != null) {
            data.add(this.lavaTank.getFluid().amount);
        } else {
            data.add(0);
        }
        return data;
    }

    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getFuel", "getFuelNeeded"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0};
            }
            case 5: {
                return new Object[]{this.lavaTank.getCapacity() - (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0)};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.fluidID == FluidRegistry.LAVA.getID() && from != ForgeDirection.getOrientation((int)this.facing)) {
            return this.lavaTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.LAVA;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.lavaTank.getInfo()};
    }
}

