/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tileentity;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import java.util.ArrayList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasAcceptor;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.IGasStorage;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.tileentity.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.tileentity.TileEntityGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityHydrogenGenerator
extends TileEntityGenerator
implements IGasAcceptor,
IGasStorage,
ITubeConnection {
    public int MAX_HYDROGEN = 18000;
    public int hydrogenStored;

    public TileEntityHydrogenGenerator() {
        super("HydrogenGenerator", 40000.0, MekanismGenerators.hydrogenGeneration * 2.0);
        this.inventory = new ItemStack[2];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            ChargeUtils.charge((int)1, (TileEntityElectricBlock)this);
            if (this.inventory[0] != null && this.hydrogenStored < this.MAX_HYDROGEN) {
                GasStack removed = GasTransmission.removeGas((ItemStack)this.inventory[0], (Gas)GasRegistry.getGas((String)"hydrogen"), (int)(this.getMaxGas(new Object[0]) - this.hydrogenStored));
                this.setGas(new GasStack(GasRegistry.getGas((String)"hydrogen"), this.hydrogenStored + (removed != null ? removed.amount : 0)), new Object[0]);
            }
            if (this.canOperate()) {
                this.setActive(true);
                this.hydrogenStored -= 2;
                this.setEnergy(this.electricityStored + MekanismGenerators.hydrogenGeneration);
            } else {
                this.setActive(false);
            }
        }
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted((ItemStack)itemstack, (boolean)true);
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(new Object[]{itemstack}) == null;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(new Object[]{itemstack}) != null && ((IGasItem)itemstack.func_77973_b()).getGas(new Object[]{itemstack}).getGas() == GasRegistry.getGas((String)"hydrogen");
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged((ItemStack)itemstack);
        }
        return true;
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (ForgeDirection.getOrientation((int)side) == MekanismUtils.getRight((int)this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    public GasStack getGas(Object ... data) {
        if (this.hydrogenStored == 0) {
            return null;
        }
        return new GasStack(GasRegistry.getGas((String)"hydrogen"), this.hydrogenStored);
    }

    public void setGas(GasStack stack, Object ... data) {
        if (stack == null) {
            this.hydrogenStored = 0;
        } else if (stack.getGas() == GasRegistry.getGas((String)"hydrogen")) {
            this.hydrogenStored = Math.max(Math.min(stack.amount, this.getMaxGas(new Object[0])), 0);
        }
        MekanismUtils.saveChunk((TileEntity)this);
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored < this.MAX_ELECTRICITY && this.hydrogenStored - 2 >= 0 && MekanismUtils.canFunction((TileEntity)this);
    }

    public int getScaledHydrogenLevel(int i) {
        return this.hydrogenStored * i / this.MAX_HYDROGEN;
    }

    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getHydrogen", "getHydrogenNeeded"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.hydrogenStored};
            }
            case 5: {
                return new Object[]{this.MAX_HYDROGEN - this.hydrogenStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.hydrogenStored = dataStream.readInt();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.hydrogenStored);
        return data;
    }

    public float getVoltage() {
        return 240.0f;
    }

    public int receiveGas(GasStack stack) {
        if (stack.getGas() == GasRegistry.getGas((String)"hydrogen")) {
            int stored = this.getGas(new Object[0]) != null ? this.getGas((Object[])new Object[0]).amount : 0;
            int toUse = Math.min(this.getMaxGas(new Object[0]) - stored, stack.amount);
            this.setGas(new GasStack(stack.getGas(), stored + toUse), new Object[0]);
            return toUse;
        }
        return 0;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.hydrogenStored = nbtTags.func_74762_e("hydrogenStored");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("hydrogenStored", this.hydrogenStored);
    }

    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return type == GasRegistry.getGas((String)"hydrogen") && side != ForgeDirection.getOrientation((int)this.facing);
    }

    public boolean canTubeConnect(ForgeDirection side) {
        return side != ForgeDirection.getOrientation((int)this.facing);
    }

    public int getMaxGas(Object ... data) {
        return this.MAX_HYDROGEN;
    }
}

