/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.nei;

import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.recipe.ShapedRecipeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.machinemuse.numina.recipe.ItemNameMappings;
import net.machinemuse.numina.recipe.JSONRecipe;
import net.machinemuse.numina.recipe.SimpleItemMatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;

public class JSONRecipeHandler
extends ShapedRecipeHandler {
    private static Map<String, ArrayList<ItemStack>> itemMap;

    public String getRecipeName() {
        return "JSON Shaped";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && ((Object)((Object)this)).getClass() == JSONRecipeHandler.class) {
            List allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe irecipe : allrecipes) {
                ShapedRecipeHandler.CachedShapedRecipe recipe = null;
                if (irecipe instanceof JSONRecipe) {
                    recipe = this.JSONShapedRecipe((JSONRecipe)irecipe);
                }
                if (recipe == null) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            ShapedRecipeHandler.CachedShapedRecipe recipe = null;
            if (irecipe instanceof JSONRecipe) {
                recipe = this.JSONShapedRecipe((JSONRecipe)irecipe);
            }
            if (recipe == null) continue;
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            ShapedRecipeHandler.CachedShapedRecipe recipe = null;
            if (irecipe instanceof JSONRecipe) {
                recipe = this.JSONShapedRecipe((JSONRecipe)irecipe);
            }
            if (recipe == null || !recipe.contains((Collection)recipe.ingredients, ingredient.field_77993_c)) continue;
            recipe.computeVisuals();
            if (!recipe.contains((Collection)recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation((Collection)recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public static ArrayList<ItemStack> getItemByUnlocalizedName(String unlocalizedName) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (itemMap == null) {
            if (ItemList.items.isEmpty()) {
                ItemStack stack = ItemNameMappings.getItem(unlocalizedName);
                if (stack != null) {
                    result.add(stack);
                }
            } else {
                itemMap = new HashMap<String, ArrayList<ItemStack>>();
                for (ItemStack stack : ItemList.items) {
                    String key = stack.func_77973_b().func_77667_c(stack);
                    if (!itemMap.containsKey(key)) {
                        itemMap.put(key, new ArrayList());
                    }
                    itemMap.get(key).add(stack);
                }
            }
        }
        if (itemMap != null && itemMap.containsKey(unlocalizedName)) {
            result.addAll((Collection<ItemStack>)itemMap.get(unlocalizedName));
        }
        return result;
    }

    public static List<ItemStack> getIngredient(SimpleItemMatcher cell) {
        ArrayList<ItemStack> t;
        ArrayList<ItemStack> result = null;
        if (cell == null) {
            return null;
        }
        if (cell.oredictName != null) {
            result = OreDictionary.getOres((String)cell.oredictName);
        }
        if (cell.unlocalizedName != null) {
            if (result == null) {
                result = JSONRecipeHandler.getItemByUnlocalizedName(cell.unlocalizedName);
            } else {
                t = new ArrayList<ItemStack>();
                for (ItemStack stack : result) {
                    if (!cell.unlocalizedName.equals(stack.func_77973_b().func_77667_c(stack))) continue;
                    t.add(stack);
                }
                result = t;
            }
        }
        if (cell.id != null) {
            int meta = Short.MAX_VALUE;
            if (cell.meta != null) {
                meta = cell.meta;
            }
            if (result == null) {
                result = new ArrayList();
                result.add(new ItemStack(cell.id, 1, meta));
            } else {
                ArrayList<ItemStack> t2 = new ArrayList<ItemStack>();
                for (ItemStack stack : result) {
                    if (stack.field_77993_c != cell.id || meta != Short.MAX_VALUE && meta != stack.func_77960_j()) continue;
                    t2.add(stack);
                }
                result = t2;
            }
        } else if (cell.meta != null && result != null && cell.meta != Short.MAX_VALUE) {
            t = new ArrayList();
            for (ItemStack stack : result) {
                if (cell.meta.intValue() != stack.func_77960_j()) continue;
                t.add(stack);
            }
            result = t;
        }
        if (cell.nbt != null && result != null) {
            ArrayList<ItemStack> t3 = new ArrayList<ItemStack>();
            for (ItemStack stack : result) {
                ItemStack stack2 = stack.func_77946_l();
                stack2.func_77982_d(cell.nbt);
                t3.add(stack2);
            }
            result = t3;
        }
        return result;
    }

    public ShapedRecipeHandler.CachedShapedRecipe JSONShapedRecipe(JSONRecipe recipe) {
        int height = recipe.ingredients.length;
        int width = recipe.getWidth();
        if (height == 0 || width == 0) {
            return null;
        }
        Object[] items = new Object[height * width];
        for (int y = 0; y < height; ++y) {
            if (recipe.ingredients[y] == null) continue;
            for (int x = 0; x < width; ++x) {
                List<ItemStack> item = recipe.ingredients[y].length > x ? JSONRecipeHandler.getIngredient(recipe.ingredients[y][x]) : null;
                if (item != null && item.isEmpty()) {
                    return null;
                }
                items[y * width + x] = item;
            }
        }
        return new ShapedRecipeHandler.CachedShapedRecipe((ShapedRecipeHandler)this, width, height, items, recipe.func_77571_b());
    }
}

