/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.recipe;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.recipe.JSONRecipe;
import net.minecraft.item.crafting.IRecipe;

public class JSONRecipeList {
    static List<JSONRecipe> recipesList = new ArrayList<JSONRecipe>();
    static final Gson gson = new Gson();
    private static FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".recipe") || name.endsWith(".recipes");
        }
    };

    public static void loadRecipesFromDir(String dir) {
        try {
            File file = new File(dir);
            if (file.exists()) {
                if (file.isDirectory()) {
                    String[] filenames;
                    for (String filename : filenames = file.list(filter)) {
                        String json = JSONRecipeList.readFile(dir + "/" + filename, StandardCharsets.UTF_8);
                        MuseLogger.logDebug("Loading recipes from " + filename);
                        JSONRecipeList.loadRecipesFromString(json);
                    }
                } else {
                    String json = JSONRecipeList.readFile(dir, StandardCharsets.UTF_8);
                    MuseLogger.logDebug("Loading recipes from " + dir);
                    JSONRecipeList.loadRecipesFromString(json);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadRecipesFromResource(URL resource) {
        try {
            String json = Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
            JSONRecipeList.loadRecipesFromString(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadRecipesFromString(String json) {
        JSONRecipe[] newrecipes = (JSONRecipe[])gson.fromJson(json, JSONRecipe[].class);
        recipesList.addAll(Arrays.asList(newrecipes));
        for (JSONRecipe recipe : newrecipes) {
            if (recipe == null) continue;
            GameRegistry.addRecipe((IRecipe)recipe);
        }
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return encoding.decode(ByteBuffer.wrap(encoded)).toString();
    }
}

