/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.recipe;

import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.recipe.IItemMaker;
import net.machinemuse.numina.recipe.ItemNameMappings;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class SimpleItemMaker
implements IItemMaker {
    public Integer id;
    public Integer meta;
    public Integer quantity;
    public String unlocalizedName;
    public String oredictName;
    public NBTTagCompound nbt;

    @Override
    public ItemStack makeItem(InventoryCrafting i) {
        return this.getRecipeOutput();
    }

    private int getOrElse(Integer input, int defaultval) {
        if (input == null) {
            return defaultval;
        }
        return input;
    }

    @Override
    public ItemStack getRecipeOutput() {
        int newmeta = this.getOrElse(this.meta, 0);
        int newquantity = this.getOrElse(this.quantity, 1);
        if (this.id != null) {
            ItemStack stack = new ItemStack(this.id, newquantity, newmeta);
            if (this.nbt != null) {
                stack.field_77990_d = (NBTTagCompound)this.nbt.func_74737_b();
            }
            return stack;
        }
        if (this.oredictName != null) {
            try {
                ItemStack stack = ((ItemStack)OreDictionary.getOres((String)this.oredictName).get(0)).func_77946_l();
                stack.field_77994_a = newquantity;
                return stack;
            }
            catch (Exception e) {
                MuseLogger.logError("Unable to load " + this.oredictName + " from oredict");
                return null;
            }
        }
        if (this.unlocalizedName != null) {
            try {
                ItemStack stack = ItemNameMappings.getItem(this.unlocalizedName);
                stack.func_77964_b(newmeta);
                stack.field_77994_a = newquantity;
                return stack;
            }
            catch (Exception e) {
                MuseLogger.logError("Unable to load " + this.unlocalizedName + " from unlocalized names");
                return null;
            }
        }
        return null;
    }
}

