/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.CallableMPL1;
import net.minecraft.client.multiplayer.CallableMPL2;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.client.multiplayer.NetClientHandler;
import net.minecraft.client.multiplayer.WorldClientINNER3;
import net.minecraft.client.multiplayer.WorldClientINNER4;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFireworkStarterFX;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.SoundUpdaterMinecart;
import net.minecraft.logging.ILogAgent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet255KickDisconnect;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.util.IntHashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveHandlerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.world.WorldEvent;

@SideOnly(value=Side.CLIENT)
public class WorldClient
extends World {
    private NetClientHandler field_73035_a;
    private ChunkProviderClient field_73033_b;
    private IntHashMap field_73034_c = new IntHashMap();
    private Set field_73032_d = new HashSet();
    private Set field_73036_L = new HashSet();
    private final Minecraft field_73037_M = Minecraft.func_71410_x();
    private final Set field_73038_N = new HashSet();

    public WorldClient(NetClientHandler par1NetClientHandler, WorldSettings par2WorldSettings, int par3, int par4, Profiler par5Profiler, ILogAgent par6ILogAgent) {
        super((ISaveHandler)new SaveHandlerMP(), "MpServer", WorldProvider.func_76570_a((int)par3), par2WorldSettings, par5Profiler, par6ILogAgent);
        this.field_73035_a = par1NetClientHandler;
        this.field_73013_u = par4;
        this.field_72988_C = par1NetClientHandler.field_72558_b;
        this.field_72995_K = true;
        this.finishSetup();
        this.func_72950_A(8, 64, 8);
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((World)this));
    }

    @Override
    public void func_72835_b() {
        super.func_72835_b();
        this.func_82738_a(this.func_82737_E() + 1L);
        if (this.func_82736_K().func_82766_b("doDaylightCycle")) {
            this.func_72877_b(this.func_72820_D() + 1L);
        }
        this.field_72984_F.func_76320_a("reEntryProcessing");
        for (int i = 0; i < 10 && !this.field_73036_L.isEmpty(); ++i) {
            Entity entity = (Entity)this.field_73036_L.iterator().next();
            this.field_73036_L.remove(entity);
            if (this.field_72996_f.contains(entity)) continue;
            this.func_72838_d(entity);
        }
        this.field_72984_F.func_76318_c("connection");
        this.field_73035_a.func_72551_d();
        this.field_72984_F.func_76318_c("chunkCache");
        this.field_73033_b.func_73156_b();
        this.field_72984_F.func_76318_c("tiles");
        this.func_72893_g();
        this.field_72984_F.func_76319_b();
    }

    public void func_73031_a(int par1, int par2, int par3, int par4, int par5, int par6) {
    }

    @Override
    protected IChunkProvider func_72970_h() {
        this.field_73033_b = new ChunkProviderClient((World)this);
        return this.field_73033_b;
    }

    @Override
    protected void func_72893_g() {
        super.func_72893_g();
        this.field_73038_N.retainAll(this.field_72993_I);
        if (this.field_73038_N.size() == this.field_72993_I.size()) {
            this.field_73038_N.clear();
        }
        int i = 0;
        for (ChunkCoordIntPair chunkcoordintpair : this.field_72993_I) {
            if (this.field_73038_N.contains(chunkcoordintpair)) continue;
            int j = chunkcoordintpair.field_77276_a * 16;
            int k = chunkcoordintpair.field_77275_b * 16;
            this.field_72984_F.func_76320_a("getChunk");
            Chunk chunk = this.func_72964_e(chunkcoordintpair.field_77276_a, chunkcoordintpair.field_77275_b);
            this.func_72941_a(j, k, chunk);
            this.field_72984_F.func_76319_b();
            this.field_73038_N.add(chunkcoordintpair);
            if (++i < 10) continue;
            return;
        }
    }

    public void func_73025_a(int par1, int par2, boolean par3) {
        if (par3) {
            this.field_73033_b.func_73158_c(par1, par2);
        } else {
            this.field_73033_b.func_73234_b(par1, par2);
        }
        if (!par3) {
            this.func_72909_d(par1 * 16, 0, par2 * 16, par1 * 16 + 15, 256, par2 * 16 + 15);
        }
    }

    @Override
    public boolean func_72838_d(Entity par1Entity) {
        boolean flag = super.func_72838_d(par1Entity);
        this.field_73032_d.add(par1Entity);
        if (!flag) {
            this.field_73036_L.add(par1Entity);
        }
        return flag;
    }

    @Override
    public void func_72900_e(Entity par1Entity) {
        super.func_72900_e(par1Entity);
        this.field_73032_d.remove(par1Entity);
    }

    @Override
    protected void func_72923_a(Entity par1Entity) {
        super.func_72923_a(par1Entity);
        if (this.field_73036_L.contains(par1Entity)) {
            this.field_73036_L.remove(par1Entity);
        }
    }

    @Override
    public void func_72847_b(Entity par1Entity) {
        super.func_72847_b(par1Entity);
        if (this.field_73032_d.contains(par1Entity)) {
            if (par1Entity.func_70089_S()) {
                this.field_73036_L.add(par1Entity);
            } else {
                this.field_73032_d.remove(par1Entity);
            }
        }
    }

    public void func_73027_a(int par1, Entity par2Entity) {
        Entity entity1 = this.func_73045_a(par1);
        if (entity1 != null) {
            this.func_72900_e(entity1);
        }
        this.field_73032_d.add(par2Entity);
        par2Entity.field_70157_k = par1;
        if (!this.func_72838_d(par2Entity)) {
            this.field_73036_L.add(par2Entity);
        }
        this.field_73034_c.func_76038_a(par1, (Object)par2Entity);
    }

    @Override
    public Entity func_73045_a(int par1) {
        return par1 == this.field_73037_M.field_71439_g.field_70157_k ? this.field_73037_M.field_71439_g : (Entity)this.field_73034_c.func_76041_a(par1);
    }

    public Entity func_73028_b(int par1) {
        Entity entity = (Entity)this.field_73034_c.func_76049_d(par1);
        if (entity != null) {
            this.field_73032_d.remove(entity);
            this.func_72900_e(entity);
        }
        return entity;
    }

    public boolean func_73023_g(int par1, int par2, int par3, int par4, int par5) {
        this.func_73031_a(par1, par2, par3, par1, par2, par3);
        return super.func_72832_d(par1, par2, par3, par4, par5, 3);
    }

    @Override
    public void func_72882_A() {
        this.field_73035_a.func_72546_b((Packet)new Packet255KickDisconnect("Quitting"));
    }

    @Override
    public IUpdatePlayerListBox func_82735_a(EntityMinecart par1EntityMinecart) {
        return new SoundUpdaterMinecart(this.field_73037_M.field_71416_A, par1EntityMinecart, (EntityPlayerSP)this.field_73037_M.field_71439_g);
    }

    @Override
    protected void func_72979_l() {
        super.func_72979_l();
    }

    @Override
    public void updateWeatherBody() {
        if (!this.field_73011_w.field_76576_e) {
            this.field_73003_n = this.field_73004_o;
            this.field_73004_o = this.field_72986_A.func_76059_o() ? (float)((double)this.field_73004_o + 0.01) : (float)((double)this.field_73004_o - 0.01);
            if (this.field_73004_o < 0.0f) {
                this.field_73004_o = 0.0f;
            }
            if (this.field_73004_o > 1.0f) {
                this.field_73004_o = 1.0f;
            }
            this.field_73018_p = this.field_73017_q;
            this.field_73017_q = this.field_72986_A.func_76061_m() ? (float)((double)this.field_73017_q + 0.01) : (float)((double)this.field_73017_q - 0.01);
            if (this.field_73017_q < 0.0f) {
                this.field_73017_q = 0.0f;
            }
            if (this.field_73017_q > 1.0f) {
                this.field_73017_q = 1.0f;
            }
        }
    }

    public void func_73029_E(int par1, int par2, int par3) {
        int b0 = 16;
        Random random = new Random();
        for (int l = 0; l < 1000; ++l) {
            int k1;
            int j1;
            int i1 = par1 + this.field_73012_v.nextInt(b0) - this.field_73012_v.nextInt(b0);
            int l1 = this.func_72798_a(i1, j1 = par2 + this.field_73012_v.nextInt(b0) - this.field_73012_v.nextInt(b0), k1 = par3 + this.field_73012_v.nextInt(b0) - this.field_73012_v.nextInt(b0));
            if (l1 == 0 && this.field_73012_v.nextInt(8) > j1 && this.field_73011_w.func_76564_j()) {
                this.func_72869_a("depthsuspend", (float)i1 + this.field_73012_v.nextFloat(), (float)j1 + this.field_73012_v.nextFloat(), (float)k1 + this.field_73012_v.nextFloat(), 0.0, 0.0, 0.0);
                continue;
            }
            if (l1 <= 0) continue;
            Block.field_71973_m[l1].func_71862_a((World)this, i1, j1, k1, random);
        }
    }

    public void func_73022_a() {
        int k;
        int j;
        Entity entity;
        int i;
        this.field_72996_f.removeAll(this.field_72997_g);
        for (i = 0; i < this.field_72997_g.size(); ++i) {
            entity = (Entity)this.field_72997_g.get(i);
            j = entity.field_70176_ah;
            k = entity.field_70164_aj;
            if (!entity.field_70175_ag || !this.func_72916_c(j, k)) continue;
            this.func_72964_e(j, k).func_76622_b(entity);
        }
        for (i = 0; i < this.field_72997_g.size(); ++i) {
            this.func_72847_b((Entity)this.field_72997_g.get(i));
        }
        this.field_72997_g.clear();
        for (i = 0; i < this.field_72996_f.size(); ++i) {
            entity = (Entity)this.field_72996_f.get(i);
            if (entity.field_70154_o != null) {
                if (!entity.field_70154_o.field_70128_L && entity.field_70154_o.field_70153_n == entity) continue;
                entity.field_70154_o.field_70153_n = null;
                entity.field_70154_o = null;
            }
            if (!entity.field_70128_L) continue;
            j = entity.field_70176_ah;
            k = entity.field_70164_aj;
            if (entity.field_70175_ag && this.func_72916_c(j, k)) {
                this.func_72964_e(j, k).func_76622_b(entity);
            }
            this.field_72996_f.remove(i--);
            this.func_72847_b(entity);
        }
    }

    @Override
    public CrashReportCategory func_72914_a(CrashReport par1CrashReport) {
        CrashReportCategory crashreportcategory = super.func_72914_a(par1CrashReport);
        crashreportcategory.func_71500_a("Forced entities", (Callable)new CallableMPL1(this));
        crashreportcategory.func_71500_a("Retry entities", (Callable)new CallableMPL2(this));
        crashreportcategory.func_71500_a("Server brand", new WorldClientINNER3(this));
        crashreportcategory.func_71500_a("Server type", new WorldClientINNER4(this));
        return crashreportcategory;
    }

    @Override
    public void func_72980_b(double par1, double par3, double par5, String par7Str, float par8, float par9, boolean par10) {
        double d3;
        float f2 = 16.0f;
        if (par8 > 1.0f) {
            f2 *= par8;
        }
        if ((d3 = this.field_73037_M.field_71451_h.func_70092_e(par1, par3, par5)) < (double)(f2 * f2)) {
            if (par10 && d3 > 100.0) {
                double d4 = Math.sqrt(d3) / 40.0;
                this.field_73037_M.field_71416_A.func_92070_a(par7Str, (float)par1, (float)par3, (float)par5, par8, par9, (int)Math.round(d4 * 20.0));
            } else {
                this.field_73037_M.field_71416_A.func_77364_b(par7Str, (float)par1, (float)par3, (float)par5, par8, par9);
            }
        }
    }

    @Override
    public void func_92088_a(double par1, double par3, double par5, double par7, double par9, double par11, NBTTagCompound par13NBTTagCompound) {
        this.field_73037_M.field_71452_i.func_78873_a((EntityFX)new EntityFireworkStarterFX((World)this, par1, par3, par5, par7, par9, par11, this.field_73037_M.field_71452_i, par13NBTTagCompound));
    }

    public void func_96443_a(Scoreboard par1Scoreboard) {
        this.field_96442_D = par1Scoreboard;
    }

    @Override
    public void func_72877_b(long par1) {
        if (par1 < 0L) {
            par1 = -par1;
            this.func_82736_K().func_82764_b("doDaylightCycle", "false");
        } else {
            this.func_82736_K().func_82764_b("doDaylightCycle", "true");
        }
        super.func_72877_b(par1);
    }

    static Set func_73026_a(WorldClient par0WorldClient) {
        return par0WorldClient.field_73032_d;
    }

    static Set func_73030_b(WorldClient par0WorldClient) {
        return par0WorldClient.field_73036_L;
    }

    static Minecraft func_142030_c(WorldClient par0WorldClient) {
        return par0WorldClient.field_73037_M;
    }
}

