/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public final class ItemStack {
    public static final DecimalFormat field_111284_a = new DecimalFormat("#.###");
    public int field_77994_a;
    public int field_77992_b;
    public int field_77993_c;
    public NBTTagCompound field_77990_d;
    int field_77991_e;
    private EntityItemFrame field_82843_f;

    public ItemStack(Block par1Block) {
        this(par1Block, 1);
    }

    public ItemStack(Block par1Block, int par2) {
        this(par1Block.field_71990_ca, par2, 0);
    }

    public ItemStack(Block par1Block, int par2, int par3) {
        this(par1Block.field_71990_ca, par2, par3);
    }

    public ItemStack(Item par1Item) {
        this(par1Item.field_77779_bT, 1, 0);
    }

    public ItemStack(Item par1Item, int par2) {
        this(par1Item.field_77779_bT, par2, 0);
    }

    public ItemStack(Item par1Item, int par2, int par3) {
        this(par1Item.field_77779_bT, par2, par3);
    }

    public ItemStack(int par1, int par2, int par3) {
        this.field_77993_c = par1;
        this.field_77994_a = par2;
        this.field_77991_e = par3;
        if (this.field_77991_e < 0) {
            this.field_77991_e = 0;
        }
    }

    public static ItemStack func_77949_a(NBTTagCompound par0NBTTagCompound) {
        ItemStack itemstack = new ItemStack();
        itemstack.func_77963_c(par0NBTTagCompound);
        return itemstack.func_77973_b() != null ? itemstack : null;
    }

    private ItemStack() {
    }

    public ItemStack func_77979_a(int par1) {
        ItemStack itemstack = new ItemStack(this.field_77993_c, par1, this.field_77991_e);
        if (this.field_77990_d != null) {
            itemstack.field_77990_d = (NBTTagCompound)this.field_77990_d.func_74737_b();
        }
        this.field_77994_a -= par1;
        return itemstack;
    }

    public Item func_77973_b() {
        return Item.field_77698_e[this.field_77993_c];
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77954_c() {
        return this.func_77973_b().func_77650_f(this);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94608_d() {
        return this.func_77973_b().func_94901_k();
    }

    public boolean func_77943_a(EntityPlayer par1EntityPlayer, World par2World, int par3, int par4, int par5, int par6, float par7, float par8, float par9) {
        boolean flag = this.func_77973_b().func_77648_a(this, par1EntityPlayer, par2World, par3, par4, par5, par6, par7, par8, par9);
        if (flag) {
            par1EntityPlayer.func_71064_a(StatList.field_75929_E[this.field_77993_c], 1);
        }
        return flag;
    }

    public float func_77967_a(Block par1Block) {
        return this.func_77973_b().func_77638_a(this, par1Block);
    }

    public ItemStack func_77957_a(World par1World, EntityPlayer par2EntityPlayer) {
        return this.func_77973_b().func_77659_a(this, par1World, par2EntityPlayer);
    }

    public ItemStack func_77950_b(World par1World, EntityPlayer par2EntityPlayer) {
        return this.func_77973_b().func_77654_b(this, par1World, par2EntityPlayer);
    }

    public NBTTagCompound func_77955_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74777_a("id", (short)this.field_77993_c);
        par1NBTTagCompound.func_74774_a("Count", (byte)this.field_77994_a);
        par1NBTTagCompound.func_74777_a("Damage", (short)this.field_77991_e);
        if (this.field_77990_d != null) {
            par1NBTTagCompound.func_74782_a("tag", (NBTBase)this.field_77990_d);
        }
        return par1NBTTagCompound;
    }

    public void func_77963_c(NBTTagCompound par1NBTTagCompound) {
        this.field_77993_c = par1NBTTagCompound.func_74765_d("id");
        this.field_77994_a = par1NBTTagCompound.func_74771_c("Count");
        this.field_77991_e = par1NBTTagCompound.func_74765_d("Damage");
        if (this.field_77991_e < 0) {
            this.field_77991_e = 0;
        }
        if (par1NBTTagCompound.func_74764_b("tag")) {
            this.field_77990_d = par1NBTTagCompound.func_74775_l("tag");
        }
    }

    public int func_77976_d() {
        return this.func_77973_b().func_77639_j();
    }

    public boolean func_77985_e() {
        return this.func_77976_d() > 1 && (!this.func_77984_f() || !this.func_77951_h());
    }

    public boolean func_77984_f() {
        return Item.field_77698_e[this.field_77993_c].func_77612_l() > 0;
    }

    public boolean func_77981_g() {
        return Item.field_77698_e[this.field_77993_c].func_77614_k();
    }

    public boolean func_77951_h() {
        boolean damaged;
        boolean bl = damaged = this.field_77991_e > 0;
        if (this.func_77973_b() != null) {
            damaged = this.func_77973_b().isDamaged(this);
        }
        return this.func_77984_f() && damaged;
    }

    public int func_77952_i() {
        if (this.func_77973_b() != null) {
            return this.func_77973_b().getDisplayDamage(this);
        }
        return this.field_77991_e;
    }

    public int func_77960_j() {
        if (this.func_77973_b() != null) {
            return this.func_77973_b().getDamage(this);
        }
        return this.field_77991_e;
    }

    public void func_77964_b(int par1) {
        if (this.func_77973_b() != null) {
            this.func_77973_b().setDamage(this, par1);
            return;
        }
        this.field_77991_e = par1;
        if (this.field_77991_e < 0) {
            this.field_77991_e = 0;
        }
    }

    public int func_77958_k() {
        return this.func_77973_b().getMaxDamage(this);
    }

    public boolean func_96631_a(int par1, Random par2Random) {
        if (!this.func_77984_f()) {
            return false;
        }
        if (par1 > 0) {
            int j = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)this);
            int k = 0;
            for (int l = 0; j > 0 && l < par1; ++l) {
                if (!EnchantmentDurability.func_92097_a((ItemStack)this, (int)j, (Random)par2Random)) continue;
                ++k;
            }
            if ((par1 -= k) <= 0) {
                return false;
            }
        }
        this.func_77964_b(this.func_77960_j() + par1);
        return this.func_77960_j() > this.func_77958_k();
    }

    public void func_77972_a(int par1, EntityLivingBase par2EntityLivingBase) {
        if ((!(par2EntityLivingBase instanceof EntityPlayer) || !((EntityPlayer)par2EntityLivingBase).field_71075_bZ.field_75098_d) && this.func_77984_f() && this.func_96631_a(par1, par2EntityLivingBase.func_70681_au())) {
            par2EntityLivingBase.func_70669_a(this);
            --this.field_77994_a;
            if (par2EntityLivingBase instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)par2EntityLivingBase;
                entityplayer.func_71064_a(StatList.field_75930_F[this.field_77993_c], 1);
                if (this.field_77994_a == 0 && this.func_77973_b() instanceof ItemBow) {
                    entityplayer.func_71028_bD();
                }
            }
            if (this.field_77994_a < 0) {
                this.field_77994_a = 0;
            }
            this.field_77991_e = 0;
        }
    }

    public void func_77961_a(EntityLivingBase par1EntityLivingBase, EntityPlayer par2EntityPlayer) {
        boolean flag = Item.field_77698_e[this.field_77993_c].func_77644_a(this, par1EntityLivingBase, (EntityLivingBase)par2EntityPlayer);
        if (flag) {
            par2EntityPlayer.func_71064_a(StatList.field_75929_E[this.field_77993_c], 1);
        }
    }

    public void func_77941_a(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
        boolean flag = Item.field_77698_e[this.field_77993_c].func_77660_a(this, par1World, par2, par3, par4, par5, (EntityLivingBase)par6EntityPlayer);
        if (flag) {
            par6EntityPlayer.func_71064_a(StatList.field_75929_E[this.field_77993_c], 1);
        }
    }

    public boolean func_77987_b(Block par1Block) {
        return Item.field_77698_e[this.field_77993_c].canHarvestBlock(par1Block, this);
    }

    public boolean func_111282_a(EntityPlayer par1EntityPlayer, EntityLivingBase par2EntityLivingBase) {
        return Item.field_77698_e[this.field_77993_c].func_111207_a(this, par1EntityPlayer, par2EntityLivingBase);
    }

    public ItemStack func_77946_l() {
        ItemStack itemstack = new ItemStack(this.field_77993_c, this.field_77994_a, this.field_77991_e);
        if (this.field_77990_d != null) {
            itemstack.field_77990_d = (NBTTagCompound)this.field_77990_d.func_74737_b();
        }
        return itemstack;
    }

    public static boolean func_77970_a(ItemStack par0ItemStack, ItemStack par1ItemStack) {
        return par0ItemStack == null && par1ItemStack == null ? true : (par0ItemStack != null && par1ItemStack != null ? (par0ItemStack.field_77990_d == null && par1ItemStack.field_77990_d != null ? false : par0ItemStack.field_77990_d == null || par0ItemStack.field_77990_d.equals((Object)par1ItemStack.field_77990_d)) : false);
    }

    public static boolean func_77989_b(ItemStack par0ItemStack, ItemStack par1ItemStack) {
        return par0ItemStack == null && par1ItemStack == null ? true : (par0ItemStack != null && par1ItemStack != null ? par0ItemStack.func_77959_d(par1ItemStack) : false);
    }

    private boolean func_77959_d(ItemStack par1ItemStack) {
        return this.field_77994_a != par1ItemStack.field_77994_a ? false : (this.field_77993_c != par1ItemStack.field_77993_c ? false : (this.field_77991_e != par1ItemStack.field_77991_e ? false : (this.field_77990_d == null && par1ItemStack.field_77990_d != null ? false : this.field_77990_d == null || this.field_77990_d.equals((Object)par1ItemStack.field_77990_d))));
    }

    public boolean func_77969_a(ItemStack par1ItemStack) {
        return this.field_77993_c == par1ItemStack.field_77993_c && this.field_77991_e == par1ItemStack.field_77991_e;
    }

    public String func_77977_a() {
        return Item.field_77698_e[this.field_77993_c].func_77667_c(this);
    }

    public static ItemStack func_77944_b(ItemStack par0ItemStack) {
        return par0ItemStack == null ? null : par0ItemStack.func_77946_l();
    }

    public String toString() {
        return this.field_77994_a + "x" + Item.field_77698_e[this.field_77993_c].func_77658_a() + "@" + this.field_77991_e;
    }

    public void func_77945_a(World par1World, Entity par2Entity, int par3, boolean par4) {
        if (this.field_77992_b > 0) {
            --this.field_77992_b;
        }
        Item.field_77698_e[this.field_77993_c].func_77663_a(this, par1World, par2Entity, par3, par4);
    }

    public void func_77980_a(World par1World, EntityPlayer par2EntityPlayer, int par3) {
        par2EntityPlayer.func_71064_a(StatList.field_75928_D[this.field_77993_c], par3);
        Item.field_77698_e[this.field_77993_c].func_77622_d(this, par1World, par2EntityPlayer);
    }

    public int func_77988_m() {
        return this.func_77973_b().func_77626_a(this);
    }

    public EnumAction func_77975_n() {
        return this.func_77973_b().func_77661_b(this);
    }

    public void func_77974_b(World par1World, EntityPlayer par2EntityPlayer, int par3) {
        this.func_77973_b().func_77615_a(this, par1World, par2EntityPlayer, par3);
    }

    public boolean func_77942_o() {
        return this.field_77990_d != null;
    }

    public NBTTagCompound func_77978_p() {
        return this.field_77990_d;
    }

    public NBTTagList func_77986_q() {
        return this.field_77990_d == null ? null : (NBTTagList)this.field_77990_d.func_74781_a("ench");
    }

    public void func_77982_d(NBTTagCompound par1NBTTagCompound) {
        this.field_77990_d = par1NBTTagCompound;
    }

    public String func_82833_r() {
        NBTTagCompound nbttagcompound;
        String s = this.func_77973_b().func_77628_j(this);
        if (this.field_77990_d != null && this.field_77990_d.func_74764_b("display") && (nbttagcompound = this.field_77990_d.func_74775_l("display")).func_74764_b("Name")) {
            s = nbttagcompound.func_74779_i("Name");
        }
        return s;
    }

    public void func_82834_c(String par1Str) {
        if (this.field_77990_d == null) {
            this.field_77990_d = new NBTTagCompound("tag");
        }
        if (!this.field_77990_d.func_74764_b("display")) {
            this.field_77990_d.func_74766_a("display", new NBTTagCompound());
        }
        this.field_77990_d.func_74775_l("display").func_74778_a("Name", par1Str);
    }

    public void func_135074_t() {
        if (this.field_77990_d != null && this.field_77990_d.func_74764_b("display")) {
            NBTTagCompound nbttagcompound = this.field_77990_d.func_74775_l("display");
            nbttagcompound.func_82580_o("Name");
            if (nbttagcompound.func_82582_d()) {
                this.field_77990_d.func_82580_o("display");
                if (this.field_77990_d.func_82582_d()) {
                    this.func_77982_d(null);
                }
            }
        }
    }

    public boolean func_82837_s() {
        return this.field_77990_d == null ? false : (!this.field_77990_d.func_74764_b("display") ? false : this.field_77990_d.func_74775_l("display").func_74764_b("Name"));
    }

    @SideOnly(value=Side.CLIENT)
    public List func_82840_a(EntityPlayer par1EntityPlayer, boolean par2) {
        Multimap multimap;
        ArrayList<String> arraylist = new ArrayList<String>();
        Item item = Item.field_77698_e[this.field_77993_c];
        String s = this.func_82833_r();
        if (this.func_82837_s()) {
            s = EnumChatFormatting.ITALIC + s + EnumChatFormatting.RESET;
        }
        if (par2) {
            String s1 = "";
            if (s.length() > 0) {
                s = s + " (";
                s1 = ")";
            }
            s = this.func_77981_g() ? s + String.format("#%04d/%d%s", this.field_77993_c, this.field_77991_e, s1) : s + String.format("#%04d%s", this.field_77993_c, s1);
        } else if (!this.func_82837_s() && this.field_77993_c == Item.field_77744_bd.field_77779_bT) {
            s = s + " #" + this.field_77991_e;
        }
        arraylist.add(s);
        item.func_77624_a(this, par1EntityPlayer, arraylist, par2);
        if (this.func_77942_o()) {
            NBTTagList nbttaglist = this.func_77986_q();
            if (nbttaglist != null) {
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    short short1 = ((NBTTagCompound)nbttaglist.func_74743_b(i)).func_74765_d("id");
                    short short2 = ((NBTTagCompound)nbttaglist.func_74743_b(i)).func_74765_d("lvl");
                    if (Enchantment.field_77331_b[short1] == null) continue;
                    arraylist.add(Enchantment.field_77331_b[short1].func_77316_c((int)short2));
                }
            }
            if (this.field_77990_d.func_74764_b("display")) {
                NBTTagList nbttaglist1;
                NBTTagCompound nbttagcompound = this.field_77990_d.func_74775_l("display");
                if (nbttagcompound.func_74764_b("color")) {
                    if (par2) {
                        arraylist.add("Color: #" + Integer.toHexString(nbttagcompound.func_74762_e("color")).toUpperCase());
                    } else {
                        arraylist.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"item.dyed"));
                    }
                }
                if (nbttagcompound.func_74764_b("Lore") && (nbttaglist1 = nbttagcompound.func_74761_m("Lore")).func_74745_c() > 0) {
                    for (int j = 0; j < nbttaglist1.func_74745_c(); ++j) {
                        arraylist.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + ((NBTTagString)nbttaglist1.func_74743_b((int)j)).field_74751_a);
                    }
                }
            }
        }
        if (!(multimap = this.func_111283_C()).isEmpty()) {
            arraylist.add("");
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                double d0 = attributemodifier.func_111164_d();
                double d1 = attributemodifier.func_111169_c() != 1 && attributemodifier.func_111169_c() != 2 ? attributemodifier.func_111164_d() : attributemodifier.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    arraylist.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)("attribute.modifier.plus." + attributemodifier.func_111169_c()), (Object[])new Object[]{field_111284_a.format(d1), StatCollector.func_74838_a((String)("attribute.name." + (String)entry.getKey()))}));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                arraylist.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)("attribute.modifier.take." + attributemodifier.func_111169_c()), (Object[])new Object[]{field_111284_a.format(d1 *= -1.0), StatCollector.func_74838_a((String)("attribute.name." + (String)entry.getKey()))}));
            }
        }
        if (par2 && this.func_77951_h()) {
            arraylist.add("Durability: " + (this.func_77958_k() - this.func_77952_i()) + " / " + this.func_77958_k());
        }
        return arraylist;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_77962_s() {
        return this.hasEffect(0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(int pass) {
        return this.func_77973_b().hasEffect(this, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77953_t() {
        return this.func_77973_b().func_77613_e(this);
    }

    public boolean func_77956_u() {
        return !this.func_77973_b().func_77616_k(this) ? false : !this.func_77948_v();
    }

    public void func_77966_a(Enchantment par1Enchantment, int par2) {
        if (this.field_77990_d == null) {
            this.func_77982_d(new NBTTagCompound());
        }
        if (!this.field_77990_d.func_74764_b("ench")) {
            this.field_77990_d.func_74782_a("ench", (NBTBase)new NBTTagList("ench"));
        }
        NBTTagList nbttaglist = (NBTTagList)this.field_77990_d.func_74781_a("ench");
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74777_a("id", (short)par1Enchantment.field_77352_x);
        nbttagcompound.func_74777_a("lvl", (short)((byte)par2));
        nbttaglist.func_74742_a((NBTBase)nbttagcompound);
    }

    public boolean func_77948_v() {
        return this.field_77990_d != null && this.field_77990_d.func_74764_b("ench");
    }

    public void func_77983_a(String par1Str, NBTBase par2NBTBase) {
        if (this.field_77990_d == null) {
            this.func_77982_d(new NBTTagCompound());
        }
        this.field_77990_d.func_74782_a(par1Str, par2NBTBase);
    }

    public boolean func_82835_x() {
        return this.func_77973_b().func_82788_x();
    }

    public boolean func_82839_y() {
        return this.field_82843_f != null;
    }

    public void func_82842_a(EntityItemFrame par1EntityItemFrame) {
        this.field_82843_f = par1EntityItemFrame;
    }

    public EntityItemFrame func_82836_z() {
        return this.field_82843_f;
    }

    public int func_82838_A() {
        return this.func_77942_o() && this.field_77990_d.func_74764_b("RepairCost") ? this.field_77990_d.func_74762_e("RepairCost") : 0;
    }

    public void func_82841_c(int par1) {
        if (!this.func_77942_o()) {
            this.field_77990_d = new NBTTagCompound("tag");
        }
        this.field_77990_d.func_74768_a("RepairCost", par1);
    }

    public Multimap func_111283_C() {
        Multimap object;
        if (this.func_77942_o() && this.field_77990_d.func_74764_b("AttributeModifiers")) {
            object = HashMultimap.create();
            NBTTagList nbttaglist = this.field_77990_d.func_74761_m("AttributeModifiers");
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = (NBTTagCompound)nbttaglist.func_74743_b(i);
                AttributeModifier attributemodifier = SharedMonsterAttributes.func_111259_a(nbttagcompound);
                if (attributemodifier.func_111167_a().getLeastSignificantBits() == 0L || attributemodifier.func_111167_a().getMostSignificantBits() == 0L) continue;
                object.put((Object)nbttagcompound.func_74779_i("AttributeName"), (Object)attributemodifier);
            }
        } else {
            object = this.func_77973_b().func_111205_h();
        }
        return object;
    }
}

