/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.dispenser.DispenserBehaviors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.logging.ILogAgent;
import net.minecraft.network.NetworkListenThread;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet4UpdateTime;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.profiler.IPlayerUsage;
import net.minecraft.profiler.PlayerUsageSnooper;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.CallableIsServerModded;
import net.minecraft.server.CallableServerMemoryStats;
import net.minecraft.server.CallableServerProfiler;
import net.minecraft.server.ConvertingProgressUpdate;
import net.minecraft.server.ThreadDedicatedServer;
import net.minecraft.server.ThreadMinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.world.EnumGameType;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldManager;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraft.world.demo.DemoWorldServer;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.world.WorldEvent;

public abstract class MinecraftServer
implements ICommandSender,
Runnable,
IPlayerUsage {
    private static MinecraftServer field_71309_l;
    private final ISaveFormat field_71310_m;
    private final PlayerUsageSnooper field_71307_n = new PlayerUsageSnooper("server", this, MinecraftServer.func_130071_aq());
    private final File field_71308_o;
    private final List field_71322_p = new ArrayList();
    private final ICommandManager field_71321_q;
    public final Profiler field_71304_b = new Profiler();
    private String field_71320_r;
    private int field_71319_s = -1;
    public WorldServer[] field_71305_c = new WorldServer[0];
    private ServerConfigurationManager field_71318_t;
    private boolean field_71317_u = true;
    private boolean field_71316_v;
    private int field_71315_w;
    protected Proxy field_110456_c;
    public String field_71302_d;
    public int field_71303_e;
    private boolean field_71325_x;
    private boolean field_71324_y;
    private boolean field_71323_z;
    private boolean field_71284_A;
    private boolean field_71285_B;
    private String field_71286_C;
    private int field_71280_D;
    private long field_71281_E;
    private long field_71282_F;
    private long field_71283_G;
    private long field_71291_H;
    public final long[] field_71300_f;
    public final long[] field_71301_g;
    public final long[] field_71313_h;
    public final long[] field_71314_i;
    public final long[] field_71311_j;
    public Hashtable<Integer, long[]> worldTickTimes = new Hashtable();
    private KeyPair field_71292_I;
    private String field_71293_J;
    private String field_71294_K;
    @SideOnly(value=Side.CLIENT)
    private String field_71287_L;
    private boolean field_71288_M;
    private boolean field_71289_N;
    private boolean field_71290_O;
    private String field_71297_P = "";
    private boolean field_71296_Q;
    private long field_71299_R;
    private String field_71298_S;
    private boolean field_71295_T;
    private boolean field_104057_T;

    public MinecraftServer(File par1File) {
        this.field_110456_c = Proxy.NO_PROXY;
        this.field_71300_f = new long[100];
        this.field_71301_g = new long[100];
        this.field_71313_h = new long[100];
        this.field_71314_i = new long[100];
        this.field_71311_j = new long[100];
        field_71309_l = this;
        this.field_71308_o = par1File;
        this.field_71321_q = new ServerCommandManager();
        this.field_71310_m = new AnvilSaveConverter(par1File);
        this.func_82355_al();
    }

    private void func_82355_al() {
        DispenserBehaviors.func_96467_a();
    }

    protected abstract boolean func_71197_b() throws IOException;

    protected void func_71237_c(String par1Str) {
        if (this.func_71254_M().func_75801_b(par1Str)) {
            this.func_98033_al().func_98233_a("Converting map!");
            this.func_71192_d("menu.convertingLevel");
            this.func_71254_M().func_75805_a(par1Str, (IProgressUpdate)new ConvertingProgressUpdate(this));
        }
    }

    protected synchronized void func_71192_d(String par1Str) {
        this.field_71298_S = par1Str;
    }

    @SideOnly(value=Side.CLIENT)
    public synchronized String func_71195_b_() {
        return this.field_71298_S;
    }

    protected void func_71247_a(String par1Str, String par2Str, long par3, WorldType par5WorldType, String par6Str) {
        WorldSettings worldsettings;
        this.func_71237_c(par1Str);
        this.func_71192_d("menu.loadingLevel");
        ISaveHandler isavehandler = this.field_71310_m.func_75804_a(par1Str, true);
        WorldInfo worldinfo = isavehandler.func_75757_d();
        if (worldinfo == null) {
            worldsettings = new WorldSettings(par3, this.func_71265_f(), this.func_71225_e(), this.func_71199_h(), par5WorldType);
            worldsettings.func_82750_a(par6Str);
        } else {
            worldsettings = new WorldSettings(worldinfo);
        }
        if (this.field_71289_N) {
            worldsettings.func_77159_a();
        }
        DemoWorldServer overWorld = this.func_71242_L() ? new DemoWorldServer(this, isavehandler, par2Str, 0, this.field_71304_b, this.func_98033_al()) : new WorldServer(this, isavehandler, par2Str, 0, worldsettings, this.field_71304_b, this.func_98033_al());
        Integer[] arr$ = DimensionManager.getStaticDimensionIDs();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int dim = arr$[i$];
            DemoWorldServer world = dim == 0 ? overWorld : new WorldServerMulti(this, isavehandler, par2Str, dim, worldsettings, (WorldServer)overWorld, this.field_71304_b, this.func_98033_al());
            world.func_72954_a((IWorldAccess)new WorldManager(this, (WorldServer)world));
            if (!this.func_71264_H()) {
                world.func_72912_H().func_76060_a(this.func_71265_f());
            }
            this.field_71318_t.func_72364_a(this.field_71305_c);
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((World)world));
        }
        this.field_71318_t.func_72364_a(new WorldServer[]{overWorld});
        this.func_71226_c(this.func_71232_g());
        this.func_71222_d();
    }

    protected void func_71222_d() {
        boolean flag = true;
        boolean flag1 = true;
        boolean flag2 = true;
        boolean flag3 = true;
        int i = 0;
        this.func_71192_d("menu.generatingTerrain");
        int b0 = 0;
        this.func_98033_al().func_98233_a("Preparing start region for level " + b0);
        WorldServer worldserver = this.field_71305_c[b0];
        ChunkCoordinates chunkcoordinates = worldserver.func_72861_E();
        long j = MinecraftServer.func_130071_aq();
        for (int k = -192; k <= 192 && this.func_71278_l(); k += 16) {
            for (int l = -192; l <= 192 && this.func_71278_l(); l += 16) {
                long i1 = MinecraftServer.func_130071_aq();
                if (i1 - j > 1000L) {
                    this.func_71216_a_("Preparing spawn area", i * 100 / 625);
                    j = i1;
                }
                ++i;
                worldserver.field_73059_b.func_73158_c(chunkcoordinates.field_71574_a + k >> 4, chunkcoordinates.field_71573_c + l >> 4);
            }
        }
        this.func_71243_i();
    }

    public abstract boolean func_71225_e();

    public abstract EnumGameType func_71265_f();

    public abstract int func_71232_g();

    public abstract boolean func_71199_h();

    public abstract int func_110455_j();

    protected void func_71216_a_(String par1Str, int par2) {
        this.field_71302_d = par1Str;
        this.field_71303_e = par2;
        this.func_98033_al().func_98233_a(par1Str + ": " + par2 + "%");
    }

    protected void func_71243_i() {
        this.field_71302_d = null;
        this.field_71303_e = 0;
    }

    protected void func_71267_a(boolean par1) {
        if (!this.field_71290_O) {
            WorldServer[] aworldserver = this.field_71305_c;
            if (aworldserver == null) {
                return;
            }
            for (WorldServer worldserver : aworldserver) {
                if (worldserver == null) continue;
                if (!par1) {
                    this.func_98033_al().func_98233_a("Saving chunks for level '" + worldserver.func_72912_H().func_76065_j() + "'/" + worldserver.field_73011_w.func_80007_l());
                }
                try {
                    worldserver.func_73044_a(true, (IProgressUpdate)null);
                }
                catch (MinecraftException minecraftexception) {
                    this.func_98033_al().func_98236_b(minecraftexception.getMessage());
                }
            }
        }
    }

    public void func_71260_j() {
        if (!this.field_71290_O) {
            WorldServer[] tmp;
            this.func_98033_al().func_98233_a("Stopping server");
            if (this.func_71212_ac() != null) {
                this.func_71212_ac().func_71744_a();
            }
            if (this.field_71318_t != null) {
                this.func_98033_al().func_98233_a("Saving players");
                this.field_71318_t.func_72389_g();
                this.field_71318_t.func_72392_r();
            }
            this.func_98033_al().func_98233_a("Saving worlds");
            this.func_71267_a(false);
            for (int i = 0; i < this.field_71305_c.length; ++i) {
                WorldServer worldserver = this.field_71305_c[i];
                MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((World)worldserver));
                worldserver.func_73041_k();
            }
            for (WorldServer world : tmp = this.field_71305_c) {
                DimensionManager.setWorld((int)world.field_73011_w.field_76574_g, null);
            }
            if (this.field_71307_n != null && this.field_71307_n.func_76468_d()) {
                this.field_71307_n.func_76470_e();
            }
        }
    }

    public String func_71211_k() {
        return this.field_71320_r;
    }

    public void func_71189_e(String par1Str) {
        this.field_71320_r = par1Str;
    }

    public boolean func_71278_l() {
        return this.field_71317_u;
    }

    public void func_71263_m() {
        this.field_71317_u = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long j;
        long i;
        try {
            if (!this.func_71197_b()) {
                this.func_71228_a(null);
                return;
            }
            FMLCommonHandler.instance().handleServerStarted();
            i = MinecraftServer.func_130071_aq();
            FMLCommonHandler.instance().onWorldLoadTick((World[])this.field_71305_c);
            j = 0L;
        }
        catch (Throwable throwable) {
            if (FMLCommonHandler.instance().shouldServerBeKilledQuietly()) {
                return;
            }
            throwable.printStackTrace();
            this.func_98033_al().func_98234_c("Encountered an unexpected exception " + throwable.getClass().getSimpleName(), throwable);
            CrashReport crashreport = null;
            crashreport = throwable instanceof ReportedException ? this.func_71230_b(((ReportedException)throwable).func_71575_a()) : this.func_71230_b(new CrashReport("Exception in server tick loop", throwable));
            File file1 = new File(new File(this.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.func_71508_a(file1, this.func_98033_al())) {
                this.func_98033_al().func_98232_c("This crash report has been saved to: " + file1.getAbsolutePath());
            } else {
                this.func_98033_al().func_98232_c("We were unable to save this crash report to disk.");
            }
            this.func_71228_a(crashreport);
            return;
        }
        finally {
            try {
                if (FMLCommonHandler.instance().shouldServerBeKilledQuietly()) {
                    return;
                }
                this.func_71260_j();
                this.field_71316_v = true;
            }
            catch (Throwable throwable1) {
                throwable1.printStackTrace();
            }
            finally {
                FMLCommonHandler.instance().handleServerStopped();
                this.field_71316_v = true;
                this.func_71240_o();
            }
        }
        while (true) {
            if (!this.field_71317_u) {
                FMLCommonHandler.instance().handleServerStopping();
                return;
            }
            long k = MinecraftServer.func_130071_aq();
            long l = k - i;
            if (l > 2000L && i - this.field_71299_R >= 15000L) {
                this.func_98033_al().func_98236_b("Can't keep up! Did the system time change, or is the server overloaded?");
                l = 2000L;
                this.field_71299_R = i;
            }
            if (l < 0L) {
                this.func_98033_al().func_98236_b("Time ran backwards! Did the system time change?");
                l = 0L;
            }
            j += l;
            i = k;
            if (this.field_71305_c[0].func_73056_e()) {
                this.func_71217_p();
                j = 0L;
            } else {
                while (j > 50L) {
                    j -= 50L;
                    this.func_71217_p();
                }
            }
            Thread.sleep(1L);
            this.field_71296_Q = true;
        }
    }

    protected File func_71238_n() {
        return new File(".");
    }

    protected void func_71228_a(CrashReport par1CrashReport) {
    }

    protected void func_71240_o() {
    }

    public void func_71217_p() {
        FMLCommonHandler.instance().rescheduleTicks(Side.SERVER);
        long i = System.nanoTime();
        AxisAlignedBB.func_72332_a().func_72298_a();
        FMLCommonHandler.instance().onPreServerTick();
        ++this.field_71315_w;
        if (this.field_71295_T) {
            this.field_71295_T = false;
            this.field_71304_b.field_76327_a = true;
            this.field_71304_b.func_76317_a();
        }
        this.field_71304_b.func_76320_a("root");
        this.func_71190_q();
        if (this.field_71315_w % 900 == 0) {
            this.field_71304_b.func_76320_a("save");
            this.field_71318_t.func_72389_g();
            this.func_71267_a(true);
            this.field_71304_b.func_76319_b();
        }
        this.field_71304_b.func_76320_a("tallying");
        this.field_71311_j[this.field_71315_w % 100] = System.nanoTime() - i;
        this.field_71300_f[this.field_71315_w % 100] = Packet.field_73290_p - this.field_71281_E;
        this.field_71281_E = Packet.field_73290_p;
        this.field_71301_g[this.field_71315_w % 100] = Packet.field_73289_q - this.field_71282_F;
        this.field_71282_F = Packet.field_73289_q;
        this.field_71313_h[this.field_71315_w % 100] = Packet.field_73292_n - this.field_71283_G;
        this.field_71283_G = Packet.field_73292_n;
        this.field_71314_i[this.field_71315_w % 100] = Packet.field_73293_o - this.field_71291_H;
        this.field_71291_H = Packet.field_73293_o;
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76320_a("snooper");
        if (!this.field_71307_n.func_76468_d() && this.field_71315_w > 100) {
            this.field_71307_n.func_76463_a();
        }
        if (this.field_71315_w % 6000 == 0) {
            this.field_71307_n.func_76471_b();
        }
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76319_b();
        FMLCommonHandler.instance().onPostServerTick();
    }

    public void func_71190_q() {
        this.field_71304_b.func_76320_a("levels");
        Integer[] ids = DimensionManager.getIDs((this.field_71315_w % 200 == 0 ? 1 : 0) != 0);
        for (int x = 0; x < ids.length; ++x) {
            int id = ids[x];
            long j = System.nanoTime();
            if (id == 0 || this.func_71255_r()) {
                WorldServer worldserver = DimensionManager.getWorld((int)id);
                this.field_71304_b.func_76320_a(worldserver.func_72912_H().func_76065_j());
                this.field_71304_b.func_76320_a("pools");
                worldserver.func_82732_R().func_72343_a();
                this.field_71304_b.func_76319_b();
                if (this.field_71315_w % 20 == 0) {
                    this.field_71304_b.func_76320_a("timeSync");
                    this.field_71318_t.func_72396_a((Packet)new Packet4UpdateTime(worldserver.func_82737_E(), worldserver.func_72820_D(), worldserver.func_82736_K().func_82766_b("doDaylightCycle")), worldserver.field_73011_w.field_76574_g);
                    this.field_71304_b.func_76319_b();
                }
                this.field_71304_b.func_76320_a("tick");
                FMLCommonHandler.instance().onPreWorldTick((Object)worldserver);
                try {
                    worldserver.func_72835_b();
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception ticking world");
                    worldserver.func_72914_a(crashreport);
                    throw new ReportedException(crashreport);
                }
                try {
                    worldserver.func_72939_s();
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport = CrashReport.func_85055_a(throwable1, "Exception ticking world entities");
                    worldserver.func_72914_a(crashreport);
                    throw new ReportedException(crashreport);
                }
                FMLCommonHandler.instance().onPostWorldTick((Object)worldserver);
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76320_a("tracker");
                worldserver.func_73039_n().func_72788_a();
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76319_b();
            }
            this.worldTickTimes.get((Object)Integer.valueOf((int)id))[this.field_71315_w % 100] = System.nanoTime() - j;
        }
        this.field_71304_b.func_76318_c("dim_unloading");
        DimensionManager.unloadWorlds(this.worldTickTimes);
        this.field_71304_b.func_76318_c("connection");
        this.func_71212_ac().func_71747_b();
        this.field_71304_b.func_76318_c("players");
        this.field_71318_t.func_72374_b();
        this.field_71304_b.func_76318_c("tickables");
        for (int i = 0; i < this.field_71322_p.size(); ++i) {
            ((IUpdatePlayerListBox)this.field_71322_p.get(i)).func_73660_a();
        }
        this.field_71304_b.func_76319_b();
    }

    public boolean func_71255_r() {
        return true;
    }

    public void func_71256_s() {
        new ThreadMinecraftServer(this, "Server thread").start();
    }

    public File func_71209_f(String par1Str) {
        return new File(this.func_71238_n(), par1Str);
    }

    public void func_71244_g(String par1Str) {
        this.func_98033_al().func_98233_a(par1Str);
    }

    public void func_71236_h(String par1Str) {
        this.func_98033_al().func_98236_b(par1Str);
    }

    public WorldServer func_71218_a(int par1) {
        WorldServer ret = DimensionManager.getWorld((int)par1);
        if (ret == null) {
            DimensionManager.initDimension((int)par1);
            ret = DimensionManager.getWorld((int)par1);
        }
        return ret;
    }

    @SideOnly(value=Side.SERVER)
    public void func_82010_a(IUpdatePlayerListBox par1IUpdatePlayerListBox) {
        this.field_71322_p.add(par1IUpdatePlayerListBox);
    }

    public String func_71277_t() {
        return this.field_71320_r;
    }

    public int func_71234_u() {
        return this.field_71319_s;
    }

    public String func_71274_v() {
        return this.field_71286_C;
    }

    public String func_71249_w() {
        return "1.6.2";
    }

    public int func_71233_x() {
        return this.field_71318_t.func_72394_k();
    }

    public int func_71275_y() {
        return this.field_71318_t.func_72352_l();
    }

    public String[] func_71213_z() {
        return this.field_71318_t.func_72369_d();
    }

    public String func_71258_A() {
        return "";
    }

    public String func_71252_i(String par1Str) {
        RConConsoleSource.field_70010_a.func_70007_b();
        this.field_71321_q.func_71556_a((ICommandSender)RConConsoleSource.field_70010_a, par1Str);
        return RConConsoleSource.field_70010_a.func_70008_c();
    }

    public boolean func_71239_B() {
        return false;
    }

    public void func_71201_j(String par1Str) {
        this.func_98033_al().func_98232_c(par1Str);
    }

    public void func_71198_k(String par1Str) {
        if (this.func_71239_B()) {
            this.func_98033_al().func_98233_a(par1Str);
        }
    }

    public String getServerModName() {
        return FMLCommonHandler.instance().getModName();
    }

    public CrashReport func_71230_b(CrashReport par1CrashReport) {
        par1CrashReport.func_85056_g().func_71500_a("Profiler Position", (Callable)new CallableIsServerModded(this));
        if (this.field_71305_c != null && this.field_71305_c.length > 0 && this.field_71305_c[0] != null) {
            par1CrashReport.func_85056_g().func_71500_a("Vec3 Pool Size", (Callable)new CallableServerProfiler(this));
        }
        if (this.field_71318_t != null) {
            par1CrashReport.func_85056_g().func_71500_a("Player Count", (Callable)new CallableServerMemoryStats(this));
        }
        return par1CrashReport;
    }

    public List func_71248_a(ICommandSender par1ICommandSender, String par2Str) {
        ArrayList<String> arraylist = new ArrayList<String>();
        if (par2Str.startsWith("/")) {
            boolean flag = !(par2Str = par2Str.substring(1)).contains(" ");
            List list = this.field_71321_q.func_71558_b(par1ICommandSender, par2Str);
            if (list != null) {
                for (String s1 : list) {
                    if (flag) {
                        arraylist.add("/" + s1);
                        continue;
                    }
                    arraylist.add(s1);
                }
            }
            return arraylist;
        }
        String[] astring = par2Str.split(" ", -1);
        String s2 = astring[astring.length - 1];
        for (String s3 : this.field_71318_t.func_72369_d()) {
            if (!CommandBase.func_71523_a((String)s2, (String)s3)) continue;
            arraylist.add(s3);
        }
        return arraylist;
    }

    public static MinecraftServer func_71276_C() {
        return field_71309_l;
    }

    public String func_70005_c_() {
        return "Server";
    }

    public void func_70006_a(ChatMessageComponent par1ChatMessageComponent) {
        this.func_98033_al().func_98233_a(par1ChatMessageComponent.toString());
    }

    public boolean func_70003_b(int par1, String par2Str) {
        return true;
    }

    public ICommandManager func_71187_D() {
        return this.field_71321_q;
    }

    public KeyPair func_71250_E() {
        return this.field_71292_I;
    }

    public int func_71215_F() {
        return this.field_71319_s;
    }

    public void func_71208_b(int par1) {
        this.field_71319_s = par1;
    }

    public String func_71214_G() {
        return this.field_71293_J;
    }

    public void func_71224_l(String par1Str) {
        this.field_71293_J = par1Str;
    }

    public boolean func_71264_H() {
        return this.field_71293_J != null;
    }

    public String func_71270_I() {
        return this.field_71294_K;
    }

    public void func_71261_m(String par1Str) {
        this.field_71294_K = par1Str;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71246_n(String par1Str) {
        this.field_71287_L = par1Str;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_71221_J() {
        return this.field_71287_L;
    }

    public void func_71253_a(KeyPair par1KeyPair) {
        this.field_71292_I = par1KeyPair;
    }

    public void func_71226_c(int par1) {
        for (int j = 0; j < this.field_71305_c.length; ++j) {
            WorldServer worldserver = this.field_71305_c[j];
            if (worldserver == null) continue;
            if (worldserver.func_72912_H().func_76093_s()) {
                worldserver.field_73013_u = 3;
                worldserver.func_72891_a(true, true);
                continue;
            }
            if (this.func_71264_H()) {
                worldserver.field_73013_u = par1;
                worldserver.func_72891_a(worldserver.field_73013_u > 0, true);
                continue;
            }
            worldserver.field_73013_u = par1;
            worldserver.func_72891_a(this.func_71193_K(), this.field_71324_y);
        }
    }

    protected boolean func_71193_K() {
        return true;
    }

    public boolean func_71242_L() {
        return this.field_71288_M;
    }

    public void func_71204_b(boolean par1) {
        this.field_71288_M = par1;
    }

    public void func_71194_c(boolean par1) {
        this.field_71289_N = par1;
    }

    public ISaveFormat func_71254_M() {
        return this.field_71310_m;
    }

    public void func_71272_O() {
        this.field_71290_O = true;
        this.func_71254_M().func_75800_d();
        for (int i = 0; i < this.field_71305_c.length; ++i) {
            WorldServer worldserver = this.field_71305_c[i];
            if (worldserver == null) continue;
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((World)worldserver));
            worldserver.func_73041_k();
        }
        this.func_71254_M().func_75802_e(this.field_71305_c[0].func_72860_G().func_75760_g());
        this.func_71263_m();
    }

    public String func_71202_P() {
        return this.field_71297_P;
    }

    public void func_71269_o(String par1Str) {
        this.field_71297_P = par1Str;
    }

    public void func_70000_a(PlayerUsageSnooper par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.func_76472_a("whitelist_enabled", false);
        par1PlayerUsageSnooper.func_76472_a("whitelist_count", 0);
        par1PlayerUsageSnooper.func_76472_a("players_current", this.func_71233_x());
        par1PlayerUsageSnooper.func_76472_a("players_max", this.func_71275_y());
        par1PlayerUsageSnooper.func_76472_a("players_seen", this.field_71318_t.func_72373_m().length);
        par1PlayerUsageSnooper.func_76472_a("uses_auth", this.field_71325_x);
        par1PlayerUsageSnooper.func_76472_a("gui_state", this.func_71279_ae() ? "enabled" : "disabled");
        par1PlayerUsageSnooper.func_76472_a("run_time", (MinecraftServer.func_130071_aq() - par1PlayerUsageSnooper.func_130105_g()) / 60L * 1000L);
        par1PlayerUsageSnooper.func_76472_a("avg_tick_ms", (int)(MathHelper.func_76127_a((long[])this.field_71311_j) * 1.0E-6));
        par1PlayerUsageSnooper.func_76472_a("avg_sent_packet_count", (int)MathHelper.func_76127_a((long[])this.field_71300_f));
        par1PlayerUsageSnooper.func_76472_a("avg_sent_packet_size", (int)MathHelper.func_76127_a((long[])this.field_71301_g));
        par1PlayerUsageSnooper.func_76472_a("avg_rec_packet_count", (int)MathHelper.func_76127_a((long[])this.field_71313_h));
        par1PlayerUsageSnooper.func_76472_a("avg_rec_packet_size", (int)MathHelper.func_76127_a((long[])this.field_71314_i));
        int i = 0;
        for (int j = 0; j < this.field_71305_c.length; ++j) {
            if (this.field_71305_c[j] == null) continue;
            WorldServer worldserver = this.field_71305_c[j];
            WorldInfo worldinfo = worldserver.func_72912_H();
            par1PlayerUsageSnooper.func_76472_a("world[" + i + "][dimension]", worldserver.field_73011_w.field_76574_g);
            par1PlayerUsageSnooper.func_76472_a("world[" + i + "][mode]", worldinfo.func_76077_q());
            par1PlayerUsageSnooper.func_76472_a("world[" + i + "][difficulty]", worldserver.field_73013_u);
            par1PlayerUsageSnooper.func_76472_a("world[" + i + "][hardcore]", worldinfo.func_76093_s());
            par1PlayerUsageSnooper.func_76472_a("world[" + i + "][generator_name]", worldinfo.func_76067_t().func_77127_a());
            par1PlayerUsageSnooper.func_76472_a("world[" + i + "][generator_version]", worldinfo.func_76067_t().func_77131_c());
            par1PlayerUsageSnooper.func_76472_a("world[" + i + "][height]", this.field_71280_D);
            par1PlayerUsageSnooper.func_76472_a("world[" + i + "][chunks_loaded]", worldserver.func_72863_F().func_73152_e());
            ++i;
        }
        par1PlayerUsageSnooper.func_76472_a("worlds", i);
    }

    public void func_70001_b(PlayerUsageSnooper par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.func_76472_a("singleplayer", this.func_71264_H());
        par1PlayerUsageSnooper.func_76472_a("server_brand", this.getServerModName());
        par1PlayerUsageSnooper.func_76472_a("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        par1PlayerUsageSnooper.func_76472_a("dedicated", this.func_71262_S());
    }

    public boolean func_70002_Q() {
        return true;
    }

    public int func_71227_R() {
        return 16;
    }

    public abstract boolean func_71262_S();

    public boolean func_71266_T() {
        return this.field_71325_x;
    }

    public void func_71229_d(boolean par1) {
        this.field_71325_x = par1;
    }

    public boolean func_71268_U() {
        return this.field_71324_y;
    }

    public void func_71251_e(boolean par1) {
        this.field_71324_y = par1;
    }

    public boolean func_71220_V() {
        return this.field_71323_z;
    }

    public void func_71257_f(boolean par1) {
        this.field_71323_z = par1;
    }

    public boolean func_71219_W() {
        return this.field_71284_A;
    }

    public void func_71188_g(boolean par1) {
        this.field_71284_A = par1;
    }

    public boolean func_71231_X() {
        return this.field_71285_B;
    }

    public void func_71245_h(boolean par1) {
        this.field_71285_B = par1;
    }

    public abstract boolean func_82356_Z();

    public String func_71273_Y() {
        return this.field_71286_C;
    }

    public void func_71205_p(String par1Str) {
        this.field_71286_C = par1Str;
    }

    public int func_71207_Z() {
        return this.field_71280_D;
    }

    public void func_71191_d(int par1) {
        this.field_71280_D = par1;
    }

    public boolean func_71241_aa() {
        return this.field_71316_v;
    }

    public ServerConfigurationManager func_71203_ab() {
        return this.field_71318_t;
    }

    public void func_71210_a(ServerConfigurationManager par1ServerConfigurationManager) {
        this.field_71318_t = par1ServerConfigurationManager;
    }

    public void func_71235_a(EnumGameType par1EnumGameType) {
        for (int i = 0; i < this.field_71305_c.length; ++i) {
            MinecraftServer.func_71276_C().field_71305_c[i].func_72912_H().func_76060_a(par1EnumGameType);
        }
    }

    public abstract NetworkListenThread func_71212_ac();

    @SideOnly(value=Side.CLIENT)
    public boolean func_71200_ad() {
        return this.field_71296_Q;
    }

    public boolean func_71279_ae() {
        return false;
    }

    public abstract String func_71206_a(EnumGameType var1, boolean var2);

    public int func_71259_af() {
        return this.field_71315_w;
    }

    public void func_71223_ag() {
        this.field_71295_T = true;
    }

    @SideOnly(value=Side.CLIENT)
    public PlayerUsageSnooper func_80003_ah() {
        return this.field_71307_n;
    }

    public ChunkCoordinates func_82114_b() {
        return new ChunkCoordinates(0, 0, 0);
    }

    public World func_130014_f_() {
        return this.field_71305_c[0];
    }

    public int func_82357_ak() {
        return 16;
    }

    public boolean func_96290_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        return false;
    }

    public abstract ILogAgent func_98033_al();

    public void func_104055_i(boolean par1) {
        this.field_104057_T = par1;
    }

    public boolean func_104056_am() {
        return this.field_104057_T;
    }

    public Proxy func_110454_ao() {
        return this.field_110456_c;
    }

    public static long func_130071_aq() {
        return System.currentTimeMillis();
    }

    public static ServerConfigurationManager func_71196_a(MinecraftServer par0MinecraftServer) {
        return par0MinecraftServer.field_71318_t;
    }

    @SideOnly(value=Side.SERVER)
    public static void main(String[] par0ArrayOfStr) {
        StatList.func_75919_a();
        ILogAgent ilogagent = null;
        try {
            boolean flag = !GraphicsEnvironment.isHeadless();
            String s = null;
            String s1 = ".";
            String s2 = null;
            boolean flag1 = false;
            boolean flag2 = false;
            int i = -1;
            for (int j = 0; j < par0ArrayOfStr.length; ++j) {
                String s3 = par0ArrayOfStr[j];
                String s4 = j == par0ArrayOfStr.length - 1 ? null : par0ArrayOfStr[j + 1];
                boolean flag3 = false;
                if (!s3.equals("nogui") && !s3.equals("--nogui")) {
                    if (s3.equals("--port") && s4 != null) {
                        flag3 = true;
                        try {
                            i = Integer.parseInt(s4);
                        }
                        catch (NumberFormatException numberformatexception) {}
                    } else if (s3.equals("--singleplayer") && s4 != null) {
                        flag3 = true;
                        s = s4;
                    } else if (s3.equals("--universe") && s4 != null) {
                        flag3 = true;
                        s1 = s4;
                    } else if (s3.equals("--world") && s4 != null) {
                        flag3 = true;
                        s2 = s4;
                    } else if (s3.equals("--demo")) {
                        flag1 = true;
                    } else if (s3.equals("--bonusChest")) {
                        flag2 = true;
                    }
                } else {
                    flag = false;
                }
                if (!flag3) continue;
                ++j;
            }
            DedicatedServer dedicatedserver = new DedicatedServer(new File(s1));
            ilogagent = dedicatedserver.func_98033_al();
            if (s != null) {
                dedicatedserver.func_71224_l(s);
            }
            if (s2 != null) {
                dedicatedserver.func_71261_m(s2);
            }
            if (i >= 0) {
                dedicatedserver.func_71208_b(i);
            }
            if (flag1) {
                dedicatedserver.func_71204_b(true);
            }
            if (flag2) {
                dedicatedserver.func_71194_c(true);
            }
            if (flag) {
                dedicatedserver.func_120011_ar();
            }
            dedicatedserver.func_71256_s();
            Runtime.getRuntime().addShutdownHook((Thread)new ThreadDedicatedServer(dedicatedserver));
        }
        catch (Exception exception) {
            if (ilogagent != null) {
                ilogagent.func_98234_c("Failed to start the minecraft server", (Throwable)exception);
            }
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failed to start the minecraft server", exception);
        }
    }
}

