/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CallableTileEntityData;
import net.minecraft.tileentity.CallableTileEntityID;
import net.minecraft.tileentity.CallableTileEntityName;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityComparator;
import net.minecraft.tileentity.TileEntityDaylightDetector;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.tileentity.TileEntityRecordPlayer;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntity {
    private static Map field_70326_a = new HashMap();
    private static Map field_70323_b = new HashMap();
    public World field_70331_k;
    public int field_70329_l;
    public int field_70330_m;
    public int field_70327_n;
    protected boolean field_70328_o;
    public int field_70325_p = -1;
    public Block field_70324_q;
    private boolean isVanilla = this.getClass().getName().startsWith("net.minecraft.tileentity");
    public static final AxisAlignedBB INFINITE_EXTENT_AABB;

    public static void func_70306_a(Class par0Class, String par1Str) {
        if (field_70326_a.containsKey(par1Str)) {
            throw new IllegalArgumentException("Duplicate id: " + par1Str);
        }
        field_70326_a.put(par1Str, par0Class);
        field_70323_b.put(par0Class, par1Str);
    }

    public World func_70314_l() {
        return this.field_70331_k;
    }

    public void func_70308_a(World par1World) {
        this.field_70331_k = par1World;
    }

    public boolean func_70309_m() {
        return this.field_70331_k != null;
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        this.field_70329_l = par1NBTTagCompound.func_74762_e("x");
        this.field_70330_m = par1NBTTagCompound.func_74762_e("y");
        this.field_70327_n = par1NBTTagCompound.func_74762_e("z");
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        String s = (String)field_70323_b.get(this.getClass());
        if (s == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        par1NBTTagCompound.func_74778_a("id", s);
        par1NBTTagCompound.func_74768_a("x", this.field_70329_l);
        par1NBTTagCompound.func_74768_a("y", this.field_70330_m);
        par1NBTTagCompound.func_74768_a("z", this.field_70327_n);
    }

    public void func_70316_g() {
    }

    public static TileEntity func_70317_c(NBTTagCompound par0NBTTagCompound) {
        TileEntity tileentity = null;
        Class oclass = null;
        try {
            oclass = (Class)field_70326_a.get(par0NBTTagCompound.func_74779_i("id"));
            if (oclass != null) {
                tileentity = (TileEntity)oclass.newInstance();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tileentity != null) {
            try {
                tileentity.func_70307_a(par0NBTTagCompound);
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"A TileEntity %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", (Object[])new Object[]{par0NBTTagCompound.func_74779_i("id"), oclass.getName()});
                tileentity = null;
            }
        } else {
            MinecraftServer.func_71276_C().func_98033_al().func_98236_b("Skipping TileEntity with id " + par0NBTTagCompound.func_74779_i("id"));
        }
        return tileentity;
    }

    public int func_70322_n() {
        if (this.field_70325_p == -1) {
            this.field_70325_p = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return this.field_70325_p;
    }

    public void func_70296_d() {
        if (this.field_70331_k != null) {
            this.field_70325_p = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72944_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this);
            if (this.func_70311_o() != null) {
                this.field_70331_k.func_96440_m(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
            }
        }
    }

    public double func_70318_a(double par1, double par3, double par5) {
        double d3 = (double)this.field_70329_l + 0.5 - par1;
        double d4 = (double)this.field_70330_m + 0.5 - par3;
        double d5 = (double)this.field_70327_n + 0.5 - par5;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_82115_m() {
        return 4096.0;
    }

    public Block func_70311_o() {
        if (this.field_70324_q == null) {
            this.field_70324_q = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n)];
        }
        return this.field_70324_q;
    }

    public Packet func_70319_e() {
        return null;
    }

    public boolean func_70320_p() {
        return this.field_70328_o;
    }

    public void func_70313_j() {
        this.field_70328_o = true;
    }

    public void func_70312_q() {
        this.field_70328_o = false;
    }

    public boolean func_70315_b(int par1, int par2) {
        return false;
    }

    public void func_70321_h() {
        this.field_70324_q = null;
        this.field_70325_p = -1;
    }

    public void func_85027_a(CrashReportCategory par1CrashReportCategory) {
        par1CrashReportCategory.func_71500_a("Name", (Callable)new CallableTileEntityName(this));
        CrashReportCategory.func_85068_a(par1CrashReportCategory, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca, this.func_70322_n());
        par1CrashReportCategory.func_71500_a("Actual block type", (Callable)new CallableTileEntityID(this));
        par1CrashReportCategory.func_71500_a("Actual block data value", (Callable)new CallableTileEntityData(this));
    }

    static Map func_85028_t() {
        return field_70323_b;
    }

    public boolean canUpdate() {
        return true;
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
    }

    public void onChunkUnload() {
    }

    public boolean shouldRefresh(int oldID, int newID, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return !this.isVanilla || oldID != newID;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB cbb;
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        Block type = this.func_70311_o();
        if (type == Block.field_72096_bE) {
            bb = AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
        } else if (type == Block.field_72077_au || type == Block.field_94347_ck) {
            bb = AxisAlignedBB.func_72332_a().func_72299_a((double)(this.field_70329_l - 1), (double)this.field_70330_m, (double)(this.field_70327_n - 1), (double)(this.field_70329_l + 2), (double)(this.field_70330_m + 2), (double)(this.field_70327_n + 2));
        } else if (type != null && type != Block.field_82518_cd && (cbb = this.func_70311_o().func_71872_e(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n)) != null) {
            bb = cbb;
        }
        return bb;
    }

    static {
        TileEntity.func_70306_a(TileEntityFurnace.class, "Furnace");
        TileEntity.func_70306_a(TileEntityChest.class, "Chest");
        TileEntity.func_70306_a(TileEntityEnderChest.class, "EnderChest");
        TileEntity.func_70306_a(TileEntityRecordPlayer.class, "RecordPlayer");
        TileEntity.func_70306_a(TileEntityDispenser.class, "Trap");
        TileEntity.func_70306_a(TileEntityDropper.class, "Dropper");
        TileEntity.func_70306_a(TileEntitySign.class, "Sign");
        TileEntity.func_70306_a(TileEntityMobSpawner.class, "MobSpawner");
        TileEntity.func_70306_a(TileEntityNote.class, "Music");
        TileEntity.func_70306_a(TileEntityPiston.class, "Piston");
        TileEntity.func_70306_a(TileEntityBrewingStand.class, "Cauldron");
        TileEntity.func_70306_a(TileEntityEnchantmentTable.class, "EnchantTable");
        TileEntity.func_70306_a(TileEntityEndPortal.class, "Airportal");
        TileEntity.func_70306_a(TileEntityCommandBlock.class, "Control");
        TileEntity.func_70306_a(TileEntityBeacon.class, "Beacon");
        TileEntity.func_70306_a(TileEntitySkull.class, "Skull");
        TileEntity.func_70306_a(TileEntityDaylightDetector.class, "DLDetector");
        TileEntity.func_70306_a(TileEntityHopper.class, "Hopper");
        TileEntity.func_70306_a(TileEntityComparator.class, "Comparator");
        INFINITE_EXTENT_AABB = AxisAlignedBB.func_72330_a((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY);
    }
}

