/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.ImmutableSetMultimap;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.block.BlockHalfSlab;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.logging.ILogAgent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ReportedException;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3Pool;
import net.minecraft.village.VillageCollection;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.CallableLvl1;
import net.minecraft.world.CallableLvl2;
import net.minecraft.world.CallableLvl3;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ForgeDummyContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.WorldSpecificSaveHandler;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;

public abstract class World
implements IBlockAccess {
    public static double MAX_ENTITY_RADIUS = 2.0;
    public final MapStorage perWorldStorage;
    public boolean field_72999_e;
    public List field_72996_f = new ArrayList();
    protected List field_72997_g = new ArrayList();
    public List field_73009_h = new ArrayList();
    private List field_73002_a = new ArrayList();
    private List field_73000_b = new ArrayList();
    public List field_73010_i = new ArrayList();
    public List field_73007_j = new ArrayList();
    private long field_73001_c = 0xFFFFFFL;
    public int field_73008_k;
    protected int field_73005_l = new Random().nextInt();
    protected final int field_73006_m = 1013904223;
    public float field_73003_n;
    public float field_73004_o;
    public float field_73018_p;
    public float field_73017_q;
    public int field_73016_r;
    public int field_73013_u;
    public Random field_73012_v = new Random();
    public final WorldProvider field_73011_w;
    protected List field_73021_x = new ArrayList();
    protected IChunkProvider field_73020_y;
    protected final ISaveHandler field_73019_z;
    protected WorldInfo field_72986_A;
    public boolean field_72987_B;
    public MapStorage field_72988_C;
    public VillageCollection field_72982_D;
    protected final VillageSiege field_72983_E = new VillageSiege(this);
    public final Profiler field_72984_F;
    private final Vec3Pool field_82741_K = new Vec3Pool(300, 2000);
    private final Calendar field_83016_L = Calendar.getInstance();
    protected Scoreboard field_96442_D = new Scoreboard();
    private final ILogAgent field_98181_L;
    private ArrayList field_72998_d = new ArrayList();
    private boolean field_72989_L;
    protected boolean field_72985_G = true;
    protected boolean field_72992_H = true;
    public Set field_72993_I = new HashSet();
    private int field_72990_M = this.field_73012_v.nextInt(12000);
    int[] field_72994_J = new int[32768];
    public boolean field_72995_K;
    private static MapStorage s_mapStorage;
    private static ISaveHandler s_savehandler;

    public BiomeGenBase func_72807_a(int par1, int par2) {
        return this.field_73011_w.getBiomeGenForCoords(par1, par2);
    }

    public BiomeGenBase getBiomeGenForCoordsBody(int par1, int par2) {
        Chunk chunk;
        if (this.func_72899_e(par1, 0, par2) && (chunk = this.func_72938_d(par1, par2)) != null) {
            return chunk.func_76591_a(par1 & 0xF, par2 & 0xF, this.field_73011_w.field_76578_c);
        }
        return this.field_73011_w.field_76578_c.func_76935_a(par1, par2);
    }

    public WorldChunkManager func_72959_q() {
        return this.field_73011_w.field_76578_c;
    }

    @SideOnly(value=Side.CLIENT)
    public World(ISaveHandler par1ISaveHandler, String par2Str, WorldProvider par3WorldProvider, WorldSettings par4WorldSettings, Profiler par5Profiler, ILogAgent par6ILogAgent) {
        this.field_73019_z = par1ISaveHandler;
        this.field_72984_F = par5Profiler;
        this.field_72986_A = new WorldInfo(par4WorldSettings, par2Str);
        this.field_73011_w = par3WorldProvider;
        this.perWorldStorage = new MapStorage((ISaveHandler)null);
        this.field_98181_L = par6ILogAgent;
    }

    @SideOnly(value=Side.CLIENT)
    protected void finishSetup() {
        VillageCollection villagecollection = (VillageCollection)this.field_72988_C.func_75742_a(VillageCollection.class, "villages");
        if (villagecollection == null) {
            this.field_72982_D = new VillageCollection(this);
            this.field_72988_C.func_75745_a("villages", (WorldSavedData)this.field_72982_D);
        } else {
            this.field_72982_D = villagecollection;
            this.field_72982_D.func_82566_a(this);
        }
        int providerDim = this.field_73011_w.field_76574_g;
        this.field_73011_w.func_76558_a(this);
        this.field_73011_w.field_76574_g = providerDim;
        this.field_73020_y = this.func_72970_h();
        this.func_72966_v();
        this.func_72947_a();
    }

    public World(ISaveHandler par1ISaveHandler, String par2Str, WorldSettings par3WorldSettings, WorldProvider par4WorldProvider, Profiler par5Profiler, ILogAgent par6ILogAgent) {
        this.field_73019_z = par1ISaveHandler;
        this.field_72984_F = par5Profiler;
        this.field_72988_C = this.getMapStorage(par1ISaveHandler);
        this.field_98181_L = par6ILogAgent;
        this.field_72986_A = par1ISaveHandler.func_75757_d();
        this.field_73011_w = par4WorldProvider != null ? par4WorldProvider : (this.field_72986_A != null && this.field_72986_A.func_76076_i() != 0 ? WorldProvider.func_76570_a((int)this.field_72986_A.func_76076_i()) : WorldProvider.func_76570_a((int)0));
        if (this.field_72986_A == null) {
            this.field_72986_A = new WorldInfo(par3WorldSettings, par2Str);
        } else {
            this.field_72986_A.func_76062_a(par2Str);
        }
        this.field_73011_w.func_76558_a(this);
        this.field_73020_y = this.func_72970_h();
        if (!this.field_72986_A.func_76070_v()) {
            try {
                this.func_72963_a(par3WorldSettings);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception initializing level");
                try {
                    this.func_72914_a(crashreport);
                }
                catch (Throwable throwable1) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            this.field_72986_A.func_76091_d(true);
        }
        this.perWorldStorage = this instanceof WorldServer ? new MapStorage((ISaveHandler)new WorldSpecificSaveHandler((WorldServer)this, par1ISaveHandler)) : new MapStorage((ISaveHandler)null);
        VillageCollection villagecollection = (VillageCollection)this.perWorldStorage.func_75742_a(VillageCollection.class, "villages");
        if (villagecollection == null) {
            this.field_72982_D = new VillageCollection(this);
            this.perWorldStorage.func_75745_a("villages", (WorldSavedData)this.field_72982_D);
        } else {
            this.field_72982_D = villagecollection;
            this.field_72982_D.func_82566_a(this);
        }
        this.func_72966_v();
        this.func_72947_a();
    }

    private MapStorage getMapStorage(ISaveHandler savehandler) {
        if (s_savehandler != savehandler || s_mapStorage == null) {
            s_mapStorage = new MapStorage(savehandler);
            s_savehandler = savehandler;
        }
        return s_mapStorage;
    }

    protected abstract IChunkProvider func_72970_h();

    protected void func_72963_a(WorldSettings par1WorldSettings) {
        this.field_72986_A.func_76091_d(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72974_f() {
        this.func_72950_A(8, 64, 8);
    }

    public int func_72922_b(int par1, int par2) {
        int k = 63;
        while (!this.func_72799_c(par1, k + 1, par2)) {
            ++k;
        }
        return this.func_72798_a(par1, k, par2);
    }

    public int func_72798_a(int par1, int par2, int par3) {
        if (par1 >= -30000000 && par3 >= -30000000 && par1 < 30000000 && par3 < 30000000) {
            if (par2 < 0) {
                return 0;
            }
            if (par2 >= 256) {
                return 0;
            }
            Chunk chunk = null;
            try {
                chunk = this.func_72964_e(par1 >> 4, par3 >> 4);
                return chunk.func_76610_a(par1 & 0xF, par2, par3 & 0xF);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception getting block type in world");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Requested block coordinates");
                crashreportcategory.func_71507_a("Found chunk", chunk == null);
                crashreportcategory.func_71507_a("Location", CrashReportCategory.func_85071_a(par1, par2, par3));
                throw new ReportedException(crashreport);
            }
        }
        return 0;
    }

    public boolean func_72799_c(int par1, int par2, int par3) {
        int id = this.func_72798_a(par1, par2, par3);
        return id == 0 || Block.field_71973_m[id] == null || Block.field_71973_m[id].isAirBlock(this, par1, par2, par3);
    }

    public boolean func_72927_d(int par1, int par2, int par3) {
        int l = this.func_72798_a(par1, par2, par3);
        int meta = this.func_72805_g(par1, par2, par3);
        return Block.field_71973_m[l] != null && Block.field_71973_m[l].hasTileEntity(meta);
    }

    public int func_85175_e(int par1, int par2, int par3) {
        int l = this.func_72798_a(par1, par2, par3);
        return Block.field_71973_m[l] != null ? Block.field_71973_m[l].func_71857_b() : -1;
    }

    public boolean func_72899_e(int par1, int par2, int par3) {
        return par2 >= 0 && par2 < 256 ? this.func_72916_c(par1 >> 4, par3 >> 4) : false;
    }

    public boolean func_72873_a(int par1, int par2, int par3, int par4) {
        return this.func_72904_c(par1 - par4, par2 - par4, par3 - par4, par1 + par4, par2 + par4, par3 + par4);
    }

    public boolean func_72904_c(int par1, int par2, int par3, int par4, int par5, int par6) {
        if (par5 >= 0 && par2 < 256) {
            par3 >>= 4;
            par4 >>= 4;
            par6 >>= 4;
            for (int k1 = par1 >>= 4; k1 <= par4; ++k1) {
                for (int l1 = par3; l1 <= par6; ++l1) {
                    if (this.func_72916_c(k1, l1)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean func_72916_c(int par1, int par2) {
        return this.field_73020_y.func_73149_a(par1, par2);
    }

    public Chunk func_72938_d(int par1, int par2) {
        return this.func_72964_e(par1 >> 4, par2 >> 4);
    }

    public Chunk func_72964_e(int par1, int par2) {
        return this.field_73020_y.func_73154_d(par1, par2);
    }

    public boolean func_72832_d(int par1, int par2, int par3, int par4, int par5, int par6) {
        if (par1 >= -30000000 && par3 >= -30000000 && par1 < 30000000 && par3 < 30000000) {
            if (par2 < 0) {
                return false;
            }
            if (par2 >= 256) {
                return false;
            }
            Chunk chunk = this.func_72964_e(par1 >> 4, par3 >> 4);
            int k1 = 0;
            if ((par6 & 1) != 0) {
                k1 = chunk.func_76610_a(par1 & 0xF, par2, par3 & 0xF);
            }
            boolean flag = chunk.func_76592_a(par1 & 0xF, par2, par3 & 0xF, par4, par5);
            this.field_72984_F.func_76320_a("checkLight");
            this.func_72969_x(par1, par2, par3);
            this.field_72984_F.func_76319_b();
            if (flag) {
                if (!((par6 & 2) == 0 || this.field_72995_K && (par6 & 4) != 0)) {
                    this.func_72845_h(par1, par2, par3);
                }
                if (!this.field_72995_K && (par6 & 1) != 0) {
                    this.func_72851_f(par1, par2, par3, k1);
                    Block block = Block.field_71973_m[par4];
                    if (block != null && block.func_96468_q_()) {
                        this.func_96440_m(par1, par2, par3, par4);
                    }
                }
            }
            return flag;
        }
        return false;
    }

    public Material func_72803_f(int par1, int par2, int par3) {
        int l = this.func_72798_a(par1, par2, par3);
        return l == 0 ? Material.field_76249_a : Block.field_71973_m[l].field_72018_cp;
    }

    public int func_72805_g(int par1, int par2, int par3) {
        if (par1 >= -30000000 && par3 >= -30000000 && par1 < 30000000 && par3 < 30000000) {
            if (par2 < 0) {
                return 0;
            }
            if (par2 >= 256) {
                return 0;
            }
            Chunk chunk = this.func_72964_e(par1 >> 4, par3 >> 4);
            return chunk.func_76628_c(par1 &= 0xF, par2, par3 &= 0xF);
        }
        return 0;
    }

    public boolean func_72921_c(int par1, int par2, int par3, int par4, int par5) {
        if (par1 >= -30000000 && par3 >= -30000000 && par1 < 30000000 && par3 < 30000000) {
            int k1;
            int j1;
            if (par2 < 0) {
                return false;
            }
            if (par2 >= 256) {
                return false;
            }
            Chunk chunk = this.func_72964_e(par1 >> 4, par3 >> 4);
            boolean flag = chunk.func_76589_b(j1 = par1 & 0xF, par2, k1 = par3 & 0xF, par4);
            if (flag) {
                int l1 = chunk.func_76610_a(j1, par2, k1);
                if (!((par5 & 2) == 0 || this.field_72995_K && (par5 & 4) != 0)) {
                    this.func_72845_h(par1, par2, par3);
                }
                if (!this.field_72995_K && (par5 & 1) != 0) {
                    this.func_72851_f(par1, par2, par3, l1);
                    Block block = Block.field_71973_m[l1];
                    if (block != null && block.func_96468_q_()) {
                        this.func_96440_m(par1, par2, par3, l1);
                    }
                }
            }
            return flag;
        }
        return false;
    }

    public boolean func_94571_i(int par1, int par2, int par3) {
        return this.func_72832_d(par1, par2, par3, 0, 0, 3);
    }

    public boolean func_94578_a(int par1, int par2, int par3, boolean par4) {
        int l = this.func_72798_a(par1, par2, par3);
        if (l > 0) {
            int i1 = this.func_72805_g(par1, par2, par3);
            this.func_72926_e(2001, par1, par2, par3, l + (i1 << 12));
            if (par4) {
                Block.field_71973_m[l].func_71897_c(this, par1, par2, par3, i1, 0);
            }
            return this.func_72832_d(par1, par2, par3, 0, 0, 3);
        }
        return false;
    }

    public boolean func_94575_c(int par1, int par2, int par3, int par4) {
        return this.func_72832_d(par1, par2, par3, par4, 0, 3);
    }

    public void func_72845_h(int par1, int par2, int par3) {
        for (int l = 0; l < this.field_73021_x.size(); ++l) {
            ((IWorldAccess)this.field_73021_x.get(l)).func_72710_a(par1, par2, par3);
        }
    }

    public void func_72851_f(int par1, int par2, int par3, int par4) {
        this.func_72898_h(par1, par2, par3, par4);
    }

    public void func_72975_g(int par1, int par2, int par3, int par4) {
        int i1;
        if (par3 > par4) {
            i1 = par4;
            par4 = par3;
            par3 = i1;
        }
        if (!this.field_73011_w.field_76576_e) {
            for (i1 = par3; i1 <= par4; ++i1) {
                this.func_72936_c(EnumSkyBlock.Sky, par1, i1, par2);
            }
        }
        this.func_72909_d(par1, par3, par2, par1, par4, par2);
    }

    public void func_72909_d(int par1, int par2, int par3, int par4, int par5, int par6) {
        for (int k1 = 0; k1 < this.field_73021_x.size(); ++k1) {
            ((IWorldAccess)this.field_73021_x.get(k1)).func_72707_a(par1, par2, par3, par4, par5, par6);
        }
    }

    public void func_72898_h(int par1, int par2, int par3, int par4) {
        this.func_72821_m(par1 - 1, par2, par3, par4);
        this.func_72821_m(par1 + 1, par2, par3, par4);
        this.func_72821_m(par1, par2 - 1, par3, par4);
        this.func_72821_m(par1, par2 + 1, par3, par4);
        this.func_72821_m(par1, par2, par3 - 1, par4);
        this.func_72821_m(par1, par2, par3 + 1, par4);
    }

    public void func_96439_d(int par1, int par2, int par3, int par4, int par5) {
        if (par5 != 4) {
            this.func_72821_m(par1 - 1, par2, par3, par4);
        }
        if (par5 != 5) {
            this.func_72821_m(par1 + 1, par2, par3, par4);
        }
        if (par5 != 0) {
            this.func_72821_m(par1, par2 - 1, par3, par4);
        }
        if (par5 != 1) {
            this.func_72821_m(par1, par2 + 1, par3, par4);
        }
        if (par5 != 2) {
            this.func_72821_m(par1, par2, par3 - 1, par4);
        }
        if (par5 != 3) {
            this.func_72821_m(par1, par2, par3 + 1, par4);
        }
    }

    public void func_72821_m(int par1, int par2, int par3, int par4) {
        int i1;
        Block block;
        if (!this.field_72995_K && (block = Block.field_71973_m[i1 = this.func_72798_a(par1, par2, par3)]) != null) {
            try {
                block.func_71863_a(this, par1, par2, par3, par4);
            }
            catch (Throwable throwable) {
                int j1;
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being updated");
                try {
                    j1 = this.func_72805_g(par1, par2, par3);
                }
                catch (Throwable throwable1) {
                    j1 = -1;
                }
                crashreportcategory.func_71500_a("Source block type", (Callable)new CallableLvl1(this, par4));
                CrashReportCategory.func_85068_a(crashreportcategory, par1, par2, par3, i1, j1);
                throw new ReportedException(crashreport);
            }
        }
    }

    public boolean func_94573_a(int par1, int par2, int par3, int par4) {
        return false;
    }

    public boolean func_72937_j(int par1, int par2, int par3) {
        return this.func_72964_e(par1 >> 4, par3 >> 4).func_76619_d(par1 & 0xF, par2, par3 & 0xF);
    }

    public int func_72883_k(int par1, int par2, int par3) {
        if (par2 < 0) {
            return 0;
        }
        if (par2 >= 256) {
            par2 = 255;
        }
        return this.func_72964_e(par1 >> 4, par3 >> 4).func_76629_c(par1 & 0xF, par2, par3 & 0xF, 0);
    }

    public int func_72957_l(int par1, int par2, int par3) {
        return this.func_72849_a(par1, par2, par3, true);
    }

    public int func_72849_a(int par1, int par2, int par3, boolean par4) {
        if (par1 >= -30000000 && par3 >= -30000000 && par1 < 30000000 && par3 < 30000000) {
            int l;
            if (par4 && Block.field_71982_s[l = this.func_72798_a(par1, par2, par3)]) {
                int i1 = this.func_72849_a(par1, par2 + 1, par3, false);
                int j1 = this.func_72849_a(par1 + 1, par2, par3, false);
                int k1 = this.func_72849_a(par1 - 1, par2, par3, false);
                int l1 = this.func_72849_a(par1, par2, par3 + 1, false);
                int i2 = this.func_72849_a(par1, par2, par3 - 1, false);
                if (j1 > i1) {
                    i1 = j1;
                }
                if (k1 > i1) {
                    i1 = k1;
                }
                if (l1 > i1) {
                    i1 = l1;
                }
                if (i2 > i1) {
                    i1 = i2;
                }
                return i1;
            }
            if (par2 < 0) {
                return 0;
            }
            if (par2 >= 256) {
                par2 = 255;
            }
            Chunk chunk = this.func_72964_e(par1 >> 4, par3 >> 4);
            return chunk.func_76629_c(par1 &= 0xF, par2, par3 &= 0xF, this.field_73008_k);
        }
        return 15;
    }

    public int func_72976_f(int par1, int par2) {
        if (par1 >= -30000000 && par2 >= -30000000 && par1 < 30000000 && par2 < 30000000) {
            if (!this.func_72916_c(par1 >> 4, par2 >> 4)) {
                return 0;
            }
            Chunk chunk = this.func_72964_e(par1 >> 4, par2 >> 4);
            return chunk.func_76611_b(par1 & 0xF, par2 & 0xF);
        }
        return 0;
    }

    public int func_82734_g(int par1, int par2) {
        if (par1 >= -30000000 && par2 >= -30000000 && par1 < 30000000 && par2 < 30000000) {
            if (!this.func_72916_c(par1 >> 4, par2 >> 4)) {
                return 0;
            }
            Chunk chunk = this.func_72964_e(par1 >> 4, par2 >> 4);
            return chunk.field_82912_p;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72925_a(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        if (this.field_73011_w.field_76576_e && par1EnumSkyBlock == EnumSkyBlock.Sky) {
            return 0;
        }
        if (par3 < 0) {
            par3 = 0;
        }
        if (par3 >= 256) {
            return par1EnumSkyBlock.field_77198_c;
        }
        if (par2 >= -30000000 && par4 >= -30000000 && par2 < 30000000 && par4 < 30000000) {
            int l = par2 >> 4;
            int i1 = par4 >> 4;
            if (!this.func_72916_c(l, i1)) {
                return par1EnumSkyBlock.field_77198_c;
            }
            if (Block.field_71982_s[this.func_72798_a(par2, par3, par4)]) {
                int j1 = this.func_72972_b(par1EnumSkyBlock, par2, par3 + 1, par4);
                int k1 = this.func_72972_b(par1EnumSkyBlock, par2 + 1, par3, par4);
                int l1 = this.func_72972_b(par1EnumSkyBlock, par2 - 1, par3, par4);
                int i2 = this.func_72972_b(par1EnumSkyBlock, par2, par3, par4 + 1);
                int j2 = this.func_72972_b(par1EnumSkyBlock, par2, par3, par4 - 1);
                if (k1 > j1) {
                    j1 = k1;
                }
                if (l1 > j1) {
                    j1 = l1;
                }
                if (i2 > j1) {
                    j1 = i2;
                }
                if (j2 > j1) {
                    j1 = j2;
                }
                return j1;
            }
            Chunk chunk = this.func_72964_e(l, i1);
            return chunk.func_76614_a(par1EnumSkyBlock, par2 & 0xF, par3, par4 & 0xF);
        }
        return par1EnumSkyBlock.field_77198_c;
    }

    public int func_72972_b(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        if (par3 < 0) {
            par3 = 0;
        }
        if (par3 >= 256) {
            par3 = 255;
        }
        if (par2 >= -30000000 && par4 >= -30000000 && par2 < 30000000 && par4 < 30000000) {
            int l = par2 >> 4;
            int i1 = par4 >> 4;
            if (!this.func_72916_c(l, i1)) {
                return par1EnumSkyBlock.field_77198_c;
            }
            Chunk chunk = this.func_72964_e(l, i1);
            return chunk.func_76614_a(par1EnumSkyBlock, par2 & 0xF, par3, par4 & 0xF);
        }
        return par1EnumSkyBlock.field_77198_c;
    }

    public void func_72915_b(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4, int par5) {
        if (par2 >= -30000000 && par4 >= -30000000 && par2 < 30000000 && par4 < 30000000 && par3 >= 0 && par3 < 256 && this.func_72916_c(par2 >> 4, par4 >> 4)) {
            Chunk chunk = this.func_72964_e(par2 >> 4, par4 >> 4);
            chunk.func_76633_a(par1EnumSkyBlock, par2 & 0xF, par3, par4 & 0xF, par5);
            for (int i1 = 0; i1 < this.field_73021_x.size(); ++i1) {
                ((IWorldAccess)this.field_73021_x.get(i1)).func_72711_b(par2, par3, par4);
            }
        }
    }

    public void func_72902_n(int par1, int par2, int par3) {
        for (int l = 0; l < this.field_73021_x.size(); ++l) {
            ((IWorldAccess)this.field_73021_x.get(l)).func_72711_b(par1, par2, par3);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72802_i(int par1, int par2, int par3, int par4) {
        int i1 = this.func_72925_a(EnumSkyBlock.Sky, par1, par2, par3);
        int j1 = this.func_72925_a(EnumSkyBlock.Block, par1, par2, par3);
        if (j1 < par4) {
            j1 = par4;
        }
        return i1 << 20 | j1 << 4;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_72808_j(int par1, int par2, int par3, int par4) {
        int i1 = this.func_72957_l(par1, par2, par3);
        if (i1 < par4) {
            i1 = par4;
        }
        return this.field_73011_w.field_76573_f[i1];
    }

    public float func_72801_o(int par1, int par2, int par3) {
        return this.field_73011_w.field_76573_f[this.func_72957_l(par1, par2, par3)];
    }

    public boolean func_72935_r() {
        return this.field_73011_w.isDaytime();
    }

    public MovingObjectPosition func_72933_a(Vec3 par1Vec3, Vec3 par2Vec3) {
        return this.func_72831_a(par1Vec3, par2Vec3, false, false);
    }

    public MovingObjectPosition func_72901_a(Vec3 par1Vec3, Vec3 par2Vec3, boolean par3) {
        return this.func_72831_a(par1Vec3, par2Vec3, par3, false);
    }

    public MovingObjectPosition func_72831_a(Vec3 par1Vec3, Vec3 par2Vec3, boolean par3, boolean par4) {
        if (!(Double.isNaN(par1Vec3.field_72450_a) || Double.isNaN(par1Vec3.field_72448_b) || Double.isNaN(par1Vec3.field_72449_c))) {
            if (!(Double.isNaN(par2Vec3.field_72450_a) || Double.isNaN(par2Vec3.field_72448_b) || Double.isNaN(par2Vec3.field_72449_c))) {
                MovingObjectPosition movingobjectposition;
                int i = MathHelper.func_76128_c((double)par2Vec3.field_72450_a);
                int j = MathHelper.func_76128_c((double)par2Vec3.field_72448_b);
                int k = MathHelper.func_76128_c((double)par2Vec3.field_72449_c);
                int l = MathHelper.func_76128_c((double)par1Vec3.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)par1Vec3.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)par1Vec3.field_72449_c);
                int k1 = this.func_72798_a(l, i1, j1);
                int l1 = this.func_72805_g(l, i1, j1);
                Block block = Block.field_71973_m[k1];
                if (block != null && (!par4 || block == null || block.func_71872_e(this, l, i1, j1) != null) && k1 > 0 && block.func_71913_a(l1, par3) && (movingobjectposition = block.func_71878_a(this, l, i1, j1, par1Vec3, par2Vec3)) != null) {
                    return movingobjectposition;
                }
                k1 = 200;
                while (k1-- >= 0) {
                    MovingObjectPosition movingobjectposition1;
                    int b0;
                    if (Double.isNaN(par1Vec3.field_72450_a) || Double.isNaN(par1Vec3.field_72448_b) || Double.isNaN(par1Vec3.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return null;
                    }
                    boolean flag2 = true;
                    boolean flag3 = true;
                    boolean flag4 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag3 = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag4 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = par2Vec3.field_72450_a - par1Vec3.field_72450_a;
                    double d7 = par2Vec3.field_72448_b - par1Vec3.field_72448_b;
                    double d8 = par2Vec3.field_72449_c - par1Vec3.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - par1Vec3.field_72450_a) / d6;
                    }
                    if (flag3) {
                        d4 = (d1 - par1Vec3.field_72448_b) / d7;
                    }
                    if (flag4) {
                        d5 = (d2 - par1Vec3.field_72449_c) / d8;
                    }
                    boolean flag5 = false;
                    if (d3 < d4 && d3 < d5) {
                        b0 = i > l ? 4 : 5;
                        par1Vec3.field_72450_a = d0;
                        par1Vec3.field_72448_b += d7 * d3;
                        par1Vec3.field_72449_c += d8 * d3;
                    } else if (d4 < d5) {
                        b0 = j > i1 ? 0 : 1;
                        par1Vec3.field_72450_a += d6 * d4;
                        par1Vec3.field_72448_b = d1;
                        par1Vec3.field_72449_c += d8 * d4;
                    } else {
                        b0 = k > j1 ? 2 : 3;
                        par1Vec3.field_72450_a += d6 * d5;
                        par1Vec3.field_72448_b += d7 * d5;
                        par1Vec3.field_72449_c = d2;
                    }
                    Vec3 vec32 = this.func_82732_R().func_72345_a(par1Vec3.field_72450_a, par1Vec3.field_72448_b, par1Vec3.field_72449_c);
                    vec32.field_72450_a = MathHelper.func_76128_c((double)par1Vec3.field_72450_a);
                    l = (int)vec32.field_72450_a;
                    if (b0 == 5) {
                        --l;
                        vec32.field_72450_a += 1.0;
                    }
                    vec32.field_72448_b = MathHelper.func_76128_c((double)par1Vec3.field_72448_b);
                    i1 = (int)vec32.field_72448_b;
                    if (b0 == 1) {
                        --i1;
                        vec32.field_72448_b += 1.0;
                    }
                    vec32.field_72449_c = MathHelper.func_76128_c((double)par1Vec3.field_72449_c);
                    j1 = (int)vec32.field_72449_c;
                    if (b0 == 3) {
                        --j1;
                        vec32.field_72449_c += 1.0;
                    }
                    int i2 = this.func_72798_a(l, i1, j1);
                    int j2 = this.func_72805_g(l, i1, j1);
                    Block block1 = Block.field_71973_m[i2];
                    if (par4 && block1 != null && block1.func_71872_e(this, l, i1, j1) == null || i2 <= 0 || !block1.func_71913_a(j2, par3) || (movingobjectposition1 = block1.func_71878_a(this, l, i1, j1, par1Vec3, par2Vec3)) == null) continue;
                    return movingobjectposition1;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public void func_72956_a(Entity par1Entity, String par2Str, float par3, float par4) {
        PlaySoundAtEntityEvent event = new PlaySoundAtEntityEvent(par1Entity, par2Str, par3, par4);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        par2Str = event.name;
        if (par1Entity != null && par2Str != null) {
            for (int i = 0; i < this.field_73021_x.size(); ++i) {
                ((IWorldAccess)this.field_73021_x.get(i)).func_72704_a(par2Str, par1Entity.field_70165_t, par1Entity.field_70163_u - (double)par1Entity.field_70129_M, par1Entity.field_70161_v, par3, par4);
            }
        }
    }

    public void func_85173_a(EntityPlayer par1EntityPlayer, String par2Str, float par3, float par4) {
        PlaySoundAtEntityEvent event = new PlaySoundAtEntityEvent((Entity)par1EntityPlayer, par2Str, par3, par4);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        par2Str = event.name;
        if (par1EntityPlayer != null && par2Str != null) {
            for (int i = 0; i < this.field_73021_x.size(); ++i) {
                ((IWorldAccess)this.field_73021_x.get(i)).func_85102_a(par1EntityPlayer, par2Str, par1EntityPlayer.field_70165_t, par1EntityPlayer.field_70163_u - (double)par1EntityPlayer.field_70129_M, par1EntityPlayer.field_70161_v, par3, par4);
            }
        }
    }

    public void func_72908_a(double par1, double par3, double par5, String par7Str, float par8, float par9) {
        if (par7Str != null) {
            for (int i = 0; i < this.field_73021_x.size(); ++i) {
                ((IWorldAccess)this.field_73021_x.get(i)).func_72704_a(par7Str, par1, par3, par5, par8, par9);
            }
        }
    }

    public void func_72980_b(double par1, double par3, double par5, String par7Str, float par8, float par9, boolean par10) {
    }

    public void func_72934_a(String par1Str, int par2, int par3, int par4) {
        for (int l = 0; l < this.field_73021_x.size(); ++l) {
            ((IWorldAccess)this.field_73021_x.get(l)).func_72702_a(par1Str, par2, par3, par4);
        }
    }

    public void func_72869_a(String par1Str, double par2, double par4, double par6, double par8, double par10, double par12) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_72708_a(par1Str, par2, par4, par6, par8, par10, par12);
        }
    }

    public boolean func_72942_c(Entity par1Entity) {
        this.field_73007_j.add(par1Entity);
        return true;
    }

    public boolean func_72838_d(Entity par1Entity) {
        int i = MathHelper.func_76128_c((double)(par1Entity.field_70165_t / 16.0));
        int j = MathHelper.func_76128_c((double)(par1Entity.field_70161_v / 16.0));
        boolean flag = par1Entity.field_98038_p;
        if (par1Entity instanceof EntityPlayer) {
            flag = true;
        }
        if (!flag && !this.func_72916_c(i, j)) {
            return false;
        }
        if (par1Entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)par1Entity;
            this.field_73010_i.add(entityplayer);
            this.func_72854_c();
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(par1Entity, this)) && !flag) {
            return false;
        }
        this.func_72964_e(i, j).func_76612_a(par1Entity);
        this.field_72996_f.add(par1Entity);
        this.func_72923_a(par1Entity);
        return true;
    }

    protected void func_72923_a(Entity par1Entity) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_72703_a(par1Entity);
        }
    }

    public void func_72847_b(Entity par1Entity) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldAccess)this.field_73021_x.get(i)).func_72709_b(par1Entity);
        }
    }

    public void func_72900_e(Entity par1Entity) {
        if (par1Entity.field_70153_n != null) {
            par1Entity.field_70153_n.func_70078_a((Entity)null);
        }
        if (par1Entity.field_70154_o != null) {
            par1Entity.func_70078_a((Entity)null);
        }
        par1Entity.func_70106_y();
        if (par1Entity instanceof EntityPlayer) {
            this.field_73010_i.remove(par1Entity);
            this.func_72854_c();
        }
    }

    public void func_72973_f(Entity par1Entity) {
        par1Entity.func_70106_y();
        if (par1Entity instanceof EntityPlayer) {
            this.field_73010_i.remove(par1Entity);
            this.func_72854_c();
        }
        int i = par1Entity.field_70176_ah;
        int j = par1Entity.field_70164_aj;
        if (par1Entity.field_70175_ag && this.func_72916_c(i, j)) {
            this.func_72964_e(i, j).func_76622_b(par1Entity);
        }
        this.field_72996_f.remove(par1Entity);
        this.func_72847_b(par1Entity);
    }

    public void func_72954_a(IWorldAccess par1IWorldAccess) {
        this.field_73021_x.add(par1IWorldAccess);
    }

    public List func_72945_a(Entity par1Entity, AxisAlignedBB par2AxisAlignedBB) {
        this.field_72998_d.clear();
        int i = MathHelper.func_76128_c((double)par2AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par2AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)par2AxisAlignedBB.field_72338_b);
        int l = MathHelper.func_76128_c((double)(par2AxisAlignedBB.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)par2AxisAlignedBB.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(par2AxisAlignedBB.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                if (!this.func_72899_e(k1, 64, l1)) continue;
                for (int i2 = k - 1; i2 < l; ++i2) {
                    Block block = Block.field_71973_m[this.func_72798_a(k1, i2, l1)];
                    if (block == null) continue;
                    block.func_71871_a(this, k1, i2, l1, par2AxisAlignedBB, (List)this.field_72998_d, par1Entity);
                }
            }
        }
        double d0 = 0.25;
        List list = this.func_72839_b(par1Entity, par2AxisAlignedBB.func_72314_b(d0, d0, d0));
        for (int j2 = 0; j2 < list.size(); ++j2) {
            AxisAlignedBB axisalignedbb1 = ((Entity)list.get(j2)).func_70046_E();
            if (axisalignedbb1 != null && axisalignedbb1.func_72326_a(par2AxisAlignedBB)) {
                this.field_72998_d.add(axisalignedbb1);
            }
            if ((axisalignedbb1 = par1Entity.func_70114_g((Entity)list.get(j2))) == null || !axisalignedbb1.func_72326_a(par2AxisAlignedBB)) continue;
            this.field_72998_d.add(axisalignedbb1);
        }
        return this.field_72998_d;
    }

    public List func_72840_a(AxisAlignedBB par1AxisAlignedBB) {
        this.field_72998_d.clear();
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int l = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                if (!this.func_72899_e(k1, 64, l1)) continue;
                for (int i2 = k - 1; i2 < l; ++i2) {
                    Block block = Block.field_71973_m[this.func_72798_a(k1, i2, l1)];
                    if (block == null) continue;
                    block.func_71871_a(this, k1, i2, l1, par1AxisAlignedBB, (List)this.field_72998_d, (Entity)null);
                }
            }
        }
        return this.field_72998_d;
    }

    public int func_72967_a(float par1) {
        float f1 = this.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.5f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        f2 = (float)((double)f2 * (1.0 - (double)(this.func_72867_j(par1) * 5.0f) / 16.0));
        f2 = (float)((double)f2 * (1.0 - (double)(this.func_72819_i(par1) * 5.0f) / 16.0));
        f2 = 1.0f - f2;
        return (int)(f2 * 11.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72848_b(IWorldAccess par1IWorldAccess) {
        this.field_73021_x.remove(par1IWorldAccess);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_72971_b(float par1) {
        float f1 = this.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        f2 = (float)((double)f2 * (1.0 - (double)(this.func_72867_j(par1) * 5.0f) / 16.0));
        f2 = (float)((double)f2 * (1.0 - (double)(this.func_72819_i(par1) * 5.0f) / 16.0));
        return f2 * 0.8f + 0.2f;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_72833_a(Entity par1Entity, float par2) {
        return this.field_73011_w.getSkyColor(par1Entity, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 getSkyColorBody(Entity par1Entity, float par2) {
        float f9;
        float f8;
        float f1 = this.func_72826_c(par2);
        float f2 = MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        int i = MathHelper.func_76128_c((double)par1Entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)par1Entity.field_70161_v);
        int multiplier = ForgeHooksClient.getSkyBlendColour((World)this, (int)i, (int)j);
        float f4 = (float)(multiplier >> 16 & 0xFF) / 255.0f;
        float f5 = (float)(multiplier >> 8 & 0xFF) / 255.0f;
        float f6 = (float)(multiplier & 0xFF) / 255.0f;
        f4 *= f2;
        f5 *= f2;
        f6 *= f2;
        float f7 = this.func_72867_j(par2);
        if (f7 > 0.0f) {
            f8 = (f4 * 0.3f + f5 * 0.59f + f6 * 0.11f) * 0.6f;
            f9 = 1.0f - f7 * 0.75f;
            f4 = f4 * f9 + f8 * (1.0f - f9);
            f5 = f5 * f9 + f8 * (1.0f - f9);
            f6 = f6 * f9 + f8 * (1.0f - f9);
        }
        if ((f8 = this.func_72819_i(par2)) > 0.0f) {
            f9 = (f4 * 0.3f + f5 * 0.59f + f6 * 0.11f) * 0.2f;
            float f10 = 1.0f - f8 * 0.75f;
            f4 = f4 * f10 + f9 * (1.0f - f10);
            f5 = f5 * f10 + f9 * (1.0f - f10);
            f6 = f6 * f10 + f9 * (1.0f - f10);
        }
        if (this.field_73016_r > 0) {
            f9 = (float)this.field_73016_r - par2;
            if (f9 > 1.0f) {
                f9 = 1.0f;
            }
            f4 = f4 * (1.0f - (f9 *= 0.45f)) + 0.8f * f9;
            f5 = f5 * (1.0f - f9) + 0.8f * f9;
            f6 = f6 * (1.0f - f9) + 1.0f * f9;
        }
        return this.func_82732_R().func_72345_a((double)f4, (double)f5, (double)f6);
    }

    public float func_72826_c(float par1) {
        return this.field_73011_w.func_76563_a(this.field_72986_A.func_76073_f(), par1);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72853_d() {
        return this.field_73011_w.func_76559_b(this.field_72986_A.func_76073_f());
    }

    public float func_130001_d() {
        return WorldProvider.field_111203_a[this.field_73011_w.func_76559_b(this.field_72986_A.func_76073_f())];
    }

    public float func_72929_e(float par1) {
        float f1 = this.func_72826_c(par1);
        return f1 * (float)Math.PI * 2.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_72824_f(float par1) {
        return this.field_73011_w.drawClouds(par1);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 drawCloudsBody(float par1) {
        float f8;
        float f7;
        float f1 = this.func_72826_c(par1);
        float f2 = MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = (float)(this.field_73001_c >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.field_73001_c >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.field_73001_c & 0xFFL) / 255.0f;
        float f6 = this.func_72867_j(par1);
        if (f6 > 0.0f) {
            f7 = (f3 * 0.3f + f4 * 0.59f + f5 * 0.11f) * 0.6f;
            f8 = 1.0f - f6 * 0.95f;
            f3 = f3 * f8 + f7 * (1.0f - f8);
            f4 = f4 * f8 + f7 * (1.0f - f8);
            f5 = f5 * f8 + f7 * (1.0f - f8);
        }
        f3 *= f2 * 0.9f + 0.1f;
        f4 *= f2 * 0.9f + 0.1f;
        f5 *= f2 * 0.85f + 0.15f;
        f7 = this.func_72819_i(par1);
        if (f7 > 0.0f) {
            f8 = (f3 * 0.3f + f4 * 0.59f + f5 * 0.11f) * 0.2f;
            float f9 = 1.0f - f7 * 0.95f;
            f3 = f3 * f9 + f8 * (1.0f - f9);
            f4 = f4 * f9 + f8 * (1.0f - f9);
            f5 = f5 * f9 + f8 * (1.0f - f9);
        }
        return this.func_82732_R().func_72345_a((double)f3, (double)f4, (double)f5);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_72948_g(float par1) {
        float f1 = this.func_72826_c(par1);
        return this.field_73011_w.func_76562_b(f1, par1);
    }

    public int func_72874_g(int par1, int par2) {
        return this.func_72938_d(par1, par2).func_76626_d(par1 & 0xF, par2 & 0xF);
    }

    public int func_72825_h(int par1, int par2) {
        Chunk chunk = this.func_72938_d(par1, par2);
        int x = par1;
        int z = par2;
        par1 &= 0xF;
        par2 &= 0xF;
        for (int k = chunk.func_76625_h() + 15; k > 0; --k) {
            int l = chunk.func_76610_a(par1, k, par2);
            if (l == 0 || !Block.field_71973_m[l].field_72018_cp.func_76230_c() || Block.field_71973_m[l].field_72018_cp == Material.field_76257_i || Block.field_71973_m[l].isBlockFoliage(this, x, k, z)) continue;
            return k + 1;
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_72880_h(float par1) {
        return this.field_73011_w.getStarBrightness(par1);
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightnessBody(float par1) {
        float f1 = this.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.5f;
    }

    public void func_72836_a(int par1, int par2, int par3, int par4, int par5) {
    }

    public void func_82740_a(int par1, int par2, int par3, int par4, int par5, int par6) {
    }

    public void func_72892_b(int par1, int par2, int par3, int par4, int par5, int par6) {
    }

    public void func_72939_s() {
        int k;
        CrashReportCategory crashreportcategory;
        CrashReport crashreport;
        Entity entity;
        int i;
        this.field_72984_F.func_76320_a("entities");
        this.field_72984_F.func_76320_a("global");
        for (i = 0; i < this.field_73007_j.size(); ++i) {
            entity = (Entity)this.field_73007_j.get(i);
            try {
                ++entity.field_70173_aa;
                entity.func_70071_h_();
            }
            catch (Throwable throwable) {
                crashreport = CrashReport.func_85055_a(throwable, "Ticking entity");
                crashreportcategory = crashreport.func_85058_a("Entity being ticked");
                if (entity == null) {
                    crashreportcategory.func_71507_a("Entity", "~~NULL~~");
                } else {
                    entity.func_85029_a(crashreportcategory);
                }
                if (ForgeDummyContainer.removeErroringEntities) {
                    FMLLog.severe((String)crashreport.func_71502_e(), (Object[])new Object[0]);
                    this.func_72900_e(entity);
                }
                throw new ReportedException(crashreport);
            }
            if (!entity.field_70128_L) continue;
            this.field_73007_j.remove(i--);
        }
        this.field_72984_F.func_76318_c("remove");
        this.field_72996_f.removeAll(this.field_72997_g);
        for (i = 0; i < this.field_72997_g.size(); ++i) {
            entity = (Entity)this.field_72997_g.get(i);
            int j = entity.field_70176_ah;
            k = entity.field_70164_aj;
            if (!entity.field_70175_ag || !this.func_72916_c(j, k)) continue;
            this.func_72964_e(j, k).func_76622_b(entity);
        }
        for (i = 0; i < this.field_72997_g.size(); ++i) {
            this.func_72847_b((Entity)this.field_72997_g.get(i));
        }
        this.field_72997_g.clear();
        this.field_72984_F.func_76318_c("regular");
        for (i = 0; i < this.field_72996_f.size(); ++i) {
            entity = (Entity)this.field_72996_f.get(i);
            if (entity.field_70154_o != null) {
                if (!entity.field_70154_o.field_70128_L && entity.field_70154_o.field_70153_n == entity) continue;
                entity.field_70154_o.field_70153_n = null;
                entity.field_70154_o = null;
            }
            this.field_72984_F.func_76320_a("tick");
            if (!entity.field_70128_L) {
                try {
                    this.func_72870_g(entity);
                }
                catch (Throwable throwable1) {
                    crashreport = CrashReport.func_85055_a(throwable1, "Ticking entity");
                    crashreportcategory = crashreport.func_85058_a("Entity being ticked");
                    entity.func_85029_a(crashreportcategory);
                    if (ForgeDummyContainer.removeErroringEntities) {
                        FMLLog.severe((String)crashreport.func_71502_e(), (Object[])new Object[0]);
                        this.func_72900_e(entity);
                    }
                    throw new ReportedException(crashreport);
                }
            }
            this.field_72984_F.func_76319_b();
            this.field_72984_F.func_76320_a("remove");
            if (entity.field_70128_L) {
                int j = entity.field_70176_ah;
                k = entity.field_70164_aj;
                if (entity.field_70175_ag && this.func_72916_c(j, k)) {
                    this.func_72964_e(j, k).func_76622_b(entity);
                }
                this.field_72996_f.remove(i--);
                this.func_72847_b(entity);
            }
            this.field_72984_F.func_76319_b();
        }
        this.field_72984_F.func_76318_c("tileEntities");
        this.field_72989_L = true;
        Iterator iterator = this.field_73009_h.iterator();
        while (iterator.hasNext()) {
            Chunk chunk;
            TileEntity tileentity = (TileEntity)iterator.next();
            if (!tileentity.func_70320_p() && tileentity.func_70309_m() && this.func_72899_e(tileentity.field_70329_l, tileentity.field_70330_m, tileentity.field_70327_n)) {
                try {
                    tileentity.func_70316_g();
                }
                catch (Throwable throwable2) {
                    crashreport = CrashReport.func_85055_a(throwable2, "Ticking tile entity");
                    crashreportcategory = crashreport.func_85058_a("Tile entity being ticked");
                    tileentity.func_85027_a(crashreportcategory);
                    if (ForgeDummyContainer.removeErroringTileEntities) {
                        FMLLog.severe((String)crashreport.func_71502_e(), (Object[])new Object[0]);
                        tileentity.func_70313_j();
                        this.func_94571_i(tileentity.field_70329_l, tileentity.field_70330_m, tileentity.field_70327_n);
                    }
                    throw new ReportedException(crashreport);
                }
            }
            if (!tileentity.func_70320_p()) continue;
            iterator.remove();
            if (!this.func_72916_c(tileentity.field_70329_l >> 4, tileentity.field_70327_n >> 4) || (chunk = this.func_72964_e(tileentity.field_70329_l >> 4, tileentity.field_70327_n >> 4)) == null) continue;
            chunk.cleanChunkBlockTileEntity(tileentity.field_70329_l & 0xF, tileentity.field_70330_m, tileentity.field_70327_n & 0xF);
        }
        if (!this.field_73000_b.isEmpty()) {
            for (Object tile : this.field_73000_b) {
                ((TileEntity)tile).onChunkUnload();
            }
            this.field_73009_h.removeAll(this.field_73000_b);
            this.field_73000_b.clear();
        }
        this.field_72989_L = false;
        this.field_72984_F.func_76318_c("pendingTileEntities");
        if (!this.field_73002_a.isEmpty()) {
            for (int l = 0; l < this.field_73002_a.size(); ++l) {
                Chunk chunk1;
                TileEntity tileentity1 = (TileEntity)this.field_73002_a.get(l);
                if (!tileentity1.func_70320_p()) {
                    if (this.field_73009_h.contains(tileentity1)) continue;
                    this.field_73009_h.add(tileentity1);
                    continue;
                }
                if (!this.func_72916_c(tileentity1.field_70329_l >> 4, tileentity1.field_70327_n >> 4) || (chunk1 = this.func_72964_e(tileentity1.field_70329_l >> 4, tileentity1.field_70327_n >> 4)) == null) continue;
                chunk1.cleanChunkBlockTileEntity(tileentity1.field_70329_l & 0xF, tileentity1.field_70330_m, tileentity1.field_70327_n & 0xF);
            }
            this.field_73002_a.clear();
        }
        this.field_72984_F.func_76319_b();
        this.field_72984_F.func_76319_b();
    }

    public void func_72852_a(Collection par1Collection) {
        List dest = this.field_72989_L ? this.field_73002_a : this.field_73009_h;
        for (Object entity : par1Collection) {
            if (!((TileEntity)entity).canUpdate()) continue;
            dest.add(entity);
        }
    }

    public void func_72870_g(Entity par1Entity) {
        this.func_72866_a(par1Entity, true);
    }

    public void func_72866_a(Entity par1Entity, boolean par2) {
        boolean canUpdate;
        int i = MathHelper.func_76128_c((double)par1Entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)par1Entity.field_70161_v);
        boolean isForced = this.getPersistentChunks().containsKey((Object)new ChunkCoordIntPair(i >> 4, j >> 4));
        int b0 = isForced ? 0 : 32;
        boolean bl = canUpdate = !par2 || this.func_72904_c(i - b0, 0, j - b0, i + b0, 0, j + b0);
        if (!canUpdate) {
            EntityEvent.CanUpdate event = new EntityEvent.CanUpdate(par1Entity);
            MinecraftForge.EVENT_BUS.post((Event)event);
            canUpdate = event.canUpdate;
        }
        if (canUpdate) {
            par1Entity.field_70142_S = par1Entity.field_70165_t;
            par1Entity.field_70137_T = par1Entity.field_70163_u;
            par1Entity.field_70136_U = par1Entity.field_70161_v;
            par1Entity.field_70126_B = par1Entity.field_70177_z;
            par1Entity.field_70127_C = par1Entity.field_70125_A;
            if (par2 && par1Entity.field_70175_ag) {
                ++par1Entity.field_70173_aa;
                if (par1Entity.field_70154_o != null) {
                    par1Entity.func_70098_U();
                } else {
                    par1Entity.func_70071_h_();
                }
            }
            this.field_72984_F.func_76320_a("chunkCheck");
            if (Double.isNaN(par1Entity.field_70165_t) || Double.isInfinite(par1Entity.field_70165_t)) {
                par1Entity.field_70165_t = par1Entity.field_70142_S;
            }
            if (Double.isNaN(par1Entity.field_70163_u) || Double.isInfinite(par1Entity.field_70163_u)) {
                par1Entity.field_70163_u = par1Entity.field_70137_T;
            }
            if (Double.isNaN(par1Entity.field_70161_v) || Double.isInfinite(par1Entity.field_70161_v)) {
                par1Entity.field_70161_v = par1Entity.field_70136_U;
            }
            if (Double.isNaN(par1Entity.field_70125_A) || Double.isInfinite(par1Entity.field_70125_A)) {
                par1Entity.field_70125_A = par1Entity.field_70127_C;
            }
            if (Double.isNaN(par1Entity.field_70177_z) || Double.isInfinite(par1Entity.field_70177_z)) {
                par1Entity.field_70177_z = par1Entity.field_70126_B;
            }
            int k = MathHelper.func_76128_c((double)(par1Entity.field_70165_t / 16.0));
            int l = MathHelper.func_76128_c((double)(par1Entity.field_70163_u / 16.0));
            int i1 = MathHelper.func_76128_c((double)(par1Entity.field_70161_v / 16.0));
            if (!par1Entity.field_70175_ag || par1Entity.field_70176_ah != k || par1Entity.field_70162_ai != l || par1Entity.field_70164_aj != i1) {
                if (par1Entity.field_70175_ag && this.func_72916_c(par1Entity.field_70176_ah, par1Entity.field_70164_aj)) {
                    this.func_72964_e(par1Entity.field_70176_ah, par1Entity.field_70164_aj).func_76608_a(par1Entity, par1Entity.field_70162_ai);
                }
                if (this.func_72916_c(k, i1)) {
                    par1Entity.field_70175_ag = true;
                    this.func_72964_e(k, i1).func_76612_a(par1Entity);
                } else {
                    par1Entity.field_70175_ag = false;
                }
            }
            this.field_72984_F.func_76319_b();
            if (par2 && par1Entity.field_70175_ag && par1Entity.field_70153_n != null) {
                if (!par1Entity.field_70153_n.field_70128_L && par1Entity.field_70153_n.field_70154_o == par1Entity) {
                    this.func_72870_g(par1Entity.field_70153_n);
                } else {
                    par1Entity.field_70153_n.field_70154_o = null;
                    par1Entity.field_70153_n = null;
                }
            }
        }
    }

    public boolean func_72855_b(AxisAlignedBB par1AxisAlignedBB) {
        return this.func_72917_a(par1AxisAlignedBB, null);
    }

    public boolean func_72917_a(AxisAlignedBB par1AxisAlignedBB, Entity par2Entity) {
        List list = this.func_72839_b(null, par1AxisAlignedBB);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity1 = (Entity)list.get(i);
            if (entity1.field_70128_L || !entity1.field_70156_m || entity1 == par2Entity) continue;
            return false;
        }
        return true;
    }

    public boolean func_72829_c(AxisAlignedBB par1AxisAlignedBB) {
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int l = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + 1.0));
        if (par1AxisAlignedBB.field_72340_a < 0.0) {
            --i;
        }
        if (par1AxisAlignedBB.field_72338_b < 0.0) {
            --k;
        }
        if (par1AxisAlignedBB.field_72339_c < 0.0) {
            --i1;
        }
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.field_71973_m[this.func_72798_a(k1, l1, i2)];
                    if (block == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_72953_d(AxisAlignedBB par1AxisAlignedBB) {
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int l = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + 1.0));
        if (par1AxisAlignedBB.field_72340_a < 0.0) {
            --i;
        }
        if (par1AxisAlignedBB.field_72338_b < 0.0) {
            --k;
        }
        if (par1AxisAlignedBB.field_72339_c < 0.0) {
            --i1;
        }
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.field_71973_m[this.func_72798_a(k1, l1, i2)];
                    if (block == null || !block.field_72018_cp.func_76224_d()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_72978_e(AxisAlignedBB par1AxisAlignedBB) {
        int j1;
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int l = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        if (this.func_72904_c(i, k, i1, j, l, j1 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + 1.0)))) {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        int j2 = this.func_72798_a(k1, l1, i2);
                        if (j2 == Block.field_72067_ar.field_71990_ca || j2 == Block.field_71944_C.field_71990_ca || j2 == Block.field_71938_D.field_71990_ca) {
                            return true;
                        }
                        Block block = Block.field_71973_m[j2];
                        if (block == null || !block.isBlockBurning(this, k1, l1, i2)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean func_72918_a(AxisAlignedBB par1AxisAlignedBB, Material par2Material, Entity par3Entity) {
        int j1;
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int l = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        if (!this.func_72904_c(i, k, i1, j, l, j1 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + 1.0)))) {
            return false;
        }
        boolean flag = false;
        Vec3 vec3 = this.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    double d0;
                    Block block = Block.field_71973_m[this.func_72798_a(k1, l1, i2)];
                    if (block == null || block.field_72018_cp != par2Material || !((double)l >= (d0 = (double)((float)(l1 + 1) - BlockFluid.func_72199_d((int)this.func_72805_g(k1, l1, i2)))))) continue;
                    flag = true;
                    block.func_71901_a(this, k1, l1, i2, par3Entity, vec3);
                }
            }
        }
        if (vec3.func_72433_c() > 0.0 && par3Entity.func_96092_aw()) {
            vec3 = vec3.func_72432_b();
            double d1 = 0.014;
            par3Entity.field_70159_w += vec3.field_72450_a * d1;
            par3Entity.field_70181_x += vec3.field_72448_b * d1;
            par3Entity.field_70179_y += vec3.field_72449_c * d1;
        }
        return flag;
    }

    public boolean func_72875_a(AxisAlignedBB par1AxisAlignedBB, Material par2Material) {
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int l = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.field_71973_m[this.func_72798_a(k1, l1, i2)];
                    if (block == null || block.field_72018_cp != par2Material) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_72830_b(AxisAlignedBB par1AxisAlignedBB, Material par2Material) {
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int l = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.field_71973_m[this.func_72798_a(k1, l1, i2)];
                    if (block == null || block.field_72018_cp != par2Material) continue;
                    int j2 = this.func_72805_g(k1, l1, i2);
                    double d0 = l1 + 1;
                    if (j2 < 8) {
                        d0 = (double)(l1 + 1) - (double)j2 / 8.0;
                    }
                    if (!(d0 >= par1AxisAlignedBB.field_72338_b)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Explosion func_72876_a(Entity par1Entity, double par2, double par4, double par6, float par8, boolean par9) {
        return this.func_72885_a(par1Entity, par2, par4, par6, par8, false, par9);
    }

    public Explosion func_72885_a(Entity par1Entity, double par2, double par4, double par6, float par8, boolean par9, boolean par10) {
        Explosion explosion = new Explosion(this, par1Entity, par2, par4, par6, par8);
        explosion.field_77286_a = par9;
        explosion.field_82755_b = par10;
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return explosion;
    }

    public float func_72842_a(Vec3 par1Vec3, AxisAlignedBB par2AxisAlignedBB) {
        double d0 = 1.0 / ((par2AxisAlignedBB.field_72336_d - par2AxisAlignedBB.field_72340_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((par2AxisAlignedBB.field_72337_e - par2AxisAlignedBB.field_72338_b) * 2.0 + 1.0);
        double d2 = 1.0 / ((par2AxisAlignedBB.field_72334_f - par2AxisAlignedBB.field_72339_c) * 2.0 + 1.0);
        int i = 0;
        int j = 0;
        float f = 0.0f;
        while (f <= 1.0f) {
            float f1 = 0.0f;
            while (f1 <= 1.0f) {
                float f2 = 0.0f;
                while (f2 <= 1.0f) {
                    double d3 = par2AxisAlignedBB.field_72340_a + (par2AxisAlignedBB.field_72336_d - par2AxisAlignedBB.field_72340_a) * (double)f;
                    double d4 = par2AxisAlignedBB.field_72338_b + (par2AxisAlignedBB.field_72337_e - par2AxisAlignedBB.field_72338_b) * (double)f1;
                    double d5 = par2AxisAlignedBB.field_72339_c + (par2AxisAlignedBB.field_72334_f - par2AxisAlignedBB.field_72339_c) * (double)f2;
                    if (this.func_72933_a(this.func_82732_R().func_72345_a(d3, d4, d5), par1Vec3) == null) {
                        ++i;
                    }
                    ++j;
                    f2 = (float)((double)f2 + d2);
                }
                f1 = (float)((double)f1 + d1);
            }
            f = (float)((double)f + d0);
        }
        return (float)i / (float)j;
    }

    public boolean func_72886_a(EntityPlayer par1EntityPlayer, int par2, int par3, int par4, int par5) {
        if (par5 == 0) {
            --par3;
        }
        if (par5 == 1) {
            ++par3;
        }
        if (par5 == 2) {
            --par4;
        }
        if (par5 == 3) {
            ++par4;
        }
        if (par5 == 4) {
            --par2;
        }
        if (par5 == 5) {
            ++par2;
        }
        if (this.func_72798_a(par2, par3, par4) == Block.field_72067_ar.field_71990_ca) {
            this.func_72889_a(par1EntityPlayer, 1004, par2, par3, par4, 0);
            this.func_94571_i(par2, par3, par4);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_72981_t() {
        return "All: " + this.field_72996_f.size();
    }

    @SideOnly(value=Side.CLIENT)
    public String func_72827_u() {
        return this.field_73020_y.func_73148_d();
    }

    public TileEntity func_72796_p(int par1, int par2, int par3) {
        if (par2 >= 0 && par2 < 256) {
            Chunk chunk;
            TileEntity tileentity1;
            int l;
            TileEntity tileentity = null;
            if (this.field_72989_L) {
                for (l = 0; l < this.field_73002_a.size(); ++l) {
                    tileentity1 = (TileEntity)this.field_73002_a.get(l);
                    if (tileentity1.func_70320_p() || tileentity1.field_70329_l != par1 || tileentity1.field_70330_m != par2 || tileentity1.field_70327_n != par3) continue;
                    tileentity = tileentity1;
                    break;
                }
            }
            if (tileentity == null && (chunk = this.func_72964_e(par1 >> 4, par3 >> 4)) != null) {
                tileentity = chunk.func_76597_e(par1 & 0xF, par2, par3 & 0xF);
            }
            if (tileentity == null) {
                for (l = 0; l < this.field_73002_a.size(); ++l) {
                    tileentity1 = (TileEntity)this.field_73002_a.get(l);
                    if (tileentity1.func_70320_p() || tileentity1.field_70329_l != par1 || tileentity1.field_70330_m != par2 || tileentity1.field_70327_n != par3) continue;
                    tileentity = tileentity1;
                    break;
                }
            }
            return tileentity;
        }
        return null;
    }

    public void func_72837_a(int par1, int par2, int par3, TileEntity par4TileEntity) {
        Chunk chunk;
        if (par4TileEntity == null || par4TileEntity.func_70320_p()) {
            return;
        }
        if (par4TileEntity.canUpdate()) {
            if (this.field_72989_L) {
                Iterator iterator = this.field_73002_a.iterator();
                while (iterator.hasNext()) {
                    TileEntity tileentity1 = (TileEntity)iterator.next();
                    if (tileentity1.field_70329_l != par1 || tileentity1.field_70330_m != par2 || tileentity1.field_70327_n != par3) continue;
                    tileentity1.func_70313_j();
                    iterator.remove();
                }
                this.field_73002_a.add(par4TileEntity);
            } else {
                this.field_73009_h.add(par4TileEntity);
            }
        }
        if ((chunk = this.func_72964_e(par1 >> 4, par3 >> 4)) != null) {
            chunk.func_76604_a(par1 & 0xF, par2, par3 & 0xF, par4TileEntity);
        }
        this.func_96440_m(par1, par2, par3, 0);
    }

    public void func_72932_q(int par1, int par2, int par3) {
        Chunk chunk = this.func_72964_e(par1 >> 4, par3 >> 4);
        if (chunk != null) {
            chunk.func_76627_f(par1 & 0xF, par2, par3 & 0xF);
        }
        this.func_96440_m(par1, par2, par3, 0);
    }

    public void func_72928_a(TileEntity par1TileEntity) {
        this.field_73000_b.add(par1TileEntity);
    }

    public boolean func_72804_r(int par1, int par2, int par3) {
        Block block = Block.field_71973_m[this.func_72798_a(par1, par2, par3)];
        return block == null ? false : block.func_71926_d();
    }

    public boolean func_72809_s(int par1, int par2, int par3) {
        Block block = Block.field_71973_m[this.func_72798_a(par1, par2, par3)];
        return block != null && block.isBlockNormalCube(this, par1, par2, par3);
    }

    public boolean func_85174_u(int par1, int par2, int par3) {
        int l = this.func_72798_a(par1, par2, par3);
        if (l != 0 && Block.field_71973_m[l] != null) {
            AxisAlignedBB axisalignedbb = Block.field_71973_m[l].func_71872_e(this, par1, par2, par3);
            return axisalignedbb != null && axisalignedbb.func_72320_b() >= 1.0;
        }
        return false;
    }

    public boolean func_72797_t(int par1, int par2, int par3) {
        return this.isBlockSolidOnSide(par1, par2, par3, ForgeDirection.UP);
    }

    @Deprecated
    public boolean func_102026_a(Block par1Block, int par2) {
        return par1Block == null ? false : (par1Block.field_72018_cp.func_76218_k() && par1Block.func_71886_c() ? true : (par1Block instanceof BlockStairs ? (par2 & 4) == 4 : (par1Block instanceof BlockHalfSlab ? (par2 & 8) == 8 : (par1Block instanceof BlockHopper ? true : (par1Block instanceof BlockSnow ? (par2 & 7) == 7 : false)))));
    }

    public boolean func_72887_b(int par1, int par2, int par3, boolean par4) {
        if (par1 >= -30000000 && par3 >= -30000000 && par1 < 30000000 && par3 < 30000000) {
            Chunk chunk = this.field_73020_y.func_73154_d(par1 >> 4, par3 >> 4);
            if (chunk != null && !chunk.func_76621_g()) {
                Block block = Block.field_71973_m[this.func_72798_a(par1, par2, par3)];
                return block == null ? false : this.func_72809_s(par1, par2, par3);
            }
            return par4;
        }
        return par4;
    }

    public void func_72966_v() {
        int i = this.func_72967_a(1.0f);
        if (i != this.field_73008_k) {
            this.field_73008_k = i;
        }
    }

    public void func_72891_a(boolean par1, boolean par2) {
        this.field_73011_w.setAllowedSpawnTypes(par1, par2);
    }

    public void func_72835_b() {
        this.func_72979_l();
    }

    private void func_72947_a() {
        this.field_73011_w.calculateInitialWeather();
    }

    public void calculateInitialWeatherBody() {
        if (this.field_72986_A.func_76059_o()) {
            this.field_73004_o = 1.0f;
            if (this.field_72986_A.func_76061_m()) {
                this.field_73017_q = 1.0f;
            }
        }
    }

    protected void func_72979_l() {
        this.field_73011_w.updateWeather();
    }

    public void updateWeatherBody() {
        if (!this.field_73011_w.field_76576_e) {
            int i = this.field_72986_A.func_76071_n();
            if (i <= 0) {
                if (this.field_72986_A.func_76061_m()) {
                    this.field_72986_A.func_76090_f(this.field_73012_v.nextInt(12000) + 3600);
                } else {
                    this.field_72986_A.func_76090_f(this.field_73012_v.nextInt(168000) + 12000);
                }
            } else {
                this.field_72986_A.func_76090_f(--i);
                if (i <= 0) {
                    this.field_72986_A.func_76069_a(!this.field_72986_A.func_76061_m());
                }
            }
            int j = this.field_72986_A.func_76083_p();
            if (j <= 0) {
                if (this.field_72986_A.func_76059_o()) {
                    this.field_72986_A.func_76080_g(this.field_73012_v.nextInt(12000) + 12000);
                } else {
                    this.field_72986_A.func_76080_g(this.field_73012_v.nextInt(168000) + 12000);
                }
            } else {
                this.field_72986_A.func_76080_g(--j);
                if (j <= 0) {
                    this.field_72986_A.func_76084_b(!this.field_72986_A.func_76059_o());
                }
            }
            this.field_73003_n = this.field_73004_o;
            this.field_73004_o = this.field_72986_A.func_76059_o() ? (float)((double)this.field_73004_o + 0.01) : (float)((double)this.field_73004_o - 0.01);
            if (this.field_73004_o < 0.0f) {
                this.field_73004_o = 0.0f;
            }
            if (this.field_73004_o > 1.0f) {
                this.field_73004_o = 1.0f;
            }
            this.field_73018_p = this.field_73017_q;
            this.field_73017_q = this.field_72986_A.func_76061_m() ? (float)((double)this.field_73017_q + 0.01) : (float)((double)this.field_73017_q - 0.01);
            if (this.field_73017_q < 0.0f) {
                this.field_73017_q = 0.0f;
            }
            if (this.field_73017_q > 1.0f) {
                this.field_73017_q = 1.0f;
            }
        }
    }

    public void func_72913_w() {
        this.field_73011_w.toggleRain();
    }

    protected void func_72903_x() {
        int k;
        int j;
        EntityPlayer entityplayer;
        int i;
        this.field_72993_I.clear();
        this.field_72993_I.addAll(this.getPersistentChunks().keySet());
        this.field_72984_F.func_76320_a("buildList");
        for (i = 0; i < this.field_73010_i.size(); ++i) {
            entityplayer = (EntityPlayer)((Object)this.field_73010_i.get(i));
            j = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            int b0 = 7;
            for (int l = -b0; l <= b0; ++l) {
                for (int i1 = -b0; i1 <= b0; ++i1) {
                    this.field_72993_I.add(new ChunkCoordIntPair(l + j, i1 + k));
                }
            }
        }
        this.field_72984_F.func_76319_b();
        if (this.field_72990_M > 0) {
            --this.field_72990_M;
        }
        this.field_72984_F.func_76320_a("playerCheckLight");
        if (!this.field_73010_i.isEmpty()) {
            i = this.field_73012_v.nextInt(this.field_73010_i.size());
            entityplayer = (EntityPlayer)((Object)this.field_73010_i.get(i));
            j = MathHelper.func_76128_c((double)entityplayer.field_70165_t) + this.field_73012_v.nextInt(11) - 5;
            k = MathHelper.func_76128_c((double)entityplayer.field_70163_u) + this.field_73012_v.nextInt(11) - 5;
            int j1 = MathHelper.func_76128_c((double)entityplayer.field_70161_v) + this.field_73012_v.nextInt(11) - 5;
            this.func_72969_x(j, k, j1);
        }
        this.field_72984_F.func_76319_b();
    }

    protected void func_72941_a(int par1, int par2, Chunk par3Chunk) {
        this.field_72984_F.func_76318_c("moodSound");
        if (this.field_72990_M == 0 && !this.field_72995_K) {
            EntityPlayer entityplayer;
            this.field_73005_l = this.field_73005_l * 3 + 1013904223;
            int k = this.field_73005_l >> 2;
            int l = k & 0xF;
            int i1 = k >> 8 & 0xF;
            int j1 = k >> 16 & 0x7F;
            int k1 = par3Chunk.func_76610_a(l, j1, i1);
            if (k1 == 0 && this.func_72883_k(l += par1, j1, i1 += par2) <= this.field_73012_v.nextInt(8) && this.func_72972_b(EnumSkyBlock.Sky, l, j1, i1) <= 0 && (entityplayer = this.func_72977_a((double)l + 0.5, (double)j1 + 0.5, (double)i1 + 0.5, 8.0)) != null && entityplayer.func_70092_e((double)l + 0.5, (double)j1 + 0.5, (double)i1 + 0.5) > 4.0) {
                this.func_72908_a((double)l + 0.5, (double)j1 + 0.5, (double)i1 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.field_73012_v.nextFloat() * 0.2f);
                this.field_72990_M = this.field_73012_v.nextInt(12000) + 6000;
            }
        }
        this.field_72984_F.func_76318_c("checkLight");
        par3Chunk.func_76594_o();
    }

    protected void func_72893_g() {
        this.func_72903_x();
    }

    public boolean func_72884_u(int par1, int par2, int par3) {
        return this.func_72834_c(par1, par2, par3, false);
    }

    public boolean func_72850_v(int par1, int par2, int par3) {
        return this.func_72834_c(par1, par2, par3, true);
    }

    public boolean func_72834_c(int par1, int par2, int par3, boolean par4) {
        return this.field_73011_w.canBlockFreeze(par1, par2, par3, par4);
    }

    public boolean canBlockFreezeBody(int par1, int par2, int par3, boolean par4) {
        int l;
        BiomeGenBase biomegenbase = this.func_72807_a(par1, par3);
        float f = biomegenbase.func_76743_j();
        if (f > 0.15f) {
            return false;
        }
        if (par2 >= 0 && par2 < 256 && this.func_72972_b(EnumSkyBlock.Block, par1, par2, par3) < 10 && ((l = this.func_72798_a(par1, par2, par3)) == Block.field_71943_B.field_71990_ca || l == Block.field_71942_A.field_71990_ca) && this.func_72805_g(par1, par2, par3) == 0) {
            if (!par4) {
                return true;
            }
            boolean flag1 = true;
            if (flag1 && this.func_72803_f(par1 - 1, par2, par3) != Material.field_76244_g) {
                flag1 = false;
            }
            if (flag1 && this.func_72803_f(par1 + 1, par2, par3) != Material.field_76244_g) {
                flag1 = false;
            }
            if (flag1 && this.func_72803_f(par1, par2, par3 - 1) != Material.field_76244_g) {
                flag1 = false;
            }
            if (flag1 && this.func_72803_f(par1, par2, par3 + 1) != Material.field_76244_g) {
                flag1 = false;
            }
            if (!flag1) {
                return true;
            }
        }
        return false;
    }

    public boolean func_72858_w(int par1, int par2, int par3) {
        return this.field_73011_w.canSnowAt(par1, par2, par3);
    }

    public boolean canSnowAtBody(int par1, int par2, int par3) {
        BiomeGenBase biomegenbase = this.func_72807_a(par1, par3);
        float f = biomegenbase.func_76743_j();
        if (f > 0.15f) {
            return false;
        }
        if (par2 >= 0 && par2 < 256 && this.func_72972_b(EnumSkyBlock.Block, par1, par2, par3) < 10) {
            int l = this.func_72798_a(par1, par2 - 1, par3);
            int i1 = this.func_72798_a(par1, par2, par3);
            if (i1 == 0 && Block.field_72037_aS.func_71930_b(this, par1, par2, par3) && l != 0 && l != Block.field_72036_aT.field_71990_ca && Block.field_71973_m[l].field_72018_cp.func_76230_c()) {
                return true;
            }
        }
        return false;
    }

    public void func_72969_x(int par1, int par2, int par3) {
        if (!this.field_73011_w.field_76576_e) {
            this.func_72936_c(EnumSkyBlock.Sky, par1, par2, par3);
        }
        this.func_72936_c(EnumSkyBlock.Block, par1, par2, par3);
    }

    private int func_98179_a(int par1, int par2, int par3, EnumSkyBlock par4EnumSkyBlock) {
        int j1;
        if (par4EnumSkyBlock == EnumSkyBlock.Sky && this.func_72937_j(par1, par2, par3)) {
            return 15;
        }
        int l = this.func_72798_a(par1, par2, par3);
        Block block = Block.field_71973_m[l];
        int blockLight = block == null ? 0 : block.getLightValue((IBlockAccess)this, par1, par2, par3);
        int i1 = par4EnumSkyBlock == EnumSkyBlock.Sky ? 0 : blockLight;
        int n = j1 = block == null ? 0 : block.getLightOpacity(this, par1, par2, par3);
        if (j1 >= 15 && blockLight > 0) {
            j1 = 1;
        }
        if (j1 < 1) {
            j1 = 1;
        }
        if (j1 >= 15) {
            return 0;
        }
        if (i1 >= 14) {
            return i1;
        }
        for (int k1 = 0; k1 < 6; ++k1) {
            int l1 = par1 + Facing.field_71586_b[k1];
            int i2 = par2 + Facing.field_71587_c[k1];
            int j2 = par3 + Facing.field_71585_d[k1];
            int k2 = this.func_72972_b(par4EnumSkyBlock, l1, i2, j2) - j1;
            if (k2 > i1) {
                i1 = k2;
            }
            if (i1 < 14) continue;
            return i1;
        }
        return i1;
    }

    public void func_72936_c(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        if (this.func_72873_a(par2, par3, par4, 17)) {
            int k3;
            int l3;
            int j3;
            int i3;
            int l2;
            int k2;
            int j2;
            int i2;
            int l1;
            int l = 0;
            int i1 = 0;
            this.field_72984_F.func_76320_a("getBrightness");
            int j1 = this.func_72972_b(par1EnumSkyBlock, par2, par3, par4);
            int k1 = this.func_98179_a(par2, par3, par4, par1EnumSkyBlock);
            if (k1 > j1) {
                this.field_72994_J[i1++] = 133152;
            } else if (k1 < j1) {
                this.field_72994_J[i1++] = 0x20820 | j1 << 18;
                while (l < i1) {
                    l1 = this.field_72994_J[l++];
                    i2 = (l1 & 0x3F) - 32 + par2;
                    j2 = (l1 >> 6 & 0x3F) - 32 + par3;
                    k2 = (l1 >> 12 & 0x3F) - 32 + par4;
                    l2 = l1 >> 18 & 0xF;
                    i3 = this.func_72972_b(par1EnumSkyBlock, i2, j2, k2);
                    if (i3 != l2) continue;
                    this.func_72915_b(par1EnumSkyBlock, i2, j2, k2, 0);
                    if (l2 <= 0 || (j3 = MathHelper.func_76130_a((int)(i2 - par2))) + (l3 = MathHelper.func_76130_a((int)(j2 - par3))) + (k3 = MathHelper.func_76130_a((int)(k2 - par4))) >= 17) continue;
                    for (int i4 = 0; i4 < 6; ++i4) {
                        int j4 = i2 + Facing.field_71586_b[i4];
                        int k4 = j2 + Facing.field_71587_c[i4];
                        int l4 = k2 + Facing.field_71585_d[i4];
                        Block block = Block.field_71973_m[this.func_72798_a(j4, k4, l4)];
                        int blockOpacity = block == null ? 0 : block.getLightOpacity(this, j4, k4, l4);
                        int i5 = Math.max(1, blockOpacity);
                        i3 = this.func_72972_b(par1EnumSkyBlock, j4, k4, l4);
                        if (i3 != l2 - i5 || i1 >= this.field_72994_J.length) continue;
                        this.field_72994_J[i1++] = j4 - par2 + 32 | k4 - par3 + 32 << 6 | l4 - par4 + 32 << 12 | l2 - i5 << 18;
                    }
                }
                l = 0;
            }
            this.field_72984_F.func_76319_b();
            this.field_72984_F.func_76320_a("checkedPosition < toCheckCount");
            while (l < i1) {
                boolean flag;
                l1 = this.field_72994_J[l++];
                i2 = (l1 & 0x3F) - 32 + par2;
                j2 = (l1 >> 6 & 0x3F) - 32 + par3;
                k2 = (l1 >> 12 & 0x3F) - 32 + par4;
                l2 = this.func_72972_b(par1EnumSkyBlock, i2, j2, k2);
                i3 = this.func_98179_a(i2, j2, k2, par1EnumSkyBlock);
                if (i3 == l2) continue;
                this.func_72915_b(par1EnumSkyBlock, i2, j2, k2, i3);
                if (i3 <= l2) continue;
                j3 = Math.abs(i2 - par2);
                l3 = Math.abs(j2 - par3);
                k3 = Math.abs(k2 - par4);
                boolean bl = flag = i1 < this.field_72994_J.length - 6;
                if (j3 + l3 + k3 >= 17 || !flag) continue;
                if (this.func_72972_b(par1EnumSkyBlock, i2 - 1, j2, k2) < i3) {
                    this.field_72994_J[i1++] = i2 - 1 - par2 + 32 + (j2 - par3 + 32 << 6) + (k2 - par4 + 32 << 12);
                }
                if (this.func_72972_b(par1EnumSkyBlock, i2 + 1, j2, k2) < i3) {
                    this.field_72994_J[i1++] = i2 + 1 - par2 + 32 + (j2 - par3 + 32 << 6) + (k2 - par4 + 32 << 12);
                }
                if (this.func_72972_b(par1EnumSkyBlock, i2, j2 - 1, k2) < i3) {
                    this.field_72994_J[i1++] = i2 - par2 + 32 + (j2 - 1 - par3 + 32 << 6) + (k2 - par4 + 32 << 12);
                }
                if (this.func_72972_b(par1EnumSkyBlock, i2, j2 + 1, k2) < i3) {
                    this.field_72994_J[i1++] = i2 - par2 + 32 + (j2 + 1 - par3 + 32 << 6) + (k2 - par4 + 32 << 12);
                }
                if (this.func_72972_b(par1EnumSkyBlock, i2, j2, k2 - 1) < i3) {
                    this.field_72994_J[i1++] = i2 - par2 + 32 + (j2 - par3 + 32 << 6) + (k2 - 1 - par4 + 32 << 12);
                }
                if (this.func_72972_b(par1EnumSkyBlock, i2, j2, k2 + 1) >= i3) continue;
                this.field_72994_J[i1++] = i2 - par2 + 32 + (j2 - par3 + 32 << 6) + (k2 + 1 - par4 + 32 << 12);
            }
            this.field_72984_F.func_76319_b();
        }
    }

    public boolean func_72955_a(boolean par1) {
        return false;
    }

    public List func_72920_a(Chunk par1Chunk, boolean par2) {
        return null;
    }

    public List func_72839_b(Entity par1Entity, AxisAlignedBB par2AxisAlignedBB) {
        return this.func_94576_a(par1Entity, par2AxisAlignedBB, null);
    }

    public List func_94576_a(Entity par1Entity, AxisAlignedBB par2AxisAlignedBB, IEntitySelector par3IEntitySelector) {
        ArrayList arraylist = new ArrayList();
        int i = MathHelper.func_76128_c((double)((par2AxisAlignedBB.field_72340_a - MAX_ENTITY_RADIUS) / 16.0));
        int j = MathHelper.func_76128_c((double)((par2AxisAlignedBB.field_72336_d + MAX_ENTITY_RADIUS) / 16.0));
        int k = MathHelper.func_76128_c((double)((par2AxisAlignedBB.field_72339_c - MAX_ENTITY_RADIUS) / 16.0));
        int l = MathHelper.func_76128_c((double)((par2AxisAlignedBB.field_72334_f + MAX_ENTITY_RADIUS) / 16.0));
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (!this.func_72916_c(i1, j1)) continue;
                this.func_72964_e(i1, j1).func_76588_a(par1Entity, par2AxisAlignedBB, arraylist, par3IEntitySelector);
            }
        }
        return arraylist;
    }

    public List func_72872_a(Class par1Class, AxisAlignedBB par2AxisAlignedBB) {
        return this.func_82733_a(par1Class, par2AxisAlignedBB, null);
    }

    public List func_82733_a(Class par1Class, AxisAlignedBB par2AxisAlignedBB, IEntitySelector par3IEntitySelector) {
        int i = MathHelper.func_76128_c((double)((par2AxisAlignedBB.field_72340_a - MAX_ENTITY_RADIUS) / 16.0));
        int j = MathHelper.func_76128_c((double)((par2AxisAlignedBB.field_72336_d + MAX_ENTITY_RADIUS) / 16.0));
        int k = MathHelper.func_76128_c((double)((par2AxisAlignedBB.field_72339_c - MAX_ENTITY_RADIUS) / 16.0));
        int l = MathHelper.func_76128_c((double)((par2AxisAlignedBB.field_72334_f + MAX_ENTITY_RADIUS) / 16.0));
        ArrayList arraylist = new ArrayList();
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (!this.func_72916_c(i1, j1)) continue;
                this.func_72964_e(i1, j1).func_76618_a(par1Class, par2AxisAlignedBB, arraylist, par3IEntitySelector);
            }
        }
        return arraylist;
    }

    public Entity func_72857_a(Class par1Class, AxisAlignedBB par2AxisAlignedBB, Entity par3Entity) {
        List list = this.func_72872_a(par1Class, par2AxisAlignedBB);
        Entity entity1 = null;
        double d0 = Double.MAX_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            Entity entity2 = (Entity)list.get(i);
            if (entity2 == par3Entity || !((d1 = par3Entity.func_70068_e(entity2)) <= d0)) continue;
            entity1 = entity2;
            d0 = d1;
        }
        return entity1;
    }

    public abstract Entity func_73045_a(int var1);

    @SideOnly(value=Side.CLIENT)
    public List func_72910_y() {
        return this.field_72996_f;
    }

    public void func_72944_b(int par1, int par2, int par3, TileEntity par4TileEntity) {
        if (this.func_72899_e(par1, par2, par3)) {
            this.func_72938_d(par1, par3).func_76630_e();
        }
    }

    public int func_72907_a(Class par1Class) {
        int i = 0;
        for (int j = 0; j < this.field_72996_f.size(); ++j) {
            Entity entity = (Entity)this.field_72996_f.get(j);
            if (entity instanceof EntityLiving && ((EntityLiving)entity).func_104002_bU() || !par1Class.isAssignableFrom(entity.getClass())) continue;
            ++i;
        }
        return i;
    }

    public void func_72868_a(List par1List) {
        for (int i = 0; i < par1List.size(); ++i) {
            Entity entity = (Entity)par1List.get(i);
            if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(entity, this))) continue;
            this.field_72996_f.add(entity);
            this.func_72923_a(entity);
        }
    }

    public void func_72828_b(List par1List) {
        this.field_72997_g.addAll(par1List);
    }

    public boolean func_72931_a(int par1, int par2, int par3, int par4, boolean par5, int par6, Entity par7Entity, ItemStack par8ItemStack) {
        int j1 = this.func_72798_a(par2, par3, par4);
        Block block = Block.field_71973_m[j1];
        Block block1 = Block.field_71973_m[par1];
        AxisAlignedBB axisalignedbb = block1.func_71872_e(this, par2, par3, par4);
        if (par5) {
            axisalignedbb = null;
        }
        if (axisalignedbb != null && !this.func_72917_a(axisalignedbb, par7Entity)) {
            return false;
        }
        if (block != null && (block == Block.field_71942_A || block == Block.field_71943_B || block == Block.field_71944_C || block == Block.field_71938_D || block == Block.field_72067_ar || block.field_72018_cp.func_76222_j())) {
            block = null;
        }
        if (block != null && block.isBlockReplaceable(this, par2, par3, par4)) {
            block = null;
        }
        return block != null && block.field_72018_cp == Material.field_76265_p && block1 == Block.field_82510_ck ? true : par1 > 0 && block == null && block1.func_94331_a(this, par2, par3, par4, par6, par8ItemStack);
    }

    public PathEntity func_72865_a(Entity par1Entity, Entity par2Entity, float par3, boolean par4, boolean par5, boolean par6, boolean par7) {
        this.field_72984_F.func_76320_a("pathfind");
        int i = MathHelper.func_76128_c((double)par1Entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)(par1Entity.field_70163_u + 1.0));
        int k = MathHelper.func_76128_c((double)par1Entity.field_70161_v);
        int l = (int)(par3 + 16.0f);
        int i1 = i - l;
        int j1 = j - l;
        int k1 = k - l;
        int l1 = i + l;
        int i2 = j + l;
        int j2 = k + l;
        ChunkCache chunkcache = new ChunkCache(this, i1, j1, k1, l1, i2, j2, 0);
        PathEntity pathentity = new PathFinder((IBlockAccess)chunkcache, par4, par5, par6, par7).func_75856_a(par1Entity, par2Entity, par3);
        this.field_72984_F.func_76319_b();
        return pathentity;
    }

    public PathEntity func_72844_a(Entity par1Entity, int par2, int par3, int par4, float par5, boolean par6, boolean par7, boolean par8, boolean par9) {
        this.field_72984_F.func_76320_a("pathfind");
        int l = MathHelper.func_76128_c((double)par1Entity.field_70165_t);
        int i1 = MathHelper.func_76128_c((double)par1Entity.field_70163_u);
        int j1 = MathHelper.func_76128_c((double)par1Entity.field_70161_v);
        int k1 = (int)(par5 + 8.0f);
        int l1 = l - k1;
        int i2 = i1 - k1;
        int j2 = j1 - k1;
        int k2 = l + k1;
        int l2 = i1 + k1;
        int i3 = j1 + k1;
        ChunkCache chunkcache = new ChunkCache(this, l1, i2, j2, k2, l2, i3, 0);
        PathEntity pathentity = new PathFinder((IBlockAccess)chunkcache, par6, par7, par8, par9).func_75859_a(par1Entity, par2, par3, par4, par5);
        this.field_72984_F.func_76319_b();
        return pathentity;
    }

    public int func_72879_k(int par1, int par2, int par3, int par4) {
        int i1 = this.func_72798_a(par1, par2, par3);
        return i1 == 0 ? 0 : Block.field_71973_m[i1].func_71855_c((IBlockAccess)this, par1, par2, par3, par4);
    }

    public int func_94577_B(int par1, int par2, int par3) {
        int b0 = 0;
        int l = Math.max(b0, this.func_72879_k(par1, par2 - 1, par3, 0));
        if (l >= 15) {
            return l;
        }
        if ((l = Math.max(l, this.func_72879_k(par1, par2 + 1, par3, 1))) >= 15) {
            return l;
        }
        if ((l = Math.max(l, this.func_72879_k(par1, par2, par3 - 1, 2))) >= 15) {
            return l;
        }
        if ((l = Math.max(l, this.func_72879_k(par1, par2, par3 + 1, 3))) >= 15) {
            return l;
        }
        if ((l = Math.max(l, this.func_72879_k(par1 - 1, par2, par3, 4))) >= 15) {
            return l;
        }
        return (l = Math.max(l, this.func_72879_k(par1 + 1, par2, par3, 5))) >= 15 ? l : l;
    }

    public boolean func_94574_k(int par1, int par2, int par3, int par4) {
        return this.func_72878_l(par1, par2, par3, par4) > 0;
    }

    public int func_72878_l(int par1, int par2, int par3, int par4) {
        if (this.func_72809_s(par1, par2, par3)) {
            return this.func_94577_B(par1, par2, par3);
        }
        int i1 = this.func_72798_a(par1, par2, par3);
        return i1 == 0 ? 0 : Block.field_71973_m[i1].func_71865_a((IBlockAccess)this, par1, par2, par3, par4);
    }

    public boolean func_72864_z(int par1, int par2, int par3) {
        return this.func_72878_l(par1, par2 - 1, par3, 0) > 0 ? true : (this.func_72878_l(par1, par2 + 1, par3, 1) > 0 ? true : (this.func_72878_l(par1, par2, par3 - 1, 2) > 0 ? true : (this.func_72878_l(par1, par2, par3 + 1, 3) > 0 ? true : (this.func_72878_l(par1 - 1, par2, par3, 4) > 0 ? true : this.func_72878_l(par1 + 1, par2, par3, 5) > 0))));
    }

    public int func_94572_D(int par1, int par2, int par3) {
        int l = 0;
        for (int i1 = 0; i1 < 6; ++i1) {
            int j1 = this.func_72878_l(par1 + Facing.field_71586_b[i1], par2 + Facing.field_71587_c[i1], par3 + Facing.field_71585_d[i1], i1);
            if (j1 >= 15) {
                return 15;
            }
            if (j1 <= l) continue;
            l = j1;
        }
        return l;
    }

    public EntityPlayer func_72890_a(Entity par1Entity, double par2) {
        return this.func_72977_a(par1Entity.field_70165_t, par1Entity.field_70163_u, par1Entity.field_70161_v, par2);
    }

    public EntityPlayer func_72977_a(double par1, double par3, double par5, double par7) {
        double d4 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)((Object)this.field_73010_i.get(i));
            double d5 = entityplayer1.func_70092_e(par1, par3, par5);
            if (!(par7 < 0.0) && !(d5 < par7 * par7) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public EntityPlayer func_72856_b(Entity par1Entity, double par2) {
        return this.func_72846_b(par1Entity.field_70165_t, par1Entity.field_70163_u, par1Entity.field_70161_v, par2);
    }

    public EntityPlayer func_72846_b(double par1, double par3, double par5, double par7) {
        double d4 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)((Object)this.field_73010_i.get(i));
            if (entityplayer1.field_71075_bZ.field_75102_a || !entityplayer1.func_70089_S()) continue;
            double d5 = entityplayer1.func_70092_e(par1, par3, par5);
            double d6 = par7;
            if (entityplayer1.func_70093_af()) {
                d6 = par7 * (double)0.8f;
            }
            if (entityplayer1.func_82150_aj()) {
                float f = entityplayer1.func_82243_bO();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d6 *= (double)(0.7f * f);
            }
            if (!(par7 < 0.0) && !(d5 < d6 * d6) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public EntityPlayer func_72924_a(String par1Str) {
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            if (!par1Str.equals(((EntityPlayer)((Object)this.field_73010_i.get(i))).func_70005_c_())) continue;
            return (EntityPlayer)((Object)this.field_73010_i.get(i));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72882_A() {
    }

    public void func_72906_B() throws MinecraftException {
        this.field_73019_z.func_75762_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_82738_a(long par1) {
        this.field_72986_A.func_82572_b(par1);
    }

    public long func_72905_C() {
        return this.field_73011_w.getSeed();
    }

    public long func_82737_E() {
        return this.field_72986_A.func_82573_f();
    }

    public long func_72820_D() {
        return this.field_73011_w.getWorldTime();
    }

    public void func_72877_b(long par1) {
        this.field_73011_w.setWorldTime(par1);
    }

    public ChunkCoordinates func_72861_E() {
        return this.field_73011_w.getSpawnPoint();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72950_A(int par1, int par2, int par3) {
        this.field_73011_w.setSpawnPoint(par1, par2, par3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72897_h(Entity par1Entity) {
        int i = MathHelper.func_76128_c((double)(par1Entity.field_70165_t / 16.0));
        int j = MathHelper.func_76128_c((double)(par1Entity.field_70161_v / 16.0));
        int b0 = 2;
        for (int k = i - b0; k <= i + b0; ++k) {
            for (int l = j - b0; l <= j + b0; ++l) {
                this.func_72964_e(k, l);
            }
        }
        if (!this.field_72996_f.contains(par1Entity) && !MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(par1Entity, this))) {
            this.field_72996_f.add(par1Entity);
        }
    }

    public boolean func_72962_a(EntityPlayer par1EntityPlayer, int par2, int par3, int par4) {
        return this.field_73011_w.canMineBlock(par1EntityPlayer, par2, par3, par4);
    }

    public boolean canMineBlockBody(EntityPlayer par1EntityPlayer, int par2, int par3, int par4) {
        return true;
    }

    public void func_72960_a(Entity par1Entity, byte par2) {
    }

    public IChunkProvider func_72863_F() {
        return this.field_73020_y;
    }

    public void func_72965_b(int par1, int par2, int par3, int par4, int par5, int par6) {
        if (par4 > 0) {
            Block.field_71973_m[par4].func_71883_b(this, par1, par2, par3, par5, par6);
        }
    }

    public ISaveHandler func_72860_G() {
        return this.field_73019_z;
    }

    public WorldInfo func_72912_H() {
        return this.field_72986_A;
    }

    public GameRules func_82736_K() {
        return this.field_72986_A.func_82574_x();
    }

    public void func_72854_c() {
    }

    public float func_72819_i(float par1) {
        return (this.field_73018_p + (this.field_73017_q - this.field_73018_p) * par1) * this.func_72867_j(par1);
    }

    public float func_72867_j(float par1) {
        return this.field_73003_n + (this.field_73004_o - this.field_73003_n) * par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72894_k(float par1) {
        this.field_73003_n = par1;
        this.field_73004_o = par1;
    }

    public boolean func_72911_I() {
        return (double)this.func_72819_i(1.0f) > 0.9;
    }

    public boolean func_72896_J() {
        return (double)this.func_72867_j(1.0f) > 0.2;
    }

    public boolean func_72951_B(int par1, int par2, int par3) {
        if (!this.func_72896_J()) {
            return false;
        }
        if (!this.func_72937_j(par1, par2, par3)) {
            return false;
        }
        if (this.func_72874_g(par1, par3) > par2) {
            return false;
        }
        BiomeGenBase biomegenbase = this.func_72807_a(par1, par3);
        return biomegenbase.func_76746_c() ? false : biomegenbase.func_76738_d();
    }

    public boolean func_72958_C(int par1, int par2, int par3) {
        return this.field_73011_w.isBlockHighHumidity(par1, par2, par3);
    }

    public void func_72823_a(String par1Str, WorldSavedData par2WorldSavedData) {
        this.field_72988_C.func_75745_a(par1Str, par2WorldSavedData);
    }

    public WorldSavedData func_72943_a(Class par1Class, String par2Str) {
        return this.field_72988_C.func_75742_a(par1Class, par2Str);
    }

    public int func_72841_b(String par1Str) {
        return this.field_72988_C.func_75743_a(par1Str);
    }

    public void func_82739_e(int par1, int par2, int par3, int par4, int par5) {
        for (int j1 = 0; j1 < this.field_73021_x.size(); ++j1) {
            ((IWorldAccess)this.field_73021_x.get(j1)).func_82746_a(par1, par2, par3, par4, par5);
        }
    }

    public void func_72926_e(int par1, int par2, int par3, int par4, int par5) {
        this.func_72889_a(null, par1, par2, par3, par4, par5);
    }

    public void func_72889_a(EntityPlayer par1EntityPlayer, int par2, int par3, int par4, int par5, int par6) {
        try {
            for (int j1 = 0; j1 < this.field_73021_x.size(); ++j1) {
                ((IWorldAccess)this.field_73021_x.get(j1)).func_72706_a(par1EntityPlayer, par2, par3, par4, par5, par6);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Playing level event");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Level event being played");
            crashreportcategory.func_71507_a("Block coordinates", CrashReportCategory.func_85071_a(par3, par4, par5));
            crashreportcategory.func_71507_a("Event source", (Object)par1EntityPlayer);
            crashreportcategory.func_71507_a("Event type", par2);
            crashreportcategory.func_71507_a("Event data", par6);
            throw new ReportedException(crashreport);
        }
    }

    public int func_72800_K() {
        return this.field_73011_w.getHeight();
    }

    public int func_72940_L() {
        return this.field_73011_w.getActualHeight();
    }

    public IUpdatePlayerListBox func_82735_a(EntityMinecart par1EntityMinecart) {
        return null;
    }

    public Random func_72843_D(int par1, int par2, int par3) {
        long l = (long)par1 * 341873128712L + (long)par2 * 132897987541L + this.func_72912_H().func_76063_b() + (long)par3;
        this.field_73012_v.setSeed(l);
        return this.field_73012_v;
    }

    public ChunkPosition func_72946_b(String par1Str, int par2, int par3, int par4) {
        return this.func_72863_F().func_73150_a(this, par1Str, par2, par3, par4);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_72806_N() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_72919_O() {
        return this.field_73011_w.getHorizon();
    }

    public CrashReportCategory func_72914_a(CrashReport par1CrashReport) {
        CrashReportCategory crashreportcategory = par1CrashReport.func_85057_a("Affected level", 1);
        crashreportcategory.func_71507_a("Level name", this.field_72986_A == null ? "????" : this.field_72986_A.func_76065_j());
        crashreportcategory.func_71500_a("All players", (Callable)new CallableLvl2(this));
        crashreportcategory.func_71500_a("Chunk stats", (Callable)new CallableLvl3(this));
        try {
            this.field_72986_A.func_85118_a(crashreportcategory);
        }
        catch (Throwable throwable) {
            crashreportcategory.func_71499_a("Level Data Unobtainable", throwable);
        }
        return crashreportcategory;
    }

    public void func_72888_f(int par1, int par2, int par3, int par4, int par5) {
        for (int j1 = 0; j1 < this.field_73021_x.size(); ++j1) {
            IWorldAccess iworldaccess = (IWorldAccess)this.field_73021_x.get(j1);
            iworldaccess.func_72705_a(par1, par2, par3, par4, par5);
        }
    }

    public Vec3Pool func_82732_R() {
        return this.field_82741_K;
    }

    public Calendar func_83015_S() {
        if (this.func_82737_E() % 600L == 0L) {
            this.field_83016_L.setTimeInMillis(MinecraftServer.func_130071_aq());
        }
        return this.field_83016_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_92088_a(double par1, double par3, double par5, double par7, double par9, double par11, NBTTagCompound par13NBTTagCompound) {
    }

    public Scoreboard func_96441_U() {
        return this.field_96442_D;
    }

    public void func_96440_m(int par1, int par2, int par3, int par4) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int j1 = par1 + dir.offsetX;
            int y = par2 + dir.offsetY;
            int k1 = par3 + dir.offsetZ;
            int l1 = this.func_72798_a(j1, y, k1);
            Block block = Block.field_71973_m[l1];
            if (block == null) continue;
            block.onNeighborTileChange(this, j1, y, k1, par1, par2, par3);
            if (!Block.func_71932_i((int)l1) || (block = Block.field_71973_m[l1 = this.func_72798_a(j1 += dir.offsetX, y += dir.offsetY, k1 += dir.offsetZ)]) == null || !block.weakTileChanges()) continue;
            block.onNeighborTileChange(this, j1, y, k1, par1, par2, par3);
        }
    }

    public ILogAgent func_98180_V() {
        return this.field_98181_L;
    }

    public float func_110746_b(double par1, double par3, double par5) {
        return this.func_110750_I(MathHelper.func_76128_c((double)par1), MathHelper.func_76128_c((double)par3), MathHelper.func_76128_c((double)par5));
    }

    public float func_110750_I(int par1, int par2, int par3) {
        boolean flag;
        float f = 0.0f;
        boolean bl = flag = this.field_73013_u == 3;
        if (this.func_72899_e(par1, par2, par3)) {
            float f1 = this.func_130001_d();
            f += MathHelper.func_76131_a((float)((float)this.func_72938_d((int)par1, (int)par3).field_111204_q / 3600000.0f), (float)0.0f, (float)1.0f) * (flag ? 1.0f : 0.75f);
            f += f1 * 0.25f;
        }
        if (this.field_73013_u < 2) {
            f *= (float)this.field_73013_u / 2.0f;
        }
        return MathHelper.func_76131_a((float)f, (float)0.0f, (float)(flag ? 1.5f : 1.0f));
    }

    public void addTileEntity(TileEntity entity) {
        List dest;
        List list = dest = this.field_72989_L ? this.field_73002_a : this.field_73009_h;
        if (entity.canUpdate()) {
            dest.add(entity);
        }
    }

    public boolean isBlockSolidOnSide(int x, int y, int z, ForgeDirection side) {
        return this.isBlockSolidOnSide(x, y, z, side, false);
    }

    public boolean isBlockSolidOnSide(int x, int y, int z, ForgeDirection side, boolean _default) {
        if (x < -30000000 || z < -30000000 || x >= 30000000 || z >= 30000000) {
            return _default;
        }
        Chunk chunk = this.field_73020_y.func_73154_d(x >> 4, z >> 4);
        if (chunk == null || chunk.func_76621_g()) {
            return _default;
        }
        Block block = Block.field_71973_m[this.func_72798_a(x, y, z)];
        if (block == null) {
            return false;
        }
        return block.isBlockSolidOnSide(this, x, y, z, side);
    }

    public ImmutableSetMultimap<ChunkCoordIntPair, ForgeChunkManager.Ticket> getPersistentChunks() {
        return ForgeChunkManager.getPersistentChunksFor((World)this);
    }

    public int getBlockLightOpacity(int x, int y, int z) {
        if (x < -30000000 || z < -30000000 || x >= 30000000 || z >= 30000000) {
            return 0;
        }
        if (y < 0 || y >= 256) {
            return 0;
        }
        return this.func_72964_e(x >> 4, z >> 4).func_76596_b(x & 0xF, y, z & 0xF);
    }

    public int countEntities(EnumCreatureType type, boolean forSpawnCount) {
        int count = 0;
        for (int x = 0; x < this.field_72996_f.size(); ++x) {
            if (!((Entity)this.field_72996_f.get(x)).isCreatureType(type, forSpawnCount)) continue;
            ++count;
        }
        return count;
    }
}

