/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import cpw.mods.fml.common.FMLCommonHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.NetClientHandler;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.crash.CallableMinecraftVersion;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.Direction;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.FoodStats;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import org.lwjgl.opengl.GL11;

public class GuiIngameForge
extends GuiIngame {
    private static final ResourceLocation VIGNETTE = new ResourceLocation("textures/misc/vignette.png");
    private static final ResourceLocation WIDGITS = new ResourceLocation("textures/gui/widgets.png");
    private static final ResourceLocation PUMPKIN_BLUR = new ResourceLocation("textures/misc/pumpkinblur.png");
    private static final int WHITE = 0xFFFFFF;
    public static boolean renderHelmet = true;
    public static boolean renderPortal = true;
    public static boolean renderHotbar = true;
    public static boolean renderCrosshairs = true;
    public static boolean renderBossHealth = true;
    public static boolean renderHealth = true;
    public static boolean renderArmor = true;
    public static boolean renderFood = true;
    public static boolean renderHealthMount = true;
    public static boolean renderAir = true;
    public static boolean renderExperiance = true;
    public static boolean renderJumpBar = true;
    public static boolean renderObjective = true;
    public static int left_height = 39;
    public static int right_height = 39;
    private ScaledResolution res = null;
    private FontRenderer fontrenderer = null;
    private RenderGameOverlayEvent eventParent;
    private static final String MC_VERSION = new CallableMinecraftVersion(null).func_71493_a();

    public GuiIngameForge(Minecraft mc) {
        super(mc);
    }

    @Override
    public void func_73830_a(float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        this.res = new ScaledResolution(this.field_73839_d.field_71474_y, this.field_73839_d.field_71443_c, this.field_73839_d.field_71440_d);
        this.eventParent = new RenderGameOverlayEvent(partialTicks, this.res, mouseX, mouseY);
        int width = this.res.func_78326_a();
        int height = this.res.func_78328_b();
        renderHealthMount = this.field_73839_d.field_71439_g.field_70154_o instanceof EntityLivingBase;
        renderFood = this.field_73839_d.field_71439_g.field_70154_o == null;
        renderJumpBar = this.field_73839_d.field_71439_g.func_110317_t();
        right_height = 39;
        left_height = 39;
        if (this.pre(RenderGameOverlayEvent.ElementType.ALL)) {
            return;
        }
        this.fontrenderer = this.field_73839_d.field_71466_p;
        this.field_73839_d.field_71460_t.func_78478_c();
        GL11.glEnable((int)3042);
        if (Minecraft.func_71375_t()) {
            this.func_73829_a(this.field_73839_d.field_71439_g.func_70013_c(partialTicks), width, height);
        } else {
            GL11.glBlendFunc((int)770, (int)771);
        }
        if (renderHelmet) {
            this.renderHelmet(this.res, partialTicks, hasScreen, mouseX, mouseY);
        }
        if (renderPortal && !this.field_73839_d.field_71439_g.func_70644_a(Potion.field_76431_k)) {
            this.renderPortal(width, height, partialTicks);
        }
        if (!this.field_73839_d.field_71442_b.func_78747_a()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_73735_i = -90.0f;
            this.field_73842_c.setSeed(this.field_73837_f * 312871);
            if (renderCrosshairs) {
                this.renderCrosshairs(width, height);
            }
            if (renderBossHealth) {
                this.func_73828_d();
            }
            if (this.field_73839_d.field_71442_b.func_78755_b()) {
                if (renderHealth) {
                    this.renderHealth(width, height);
                }
                if (renderArmor) {
                    this.renderArmor(width, height);
                }
                if (renderFood) {
                    this.renderFood(width, height);
                }
                if (renderHealthMount) {
                    this.renderHealthMount(width, height);
                }
                if (renderAir) {
                    this.renderAir(width, height);
                }
            }
            if (renderHotbar) {
                this.renderHotbar(width, height, partialTicks);
            }
        }
        if (renderJumpBar) {
            this.renderJumpBar(width, height);
        } else if (renderExperiance) {
            this.renderExperience(width, height);
        }
        this.renderSleepFade(width, height);
        this.renderToolHightlight(width, height);
        this.renderHUDText(width, height);
        this.renderRecordOverlay(width, height, partialTicks);
        ScoreObjective objective = this.field_73839_d.field_71441_e.func_96441_U().func_96539_a(1);
        if (renderObjective && objective != null) {
            this.func_96136_a(objective, height, width, this.fontrenderer);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        this.renderChat(width, height);
        this.renderPlayerList(width, height);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        this.post(RenderGameOverlayEvent.ElementType.ALL);
    }

    public ScaledResolution getResolution() {
        return this.res;
    }

    protected void renderHotbar(int width, int height, float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.HOTBAR)) {
            return;
        }
        this.field_73839_d.field_71424_I.func_76320_a("actionBar");
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73839_d.field_71446_o.func_110577_a(WIDGITS);
        InventoryPlayer inv = this.field_73839_d.field_71439_g.field_71071_by;
        this.func_73729_b(width / 2 - 91, height - 22, 0, 0, 182, 22);
        this.func_73729_b(width / 2 - 91 - 1 + inv.field_70461_c * 20, height - 22 - 1, 0, 22, 24, 22);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        for (int i = 0; i < 9; ++i) {
            int x = width / 2 - 90 + i * 20 + 2;
            int z = height - 16 - 3;
            this.func_73832_a(i, x, z, partialTicks);
        }
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.HOTBAR);
    }

    protected void renderCrosshairs(int width, int height) {
        if (this.pre(RenderGameOverlayEvent.ElementType.CROSSHAIRS)) {
            return;
        }
        this.bind(Gui.field_110324_m);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)775, (int)769);
        this.func_73729_b(width / 2 - 7, height / 2 - 7, 0, 0, 16, 16);
        GL11.glDisable((int)3042);
        this.post(RenderGameOverlayEvent.ElementType.CROSSHAIRS);
    }

    @Override
    protected void func_73828_d() {
        if (this.pre(RenderGameOverlayEvent.ElementType.BOSSHEALTH)) {
            return;
        }
        this.field_73839_d.field_71424_I.func_76320_a("bossHealth");
        super.func_73828_d();
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.BOSSHEALTH);
    }

    private void renderHelmet(ScaledResolution res, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        if (this.pre(RenderGameOverlayEvent.ElementType.HELMET)) {
            return;
        }
        ItemStack itemstack = this.field_73839_d.field_71439_g.field_71071_by.func_70440_f(3);
        if (this.field_73839_d.field_71474_y.field_74320_O == 0 && itemstack != null && itemstack.func_77973_b() != null) {
            if (itemstack.field_77993_c == Block.field_72061_ba.field_71990_ca) {
                this.func_73836_a(res.func_78326_a(), res.func_78328_b());
            } else {
                itemstack.func_77973_b().renderHelmetOverlay(itemstack, (EntityPlayer)((Object)this.field_73839_d.field_71439_g), res, partialTicks, hasScreen, mouseX, mouseY);
            }
        }
        this.post(RenderGameOverlayEvent.ElementType.HELMET);
    }

    protected void renderArmor(int width, int height) {
        if (this.pre(RenderGameOverlayEvent.ElementType.ARMOR)) {
            return;
        }
        this.field_73839_d.field_71424_I.func_76320_a("armor");
        int left = width / 2 - 91;
        int top = height - left_height;
        int level = ForgeHooks.getTotalArmorValue((EntityPlayer)((Object)this.field_73839_d.field_71439_g));
        for (int i = 1; level > 0 && i < 20; i += 2) {
            if (i < level) {
                this.func_73729_b(left, top, 34, 9, 9, 9);
            } else if (i == level) {
                this.func_73729_b(left, top, 25, 9, 9, 9);
            } else if (i > level) {
                this.func_73729_b(left, top, 16, 9, 9, 9);
            }
            left += 8;
        }
        left_height += 10;
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.ARMOR);
    }

    protected void renderPortal(int width, int height, float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.PORTAL)) {
            return;
        }
        float f1 = this.field_73839_d.field_71439_g.field_71080_cy + (this.field_73839_d.field_71439_g.field_71086_bY - this.field_73839_d.field_71439_g.field_71080_cy) * partialTicks;
        if (f1 > 0.0f) {
            this.func_130015_b(f1, width, height);
        }
        this.post(RenderGameOverlayEvent.ElementType.PORTAL);
    }

    protected void renderAir(int width, int height) {
        if (this.pre(RenderGameOverlayEvent.ElementType.AIR)) {
            return;
        }
        this.field_73839_d.field_71424_I.func_76320_a("air");
        int left = width / 2 + 91;
        int top = height - right_height;
        if (this.field_73839_d.field_71439_g.func_70055_a(Material.field_76244_g)) {
            int air = this.field_73839_d.field_71439_g.func_70086_ai();
            int full = MathHelper.func_76143_f((double)((double)(air - 2) * 10.0 / 300.0));
            int partial = MathHelper.func_76143_f((double)((double)air * 10.0 / 300.0)) - full;
            for (int i = 0; i < full + partial; ++i) {
                this.func_73729_b(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
            }
            right_height += 10;
        }
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.AIR);
    }

    public void renderHealth(int width, int height) {
        boolean highlight;
        this.bind(field_110324_m);
        if (this.pre(RenderGameOverlayEvent.ElementType.HEALTH)) {
            return;
        }
        this.field_73839_d.field_71424_I.func_76320_a("health");
        boolean bl = highlight = this.field_73839_d.field_71439_g.field_70172_ad / 3 % 2 == 1;
        if (this.field_73839_d.field_71439_g.field_70172_ad < 10) {
            highlight = false;
        }
        AttributeInstance attrMaxHealth = this.field_73839_d.field_71439_g.func_110148_a(SharedMonsterAttributes.field_111267_a);
        int health = MathHelper.func_76123_f((float)this.field_73839_d.field_71439_g.func_110143_aJ());
        int healthLast = MathHelper.func_76123_f((float)this.field_73839_d.field_71439_g.field_70735_aL);
        float healthMax = (float)attrMaxHealth.func_111126_e();
        float absorb = this.field_73839_d.field_71439_g.func_110139_bj();
        int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.field_73842_c.setSeed(this.field_73837_f * 312871);
        int left = width / 2 - 91;
        int top = height - left_height;
        left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            left_height += 10 - rowHeight;
        }
        int regen = -1;
        if (this.field_73839_d.field_71439_g.func_70644_a(Potion.field_76428_l)) {
            regen = this.field_73837_f % 25;
        }
        int TOP = 9 * (this.field_73839_d.field_71441_e.func_72912_H().func_76093_s() ? 5 : 0);
        int BACKGROUND = highlight ? 25 : 16;
        int MARGIN = 16;
        if (this.field_73839_d.field_71439_g.func_70644_a(Potion.field_76436_u)) {
            MARGIN += 36;
        } else if (this.field_73839_d.field_71439_g.func_70644_a(Potion.field_82731_v)) {
            MARGIN += 72;
        }
        float absorbRemaining = absorb;
        for (int i = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
            boolean b0 = highlight;
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += this.field_73842_c.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            this.func_73729_b(x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.func_73729_b(x, y, MARGIN + 54, TOP, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.func_73729_b(x, y, MARGIN + 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.func_73729_b(x, y, MARGIN + 153, TOP, 9, 9);
                } else {
                    this.func_73729_b(x, y, MARGIN + 144, TOP, 9, 9);
                }
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < health) {
                this.func_73729_b(x, y, MARGIN + 36, TOP, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            this.func_73729_b(x, y, MARGIN + 45, TOP, 9, 9);
        }
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.HEALTH);
    }

    public void renderFood(int width, int height) {
        if (this.pre(RenderGameOverlayEvent.ElementType.FOOD)) {
            return;
        }
        this.field_73839_d.field_71424_I.func_76320_a("food");
        int left = width / 2 + 91;
        int top = height - right_height;
        right_height += 10;
        boolean unused = false;
        FoodStats stats = this.field_73839_d.field_71439_g.func_71024_bL();
        int level = stats.func_75116_a();
        int levelLast = stats.func_75120_b();
        for (int i = 0; i < 10; ++i) {
            int idx = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            int icon = 16;
            int backgound = 0;
            if (this.field_73839_d.field_71439_g.func_70644_a(Potion.field_76438_s)) {
                icon += 36;
                backgound = 13;
            }
            if (unused) {
                backgound = 1;
            }
            if (this.field_73839_d.field_71439_g.func_71024_bL().func_75115_e() <= 0.0f && this.field_73837_f % (level * 3 + 1) == 0) {
                y = top + (this.field_73842_c.nextInt(3) - 1);
            }
            this.func_73729_b(x, y, 16 + backgound * 9, 27, 9, 9);
            if (unused) {
                if (idx < levelLast) {
                    this.func_73729_b(x, y, icon + 54, 27, 9, 9);
                } else if (idx == levelLast) {
                    this.func_73729_b(x, y, icon + 63, 27, 9, 9);
                }
            }
            if (idx < level) {
                this.func_73729_b(x, y, icon + 36, 27, 9, 9);
                continue;
            }
            if (idx != level) continue;
            this.func_73729_b(x, y, icon + 45, 27, 9, 9);
        }
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.FOOD);
    }

    protected void renderSleepFade(int width, int height) {
        if (this.field_73839_d.field_71439_g.func_71060_bI() > 0) {
            this.field_73839_d.field_71424_I.func_76320_a("sleep");
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3008);
            int sleepTime = this.field_73839_d.field_71439_g.func_71060_bI();
            float opacity = (float)sleepTime / 100.0f;
            if (opacity > 1.0f) {
                opacity = 1.0f - (float)(sleepTime - 100) / 10.0f;
            }
            int color = (int)(220.0f * opacity) << 24 | 0x101020;
            GuiIngameForge.func_73734_a((int)0, (int)0, (int)width, (int)height, (int)color);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)2929);
            this.field_73839_d.field_71424_I.func_76319_b();
        }
    }

    protected void renderExperience(int width, int height) {
        this.bind(field_110324_m);
        if (this.pre(RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_73839_d.field_71442_b.func_78763_f()) {
            this.field_73839_d.field_71424_I.func_76320_a("expBar");
            int cap = this.field_73839_d.field_71439_g.func_71050_bK();
            int left = width / 2 - 91;
            if (cap > 0) {
                int barWidth = 182;
                int filled = (int)(this.field_73839_d.field_71439_g.field_71106_cc * (float)(barWidth + 1));
                int top = height - 32 + 3;
                this.func_73729_b(left, top, 0, 64, barWidth, 5);
                if (filled > 0) {
                    this.func_73729_b(left, top, 0, 69, filled, 5);
                }
            }
            this.field_73839_d.field_71424_I.func_76319_b();
            if (this.field_73839_d.field_71442_b.func_78763_f() && this.field_73839_d.field_71439_g.field_71068_ca > 0) {
                this.field_73839_d.field_71424_I.func_76320_a("expLevel");
                boolean flag1 = false;
                int color = flag1 ? 0xFFFFFF : 8453920;
                String text = "" + this.field_73839_d.field_71439_g.field_71068_ca;
                int x = (width - this.fontrenderer.func_78256_a(text)) / 2;
                int y = height - 31 - 4;
                this.fontrenderer.func_78276_b(text, x + 1, y, 0);
                this.fontrenderer.func_78276_b(text, x - 1, y, 0);
                this.fontrenderer.func_78276_b(text, x, y + 1, 0);
                this.fontrenderer.func_78276_b(text, x, y - 1, 0);
                this.fontrenderer.func_78276_b(text, x, y, color);
                this.field_73839_d.field_71424_I.func_76319_b();
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.post(RenderGameOverlayEvent.ElementType.EXPERIENCE);
    }

    protected void renderJumpBar(int width, int height) {
        this.bind(field_110324_m);
        if (this.pre(RenderGameOverlayEvent.ElementType.JUMPBAR)) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73839_d.field_71424_I.func_76320_a("jumpBar");
        float charge = this.field_73839_d.field_71439_g.func_110319_bJ();
        int barWidth = 182;
        int x = width / 2 - 91;
        int filled = (int)(charge * 183.0f);
        int top = height - 32 + 3;
        this.func_73729_b(x, top, 0, 84, 182, 5);
        if (filled > 0) {
            this.func_73729_b(x, top, 0, 89, filled, 5);
        }
        this.field_73839_d.field_71424_I.func_76319_b();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.post(RenderGameOverlayEvent.ElementType.JUMPBAR);
    }

    protected void renderToolHightlight(int width, int height) {
        if (this.field_73839_d.field_71474_y.field_92117_D) {
            this.field_73839_d.field_71424_I.func_76320_a("toolHighlight");
            if (this.field_92017_k > 0 && this.field_92016_l != null) {
                String name = this.field_92016_l.func_82833_r();
                int opacity = (int)((float)this.field_92017_k * 256.0f / 10.0f);
                if (opacity > 255) {
                    opacity = 255;
                }
                if (opacity > 0) {
                    int y = height - 59;
                    if (!this.field_73839_d.field_71442_b.func_78755_b()) {
                        y += 14;
                    }
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    FontRenderer font = this.field_92016_l.func_77973_b().getFontRenderer(this.field_92016_l);
                    if (font != null) {
                        int x = (width - font.func_78256_a(name)) / 2;
                        font.func_78261_a(name, x, y, 0xFFFFFF | opacity << 24);
                    } else {
                        int x = (width - this.fontrenderer.func_78256_a(name)) / 2;
                        this.fontrenderer.func_78261_a(name, x, y, 0xFFFFFF | opacity << 24);
                    }
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                }
            }
            this.field_73839_d.field_71424_I.func_76319_b();
        }
    }

    protected void renderHUDText(int width, int height) {
        RenderGameOverlayEvent.Text event;
        this.field_73839_d.field_71424_I.func_76320_a("forgeHudText");
        ArrayList<String> left = new ArrayList<String>();
        ArrayList<String> right = new ArrayList<String>();
        if (this.field_73839_d.func_71355_q()) {
            long time = this.field_73839_d.field_71441_e.func_82737_E();
            if (time >= 120500L) {
                right.add(StatCollector.func_74838_a((String)"demo.demoExpired"));
            } else {
                right.add(String.format(StatCollector.func_74838_a((String)"demo.remainingTime"), StringUtils.func_76337_a((int)((int)(120500L - time)))));
            }
        }
        if (this.field_73839_d.field_71474_y.field_74330_P) {
            this.field_73839_d.field_71424_I.func_76320_a("debug");
            GL11.glPushMatrix();
            left.add("Minecraft " + MC_VERSION + " (" + this.field_73839_d.field_71426_K + ")");
            left.add(this.field_73839_d.func_71393_m());
            left.add(this.field_73839_d.func_71408_n());
            left.add(this.field_73839_d.func_71374_p());
            left.add(this.field_73839_d.func_71388_o());
            left.add(null);
            long max = Runtime.getRuntime().maxMemory();
            long total = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            long used = total - free;
            right.add("Used memory: " + used * 100L / max + "% (" + used / 1024L / 1024L + "MB) of " + max / 1024L / 1024L + "MB");
            right.add("Allocated memory: " + total * 100L / max + "% (" + total / 1024L / 1024L + "MB)");
            int x = MathHelper.func_76128_c((double)this.field_73839_d.field_71439_g.field_70165_t);
            int y = MathHelper.func_76128_c((double)this.field_73839_d.field_71439_g.field_70163_u);
            int z = MathHelper.func_76128_c((double)this.field_73839_d.field_71439_g.field_70161_v);
            float yaw = this.field_73839_d.field_71439_g.field_70177_z;
            int heading = MathHelper.func_76128_c((double)((double)(this.field_73839_d.field_71439_g.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            left.add(String.format("x: %.5f (%d) // c: %d (%d)", this.field_73839_d.field_71439_g.field_70165_t, x, x >> 4, x & 0xF));
            left.add(String.format("y: %.3f (feet pos, %.3f eyes pos)", this.field_73839_d.field_71439_g.field_70121_D.field_72338_b, this.field_73839_d.field_71439_g.field_70163_u));
            left.add(String.format("z: %.5f (%d) // c: %d (%d)", this.field_73839_d.field_71439_g.field_70161_v, z, z >> 4, z & 0xF));
            left.add(String.format("f: %d (%s) / %f", heading, Direction.field_82373_c[heading], Float.valueOf(MathHelper.func_76142_g((float)yaw))));
            if (this.field_73839_d.field_71441_e != null && this.field_73839_d.field_71441_e.func_72899_e(x, y, z)) {
                Chunk chunk = this.field_73839_d.field_71441_e.func_72938_d(x, z);
                left.add(String.format("lc: %d b: %s bl: %d sl: %d rl: %d", chunk.func_76625_h() + 15, chunk.func_76591_a((int)(x & 0xF), (int)(z & 0xF), (WorldChunkManager)this.field_73839_d.field_71441_e.func_72959_q()).field_76791_y, chunk.func_76614_a(EnumSkyBlock.Block, x & 0xF, y, z & 0xF), chunk.func_76614_a(EnumSkyBlock.Sky, x & 0xF, y, z & 0xF), chunk.func_76629_c(x & 0xF, y, z & 0xF, 0)));
            } else {
                left.add(null);
            }
            left.add(String.format("ws: %.3f, fs: %.3f, g: %b, fl: %d", Float.valueOf(this.field_73839_d.field_71439_g.field_71075_bZ.func_75094_b()), Float.valueOf(this.field_73839_d.field_71439_g.field_71075_bZ.func_75093_a()), this.field_73839_d.field_71439_g.field_70122_E, this.field_73839_d.field_71441_e.func_72976_f(x, z)));
            right.add(null);
            for (String s : FMLCommonHandler.instance().getBrandings().subList(1, FMLCommonHandler.instance().getBrandings().size())) {
                right.add(s);
            }
            GL11.glPopMatrix();
            this.field_73839_d.field_71424_I.func_76319_b();
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(event = new RenderGameOverlayEvent.Text(this.eventParent, left, right)))) {
            int x;
            for (x = 0; x < left.size(); ++x) {
                String msg = (String)left.get(x);
                if (msg == null) continue;
                this.fontrenderer.func_78261_a(msg, 2, 2 + x * 10, 0xFFFFFF);
            }
            for (x = 0; x < right.size(); ++x) {
                String msg = (String)right.get(x);
                if (msg == null) continue;
                int w = this.fontrenderer.func_78256_a(msg);
                this.fontrenderer.func_78261_a(msg, width - w - 10, 2 + x * 10, 0xFFFFFF);
            }
        }
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.TEXT);
    }

    protected void renderRecordOverlay(int width, int height, float partialTicks) {
        if (this.field_73845_h > 0) {
            this.field_73839_d.field_71424_I.func_76320_a("overlayMessage");
            float hue = (float)this.field_73845_h - partialTicks;
            int opacity = (int)(hue * 256.0f / 20.0f);
            if (opacity > 255) {
                opacity = 255;
            }
            if (opacity > 0) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(width / 2), (float)(height - 48), (float)0.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                int color = this.field_73844_j ? Color.HSBtoRGB(hue / 50.0f, 0.7f, 0.6f) & 0xFFFFFF : 0xFFFFFF;
                this.fontrenderer.func_78276_b(this.field_73838_g, -this.fontrenderer.func_78256_a(this.field_73838_g) / 2, -4, color | opacity << 24);
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
            this.field_73839_d.field_71424_I.func_76319_b();
        }
    }

    protected void renderChat(int width, int height) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(height - 48), (float)0.0f);
        this.field_73839_d.field_71424_I.func_76320_a("chat");
        this.field_73840_e.func_73762_a(this.field_73837_f);
        this.field_73839_d.field_71424_I.func_76319_b();
        GL11.glPopMatrix();
    }

    protected void renderPlayerList(int width, int height) {
        ScoreObjective scoreobjective = this.field_73839_d.field_71441_e.func_96441_U().func_96539_a(0);
        NetClientHandler handler = this.field_73839_d.field_71439_g.field_71174_a;
        if (this.field_73839_d.field_71474_y.field_74321_H.field_74513_e && (!this.field_73839_d.func_71387_A() || handler.field_72559_c.size() > 1 || scoreobjective != null)) {
            int maxPlayers;
            this.field_73839_d.field_71424_I.func_76320_a("playerList");
            List players = handler.field_72559_c;
            int rows = maxPlayers = handler.field_72556_d;
            int columns = 1;
            columns = 1;
            while (rows > 20) {
                rows = (maxPlayers + ++columns - 1) / columns;
            }
            int columnWidth = 300 / columns;
            if (columnWidth > 150) {
                columnWidth = 150;
            }
            int left = (width - columns * columnWidth) / 2;
            int border = 10;
            GuiIngameForge.func_73734_a((int)(left - 1), (int)(border - 1), (int)(left + columnWidth * columns), (int)(border + 9 * rows), (int)Integer.MIN_VALUE);
            for (int i = 0; i < maxPlayers; ++i) {
                int endX;
                int maxX;
                int xPos = left + i % columns * columnWidth;
                int yPos = border + i / columns * 9;
                GuiIngameForge.func_73734_a((int)xPos, (int)yPos, (int)(xPos + columnWidth - 1), (int)(yPos + 8), (int)0x20FFFFFF);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3008);
                if (i >= players.size()) continue;
                GuiPlayerInfo player = (GuiPlayerInfo)players.get(i);
                ScorePlayerTeam team = this.field_73839_d.field_71441_e.func_96441_U().func_96509_i(player.field_78831_a);
                String displayName = ScorePlayerTeam.func_96667_a(team, player.field_78831_a);
                this.fontrenderer.func_78261_a(displayName, xPos, yPos, 0xFFFFFF);
                if (scoreobjective != null && (maxX = xPos + columnWidth - 12 - 5) - (endX = xPos + this.fontrenderer.func_78256_a(displayName) + 5) > 5) {
                    Score score = scoreobjective.func_96682_a().func_96529_a(player.field_78831_a, scoreobjective);
                    String scoreDisplay = EnumChatFormatting.YELLOW + "" + score.func_96652_c();
                    this.fontrenderer.func_78261_a(scoreDisplay, maxX - this.fontrenderer.func_78256_a(scoreDisplay), yPos, 0xFFFFFF);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_73839_d.func_110434_K().func_110577_a(Gui.field_110324_m);
                int pingIndex = 4;
                int ping = player.field_78829_b;
                if (ping < 0) {
                    pingIndex = 5;
                } else if (ping < 150) {
                    pingIndex = 0;
                } else if (ping < 300) {
                    pingIndex = 1;
                } else if (ping < 600) {
                    pingIndex = 2;
                } else if (ping < 1000) {
                    pingIndex = 3;
                }
                this.field_73735_i += 100.0f;
                this.func_73729_b(xPos + columnWidth - 12, yPos, 0, 176 + pingIndex * 8, 10, 8);
                this.field_73735_i -= 100.0f;
            }
        }
    }

    protected void renderHealthMount(int width, int height) {
        Entity tmp = this.field_73839_d.field_71439_g.field_70154_o;
        if (!(tmp instanceof EntityLivingBase)) {
            return;
        }
        this.bind(field_110324_m);
        if (this.pre(RenderGameOverlayEvent.ElementType.HEALTHMOUNT)) {
            return;
        }
        boolean unused = false;
        int left_align = width / 2 + 91;
        this.field_73839_d.field_71424_I.func_76318_c("mountHealth");
        EntityLivingBase mount = (EntityLivingBase)tmp;
        int health = (int)Math.ceil(mount.func_110143_aJ());
        float healthMax = mount.func_110138_aP();
        int hearts = (int)(healthMax + 0.5f) / 2;
        if (hearts > 30) {
            hearts = 30;
        }
        int MARGIN = 52;
        int BACKGROUND = 52 + (unused ? 1 : 0);
        int HALF = 97;
        int FULL = 88;
        int heart = 0;
        while (hearts > 0) {
            int top = height - right_height;
            int rowCount = Math.min(hearts, 10);
            hearts -= rowCount;
            for (int i = 0; i < rowCount; ++i) {
                int x = left_align - i * 8 - 9;
                this.func_73729_b(x, top, BACKGROUND, 9, 9, 9);
                if (i * 2 + 1 + heart < health) {
                    this.func_73729_b(x, top, 88, 9, 9, 9);
                    continue;
                }
                if (i * 2 + 1 + heart != health) continue;
                this.func_73729_b(x, top, 97, 9, 9, 9);
            }
            right_height += 10;
            heart += 20;
        }
        this.post(RenderGameOverlayEvent.ElementType.HEALTHMOUNT);
    }

    private boolean pre(RenderGameOverlayEvent.ElementType type) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Pre(this.eventParent, type));
    }

    private void post(RenderGameOverlayEvent.ElementType type) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(this.eventParent, type));
    }

    private void bind(ResourceLocation res) {
        this.field_73839_d.func_110434_K().func_110577_a(res);
    }
}

