/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.mars;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.world.ICelestialBody;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GCCoreCreativeTab;
import micdoodle8.mods.galacticraft.core.GCLog;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.mars.CommonProxyMars;
import micdoodle8.mods.galacticraft.mars.GCMarsConfigManager;
import micdoodle8.mods.galacticraft.mars.GCMarsEvents;
import micdoodle8.mods.galacticraft.mars.GCMarsPlanet;
import micdoodle8.mods.galacticraft.mars.blocks.GCMarsBlocks;
import micdoodle8.mods.galacticraft.mars.dimension.GCMarsTeleportType;
import micdoodle8.mods.galacticraft.mars.dimension.GCMarsWorldProvider;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntityCargoRocket;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntityCreeperBoss;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntityLandingBalloons;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntityProjectileTNT;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntityRocketT2;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntitySlimeling;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntitySludgeling;
import micdoodle8.mods.galacticraft.mars.entities.GCMarsEntityTerraformBubble;
import micdoodle8.mods.galacticraft.mars.items.GCMarsItems;
import micdoodle8.mods.galacticraft.mars.network.GCMarsPacketHandlerServer;
import micdoodle8.mods.galacticraft.mars.recipe.GCMarsRecipeManager;
import micdoodle8.mods.galacticraft.mars.schematic.GCMarsSchematicCargoRocket;
import micdoodle8.mods.galacticraft.mars.schematic.GCMarsSchematicRocketT2;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityCryogenicChamber;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityLaunchController;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntitySlimelingEgg;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityTerraformer;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityTreasureChest;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@Mod(name="Galacticraft Mars", version="2.0.14", useMetadata=true, modid="GalacticraftMars", dependencies="required-after:GalacticraftCore;")
@NetworkMod(channels={"GalacticraftMars"}, clientSideRequired=true, serverSideRequired=false, packetHandler=GCCorePacketManager.class)
public class GalacticraftMars {
    public static final String NAME = "Galacticraft Mars";
    public static final String MODID = "GalacticraftMars";
    public static final String CHANNEL = "GalacticraftMars";
    public static final String CHANNELENTITIES = "GCMarsEntities";
    public static final String LANGUAGE_PATH = "/assets/galacticraftmars/lang/";
    @SidedProxy(clientSide="micdoodle8.mods.galacticraft.mars.client.ClientProxyMars", serverSide="micdoodle8.mods.galacticraft.mars.CommonProxyMars")
    public static CommonProxyMars proxy;
    @Mod.Instance(value="GalacticraftMars")
    public static GalacticraftMars instance;
    public static GCCoreCreativeTab galacticraftMarsTab;
    public static final String TEXTURE_DOMAIN = "galacticraftmars";
    public static final String TEXTURE_PREFIX = "galacticraftmars:";
    public static Fluid SLUDGE;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new GCMarsEvents());
        new GCMarsConfigManager(new File(event.getModConfigurationDirectory(), "Galacticraft/mars.conf"));
        SLUDGE = new Fluid("bacterialsludge").setBlockID(GCMarsConfigManager.idBlockBacterialSludge).setViscosity(3000);
        if (!FluidRegistry.registerFluid((Fluid)SLUDGE)) {
            GCLog.info((String)"\"bacterialsludge\" has already been registered as a fluid, ignoring...");
        }
        GCMarsBlocks.initBlocks();
        GCMarsBlocks.registerBlocks();
        GCMarsBlocks.setHarvestLevels();
        GCMarsItems.initItems();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new GCMarsSchematicRocketT2());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new GCMarsSchematicCargoRocket());
        galacticraftMarsTab = new GCCoreCreativeTab(CreativeTabs.getNextID(), "GalacticraftMars", GCMarsItems.spaceship.field_77779_bT, 5);
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        this.registerTileEntities();
        this.registerCreatures();
        this.registerOtherEntities();
        proxy.init(event);
        GalacticraftRegistry.registerTeleportType(GCMarsWorldProvider.class, (ITeleportType)new GCMarsTeleportType());
        GalacticraftRegistry.registerCelestialBody((ICelestialBody)new GCMarsPlanet());
        GalacticraftRegistry.registerRocketGui(GCMarsWorldProvider.class, (ResourceLocation)new ResourceLocation(TEXTURE_DOMAIN, "textures/gui/marsRocketGui.png"));
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(GCMarsItems.schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(GCMarsItems.schematic, 1, 1));
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GCMarsItems.marsItemBasic, 1, 3), (Object[])new Object[]{new ItemStack(GCCoreItems.heavyPlatingTier1), new ItemStack(GCCoreItems.meteoricIronIngot, 1, 1)});
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GCMarsItems.marsItemBasic, 1, 5), (Object[])new Object[]{new ItemStack(GCMarsItems.marsItemBasic, 1, 2)});
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        NetworkRegistry.instance().registerChannel((IPacketHandler)new GCMarsPacketHandlerServer(), "GalacticraftMars", Side.SERVER);
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntity(GCMarsTileEntitySlimelingEgg.class, (String)"Slimeling Egg");
        GameRegistry.registerTileEntity(GCMarsTileEntityTreasureChest.class, (String)"Tier 2 Treasure Chest");
        GameRegistry.registerTileEntity(GCMarsTileEntityTerraformer.class, (String)"Planet Terraformer");
        GameRegistry.registerTileEntity(GCMarsTileEntityCryogenicChamber.class, (String)"Cryogenic Chamber");
        GameRegistry.registerTileEntity(GCMarsTileEntityDungeonSpawner.class, (String)"Mars Dungeon Spawner");
        GameRegistry.registerTileEntity(GCMarsTileEntityLaunchController.class, (String)"Launch Controller");
    }

    public void registerCreatures() {
        this.registerGalacticraftCreature(GCMarsEntitySludgeling.class, "Sludgeling", GCMarsConfigManager.idEntitySludgeling, GCCoreUtil.convertTo32BitColor((int)255, (int)0, (int)0, (int)50), GCCoreUtil.convertTo32BitColor((int)255, (int)0, (int)0, (int)150));
        this.registerGalacticraftCreature(GCMarsEntitySlimeling.class, "Slimeling", GCMarsConfigManager.idEntitySlimeling, GCCoreUtil.convertTo32BitColor((int)255, (int)0, (int)0, (int)50), GCCoreUtil.convertTo32BitColor((int)255, (int)0, (int)0, (int)150));
        this.registerGalacticraftCreature(GCMarsEntityCreeperBoss.class, "CreeperBoss", GCMarsConfigManager.idEntityCreeperBoss, GCCoreUtil.convertTo32BitColor((int)255, (int)0, (int)0, (int)50), GCCoreUtil.convertTo32BitColor((int)255, (int)0, (int)0, (int)150));
    }

    public void registerOtherEntities() {
        this.registerGalacticraftNonMobEntity(GCMarsEntityRocketT2.class, "SpaceshipT2", GCMarsConfigManager.idEntitySpaceshipTier2, 150, 1, false);
        this.registerGalacticraftNonMobEntity(GCMarsEntityTerraformBubble.class, "TerraformBubble", GCMarsConfigManager.idEntityTerraformBubble, 150, 20, false);
        this.registerGalacticraftNonMobEntity(GCMarsEntityProjectileTNT.class, "ProjectileTNT", GCMarsConfigManager.idEntityProjectileTNT, 150, 1, true);
        this.registerGalacticraftNonMobEntity(GCMarsEntityLandingBalloons.class, "LandingBalloons", GCMarsConfigManager.idEntityLandingBalloons, 150, 5, true);
        this.registerGalacticraftNonMobEntity(GCMarsEntityCargoRocket.class, "CargoRocket", GCMarsConfigManager.idEntityCargoRocket, 150, 1, false);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        proxy.registerRenderInformation();
        GCMarsRecipeManager.loadRecipes();
    }

    public void registerGalacticraftCreature(Class<? extends Entity> var0, String var1, int id, int back, int fore) {
        EntityRegistry.registerGlobalEntityID(var0, (String)var1, (int)id, (int)back, (int)fore);
        EntityRegistry.registerModEntity(var0, (String)var1, (int)id, (Object)instance, (int)80, (int)3, (boolean)true);
    }

    public void registerGalacticraftNonMobEntity(Class<? extends Entity> var0, String var1, int id, int trackingDistance, int updateFreq, boolean sendVel) {
        EntityList.func_75618_a(var0, (String)var1, (int)id);
        EntityRegistry.registerModEntity(var0, (String)var1, (int)id, (Object)this, (int)trackingDistance, (int)updateFreq, (boolean)sendVel);
    }
}

