/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.mars.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.block.IPlantableBlock;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.mars.GalacticraftMars;
import micdoodle8.mods.galacticraft.mars.items.GCMarsItems;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityDungeonSpawner;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class GCMarsBlock
extends Block
implements IDetectableResource,
IPlantableBlock,
ITileEntityProvider,
ITerraformableBlock {
    @SideOnly(value=Side.CLIENT)
    private Icon[] marsBlockIcons;

    public GCMarsBlock(int i) {
        super(i, Material.field_76246_e);
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 10) {
            return null;
        }
        return super.func_71872_e(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 10) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.0, (double)y + 0.0, (double)z + 0.0, (double)x + 0.0, (double)y + 0.0, (double)z + 0.0);
        }
        return super.func_71911_a_(world, x, y, z);
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 10 || metadata == 7) {
            return 10000.0f;
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.marsBlockIcons = new Icon[11];
        this.marsBlockIcons[0] = par1IconRegister.func_94245_a("galacticraftmars:cobblestone");
        this.marsBlockIcons[1] = par1IconRegister.func_94245_a("galacticraftmars:decoration_desh");
        this.marsBlockIcons[2] = par1IconRegister.func_94245_a("galacticraftmars:middle");
        this.marsBlockIcons[3] = par1IconRegister.func_94245_a("galacticraftmars:brick");
        this.marsBlockIcons[4] = par1IconRegister.func_94245_a("galacticraftmars:top");
        this.marsBlockIcons[5] = par1IconRegister.func_94245_a("galacticraftmars:copper");
        this.marsBlockIcons[6] = par1IconRegister.func_94245_a("galacticraftmars:desh");
        this.marsBlockIcons[7] = par1IconRegister.func_94245_a("galacticraftmars:tin");
        this.marsBlockIcons[8] = par1IconRegister.func_94245_a("galacticraftmars:bottom");
        this.marsBlockIcons[9] = par1IconRegister.func_94245_a("galacticraftmars:iron");
        this.marsBlockIcons[10] = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "blank");
    }

    public CreativeTabs func_71882_w() {
        return GalacticraftMars.galacticraftMarsTab;
    }

    public float func_71934_m(World par1World, int par2, int par3, int par4) {
        int meta = par1World.func_72805_g(par2, par3, par4);
        if (meta == 10 || meta == 7) {
            return -1.0f;
        }
        return this.field_71989_cb;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 10) {
            return new GCMarsTileEntityDungeonSpawner();
        }
        return null;
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        if (meta == 10 || meta == 7) {
            return false;
        }
        return super.canHarvestBlock(player, meta);
    }

    public Icon func_71858_a(int side, int meta) {
        switch (meta) {
            case 0: {
                return this.marsBlockIcons[5];
            }
            case 1: {
                return this.marsBlockIcons[7];
            }
            case 2: {
                return this.marsBlockIcons[6];
            }
            case 3: {
                return this.marsBlockIcons[9];
            }
            case 4: {
                return this.marsBlockIcons[0];
            }
            case 5: {
                return this.marsBlockIcons[4];
            }
            case 6: {
                return this.marsBlockIcons[2];
            }
            case 7: {
                return this.marsBlockIcons[3];
            }
            case 8: {
                return this.marsBlockIcons[1];
            }
            case 9: {
                return this.marsBlockIcons[8];
            }
            case 10: {
                return this.marsBlockIcons[10];
            }
        }
        return this.marsBlockIcons[1];
    }

    public int func_71885_a(int meta, Random random, int par3) {
        if (meta == 2) {
            return GCMarsItems.marsItemBasic.field_77779_bT;
        }
        if (meta == 10 || meta == 7) {
            return 0;
        }
        return this.field_71990_ca;
    }

    public int func_71899_b(int meta) {
        if (meta == 9) {
            return 4;
        }
        if (meta == 2) {
            return 0;
        }
        return meta;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        if (meta == 10 || meta == 7) {
            return 0;
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 0; var4 < 11; ++var4) {
            if (var4 == 10) continue;
            par3List.add(new ItemStack(par1, 1, var4));
        }
    }

    public boolean isValueable(int metadata) {
        switch (metadata) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean canSustainPlant(World world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        return false;
    }

    public int requiredLiquidBlocksNearby() {
        return 4;
    }

    public boolean isPlantable(int metadata) {
        return false;
    }

    public void func_71862_a(World world, int x, int y, int z, Random rand) {
        int metadata;
        if (rand.nextInt(10) == 0 && (metadata = world.func_72805_g(x, y, z)) == 7) {
            GalacticraftMars.proxy.spawnParticle("sludgeDrip", (double)x + rand.nextDouble(), y, (double)z + rand.nextDouble());
            if (rand.nextInt(100) == 0) {
                world.func_72980_b((double)x, (double)y, (double)z, GalacticraftCore.ASSET_PREFIX + "ambience.singledrip", 1.0f, 0.8f + rand.nextFloat() / 5.0f, false);
            }
        }
    }

    public boolean isTerraformable(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 5 && world.func_72798_a(x, y + 1, z) == 0;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return metadata < 10;
    }
}

