/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.mars.blocks;

import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockTile;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.world.IChunkLoader;
import micdoodle8.mods.galacticraft.mars.GCMarsConfigManager;
import micdoodle8.mods.galacticraft.mars.GalacticraftMars;
import micdoodle8.mods.galacticraft.mars.blocks.GCMarsBlocks;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityCryogenicChamber;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityLaunchController;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityTerraformer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeDirection;

public class GCMarsBlockMachine
extends GCCoreBlockTile {
    public static final int TERRAFORMER_METADATA = 0;
    public static final int CRYOGENIC_CHAMBER_METADATA = 4;
    public static final int LAUNCH_CONTROLLER_METADATA = 8;
    private Icon iconMachineSide;
    private Icon iconInput;
    private Icon iconTerraformer;
    private Icon iconLaunchController;
    private Icon iconCryochamber;

    public GCMarsBlockMachine(int id) {
        super(id, GCCoreBlocks.machine);
    }

    public void func_94332_a(IconRegister par1IconRegister) {
        this.field_94336_cN = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_blank");
        this.iconInput = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_input");
        this.iconMachineSide = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_blank");
        this.iconTerraformer = par1IconRegister.func_94245_a("galacticraftmars:terraformer_0");
        this.iconLaunchController = par1IconRegister.func_94245_a("galacticraftmars:launchController");
        this.iconCryochamber = par1IconRegister.func_94245_a("galacticraftmars:cryoDummy");
    }

    public void func_71852_a(World var1, int var2, int var3, int var4, int var5, int var6) {
        TileEntity var9 = var1.func_72796_p(var2, var3, var4);
        if (var9 instanceof IMultiBlock) {
            ((IMultiBlock)var9).onDestroy(var9);
        }
        super.func_71852_a(var1, var2, var3, var4, var5, var6);
    }

    public CreativeTabs func_71882_w() {
        return GalacticraftMars.galacticraftMarsTab;
    }

    public Icon func_71858_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.field_94336_cN;
        }
        if (metadata >= 8) {
            if (side == (metadata -= 8) + 2) {
                return this.iconInput;
            }
            if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
                return this.iconMachineSide;
            }
            return this.iconLaunchController;
        }
        if (metadata >= 4) {
            return this.iconCryochamber;
        }
        if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
            return this.iconMachineSide;
        }
        if (side == ForgeDirection.getOrientation((int)(metadata + 2)).ordinal()) {
            return this.iconInput;
        }
        return this.iconTerraformer;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
                break;
            }
            case 3: {
                change = 3;
            }
        }
        if (metadata >= 8) {
            switch (angle) {
                case 0: {
                    change = 3;
                    break;
                }
                case 1: {
                    change = 1;
                    break;
                }
                case 2: {
                    change = 2;
                    break;
                }
                case 3: {
                    change = 0;
                }
            }
            world.func_72921_c(x, y, z, 8 + change, 3);
        } else if (metadata >= 4) {
            if (!this.canPlaceChamberAt(world, x, y, z, entityLiving)) {
                if (entityLiving instanceof EntityPlayer) {
                    if (!world.field_72995_K) {
                        ((EntityPlayer)entityLiving).func_71035_c(EnumColor.RED + "Not enough room!");
                    }
                    world.func_94571_i(x, y, z);
                    ((EntityPlayer)entityLiving).field_71071_by.func_70441_a(new ItemStack(GCMarsBlocks.machine, 1, 4));
                    return;
                }
            } else {
                switch (angle) {
                    case 0: {
                        change = 3;
                        break;
                    }
                    case 1: {
                        change = 1;
                        break;
                    }
                    case 2: {
                        change = 2;
                        break;
                    }
                    case 3: {
                        change = 0;
                    }
                }
                world.func_72921_c(x, y, z, 4 + change, 3);
            }
        } else {
            world.func_72921_c(x, y, z, 0 + change, 3);
        }
        TileEntity var8 = world.func_72796_p(x, y, z);
        if (var8 instanceof IMultiBlock) {
            ((IMultiBlock)var8).onCreate(new Vector3((double)x, (double)y, (double)z));
        }
        if (metadata >= 8) {
            for (int dX = -2; dX < 3; ++dX) {
                for (int dZ = -2; dZ < 3; ++dZ) {
                    int id = world.func_72798_a(x + dX, y, z + dZ);
                    if (id != GCCoreBlocks.landingPadFull.field_71990_ca) continue;
                    world.func_72845_h(x + dX, y, z + dZ);
                }
            }
        }
        if (var8 instanceof IChunkLoader && !var8.field_70331_k.field_72995_K && GCMarsConfigManager.launchControllerChunkLoad && entityLiving instanceof EntityPlayer) {
            ((IChunkLoader)var8).setOwnerName(((EntityPlayer)entityLiving).field_71092_bJ);
            ((IChunkLoader)var8).onTicketLoaded(ForgeChunkManager.requestTicket((Object)GalacticraftCore.instance, (World)var8.field_70331_k, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL), true);
        } else if (var8 instanceof GCMarsTileEntityLaunchController && entityLiving instanceof EntityPlayer) {
            ((GCMarsTileEntityLaunchController)var8).setOwnerName(((EntityPlayer)entityLiving).field_71092_bJ);
        }
    }

    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata;
        int original = metadata = par1World.func_72805_g(x, y, z);
        int change = 0;
        if (metadata >= 8) {
            original -= 8;
        } else if (metadata >= 4) {
            return false;
        }
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        if (metadata >= 8) {
            change += 8;
        }
        par1World.func_72921_c(x, y, z, change, 3);
        return true;
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= 8) {
            par5EntityPlayer.openGui((Object)GalacticraftMars.instance, GCMarsConfigManager.idGuiMachine, world, x, y, z);
            return true;
        }
        if (metadata >= 4) {
            ((IMultiBlock)world.func_72796_p(x, y, z)).onActivated(par5EntityPlayer);
            return true;
        }
        par5EntityPlayer.openGui((Object)GalacticraftMars.instance, GCMarsConfigManager.idGuiMachine, world, x, y, z);
        return true;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= 8) {
            return new GCMarsTileEntityLaunchController();
        }
        if (metadata >= 4) {
            return new GCMarsTileEntityCryogenicChamber();
        }
        return new GCMarsTileEntityTerraformer();
    }

    public void func_71898_d(World world, int x, int y, int z, int par5) {
        super.func_71898_d(world, x, y, z, par5);
        if (world.func_72805_g(x, y, z) >= 8) {
            for (int dX = -2; dX < 3; ++dX) {
                for (int dZ = -2; dZ < 3; ++dZ) {
                    int id = world.func_72798_a(x + dX, y, z + dZ);
                    if (id != GCCoreBlocks.landingPadFull.field_71990_ca) continue;
                    world.func_72845_h(x + dX, y, z + dZ);
                }
            }
        }
    }

    public ItemStack getTerraformer() {
        return new ItemStack(this.field_71990_ca, 1, 0);
    }

    public ItemStack getChamber() {
        return new ItemStack(this.field_71990_ca, 1, 4);
    }

    public ItemStack getLaunchController() {
        return new ItemStack(this.field_71990_ca, 1, 8);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getTerraformer());
        par3List.add(this.getChamber());
        par3List.add(this.getLaunchController());
    }

    private boolean canPlaceChamberAt(World world, int x0, int y0, int z0, EntityLivingBase player) {
        int angle = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int meta = 0;
        switch (angle) {
            case 0: {
                meta = 3;
                break;
            }
            case 1: {
                meta = 1;
                break;
            }
            case 2: {
                meta = 2;
                break;
            }
            case 3: {
                meta = 0;
            }
        }
        int x1 = 0;
        int x2 = 0;
        int z1 = 0;
        int z2 = 0;
        switch (meta) {
            case 0: {
                x1 = 0;
                x2 = 0;
                z1 = -1;
                z2 = 1;
                break;
            }
            case 1: {
                x1 = 0;
                x2 = 0;
                z1 = -1;
                z2 = 1;
                break;
            }
            case 2: {
                x1 = -1;
                x2 = 1;
                z1 = 0;
                z2 = 0;
                break;
            }
            case 3: {
                x1 = -1;
                x2 = 1;
                z1 = 0;
                z2 = 0;
            }
        }
        for (int x = x1; x <= x2; ++x) {
            for (int z = z1; z <= z2; ++z) {
                for (int y = 0; y < 4; ++y) {
                    int idAt = world.func_72798_a(x0 + x, y0 + y, z0 + z);
                    int metaAt = world.func_72805_g(x0 + x, y0 + y, z0 + z);
                    if (x == 0 && y == 0 && z == 0 && idAt == GCMarsBlocks.machine.field_71990_ca && metaAt >= 4 && metaAt < 8 || Block.field_71973_m[idAt] == null || Block.field_71973_m[idAt].field_72018_cp.func_76222_j()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public int func_71899_b(int metadata) {
        if (metadata >= 8) {
            return 8;
        }
        if (metadata >= 4) {
            return 4;
        }
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Item item = Item.field_77698_e[this.field_71990_ca];
        if (item == null) {
            return null;
        }
        int metadata = this.func_71873_h(world, x, y, z);
        return new ItemStack(this.field_71990_ca, 1, metadata);
    }

    public int func_71857_b() {
        return GalacticraftMars.proxy.getMachineRenderID();
    }

    public boolean isBed(World world, int x, int y, int z, EntityLivingBase player) {
        return world.func_72805_g(x, y, z) >= 4;
    }

    public ChunkCoordinates getBedSpawnPosition(World world, int x, int y, int z, EntityPlayer player) {
        return new ChunkCoordinates(x, y + 1, z);
    }

    public void setBedOccupied(World world, int x, int y, int z, EntityPlayer player, boolean occupied) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof GCMarsTileEntityCryogenicChamber) {
            ((GCMarsTileEntityCryogenicChamber)tile).isOccupied = true;
        }
    }

    public static ChunkCoordinates getNearestEmptyChunkCoordinates(World par0World, int par1, int par2, int par3, int par4) {
        for (int k1 = 0; k1 <= 1; ++k1) {
            int l1 = par1 - 1;
            int i2 = par3 - 1;
            int j2 = l1 + 2;
            int k2 = i2 + 2;
            for (int l2 = l1; l2 <= j2; ++l2) {
                for (int i3 = i2; i3 <= k2; ++i3) {
                    if (!par0World.func_72797_t(l2, par2 - 1, i3) || par0World.func_72803_f(l2, par2, i3).func_76218_k() || par0World.func_72803_f(l2, par2 + 1, i3).func_76218_k()) continue;
                    if (par4 <= 0) {
                        return new ChunkCoordinates(l2, par2, i3);
                    }
                    --par4;
                }
            }
        }
        return null;
    }
}

