/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.core.DefaultProps;
import buildcraft.core.network.ISynchronizedTile;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketPayloadArrays;
import buildcraft.core.network.PacketTileUpdate;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TilePacketWrapper;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileBuildCraft
extends TileEntity
implements ISynchronizedTile {
    private static Map<Class, TilePacketWrapper> updateWrappers = new HashMap<Class, TilePacketWrapper>();
    private static Map<Class, TilePacketWrapper> descriptionWrappers = new HashMap<Class, TilePacketWrapper>();
    private final TilePacketWrapper descriptionPacket;
    private final TilePacketWrapper updatePacket;
    private boolean init = false;
    private String owner = "[BuildCraft]";

    public TileBuildCraft() {
        if (!updateWrappers.containsKey(this.getClass())) {
            updateWrappers.put(this.getClass(), new TilePacketWrapper(this.getClass()));
        }
        if (!descriptionWrappers.containsKey(this.getClass())) {
            descriptionWrappers.put(this.getClass(), new TilePacketWrapper(this.getClass()));
        }
        this.updatePacket = updateWrappers.get(this.getClass());
        this.descriptionPacket = descriptionWrappers.get(this.getClass());
    }

    public String getOwner() {
        return this.owner;
    }

    public void func_70316_g() {
        if (!this.init && !this.func_70320_p()) {
            this.initialize();
            this.init = true;
        }
        if (this instanceof IPowerReceptor) {
            IPowerReceptor receptor = (IPowerReceptor)((Object)this);
            receptor.getPowerReceiver(null).update();
        }
    }

    public void func_70313_j() {
        this.init = false;
        super.func_70313_j();
    }

    public void initialize() {
        Utils.handleBufferedDescription(this);
    }

    public void onBlockPlacedBy(EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer) {
            this.owner = ((EntityPlayer)entity).field_71092_bJ;
        }
    }

    public void destroy() {
    }

    public void sendNetworkUpdate() {
        if (CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            CoreProxy.proxy.sendToPlayers(this.getUpdatePacket(), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, DefaultProps.NETWORK_UPDATE_RANGE);
        }
    }

    public Packet func_70319_e() {
        return new PacketTileUpdate(this).getPacket();
    }

    @Override
    public PacketPayload getPacketPayload() {
        return this.updatePacket.toPayload(this);
    }

    @Override
    public Packet getUpdatePacket() {
        return new PacketTileUpdate(this).getPacket();
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) throws IOException {
        if (packet.payload instanceof PacketPayloadArrays) {
            this.descriptionPacket.fromPayload(this, (PacketPayloadArrays)packet.payload);
        }
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) throws IOException {
        if (packet.payload instanceof PacketPayloadArrays) {
            this.updatePacket.fromPayload(this, (PacketPayloadArrays)packet.payload);
        }
    }

    @Override
    public void postPacketHandling(PacketUpdate packet) {
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74778_a("owner", this.owner);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        if (nbt.func_74764_b("owner")) {
            this.owner = nbt.func_74779_i("owner");
        }
    }

    public boolean isInvNameLocalized() {
        return false;
    }

    public World getWorld() {
        return this.field_70331_k;
    }
}

