/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.IClientState;
import buildcraft.core.network.ISyncedTile;
import buildcraft.core.network.PacketCoordinates;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class PacketTileState
extends PacketCoordinates {
    private List<StateWithId> stateList = new LinkedList<StateWithId>();

    public PacketTileState() {
    }

    public PacketTileState(int x, int y, int z) {
        super(100, x, y, z);
        this.isChunkDataPacket = true;
    }

    @Override
    public int getID() {
        return 100;
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
    }

    public void applyStates(DataInputStream data, ISyncedTile tile) throws IOException {
        int stateCount = data.readByte();
        for (int i = 0; i < stateCount; ++i) {
            byte stateId = data.readByte();
            tile.getStateInstance(stateId).readData(data);
            tile.afterStateUpdated(stateId);
        }
    }

    public void addStateForSerialization(byte stateId, IClientState state) {
        this.stateList.add(new StateWithId(stateId, state));
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeByte(this.stateList.size());
        for (StateWithId stateWithId : this.stateList) {
            data.writeByte(stateWithId.stateId);
            stateWithId.state.writeData(data);
        }
    }

    private class StateWithId {
        public byte stateId;
        public IClientState state;

        public StateWithId(byte stateId, IClientState state) {
            this.stateId = stateId;
            this.state = state;
        }
    }
}

