/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.utils;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.BlockIndex;
import buildcraft.core.EntityBlock;
import buildcraft.core.IDropControlInventory;
import buildcraft.core.IFramePipeConnection;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.network.ISynchronizedTile;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.energy.TileEngine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class Utils {
    public static final Random RANDOM = new Random();
    private static final List<ForgeDirection> directions = new ArrayList<ForgeDirection>(Arrays.asList(ForgeDirection.VALID_DIRECTIONS));

    public static int addToRandomInventoryAround(World world, int x, int y, int z, ItemStack stack) {
        Collections.shuffle(directions);
        for (ForgeDirection orientation : directions) {
            Position pos = new Position(x, y, z, orientation);
            pos.moveForwards(1.0);
            TileEntity tileInventory = world.func_72796_p((int)pos.x, (int)pos.y, (int)pos.z);
            ITransactor transactor = Transactor.getTransactorFor(tileInventory);
            if (transactor == null || tileInventory instanceof TileEngine || transactor.add((ItemStack)stack, (ForgeDirection)orientation.getOpposite(), (boolean)false).field_77994_a <= 0) continue;
            return transactor.add((ItemStack)stack, (ForgeDirection)orientation.getOpposite(), (boolean)true).field_77994_a;
        }
        return 0;
    }

    public static ForgeDirection get2dOrientation(Position pos1, Position pos2) {
        double Dz = pos1.z - pos2.z;
        double Dx = pos1.x - pos2.x;
        double angle = Math.atan2(Dz, Dx) / Math.PI * 180.0 + 180.0;
        if (angle < 45.0 || angle > 315.0) {
            return ForgeDirection.EAST;
        }
        if (angle < 135.0) {
            return ForgeDirection.SOUTH;
        }
        if (angle < 225.0) {
            return ForgeDirection.WEST;
        }
        return ForgeDirection.NORTH;
    }

    public static ForgeDirection get3dOrientation(Position pos1, Position pos2) {
        double Dy = pos1.y - pos2.y;
        double Dx = pos1.x - pos2.x;
        double angle = Math.atan2(Dy, Dx) / Math.PI * 180.0 + 180.0;
        if (angle > 45.0 && angle < 135.0) {
            return ForgeDirection.UP;
        }
        if (angle > 225.0 && angle < 315.0) {
            return ForgeDirection.DOWN;
        }
        return Utils.get2dOrientation(pos1, pos2);
    }

    public static int addToRandomPipeAround(World world, int x, int y, int z, ForgeDirection from, ItemStack stack) {
        ArrayList<IPipeTile> possiblePipes = new ArrayList<IPipeTile>();
        ArrayList<ForgeDirection> pipeDirections = new ArrayList<ForgeDirection>();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            IPipeTile pipe;
            if (from.getOpposite() == side) continue;
            Position pos = new Position(x, y, z, side);
            pos.moveForwards(1.0);
            TileEntity tile = world.func_72796_p((int)pos.x, (int)pos.y, (int)pos.z);
            if (!(tile instanceof IPipeTile) || (pipe = (IPipeTile)tile).getPipeType() != IPipeTile.PipeType.ITEM || !pipe.isPipeConnected(side.getOpposite())) continue;
            possiblePipes.add(pipe);
            pipeDirections.add(side.getOpposite());
        }
        if (possiblePipes.size() > 0) {
            int choice = RANDOM.nextInt(possiblePipes.size());
            IPipeTile pipeEntry = (IPipeTile)possiblePipes.get(choice);
            return pipeEntry.injectItem(stack, true, (ForgeDirection)pipeDirections.get(choice));
        }
        return 0;
    }

    public static TileEntity getTile(World world, Position pos, ForgeDirection step) {
        Position tmp = new Position(pos);
        tmp.orientation = step;
        tmp.moveForwards(1.0);
        return world.func_72796_p((int)tmp.x, (int)tmp.y, (int)tmp.z);
    }

    public static IInventory getInventory(IInventory inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inv;
            TileEntityChest adjacent = null;
            if (chest.field_70421_d != null) {
                adjacent = chest.field_70421_d;
            }
            if (chest.field_70424_c != null) {
                adjacent = chest.field_70424_c;
            }
            if (chest.field_70423_b != null) {
                adjacent = chest.field_70423_b;
            }
            if (chest.field_70422_e != null) {
                adjacent = chest.field_70422_e;
            }
            if (adjacent != null) {
                return new InventoryLargeChest("", inv, (IInventory)adjacent);
            }
            return inv;
        }
        return inv;
    }

    public static IAreaProvider getNearbyAreaProvider(World world, int i, int j, int k) {
        TileEntity a1 = world.func_72796_p(i + 1, j, k);
        TileEntity a2 = world.func_72796_p(i - 1, j, k);
        TileEntity a3 = world.func_72796_p(i, j, k + 1);
        TileEntity a4 = world.func_72796_p(i, j, k - 1);
        TileEntity a5 = world.func_72796_p(i, j + 1, k);
        TileEntity a6 = world.func_72796_p(i, j - 1, k);
        if (a1 instanceof IAreaProvider) {
            return (IAreaProvider)a1;
        }
        if (a2 instanceof IAreaProvider) {
            return (IAreaProvider)a2;
        }
        if (a3 instanceof IAreaProvider) {
            return (IAreaProvider)a3;
        }
        if (a4 instanceof IAreaProvider) {
            return (IAreaProvider)a4;
        }
        if (a5 instanceof IAreaProvider) {
            return (IAreaProvider)a5;
        }
        if (a6 instanceof IAreaProvider) {
            return (IAreaProvider)a6;
        }
        return null;
    }

    public static EntityBlock createLaser(World world, Position p1, Position p2, LaserKind kind) {
        if (p1.equals(p2)) {
            return null;
        }
        double iSize = p2.x - p1.x;
        double jSize = p2.y - p1.y;
        double kSize = p2.z - p1.z;
        double i = p1.x;
        double j = p1.y;
        double k = p1.z;
        if (iSize != 0.0) {
            i += 0.5;
            j += 0.45;
            k += 0.45;
            jSize = 0.1;
            kSize = 0.1;
        } else if (jSize != 0.0) {
            i += 0.45;
            j += 0.5;
            k += 0.45;
            iSize = 0.1;
            kSize = 0.1;
        } else if (kSize != 0.0) {
            i += 0.45;
            j += 0.45;
            k += 0.5;
            iSize = 0.1;
            jSize = 0.1;
        }
        EntityBlock block = CoreProxy.proxy.newEntityBlock(world, i, j, k, iSize, jSize, kSize, kind);
        block.setBrightness(210);
        world.func_72838_d((Entity)block);
        return block;
    }

    public static EntityBlock[] createLaserBox(World world, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, LaserKind kind) {
        EntityBlock[] lasers = new EntityBlock[12];
        Position[] p = new Position[]{new Position(xMin, yMin, zMin), new Position(xMax, yMin, zMin), new Position(xMin, yMax, zMin), new Position(xMax, yMax, zMin), new Position(xMin, yMin, zMax), new Position(xMax, yMin, zMax), new Position(xMin, yMax, zMax), new Position(xMax, yMax, zMax)};
        lasers[0] = Utils.createLaser(world, p[0], p[1], kind);
        lasers[1] = Utils.createLaser(world, p[0], p[2], kind);
        lasers[2] = Utils.createLaser(world, p[2], p[3], kind);
        lasers[3] = Utils.createLaser(world, p[1], p[3], kind);
        lasers[4] = Utils.createLaser(world, p[4], p[5], kind);
        lasers[5] = Utils.createLaser(world, p[4], p[6], kind);
        lasers[6] = Utils.createLaser(world, p[5], p[7], kind);
        lasers[7] = Utils.createLaser(world, p[6], p[7], kind);
        lasers[8] = Utils.createLaser(world, p[0], p[4], kind);
        lasers[9] = Utils.createLaser(world, p[1], p[5], kind);
        lasers[10] = Utils.createLaser(world, p[2], p[6], kind);
        lasers[11] = Utils.createLaser(world, p[3], p[7], kind);
        return lasers;
    }

    public static void handleBufferedDescription(ISynchronizedTile tileSynch) {
        TileEntity tile = (TileEntity)tileSynch;
        BlockIndex index = new BlockIndex(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
        if (BuildCraftCore.bufferedDescriptions.containsKey(index)) {
            PacketUpdate payload = BuildCraftCore.bufferedDescriptions.get(index);
            BuildCraftCore.bufferedDescriptions.remove(index);
            try {
                tileSynch.handleDescriptionPacket(payload);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            tileSynch.postPacketHandling(payload);
        }
    }

    public static void preDestroyBlock(World world, int i, int j, int k) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof IInventory && !CoreProxy.proxy.isRenderWorld(world) && (!(tile instanceof IDropControlInventory) || ((IDropControlInventory)tile).doDrop())) {
            InvUtils.dropItems(world, (IInventory)tile, i, j, k);
            InvUtils.wipeInventory((IInventory)tile);
        }
        if (tile instanceof TileBuildCraft) {
            ((TileBuildCraft)tile).destroy();
        }
    }

    public static boolean checkPipesConnections(TileEntity tile1, TileEntity tile2) {
        if (tile1 == null || tile2 == null) {
            return false;
        }
        if (!(tile1 instanceof IPipeTile) && !(tile2 instanceof IPipeTile)) {
            return false;
        }
        ForgeDirection o = ForgeDirection.UNKNOWN;
        if (tile1.field_70329_l - 1 == tile2.field_70329_l) {
            o = ForgeDirection.WEST;
        } else if (tile1.field_70329_l + 1 == tile2.field_70329_l) {
            o = ForgeDirection.EAST;
        } else if (tile1.field_70330_m - 1 == tile2.field_70330_m) {
            o = ForgeDirection.DOWN;
        } else if (tile1.field_70330_m + 1 == tile2.field_70330_m) {
            o = ForgeDirection.UP;
        } else if (tile1.field_70327_n - 1 == tile2.field_70327_n) {
            o = ForgeDirection.NORTH;
        } else if (tile1.field_70327_n + 1 == tile2.field_70327_n) {
            o = ForgeDirection.SOUTH;
        }
        if (tile1 instanceof IPipeTile && !((IPipeTile)tile1).isPipeConnected(o)) {
            return false;
        }
        return !(tile2 instanceof IPipeTile) || ((IPipeTile)tile2).isPipeConnected(o.getOpposite());
    }

    public static boolean checkLegacyPipesConnections(IBlockAccess blockAccess, int x1, int y1, int z1, int x2, int y2, int z2) {
        Block b1 = Block.field_71973_m[blockAccess.func_72798_a(x1, y1, z1)];
        Block b2 = Block.field_71973_m[blockAccess.func_72798_a(x2, y2, z2)];
        if (!(b1 instanceof IFramePipeConnection) && !(b2 instanceof IFramePipeConnection)) {
            return false;
        }
        if (b1 instanceof IFramePipeConnection && !((IFramePipeConnection)b1).isPipeConnected(blockAccess, x1, y1, z1, x2, y2, z2)) {
            return false;
        }
        return !(b2 instanceof IFramePipeConnection) || ((IFramePipeConnection)b2).isPipeConnected(blockAccess, x2, y2, z2, x1, y1, z1);
    }

    public static NBTTagCompound getItemData(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound("tag");
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public static void addItemToolTip(ItemStack stack, String tag, String msg) {
        NBTTagCompound nbt = Utils.getItemData(stack);
        NBTTagCompound display = nbt.func_74775_l("display");
        nbt.func_74766_a("display", display);
        NBTTagList lore = display.func_74761_m("Lore");
        display.func_74782_a("Lore", (NBTBase)lore);
        lore.func_74742_a((NBTBase)new NBTTagString(tag, msg));
    }

    public static void writeInvToNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = new NBTTagList();
        for (byte slot = 0; slot < inv.func_70302_i_(); slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = inv.func_70301_a((int)slot);
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", slot);
            stack.func_77955_b(itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        data.func_74782_a(tag, (NBTBase)list);
    }

    public static void readInvFromNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = data.func_74761_m(tag);
        for (int entry = 0; entry < list.func_74745_c(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound itemTag = (NBTTagCompound)list.func_74743_b(entry);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= inv.func_70302_i_()) continue;
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            inv.func_70299_a((int)slot, stack);
        }
    }

    public static void readStacksFromNBT(NBTTagCompound nbt, String name, ItemStack[] stacks) {
        NBTTagList nbttaglist = nbt.func_74761_m(name);
        for (int i = 0; i < stacks.length; ++i) {
            if (i < nbttaglist.func_74745_c()) {
                NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbttaglist.func_74743_b(i);
                stacks[i] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2);
                continue;
            }
            stacks[i] = null;
        }
    }

    public static void writeStacksToNBT(NBTTagCompound nbt, String name, ItemStack[] stacks) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < stacks.length; ++i) {
            NBTTagCompound cpt = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)cpt);
            if (stacks[i] == null) continue;
            stacks[i].func_77955_b(cpt);
        }
        nbt.func_74782_a(name, (NBTBase)nbttaglist);
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().func_77634_r()) {
                return stack.func_77973_b().getContainerItemStack(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static int[] concat(int[] first, int[] second) {
        int[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static float[] concat(float[] first, float[] second) {
        float[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static int[] createSlotArray(int first, int count) {
        int[] slots = new int[count];
        for (int k = first; k < first + count; ++k) {
            slots[k - first] = k;
        }
        return slots;
    }
}

