/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.gui;

import buildcraft.core.DefaultProps;
import buildcraft.core.fluids.Tank;
import buildcraft.core.utils.StringUtils;
import buildcraft.energy.TileEngineIron;
import buildcraft.energy.TileEngineWithInventory;
import buildcraft.energy.gui.ContainerEngine;
import buildcraft.energy.gui.GuiEngine;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiCombustionEngine
extends GuiEngine {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/combustion_engine_gui.png");
    private static final ResourceLocation BLOCK_TEXTURE = TextureMap.field_110575_b;

    public GuiCombustionEngine(InventoryPlayer inventoryplayer, TileEngineWithInventory tileEngine) {
        super(new ContainerEngine(inventoryplayer, tileEngine), tileEngine, TEXTURE);
    }

    @Override
    protected void func_74189_g(int par1, int par2) {
        super.func_74189_g(par1, par2);
        String title = StringUtils.localize("tile.engineIron");
        this.field_73886_k.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        this.field_73886_k.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_74195_c - 96 + 2, 0x404040);
    }

    @Override
    protected void func_74185_a(float f, int x, int y) {
        super.func_74185_a(f, x, y);
        int j = (this.field_73880_f - this.field_74194_b) / 2;
        int k = (this.field_73881_g - this.field_74195_c) / 2;
        TileEngineIron engine = (TileEngineIron)this.tile;
        if (engine.getScaledBurnTime(58) > 0) {
            this.displayGauge(j, k, 19, 104, engine.getScaledBurnTime(58), engine.getFuel(), engine.tankFuel);
        }
        if (engine.getScaledCoolant(58) > 0) {
            this.displayGauge(j, k, 19, 122, engine.getScaledCoolant(58), engine.getCoolant(), engine.tankCoolant);
        }
    }

    private void displayGauge(int j, int k, int line, int col, int squaled, FluidStack liquid, Tank tank) {
        if (liquid == null) {
            return;
        }
        int start = 0;
        Icon liquidIcon = null;
        Fluid fluid = liquid.getFluid();
        int color = tank.colorRenderCache;
        if (fluid != null && fluid.getStillIcon() != null) {
            liquidIcon = fluid.getStillIcon();
        }
        this.field_73882_e.field_71446_o.func_110577_a(BLOCK_TEXTURE);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        if (liquidIcon != null) {
            int x;
            do {
                if (squaled > 16) {
                    x = 16;
                    squaled -= 16;
                } else {
                    x = squaled;
                    squaled = 0;
                }
                this.func_94065_a(j + col, k + line + 58 - x - start, liquidIcon, 16, 16 - (16 - x));
                start += 16;
            } while (x != 0 && squaled != 0);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(j + col, k + line, 176, 0, 16, 60);
    }
}

