/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.tools.IToolWrench;
import buildcraft.core.TileBuffer;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Pipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public abstract class PipeLogicWood {
    protected final Pipe pipe;

    public PipeLogicWood(Pipe pipe) {
        this.pipe = pipe;
    }

    private void switchSource() {
        int meta = this.pipe.container.func_70322_n();
        ForgeDirection newFacing = null;
        for (int i = meta + 1; i <= meta + 6; ++i) {
            ForgeDirection facing = ForgeDirection.getOrientation((int)(i % 6));
            if (!this.isValidFacing(facing)) continue;
            newFacing = facing;
            break;
        }
        if (newFacing != null && newFacing.ordinal() != meta) {
            this.pipe.container.field_70331_k.func_72921_c(this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n, newFacing.ordinal(), 3);
            this.pipe.container.scheduleRenderUpdate();
        }
    }

    private void switchSourceIfNeeded() {
        int meta = this.pipe.container.func_70322_n();
        if (meta > 5) {
            this.switchSource();
        } else {
            ForgeDirection facing = ForgeDirection.getOrientation((int)meta);
            if (!this.isValidFacing(facing)) {
                this.switchSource();
            }
        }
    }

    private boolean isValidFacing(ForgeDirection side) {
        TileBuffer[] tileBuffer = this.pipe.container.getTileCache();
        if (tileBuffer == null) {
            return true;
        }
        if (!tileBuffer[side.ordinal()].exists()) {
            return true;
        }
        TileEntity tile = tileBuffer[side.ordinal()].getTile();
        return this.isValidConnectingTile(tile);
    }

    protected abstract boolean isValidConnectingTile(TileEntity var1);

    public void initialize() {
        if (!CoreProxy.proxy.isRenderWorld(this.pipe.container.field_70331_k)) {
            this.switchSourceIfNeeded();
        }
    }

    public boolean blockActivated(EntityPlayer entityplayer) {
        Item equipped;
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n)) {
            this.switchSource();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n);
            return true;
        }
        return false;
    }

    public void onNeighborBlockChange(int blockId) {
        if (!CoreProxy.proxy.isRenderWorld(this.pipe.container.field_70331_k)) {
            this.switchSourceIfNeeded();
        }
    }
}

