/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.logic;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tconstruct.library.util.IActiveLogic;
import tconstruct.library.util.IFacingLogic;

public class FaucetLogic
extends TileEntity
implements IFacingLogic,
IActiveLogic,
IFluidHandler {
    byte direction;
    boolean active;
    public FluidStack liquid;

    public boolean activateFaucet() {
        if (this.liquid == null && this.active) {
            FluidStack templiquid;
            int x = this.field_70329_l;
            int z = this.field_70327_n;
            switch (this.getRenderDirection()) {
                case 2: {
                    ++z;
                    break;
                }
                case 3: {
                    --z;
                    break;
                }
                case 4: {
                    ++x;
                    break;
                }
                case 5: {
                    --x;
                }
            }
            TileEntity drainte = this.field_70331_k.func_72796_p(x, this.field_70330_m, z);
            TileEntity tankte = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
            if (drainte != null && drainte instanceof IFluidHandler && tankte != null && tankte instanceof IFluidHandler && (templiquid = ((IFluidHandler)drainte).drain(this.getForgeDirection(), 144, false)) != null) {
                int drained = ((IFluidHandler)tankte).fill(ForgeDirection.UP, templiquid, false);
                if (drained > 0) {
                    this.liquid = ((IFluidHandler)drainte).drain(this.getForgeDirection(), drained, true);
                    ((IFluidHandler)tankte).fill(ForgeDirection.UP, this.liquid, true);
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void func_70316_g() {
        if (this.liquid != null) {
            this.liquid.amount -= 6;
            if (this.liquid.amount <= 0) {
                this.liquid = null;
                if (!this.activateFaucet()) {
                    this.active = false;
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
            }
        }
    }

    @Override
    public byte getRenderDirection() {
        return this.direction;
    }

    @Override
    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    @Override
    public void setDirection(int side) {
    }

    @Override
    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
        switch (facing) {
            case 0: {
                this.direction = (byte)2;
                break;
            }
            case 1: {
                this.direction = (byte)5;
                break;
            }
            case 2: {
                this.direction = (byte)3;
                break;
            }
            case 3: {
                this.direction = (byte)4;
            }
        }
    }

    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.readCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.func_74771_c("Direction");
        this.liquid = tags.func_74767_n("hasLiquid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tags.func_74775_l("Fluid")) : null;
    }

    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.writeCustomNBT(tags);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74774_a("Direction", this.direction);
        tags.func_74757_a("hasLiquid", this.liquid != null);
        if (this.liquid != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.liquid.writeToNBT(nbt);
            tags.func_74766_a("Fluid", nbt);
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.readCustomNBT(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean flag) {
        if (!this.active) {
            this.active = true;
            this.activateFaucet();
        } else {
            this.active = false;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }
}

