/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.logic;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tconstruct.blocks.logic.MultiServantLogic;

public class LavaTankLogic
extends MultiServantLogic
implements IFluidHandler {
    public FluidTank tank = new FluidTank(4000);
    public int renderOffset;

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        if (amount > 0 && doFill) {
            this.renderOffset = resource.amount;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack amount = this.tank.drain(maxDrain, doDrain);
        if (amount != null && doDrain) {
            this.renderOffset = -maxDrain;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidStack fluid = null;
        if (this.tank.getFluid() != null) {
            fluid = this.tank.getFluid().copy();
        }
        return new FluidTankInfo[]{new FluidTankInfo(fluid, this.tank.getCapacity())};
    }

    public float getFluidAmountScaled() {
        return (float)(this.tank.getFluid().amount - this.renderOffset) / ((float)this.tank.getCapacity() * 1.01f);
    }

    public boolean containsFluid() {
        return this.tank.getFluid() != null;
    }

    public int getBrightness() {
        int id;
        if (this.containsFluid() && (id = this.tank.getFluid().fluidID) < 4096) {
            return Block.field_71984_q[id];
        }
        return 0;
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.readCustomNBT(tags);
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.writeCustomNBT(tags);
    }

    @Override
    public void readCustomNBT(NBTTagCompound tags) {
        if (tags.func_74767_n("hasFluid")) {
            this.tank.setFluid(new FluidStack(tags.func_74762_e("itemID"), tags.func_74762_e("amount")));
        } else {
            this.tank.setFluid(null);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tags) {
        FluidStack liquid = this.tank.getFluid();
        tags.func_74757_a("hasFluid", liquid != null);
        if (liquid != null) {
            tags.func_74768_a("itemID", liquid.fluidID);
            tags.func_74768_a("amount", liquid.amount);
        }
    }

    @Override
    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.readCustomNBT(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_70316_g() {
        if (this.renderOffset > 0) {
            this.renderOffset -= 6;
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }
}

