/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.event.ForgeSubscribe;
import tconstruct.TConstruct;
import tconstruct.client.armor.WingModel;
import tconstruct.common.TContent;
import tconstruct.util.player.TPlayerStats;

@SideOnly(value=Side.CLIENT)
public class TClientEvents {
    Minecraft mc = Minecraft.func_71410_x();
    boolean initSounds;
    Icon[] stillIcons = new Icon[2];
    Icon[] flowIcons = new Icon[2];
    private static final ResourceLocation hearts = new ResourceLocation("tinker", "textures/gui/newhearts.png");
    private static final ResourceLocation icons = new ResourceLocation("textures/gui/icons.png");
    Random rand = new Random();
    int updateCounter = 0;
    boolean tukmc = Loader.isModLoaded((String)"tukmc_Vz");
    boolean borderlands = Loader.isModLoaded((String)"borderlands");
    GameSettings gs;
    double zLevel;
    ModelBiped model;
    WingModel wings;

    public TClientEvents() {
        this.gs = Minecraft.func_71410_x().field_71474_y;
        this.zLevel = 0.0;
        this.model = new ModelBiped(5.0f);
        this.wings = new WingModel();
    }

    @ForgeSubscribe
    public void onSound(SoundLoadEvent event) {
        if (!this.initSounds) {
            this.initSounds = true;
            try {
                SoundManager soundmanager = event.manager;
                soundmanager.func_77372_a("tinker:frypan_hit.ogg");
                soundmanager.func_77372_a("tinker:little_saw.ogg");
                soundmanager.func_77372_a("tinker:launcher_clank.ogg");
                TConstruct.logger.info("Successfully loaded sounds.");
            }
            catch (Exception e) {
                TConstruct.logger.warning("Failed to register one or more sounds");
            }
        }
    }

    @ForgeSubscribe
    public void preStitch(TextureStitchEvent.Pre event) {
        TextureMap register = event.map;
        if (register.field_94255_a == 0) {
            this.stillIcons[0] = register.func_94245_a("tinker:liquid_pigiron");
            this.flowIcons[0] = register.func_94245_a("tinker:liquid_pigiron");
        }
    }

    @ForgeSubscribe
    public void postStitch(TextureStitchEvent.Post event) {
        if (event.map.field_94255_a == 0) {
            for (int i = 0; i < TContent.fluidBlocks.length; ++i) {
                TContent.fluids[i].setIcons(TContent.fluidBlocks[i].func_71858_a(0, 0), TContent.fluidBlocks[i].func_71858_a(2, 0));
            }
            TContent.pigIronFluid.setIcons(this.stillIcons[0], this.flowIcons[0]);
        }
    }

    @ForgeSubscribe
    public void renderHealthbar(RenderGameOverlayEvent.Pre event) {
        if (!this.tukmc && !this.borderlands) {
            if (event.type == RenderGameOverlayEvent.ElementType.HEALTH) {
                boolean highlight;
                ++this.updateCounter;
                ScaledResolution scaledresolution = new ScaledResolution(this.mc.field_71474_y, this.mc.field_71443_c, this.mc.field_71440_d);
                int scaledWidth = scaledresolution.func_78326_a();
                int scaledHeight = scaledresolution.func_78328_b();
                int xBasePos = scaledWidth / 2 - 91;
                int yBasePos = scaledHeight - 39;
                TPlayerStats stats = TConstruct.playerTracker.getPlayerStats(this.mc.field_71439_g.field_71092_bJ);
                boolean bl = highlight = this.mc.field_71439_g.field_70172_ad / 3 % 2 == 1;
                if (this.mc.field_71439_g.field_70172_ad < 10) {
                    highlight = false;
                }
                AttributeInstance attrMaxHealth = this.mc.field_71439_g.func_110148_a(SharedMonsterAttributes.field_111267_a);
                int health = MathHelper.func_76123_f((float)this.mc.field_71439_g.func_110143_aJ());
                int healthLast = MathHelper.func_76123_f((float)this.mc.field_71439_g.field_70735_aL);
                float healthMax = (float)attrMaxHealth.func_111126_e();
                if (healthMax > 20.0f) {
                    healthMax = 20.0f;
                }
                float absorb = this.mc.field_71439_g.func_110139_bj();
                int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
                int rowHeight = Math.max(10 - (healthRows - 2), 3);
                this.rand.setSeed(this.updateCounter * 312871);
                int left = scaledWidth / 2 - 91;
                int top = scaledHeight - GuiIngameForge.left_height;
                int regen = -1;
                if (this.mc.field_71439_g.func_70644_a(Potion.field_76428_l)) {
                    regen = this.updateCounter % 25;
                }
                int TOP = 9 * (this.mc.field_71441_e.func_72912_H().func_76093_s() ? 5 : 0);
                int BACKGROUND = highlight ? 25 : 16;
                int MARGIN = 16;
                if (this.mc.field_71439_g.func_70644_a(Potion.field_76436_u)) {
                    MARGIN += 36;
                } else if (this.mc.field_71439_g.func_70644_a(Potion.field_82731_v)) {
                    MARGIN += 72;
                }
                float absorbRemaining = absorb;
                for (int i = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
                    boolean b0 = highlight;
                    int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
                    int x = left + i % 10 * 8;
                    int y = top - row * rowHeight;
                    if (health <= 4) {
                        y += this.rand.nextInt(2);
                    }
                    if (i == regen) {
                        y -= 2;
                    }
                    this.drawTexturedModalRect(x, y, BACKGROUND, TOP, 9, 9);
                    if (highlight) {
                        if (i * 2 + 1 < healthLast) {
                            this.drawTexturedModalRect(x, y, MARGIN + 54, TOP, 9, 9);
                        } else if (i * 2 + 1 == healthLast) {
                            this.drawTexturedModalRect(x, y, MARGIN + 63, TOP, 9, 9);
                        }
                    }
                    if (absorbRemaining > 0.0f) {
                        if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                            this.drawTexturedModalRect(x, y, MARGIN + 153, TOP, 9, 9);
                        } else {
                            this.drawTexturedModalRect(x, y, MARGIN + 144, TOP, 9, 9);
                        }
                        absorbRemaining -= 2.0f;
                        continue;
                    }
                    if (i * 2 + 1 < health) {
                        this.drawTexturedModalRect(x, y, MARGIN + 36, TOP, 9, 9);
                        continue;
                    }
                    if (i * 2 + 1 != health) continue;
                    this.drawTexturedModalRect(x, y, MARGIN + 45, TOP, 9, 9);
                }
                int potionOffset = 0;
                PotionEffect potion = this.mc.field_71439_g.func_70660_b(Potion.field_82731_v);
                if (potion != null) {
                    potionOffset = 18;
                }
                if ((potion = this.mc.field_71439_g.func_70660_b(Potion.field_76436_u)) != null) {
                    potionOffset = 9;
                }
                this.mc.func_110434_K().func_110577_a(hearts);
                int hp = MathHelper.func_76123_f((float)this.mc.field_71439_g.func_110143_aJ());
                for (int iter = 0; iter < hp / 20; ++iter) {
                    int renderHearts = (hp - 20 * (iter + 1)) / 2;
                    if (renderHearts > 10) {
                        renderHearts = 10;
                    }
                    for (int i = 0; i < renderHearts; ++i) {
                        int y = 0;
                        if (i == regen) {
                            y -= 2;
                        }
                        this.drawTexturedModalRect(xBasePos + 8 * i, yBasePos + y, 0 + 18 * iter, potionOffset, 9, 9);
                    }
                    if (hp % 2 != 1 || renderHearts >= 10) continue;
                    this.drawTexturedModalRect(xBasePos + 8 * renderHearts, yBasePos, 9 + 18 * iter, potionOffset, 9, 9);
                }
                this.mc.func_110434_K().func_110577_a(icons);
                GuiIngameForge.left_height += 10;
                if (absorb > 0.0f) {
                    GuiIngameForge.left_height += 10;
                }
                event.setCanceled(true);
            }
            if (event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && this.gs.field_74320_O != 0) {
                event.setCanceled(true);
            }
        }
    }

    public void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par6), this.zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + par6), this.zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + 0), this.zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), this.zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78381_a();
    }

    private float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }

    protected float handleRotationFloat(EntityLiving par1EntityLiving, float par2) {
        return (float)par1EntityLiving.field_70173_aa + par2;
    }
}

