/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.library.crafting.AlloyMix;
import tconstruct.library.crafting.FluidType;

public class Smeltery {
    public static Smeltery instance = new Smeltery();
    private final HashMap<List<Integer>, FluidStack> smeltingList = new HashMap();
    private final HashMap<List<Integer>, Integer> temperatureList = new HashMap();
    private final HashMap<List<Integer>, ItemStack> renderIndex = new HashMap();
    private final ArrayList<AlloyMix> alloys = new ArrayList();

    public static void addMelting(ItemStack stack, int temperature, FluidStack output) {
        Smeltery.addMelting(stack, stack.field_77993_c, stack.func_77960_j(), temperature, output);
    }

    public static void addMelting(Block block, int metadata, int temperature, FluidStack output) {
        Smeltery.addMelting(new ItemStack(block, 1, metadata), block.field_71990_ca, metadata, temperature, output);
    }

    public static void addMelting(ItemStack input, int blockID, int metadata, int temperature, FluidStack liquid) {
        Smeltery.instance.smeltingList.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), liquid);
        Smeltery.instance.temperatureList.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), temperature);
        Smeltery.instance.renderIndex.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), new ItemStack(blockID, input.field_77994_a, metadata));
    }

    public static void addAlloyMixing(FluidStack result, FluidStack ... mixers) {
        ArrayList<FluidStack> inputs = new ArrayList<FluidStack>();
        for (FluidStack liquid : mixers) {
            inputs.add(liquid);
        }
        Smeltery.instance.alloys.add(new AlloyMix(result, inputs));
    }

    public static Integer getLiquifyTemperature(ItemStack item) {
        if (item == null) {
            return 20;
        }
        Integer temp = Smeltery.instance.temperatureList.get(Arrays.asList(item.field_77993_c, item.func_77960_j()));
        if (temp == null) {
            return 20;
        }
        return temp;
    }

    public static Integer getLiquifyTemperature(int blockID, int metadata) {
        return Smeltery.instance.temperatureList.get(Arrays.asList(blockID, metadata));
    }

    public static FluidStack getSmelteryResult(ItemStack item) {
        if (item == null) {
            return null;
        }
        FluidStack stack = Smeltery.instance.smeltingList.get(Arrays.asList(item.field_77993_c, item.func_77960_j()));
        if (stack == null) {
            return null;
        }
        return stack.copy();
    }

    public static FluidStack getSmelteryResult(int blockID, int metadata) {
        FluidStack stack = Smeltery.instance.smeltingList.get(Arrays.asList(blockID, metadata));
        if (stack == null) {
            return null;
        }
        return stack.copy();
    }

    public static ItemStack getRenderIndex(ItemStack input) {
        return Smeltery.instance.renderIndex.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
    }

    public static ArrayList mixMetals(ArrayList<FluidStack> moltenMetal) {
        ArrayList<FluidStack> liquids = new ArrayList<FluidStack>();
        for (AlloyMix alloy : Smeltery.instance.alloys) {
            FluidStack liquid = alloy.mix(moltenMetal);
            if (liquid == null) continue;
            liquids.add(liquid);
        }
        return liquids;
    }

    public static HashMap<List<Integer>, FluidStack> getSmeltingList() {
        return Smeltery.instance.smeltingList;
    }

    public static HashMap<List<Integer>, Integer> getTemperatureList() {
        return Smeltery.instance.temperatureList;
    }

    public static HashMap<List<Integer>, ItemStack> getRenderIndex() {
        return Smeltery.instance.renderIndex;
    }

    public static ArrayList<AlloyMix> getAlloyList() {
        return Smeltery.instance.alloys;
    }

    public static void addMelting(FluidType type, ItemStack input, int temperatureDifference, int fluidAmount) {
        int temp = type.baseTemperature + temperatureDifference;
        if (temp <= 20) {
            temp = type.baseTemperature;
        }
        if (input.func_77973_b() instanceof ItemBlock) {
            Smeltery.addMelting(input, input.field_77993_c, input.func_77960_j(), type.baseTemperature + temperatureDifference, new FluidStack(type.fluid, fluidAmount));
        } else {
            Smeltery.addMelting(input, type.renderBlockID, type.renderMeta, type.baseTemperature + temperatureDifference, new FluidStack(type.fluid, fluidAmount));
        }
    }

    public static void addDictionaryMelting(String oreName, FluidType type, int temperatureDifference, int fluidAmount) {
        for (ItemStack is : OreDictionary.getOres((String)oreName)) {
            Smeltery.addMelting(type, is, temperatureDifference, fluidAmount);
        }
    }
}

